/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.mj.service;

import com.bizvane.baisonBase.facade.models.mj.MjQueryMemberInfoRequestVo;
import com.bizvane.baisonBase.facade.rpc.MjMemberServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.MemberLoginResponseVO;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.QiNiuConfig;
import com.bizvane.customized.company.mj.service.CurMjGiftCardConfigService;
import com.bizvane.customized.facade.enums.mj.GjftCardSkipTypEnum;
import com.bizvane.customized.facade.models.po.CusMjGiftCardConfigPO;
import com.bizvane.customized.facade.models.po.CusMjGiftCardConfigPOExample;
import com.bizvane.customized.facade.models.vo.mj.CurMjGiftCardConfigVo;
import com.bizvane.customized.mappers.CusMjGiftCardConfigPOMapper;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CurMjGiftCardConfigServiceImpl
implements CurMjGiftCardConfigService {
    private static final Logger log = LoggerFactory.getLogger(CurMjGiftCardConfigServiceImpl.class);
    @Autowired
    private CusMjGiftCardConfigPOMapper cusMjGiftCardConfigPOMapper;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private MjMemberServiceRpc mjMemberServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private QiNiuConfig qiNiuConfig;

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> saveOrUpdateGiftCardConfig(CurMjGiftCardConfigVo vo, SysAccountPO sysAccountPO) {
        ResponseData wxPublicInfo;
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        Long cusMjGiftCardConfigId = vo.getCusMjGiftCardConfigId();
        Byte skipType = vo.getSkipType();
        String skipAppid = vo.getSkipAppid();
        if (skipType != null && GjftCardSkipTypEnum.CURRENT_APPLET.getCode() == skipType && StringUtil.isBlank((CharSequence)skipAppid) && (wxPublicInfo = this.wxPublicServiceFeign.getWxPublicInfo(sysAccountPO.getSysCompanyId(), sysAccountPO.getBrandId(), "2", "10")) != null && SysResponseEnum.SUCCESS.getCode() == wxPublicInfo.getCode() && wxPublicInfo.getData() != null) {
            String appid = ((WxPublicPO)wxPublicInfo.getData()).getAppid();
            vo.setSkipAppid(appid);
        }
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        CusMjGiftCardConfigPO po = new CusMjGiftCardConfigPO();
        BeanUtils.copyProperties((Object)vo, (Object)po);
        po.setValid(Boolean.valueOf(true));
        int i = 0;
        if (cusMjGiftCardConfigId == null) {
            CusMjGiftCardConfigPOExample example = new CusMjGiftCardConfigPOExample();
            CusMjGiftCardConfigPOExample.Criteria criteria = example.createCriteria();
            criteria.andSysCompanyIdEqualTo(vo.getSysCompanyId());
            criteria.andSysBrandIdEqualTo(vo.getSysBrandId());
            criteria.andValidEqualTo(Boolean.valueOf(true));
            example.setOrderByClause("create_date desc");
            List list = this.cusMjGiftCardConfigPOMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                cusMjGiftCardConfigId = ((CusMjGiftCardConfigPO)list.get(0)).getCusMjGiftCardConfigId();
            }
        }
        if (cusMjGiftCardConfigId == null) {
            po.setCreateDate(new Date());
            po.setCreateUserId(sysAccountPO.getSysAccountId());
            po.setCreateUserName(sysAccountPO.getName());
            i = this.cusMjGiftCardConfigPOMapper.insertSelective(po);
        } else {
            po.setModifiedDate(new Date());
            po.setModifiedUserId(sysAccountPO.getSysAccountId());
            po.setModifiedUserName(sysAccountPO.getName());
            i = this.cusMjGiftCardConfigPOMapper.updateByPrimaryKeySelective(po);
        }
        if (i > 0) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u4fdd\u5b58\u6210\u529f");
        }
        return responseData;
    }

    public ResponseData<CurMjGiftCardConfigVo> getGiftCardConfig(CurMjGiftCardConfigVo vo) {
        ResponseData responseData = new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage());
        CurMjGiftCardConfigVo giftCardConfigVo = new CurMjGiftCardConfigVo();
        Byte isNeedMjGiftCardConfig = vo.getIsNeedMjGiftCardConfig();
        if (isNeedMjGiftCardConfig != null && isNeedMjGiftCardConfig == 1) {
            CusMjGiftCardConfigPOExample example = new CusMjGiftCardConfigPOExample();
            CusMjGiftCardConfigPOExample.Criteria criteria = example.createCriteria();
            criteria.andSysCompanyIdEqualTo(vo.getSysCompanyId());
            criteria.andSysBrandIdEqualTo(vo.getSysBrandId());
            criteria.andValidEqualTo(Boolean.valueOf(true));
            example.setOrderByClause("create_date desc");
            List list = this.cusMjGiftCardConfigPOMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                CusMjGiftCardConfigPO cusMjGiftCardConfigPO = (CusMjGiftCardConfigPO)list.get(0);
                BeanUtils.copyProperties((Object)cusMjGiftCardConfigPO, (Object)giftCardConfigVo);
                if (StringUtil.isNotBlank((CharSequence)vo.getMemberCode())) {
                    String domain = this.qiNiuConfig.getDomain();
                    if (StringUtils.isNotEmpty((CharSequence)giftCardConfigVo.getGiftCardBindBeforeImg()) && (!giftCardConfigVo.getGiftCardBindBeforeImg().startsWith("http://") || giftCardConfigVo.getGiftCardBindBeforeImg().startsWith("https://"))) {
                        giftCardConfigVo.setGiftCardBindBeforeImg(domain + "/" + giftCardConfigVo.getGiftCardBindBeforeImg());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)giftCardConfigVo.getGiftCardBindAfterImg()) && (!giftCardConfigVo.getGiftCardBindAfterImg().startsWith("http://") || giftCardConfigVo.getGiftCardBindAfterImg().startsWith("https://"))) {
                        giftCardConfigVo.setGiftCardBindAfterImg(domain + "/" + giftCardConfigVo.getGiftCardBindAfterImg());
                    }
                }
            }
        }
        if (StringUtil.isNotBlank((CharSequence)vo.getMemberCode())) {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setSysCompanyId(vo.getSysCompanyId());
            memberInfoModel.setBrandId(vo.getSysBrandId());
            memberInfoModel.setMemberCode(vo.getMemberCode());
            memberInfoModel.setValid(Integer.valueOf(1));
            ResponseData memberResponseData = this.memberInfoApiService.getMemberModel(memberInfoModel);
            if (memberResponseData != null && SysResponseEnum.SUCCESS.getCode() == memberResponseData.getCode() && memberResponseData.getData() != null) {
                MemberLoginResponseVO tData;
                Boolean IsBindGiftCard;
                memberInfoModel = (MemberInfoModel)memberResponseData.getData();
                String phone = memberInfoModel.getPhone();
                giftCardConfigVo.setMemberPhone(phone);
                MjQueryMemberInfoRequestVo requestVo = new MjQueryMemberInfoRequestVo();
                requestVo.setSysCompanyId(vo.getSysCompanyId());
                requestVo.setCardNo(memberInfoModel.getCardNo());
                requestVo.setPhone(memberInfoModel.getPhone());
                requestVo.setNum(Integer.valueOf(1));
                requestVo.setPageNum(Integer.valueOf(1));
                log.info("\u8c03\u7528\u7ebf\u4e0b\u4f1a\u5458 \u53c2\u6570param:{}", (Object)JacksonUtil.bean2Json((Object)requestVo));
                Result responseVOResult = this.mjMemberServiceRpc.queryMemberInfo(requestVo);
                log.info("\u8c03\u7528\u7ebf\u4e0b\u4f1a\u5458 \u8fd4\u56de\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)responseVOResult));
                if (responseVOResult != null && SysResponseEnum.SUCCESS.getCode() == responseVOResult.getCode().intValue() && responseVOResult.getTData() != null && (IsBindGiftCard = Boolean.valueOf((tData = (MemberLoginResponseVO)responseVOResult.getTData()).getMjIsBindCard() != null && 1 == tData.getMjIsBindCard())).booleanValue()) {
                    giftCardConfigVo.setTotalBalance(tData.getMjGiftBalance());
                    giftCardConfigVo.setIsBindGiftCard(IsBindGiftCard);
                }
            }
        }
        responseData.setData((Object)giftCardConfigVo);
        return responseData;
    }
}

