/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.huairen.service.impl;

import com.bizvane.customized.common.utils.BeanUtils;
import com.bizvane.customized.company.huairen.service.AdvertisementSpaceService;
import com.bizvane.customized.facade.enums.AdvertisementSpaceEnum;
import com.bizvane.customized.facade.models.po.CusAdvertisementSpacePO;
import com.bizvane.customized.facade.models.po.CusAdvertisementSpacePOExample;
import com.bizvane.customized.facade.models.vo.AdvertisementSpaceRegionVO;
import com.bizvane.customized.facade.models.vo.AdvertisementSpaceRequestVO;
import com.bizvane.customized.facade.models.vo.AdvertisementSpaceResponseVO;
import com.bizvane.customized.facade.models.vo.AdvertisementSpaceVO;
import com.bizvane.customized.mappers.CusAdvertisementSpacePOMapper;
import com.bizvane.fitmentservice.models.Rpc.AppletSlideJumpRpc;
import com.bizvane.fitmentservice.models.po.AppletSlideJumpPO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdvertisementSpaceServiceImpl
implements AdvertisementSpaceService {
    private static final Logger log = LoggerFactory.getLogger(AdvertisementSpaceServiceImpl.class);
    @Autowired
    private CusAdvertisementSpacePOMapper advertisementSpacePoMapper;
    @Autowired
    private AppletSlideJumpRpc appletSlideJumpRpc;

    public ResponseData<AdvertisementSpaceResponseVO> getAdvertisementSpace(AdvertisementSpaceRequestVO vo) {
        log.info("AdvertisementSpaceServiceImpl getAdvertisementSpace start!");
        ResponseData responseData = new ResponseData();
        CusAdvertisementSpacePO record = new CusAdvertisementSpacePO();
        record.setSysCompanyId(vo.getSysCompanyId());
        record.setSysBrandId(vo.getSysBrandId());
        List advertisementSpaceList = this.advertisementSpacePoMapper.getAdvertisementSpace(record);
        if (CollectionUtils.isNotEmpty((Collection)advertisementSpaceList)) {
            AdvertisementSpaceResponseVO responseVo = new AdvertisementSpaceResponseVO();
            AdvertisementSpaceRegionVO bannerTegion = new AdvertisementSpaceRegionVO();
            ArrayList<AdvertisementSpaceVO> bannerTegionList = new ArrayList<AdvertisementSpaceVO>();
            AdvertisementSpaceRegionVO benefitsTegion = new AdvertisementSpaceRegionVO();
            ArrayList<AdvertisementSpaceVO> benefitsTegionList = new ArrayList<AdvertisementSpaceVO>();
            AdvertisementSpaceRegionVO couponTegion = new AdvertisementSpaceRegionVO();
            ArrayList<AdvertisementSpaceVO> couponTegionList = new ArrayList<AdvertisementSpaceVO>();
            AdvertisementSpaceRegionVO mallTegion = new AdvertisementSpaceRegionVO();
            ArrayList<AdvertisementSpaceVO> mallTegionList = new ArrayList<AdvertisementSpaceVO>();
            AdvertisementSpaceRegionVO pointsMallTegion = new AdvertisementSpaceRegionVO();
            ArrayList<AdvertisementSpaceVO> pointsMallTegionList = new ArrayList<AdvertisementSpaceVO>();
            for (CusAdvertisementSpacePO po : advertisementSpaceList) {
                AdvertisementSpaceVO spaceVo = new AdvertisementSpaceVO();
                BeanUtils.copyProperties((Object)po, (Object)spaceVo);
                if (2 == po.getAppletType()) {
                    this.assemblyAppId(po.getAppletJumpRelatedId(), spaceVo);
                }
                if (AdvertisementSpaceEnum.BANNER.getCode().equals(po.getRegionType())) {
                    bannerTegionList.add(spaceVo);
                    continue;
                }
                if (AdvertisementSpaceEnum.BENEFITS.getCode().equals(po.getRegionType())) {
                    if (AdvertisementSpaceEnum.IMAGE_SHARE_ONE.getCode().equals(po.getImageShare())) {
                        benefitsTegion.setTopSpace(spaceVo);
                        continue;
                    }
                    benefitsTegionList.add(spaceVo);
                    continue;
                }
                if (AdvertisementSpaceEnum.COUPON.getCode().equals(po.getRegionType())) {
                    if (AdvertisementSpaceEnum.IMAGE_SHARE_ONE.getCode().equals(po.getImageShare())) {
                        couponTegion.setTopSpace(spaceVo);
                        continue;
                    }
                    couponTegionList.add(spaceVo);
                    continue;
                }
                if (AdvertisementSpaceEnum.MALL.getCode().equals(po.getRegionType())) {
                    if (AdvertisementSpaceEnum.IMAGE_SHARE_ONE.getCode().equals(po.getImageShare())) {
                        mallTegion.setTopSpace(spaceVo);
                        continue;
                    }
                    if (AdvertisementSpaceEnum.VIEW_MORE.getCode().equals(po.getImageShare())) {
                        mallTegion.setViewMore(spaceVo);
                        continue;
                    }
                    mallTegionList.add(spaceVo);
                    continue;
                }
                if (!AdvertisementSpaceEnum.POINTSMALL.getCode().equals(po.getRegionType())) continue;
                if (AdvertisementSpaceEnum.IMAGE_SHARE_ONE.getCode().equals(po.getImageShare())) {
                    pointsMallTegion.setTopSpace(spaceVo);
                    continue;
                }
                if (AdvertisementSpaceEnum.VIEW_MORE.getCode().equals(po.getImageShare())) {
                    pointsMallTegion.setViewMore(spaceVo);
                    continue;
                }
                pointsMallTegionList.add(spaceVo);
            }
            bannerTegion.setSpacePoList(bannerTegionList);
            responseVo.setBannerTegion(bannerTegion);
            benefitsTegion.setSpacePoList(benefitsTegionList);
            responseVo.setBenefitsTegion(benefitsTegion);
            couponTegion.setSpacePoList(couponTegionList);
            responseVo.setCouponTegion(couponTegion);
            mallTegion.setSpacePoList(mallTegionList);
            responseVo.setMallTegion(mallTegion);
            pointsMallTegion.setSpacePoList(pointsMallTegionList);
            responseVo.setPointsMallTegion(pointsMallTegion);
            responseData.setData((Object)responseVo);
        }
        return responseData;
    }

    private void assemblyAppId(Long id, AdvertisementSpaceVO spaceVo) {
        ResponseData jumpAppId = this.appletSlideJumpRpc.getJumpAppIdByPrimaryKey(id);
        if (jumpAppId.getData() != null) {
            spaceVo.setAppId(((AppletSlideJumpPO)jumpAppId.getData()).getAppid());
        }
    }

    @Transactional
    public boolean save(List<CusAdvertisementSpacePO> list, SysAccountPO sysAccountPo) {
        Long sysBrandId = sysAccountPo.getBrandId();
        CusAdvertisementSpacePOExample example = new CusAdvertisementSpacePOExample();
        example.createCriteria().andSysBrandIdEqualTo(sysBrandId);
        this.advertisementSpacePoMapper.deleteByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            for (CusAdvertisementSpacePO po : list) {
                po.setCreateUserId(sysAccountPo.getSysAccountId());
                po.setCreateDate(new Date());
                po.setSysCompanyId(sysAccountPo.getSysCompanyId());
                po.setSysBrandId(sysBrandId);
                this.advertisementSpacePoMapper.insertSelective(po);
            }
        }
        return true;
    }

    public List<CusAdvertisementSpacePO> getList(long sysCompanyId, long sysBrandId) {
        CusAdvertisementSpacePO record = new CusAdvertisementSpacePO();
        record.setSysCompanyId(Long.valueOf(sysCompanyId));
        record.setSysBrandId(Long.valueOf(sysBrandId));
        return this.advertisementSpacePoMapper.getAdvertisementSpace(record);
    }
}

