/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.huairen.controller.rpc;

import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.huairen.service.AdvertisementSpaceService;
import com.bizvane.customized.facade.models.bo.AdvertisementSpaceSaveBO;
import com.bizvane.customized.facade.models.po.CusAdvertisementSpacePO;
import com.bizvane.customized.facade.models.vo.AdvertisementSpaceRequestVO;
import com.bizvane.customized.facade.models.vo.AdvertisementSpaceResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.Api;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e7f\u544a\u4f4d"})
@RequestMapping(value={"/advertisementSpace"})
@RestController
public class AdvertisementSpaceRpcController {
    private static final Logger log = LoggerFactory.getLogger(AdvertisementSpaceRpcController.class);
    @Autowired
    private AdvertisementSpaceService advertisementSpaceService;

    @PostMapping(value={"/getAdvertisementSpace"})
    ResponseData<AdvertisementSpaceResponseVO> getAdvertisementSpace(@RequestBody AdvertisementSpaceRequestVO vo) {
        log.info("enter getAdvertisementSpace param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.advertisementSpaceService.getAdvertisementSpace(vo);
    }

    @PostMapping(value={"/save"})
    public boolean save(@NotNull @Valid @RequestBody AdvertisementSpaceSaveBO bo, HttpServletRequest request) {
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.advertisementSpaceService.save(bo.getList(), sysAccountPo);
    }

    @RequestMapping(value={"/getList"})
    public List<CusAdvertisementSpacePO> getList(HttpServletRequest request) {
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.advertisementSpaceService.getList(sysAccountPo.getSysCompanyId().longValue(), sysAccountPo.getBrandId().longValue());
    }
}

