/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.goldLion.service.biz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.connectorservice.entity.jll.VipInterestsResponseVo;
import com.bizvane.customized.common.utils.BeanUtils;
import com.bizvane.customized.common.utils.ValidateUtils;
import com.bizvane.customized.company.goldLion.service.base.CusGoldlionMemberActivityService;
import com.bizvane.customized.company.goldLion.service.proxy.ConenctorProxyService;
import com.bizvane.customized.company.goldLion.service.proxy.MemberProxyService;
import com.bizvane.customized.facade.enums.goldLionEnums.ActivityStatusEnum;
import com.bizvane.customized.facade.enums.goldLionEnums.BizActivityStatusEnum;
import com.bizvane.customized.facade.exception.ServiceException;
import com.bizvane.customized.facade.models.vo.goldLion.base.CusGoldlionMemberActivityVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.BizGoldLionMemberActivityVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.GoldLionMemberActivityReqVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.MemberActivityListReqVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.MemberActivityListResVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageHelper;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizCusGoldlionMemberActivityService {
    private static final Logger logger = LoggerFactory.getLogger(BizCusGoldlionMemberActivityService.class);
    @Autowired
    private CusGoldlionMemberActivityService cusGoldlionMemberActivityService;
    @Autowired
    private ConenctorProxyService conenctorProxyService;
    @Autowired
    private MemberProxyService memberProxyService;

    public void addActivity(CusGoldlionMemberActivityVo cusGoldlionMemberActivityVo, SysAccountPO sysAccountPO) {
        logger.info("BizCusGoldlionMemberActivityService.addActivity\u5165\u53c2cusGoldlionMemberActivityVo:{},sysAccountPO:{}", (Object)JSON.toJSONString((Object)cusGoldlionMemberActivityVo), (Object)JSON.toJSONString((Object)sysAccountPO));
        ResponseData validate = ValidateUtils.validate((Object)cusGoldlionMemberActivityVo, (String)"\u6821\u9a8c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Class[])new Class[0]);
        if (validate != null) {
            throw new ServiceException(validate.getData().toString());
        }
        this.bizVaildate(cusGoldlionMemberActivityVo, sysAccountPO.getBrandId());
        this.cusGoldlionMemberActivityService.add(cusGoldlionMemberActivityVo, sysAccountPO);
    }

    public PageInfo<BizGoldLionMemberActivityVo> getPageList(GoldLionMemberActivityReqVo goldLionMemberActivityReqVo) {
        PageHelper.startPage((int)goldLionMemberActivityReqVo.getPageNum(), (int)goldLionMemberActivityReqVo.getPageSize());
        this.setDateTime(goldLionMemberActivityReqVo);
        List cusGoldlionMemberActivityVoList = this.cusGoldlionMemberActivityService.getPageList(goldLionMemberActivityReqVo);
        if (CollectionUtils.isEmpty((Collection)cusGoldlionMemberActivityVoList)) {
            return null;
        }
        PageInfo pageInfo = new PageInfo(cusGoldlionMemberActivityVoList);
        List bizGoldLionMemberActivityVos = BeanUtils.copyProperties((List)cusGoldlionMemberActivityVoList, BizGoldLionMemberActivityVo.class);
        bizGoldLionMemberActivityVos.forEach(bizGoldLionMemberActivityVo -> {
            bizGoldLionMemberActivityVo.setMemberRencentUsableAmount(Integer.valueOf(bizGoldLionMemberActivityVo.getTotalAcquirableEquityAmount() - bizGoldLionMemberActivityVo.getAlreadyReceivedAmount()));
            Integer bizActivityStatus = this.setBizActivityStatus(bizGoldLionMemberActivityVo);
            if (bizActivityStatus != null) {
                bizGoldLionMemberActivityVo.setBizActivityStatus(bizActivityStatus);
            }
        });
        pageInfo.setList(bizGoldLionMemberActivityVos);
        return pageInfo;
    }

    public void setDateTime(GoldLionMemberActivityReqVo goldLionMemberActivityReqVo) {
        LocalTime localTime1 = LocalTime.of(0, 0, 0);
        LocalTime localTime2 = LocalTime.of(23, 59, 59);
        if (goldLionMemberActivityReqVo.getStartBeginDate() != null || goldLionMemberActivityReqVo.getStartEndDate() != null) {
            LocalDateTime startBeginDate = LocalDateTime.of(this.transverter(goldLionMemberActivityReqVo.getStartBeginDate()), localTime1);
            LocalDateTime startEndDate = LocalDateTime.of(this.transverter(goldLionMemberActivityReqVo.getStartEndDate()), localTime2);
            goldLionMemberActivityReqVo.setStartBeginDateTime(startBeginDate);
            goldLionMemberActivityReqVo.setStartEndDateTime(startEndDate);
        }
        if (goldLionMemberActivityReqVo.getOverBeginDate() != null || goldLionMemberActivityReqVo.getOverEndDate() != null) {
            LocalDateTime overBeginDate = LocalDateTime.of(this.transverter(goldLionMemberActivityReqVo.getOverBeginDate()), localTime1);
            LocalDateTime overEndDate = LocalDateTime.of(this.transverter(goldLionMemberActivityReqVo.getOverEndDate()), localTime2);
            goldLionMemberActivityReqVo.setOverBeginDateTime(overBeginDate);
            goldLionMemberActivityReqVo.setOverEndDateTime(overEndDate);
        }
    }

    public Integer setBizActivityStatus(BizGoldLionMemberActivityVo bizGoldLionMemberActivityVo) {
        LocalDateTime beginDate = this.transverterDateTme(bizGoldLionMemberActivityVo.getBeginDate());
        LocalDateTime endDate = this.transverterDateTme(bizGoldLionMemberActivityVo.getEndDate());
        LocalDateTime now = LocalDateTime.now();
        Integer bizActivityStatus = BizActivityStatusEnum.CLOSE.getCode();
        if (ActivityStatusEnum.OPEN.getCode().equals(bizGoldLionMemberActivityVo.getActivityStatus())) {
            if (beginDate.isAfter(now)) {
                Integer bizActivityStatus1 = BizActivityStatusEnum.ON_THE_THRESHOLD_OF.getCode();
                return bizActivityStatus1;
            }
            if (beginDate.isBefore(now) && now.isBefore(endDate) && beginDate.isBefore(endDate)) {
                Integer bizActivityStatus1 = BizActivityStatusEnum.IN_EXECUTION.getCode();
                return bizActivityStatus1;
            }
            if (now.isAfter(endDate)) {
                Integer bizActivityStatus1 = BizActivityStatusEnum.FINISHED.getCode();
                return bizActivityStatus1;
            }
        }
        return bizActivityStatus;
    }

    public BizGoldLionMemberActivityVo getById(Long cusGoldlionMemberActivityId) {
        if (cusGoldlionMemberActivityId == null) {
            throw new ServiceException("\u5165\u53c2cusGoldlionMemberActivityId\u4e3a\u7a7a\uff01");
        }
        BizGoldLionMemberActivityVo bizGoldLionMemberActivityVo = this.cusGoldlionMemberActivityService.getById(cusGoldlionMemberActivityId);
        if (bizGoldLionMemberActivityVo == null) {
            return null;
        }
        return bizGoldLionMemberActivityVo;
    }

    public void activitySwitch(Long cusGoldlionMemberActivityId, Boolean isOpenFlag, SysAccountPO sysAccountPO) {
        if (cusGoldlionMemberActivityId == null) {
            throw new ServiceException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.cusGoldlionMemberActivityService.switchById(cusGoldlionMemberActivityId, isOpenFlag, sysAccountPO);
    }

    public List<MemberActivityListResVo> memberActivityList(MemberActivityListReqVo memberActivityListReqVo) {
        logger.info("\u5165\u53e3\u6743\u76ca\u6d3b\u52a8\u5217\u8868BizCusGoldlionMemberActivityService.memberActivityList\u5165\u53c2memberActivityListReqVo:{}", (Object)JSONObject.toJSONString((Object)memberActivityListReqVo));
        List<MemberActivityListResVo> memberActivityListResVos = this.cusGoldlionMemberActivityService.memberActivityList(memberActivityListReqVo);
        if (CollectionUtils.isEmpty((Collection)memberActivityListResVos)) {
            return null;
        }
        MemberInfoModel infoByMemberCode = this.memberProxyService.getInfoByMemberCode(memberActivityListReqVo.getMemberCode());
        if (infoByMemberCode == null) {
            throw new ServiceException("\u67e5\u8be2\u4f1a\u5458erpid\u5931\u8d25\uff01");
        }
        List offLionActivityByErpId = this.conenctorProxyService.getOffLionActivityByErpId(infoByMemberCode.getErpId(), infoByMemberCode.getBrandId());
        if (CollectionUtils.isEmpty((Collection)offLionActivityByErpId)) {
            return memberActivityListResVos;
        }
        memberActivityListResVos.forEach(memberActivityListResVo -> offLionActivityByErpId.forEach(vipInterestsItemResponseVo -> {
            if (memberActivityListResVo.getActivityNo().equals(vipInterestsItemResponseVo.getName())) {
                memberActivityListResVo.setStandardsFlag(Boolean.TRUE);
                List cusGoldlionMemberReceiveRecordVos = memberActivityListResVo.getCusGoldlionMemberReceiveRecordVos();
                if (CollectionUtils.isEmpty((Collection)cusGoldlionMemberReceiveRecordVos)) {
                    memberActivityListResVo.setActivityMemberCanResidueReceiveNum(memberActivityListResVo.getMaxAcquirableEquityAmount());
                } else {
                    Integer num = memberActivityListResVo.getMaxAcquirableEquityAmount() - cusGoldlionMemberReceiveRecordVos.size();
                    memberActivityListResVo.setActivityMemberCanResidueReceiveNum(num);
                }
            }
        }));
        memberActivityListResVos = memberActivityListResVos.stream().sorted(Comparator.comparing(malr -> malr.getActivityMemberCanResidueReceiveNum()).reversed().thenComparing(CusGoldlionMemberActivityVo::getBeginDate)).collect(Collectors.toList());
        return memberActivityListResVos;
    }

    public void bizVaildate(CusGoldlionMemberActivityVo cusGoldlionMemberActivityVo, Long brandId) {
        VipInterestsResponseVo offlionActivityByActivityNo = this.conenctorProxyService.getOfflionActivityByActivityNo(cusGoldlionMemberActivityVo.getActivityNo(), brandId);
        if (offlionActivityByActivityNo == null) {
            throw new ServiceException("\u8be5\u6d3b\u52a8\u672a\u5728\u7ebf\u4e0b\u67e5\u8be2\u5230\u76f8\u5173\u6d3b\u52a8");
        }
        LocalDateTime beginDate = this.transverterDateTme(cusGoldlionMemberActivityVo.getBeginDate());
        LocalDateTime endDate = this.transverterDateTme(cusGoldlionMemberActivityVo.getEndDate());
        if (beginDate.isBefore(LocalDateTime.now())) {
            throw new ServiceException("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u6bd4\u5f53\u524d\u65f6\u95f4\u5c0f");
        }
        if (beginDate.isAfter(endDate)) {
            throw new ServiceException("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        }
        List byActivityNo = this.cusGoldlionMemberActivityService.getByActivityNo(cusGoldlionMemberActivityVo.getActivityNo());
        if (!CollectionUtils.isEmpty((Collection)byActivityNo)) {
            throw new ServiceException("\u60a8\u8f93\u5165\u7684ID\u91cd\u590d");
        }
    }

    public LocalDateTime transverterDateTme(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime;
    }

    public LocalDate transverter(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = instant.atZone(zoneId).toLocalDate();
        return localDate;
    }
}

