/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.common.utils;

import com.auth0.jwt.internal.org.apache.commons.lang3.concurrent.BasicThreadFactory;
import com.bizvane.customized.common.utils.StreamingCallBack;
import com.bizvane.utils.redisutils.SpringContextHolder;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StreamingExportExcelUtil<T> {
    private Log log = LogFactory.getLog(this.getClass());
    private final Integer MAX_NUM_EXCEL_SHEET_ROW = 1000000;
    private Integer MAX_NUM_THREAD_POOL = 1;
    private Integer PER_READ_NUM = 20000;
    private Long TOTAL_NUM_DATA = 0L;
    private ExecutorService es = null;
    private SXSSFWorkbook wb = new SXSSFWorkbook(10);
    private Object obj = new Object();
    private static Map<Object, Long> totalMap = new ConcurrentHashMap();
    private static Map<Object, AtomicLong> progressMap = new ConcurrentHashMap();
    private Object exportProcessId;

    public StreamingExportExcelUtil(Long total_num_data) {
        this.TOTAL_NUM_DATA = total_num_data;
        this.es = new ScheduledThreadPoolExecutor((int)this.MAX_NUM_THREAD_POOL, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("customized-export-schedule-pool-%d").daemon(true).build());
    }

    public StreamingExportExcelUtil(Integer per_read_num, Long total_num_data) {
        this.PER_READ_NUM = per_read_num;
        this.TOTAL_NUM_DATA = total_num_data;
        this.es = new ScheduledThreadPoolExecutor((int)this.MAX_NUM_THREAD_POOL, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("customized-export-schedule-pool-%d").daemon(true).build());
    }

    public StreamingExportExcelUtil(Integer max_num_thread_pool, Integer per_read_num, Long total_num_data) {
        this.MAX_NUM_THREAD_POOL = max_num_thread_pool;
        this.PER_READ_NUM = per_read_num;
        this.TOTAL_NUM_DATA = total_num_data;
        this.es = new ScheduledThreadPoolExecutor((int)this.MAX_NUM_THREAD_POOL, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("customized-export-schedule-pool-%d").daemon(true).build());
    }

    public void setExportProcessId(Object exportProcessId) {
        this.exportProcessId = exportProcessId;
        this.initProgress(exportProcessId);
    }

    protected void initProgress(Object exportProcessId) {
        totalMap.put(exportProcessId, this.TOTAL_NUM_DATA);
        progressMap.put(exportProcessId, new AtomicLong(0L));
    }

    public static AtomicLong getExportProcess(Object exportProcessId) {
        AtomicLong al = (AtomicLong)progressMap.get(exportProcessId);
        return al;
    }

    public static void removeExportProcess(Object exportProcessId) {
        progressMap.remove(exportProcessId);
    }

    public static BigDecimal getExportPercentageProcess(Object exportProcessId) {
        AtomicLong al = (AtomicLong)progressMap.get(exportProcessId);
        if (al != null) {
            long currentProcessRow = al.get();
            long total = (Long)totalMap.get(exportProcessId);
            if (total == 0L) {
                return new BigDecimal(-1);
            }
            return new BigDecimal(currentProcessRow).divide(new BigDecimal(total), 2, RoundingMode.HALF_DOWN).setScale(2, RoundingMode.HALF_DOWN);
        }
        return null;
    }

    public void read(String beanName, Method method, StreamingCallBack<T> callback, Object ... args) throws Exception {
        int i;
        Long startTimeMillis = System.currentTimeMillis();
        AtomicLong al = new AtomicLong(0L);
        if (this.exportProcessId != null) {
            progressMap.put(this.exportProcessId, al);
            totalMap.put(this.exportProcessId, this.TOTAL_NUM_DATA);
        }
        Integer sheetNum = (int)(this.TOTAL_NUM_DATA / (long)this.MAX_NUM_EXCEL_SHEET_ROW.intValue() + (long)(this.TOTAL_NUM_DATA % (long)this.MAX_NUM_EXCEL_SHEET_ROW.intValue() == 0L ? 0 : 1));
        CountDownLatch cd = new CountDownLatch(sheetNum);
        AtomicInteger ai = new AtomicInteger(0);
        Thread mainThread = Thread.currentThread();
        for (i = 0; i < sheetNum; ++i) {
            this.es.submit(() -> {
                try {
                    int sheetExecuteNum = ai.getAndIncrement();
                    Sheet sh = null;
                    Object object = this.obj;
                    synchronized (object) {
                        sh = this.wb.createSheet("sheet" + sheetExecuteNum);
                    }
                    Row row = sh.createRow(0);
                    callback.onCompletion(null, row);
                    int perQuery = 0;
                    while (perQuery * this.PER_READ_NUM < this.MAX_NUM_EXCEL_SHEET_ROW) {
                        long beginNum = sheetExecuteNum * this.MAX_NUM_EXCEL_SHEET_ROW + perQuery * this.PER_READ_NUM;
                        long endNum = Math.min(this.PER_READ_NUM, this.MAX_NUM_EXCEL_SHEET_ROW - perQuery * this.PER_READ_NUM);
                        if (beginNum >= this.TOTAL_NUM_DATA) break;
                        if (beginNum + endNum > this.TOTAL_NUM_DATA) {
                            endNum = this.TOTAL_NUM_DATA - beginNum;
                        }
                        Object bean = SpringContextHolder.getBean((String)beanName);
                        List datalist = null;
                        if (args != null && args.length > 0) {
                            int length = args.length;
                            Object[] realArgs = Arrays.copyOf(args, length + 2, Object[].class);
                            realArgs[length] = beginNum;
                            realArgs[length + 1] = endNum;
                            datalist = (List)ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])realArgs);
                        } else {
                            datalist = (List)ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{beginNum, endNum});
                        }
                        for (int column = 0; column < datalist.size(); ++column) {
                            if (this.exportProcessId != null) {
                                al.incrementAndGet();
                            }
                            Object t = datalist.get(column);
                            Row row2 = sh.createRow(column + perQuery * this.PER_READ_NUM + 1);
                            callback.onCompletion(t, row2);
                        }
                        ++perQuery;
                    }
                    System.out.println("countDown:" + sheetExecuteNum);
                    cd.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    progressMap.put(this.exportProcessId, new AtomicLong(-1L));
                    this.es.shutdownNow();
                    this.log.error((Object)"\u5bfc\u51fa\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                    mainThread.interrupt();
                }
            });
        }
        cd.await();
        if (!this.es.isShutdown()) {
            this.es.shutdown();
        }
        for (i = 0; i < sheetNum; ++i) {
            this.wb.setSheetOrder("sheet" + i, i);
        }
        if (this.exportProcessId != null) {
            progressMap.put(this.exportProcessId, new AtomicLong(this.TOTAL_NUM_DATA));
            totalMap.put(this.exportProcessId, this.TOTAL_NUM_DATA);
        }
        Long endTimeMillis = System.currentTimeMillis();
        long internal = endTimeMillis - startTimeMillis;
        System.out.println("\u6267\u884c\u65f6\u95f4\uff1a" + internal);
    }

    public void exportToOutputStream(OutputStream os) throws IOException {
        this.wb.write(os);
        this.wb.dispose();
    }

    public void exprotToZipOutputStream(OutputStream os, @NonNull String zipEntryName, @Nullable String comment) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(os);
        zipOut.putNextEntry(new ZipEntry(zipEntryName));
        zipOut.setComment(comment);
        this.wb.write((OutputStream)zipOut);
        this.wb.dispose();
    }

    public static void receiveParam(Object ... args) {
        T[] args11 = Arrays.copyOf(args, 2, Object[].class);
        System.out.println(args11[0] + "" + args11[1]);
    }

    public static void main(String[] args) {
        ConcurrentHashMap<String, AtomicLong> map = new ConcurrentHashMap<String, AtomicLong>();
        AtomicLong al = new AtomicLong(0L);
        map.put("xxx", al);
        al.getAndIncrement();
        al.getAndIncrement();
        System.out.println(map.get("xxx"));
        StreamingExportExcelUtil.receiveParam((Object[])new Object[]{new Object()});
    }
}

