/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized;

import io.searchbox.client.JestClient;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchAutoConfiguration;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchDataAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.client.RestTemplate;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication(scanBasePackages={"com.bizvane"})
@EnableDiscoveryClient
@EnableSwagger2
@EnableFeignClients(basePackages={"com.bizvane.messagefacade.interfaces", "com.bizvane.members.facade.service", "com.bizvane.members.facade.service.ur", "com.bizvane.centercontrolservice.rpc", "com.bizvane.centerstageservice.rpc", "com.bizvane.connectorservice.interfaces.rpc", "com.bizvane.wechatfacade.interfaces", "com.bizvane.couponfacade.interfaces", "com.bizvane.core.facade.interfaces", "com.bizvane.mktcenterservice.rpc", "com.bizvane.baisonBase.facade.rpc", "com.bizvane.redis.canal.service", "com.bizvane.openapifacade.rpc", "com.bizvane.fitmentservice.models.Rpc"})
@MapperScan(value={"com.bizvane.customized.mappers"})
@EnableElasticsearchRepositories(basePackages={"com.bizvane.customized.es.repository"})
@EnableAsync
@EnableAutoConfiguration(exclude={ElasticsearchAutoConfiguration.class, ElasticsearchDataAutoConfiguration.class})
@ConditionalOnClass(value={JestClient.class})
public class CustomizedApplication {
    @Bean
    RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder) {
        return restTemplateBuilder.build();
    }

    public static void main(String[] args) {
        SpringApplication.run(CustomizedApplication.class, (String[])args);
    }
}

