/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.rocketmq.rocketutils;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class RocketMQProducerService {
    @Autowired
    public ApplicationContext context;

    public SendResult sendMessage(Message message) {
        Producer producer = (Producer)this.context.getBean("topicSendCouponProducer");
        SendResult sendResult = producer.send(message);
        return sendResult;
    }

    public SendResult sendMessage(String messageBody, String topic, String tag, String megID, String messageKey) {
        Producer producer = (Producer)this.context.getBean("topicSendCouponProducer");
        Message message = new Message();
        message.setMsgID(megID);
        message.setKey(messageKey);
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        SendResult sendResult = producer.send(message);
        return sendResult;
    }

    public SendResult sendMessage(String messageBody, String topic, String tag) {
        Producer producer = (Producer)this.context.getBean("topicSendCouponProducer");
        Message message = new Message();
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        SendResult sendResult = producer.send(message);
        return sendResult;
    }

    public SendResult sendDeliverTimeMessage(String messageBody, String topic, String tag, long timeStamp) {
        Producer producer = (Producer)this.context.getBean("topicSendCouponProducer");
        Message message = new Message();
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        message.setStartDeliverTime(timeStamp);
        SendResult sendResult = producer.send(message);
        return sendResult;
    }

    public SendResult sendDelayMessage(String messageBody, String topic, String tag, long timeStamp) {
        Producer producer = (Producer)this.context.getBean("topicSendCouponProducer");
        long delayTime = System.currentTimeMillis() + timeStamp;
        Message message = new Message();
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        message.setStartDeliverTime(delayTime);
        SendResult sendResult = producer.send(message);
        return sendResult;
    }
}

