/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.rocketmq.messagelisterner;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.Message;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.customized.common.constants.IntegralCalculationConfig;
import com.bizvane.customized.common.utils.DateUtil;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.store361.service.Cus361IntegralCalculationPayTypeService;
import com.bizvane.customized.company.store361.service.Cus361StoreGroupService;
import com.bizvane.customized.facade.enums.OrderEnum;
import com.bizvane.customized.facade.models.bo.Cus361SapAndCorpBo;
import com.bizvane.customized.facade.models.po.Cus361GoodsPointsDetailsPO;
import com.bizvane.customized.facade.models.po.Cus361GoodsPointsDetailsPOExample;
import com.bizvane.customized.facade.models.po.Cus361OrderPointsDetailsPO;
import com.bizvane.customized.facade.models.po.Cus361PointsCalculationPayType;
import com.bizvane.customized.facade.models.po.Cus361PonitsCalculationConfigurationPO;
import com.bizvane.customized.facade.models.po.Cus361PonitsCalculationConfigurationPOExample;
import com.bizvane.customized.facade.utils.UUIDUtil;
import com.bizvane.customized.mappers.Cus361GoodsPointsDetailsPOMapper;
import com.bizvane.customized.mappers.Cus361OrderPointsDetailsPOMapper;
import com.bizvane.customized.mappers.Cus361PonitsCalculationConfigurationPOMapper;
import com.bizvane.customized.mappers.SysDimSkuPoMapper;
import com.bizvane.customized.rocketmq.rocketutils.RocketMQConsumeInit;
import com.bizvane.members.facade.enums.BusinessTypeEnum;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderDetailModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.models.bo.Order361Bo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.service.api.MemberOrderApiService;
import com.bizvane.members.facade.service.api361.IntegralChange361ApiService;
import com.bizvane.members.facade.service.card.request.IntegralChange361ApiRequestModel;
import com.bizvane.members.facade.service.card.request.IntegralChangeOtherBrandVO;
import com.bizvane.members.facade.vo.OrderUsedPaymentVo;
import com.bizvane.trace.annotation.TraceWeaving;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class IntegralCalculationListener
extends RocketMQConsumeInit {
    private static final Logger log = LoggerFactory.getLogger(IntegralCalculationListener.class);
    @Value(value="${customizedmq.orderconsume.consumeId361}")
    private String consumeId;
    @Value(value="${customizedmq.orderconsume.topic}")
    private String topic;
    @Autowired
    IntegralCalculationConfig integralCalculationConfig;
    @Autowired
    private Cus361PonitsCalculationConfigurationPOMapper cus361PonitsCalculationConfigurationPOMapper;
    @Autowired
    private Cus361GoodsPointsDetailsPOMapper cus361GoodsPointsDetailsPOMapper;
    @Autowired
    private Cus361OrderPointsDetailsPOMapper cus361OrderPointsDetailsPOMapper;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private Cus361StoreGroupService cus361StoreGroupService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private IntegralChange361ApiService integralChange361ApiService;
    @Autowired
    private SysDimSkuPoMapper sysDimSkuPoMapper;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private Cus361IntegralCalculationPayTypeService payTypeService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private MemberOrderApiService memberOrderApiService;
    private Long expireTime = 3600000L;

    @TraceWeaving
    protected Action processMessage(Message message) {
        log.info("IntegralCalculationListener start 361 message:{}", (Object)JSON.toJSONString((Object)message));
        String msg = new String(message.getBody());
        Order361Bo vo = (Order361Bo)JacksonUtil.json2Obj((String)msg, Order361Bo.class);
        log.info("IntegralCalculationListener enter processMessage param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        if (!this.integralCalculationConfig.getFlag().booleanValue()) {
            log.info(" orderNo {}, IntegralCalculation closed {}", (Object)vo.getOrderModel().getOrderNo(), (Object)JacksonUtil.bean2Json((Object)vo));
            return Action.CommitMessage;
        }
        String value = (String)this.redisTemplateService.stringGetStringByKey((Object)message.getKey());
        log.info("orderNo {},redis value {}", (Object)vo.getOrderModel().getOrderNo(), (Object)value);
        if (StringUtils.isNotEmpty((String)value)) {
            log.info("orderNo {},IntegralCalculation \u91cd\u590d\u6d88\u8d39 {}", (Object)vo.getOrderModel().getOrderNo(), (Object)JacksonUtil.bean2Json((Object)vo));
            return Action.CommitMessage;
        }
        try {
            SysStorePo sysStorePo = this.queryStoreInfo(vo.getOrderModel().getServiceStoreCode(), vo.getOrderModel().getSysCompanyId());
            log.info("orderNo {},\u8ba2\u5355\u95e8\u5e97\u4fe1\u606f,serviceStore sysStorePo {}", (Object)vo.getOrderModel().getOrderNo(), (Object)com.bizvane.utils.jacksonutils.JacksonUtil.bean2Json((Object)sysStorePo));
            Cus361SapAndCorpBo servicecus361SapAndCorpBo = new Cus361SapAndCorpBo();
            if (sysStorePo != null && (servicecus361SapAndCorpBo = this.queryStoreInfoByStoreCode(sysStorePo.getSysStoreOfflineCode(), "")) == null) {
                servicecus361SapAndCorpBo = new Cus361SapAndCorpBo();
            }
            Cus361PonitsCalculationConfigurationPO configurationPO = this.queryConfiguration(vo.getOrderModel().getSysCompanyId());
            log.info("orderNo {},\u7ebf\u4e0b\u6d88\u8d39\u79ef\u5206\u8ba1\u7b97\u89c4\u5219,configurationPO {}", (Object)vo.getOrderModel().getOrderNo(), (Object)com.bizvane.utils.jacksonutils.JacksonUtil.bean2Json((Object)configurationPO));
            MemberInfoModel memberInfoModel = this.queryMemberInfo(vo.getOrderModel().getMemberCode());
            log.info("orderNo {},\u4f1a\u5458\u4fe1\u606f,memberInfoModel {}", (Object)vo.getOrderModel().getOrderNo(), (Object)com.bizvane.utils.jacksonutils.JacksonUtil.bean2Json((Object)memberInfoModel));
            SysStorePo memberStorePo = this.queryStoreInfoById(memberInfoModel.getServiceStoreId());
            if (memberStorePo == null) {
                log.info("oderNO:{},memberStorePo {},\u4f1a\u5458\u6240\u5c5e\u5e97\u94fa\u4e3a\u7a7a,", (Object)vo.getOrderModel().getOrderNo());
            }
            log.info("orderNo {},\u4f1a\u5458\u6240\u5c5e\u5e97\u94fa\u4fe1\u606f,memberStorePo {}", (Object)vo.getOrderModel().getOrderNo(), (Object)com.bizvane.utils.jacksonutils.JacksonUtil.bean2Json((Object)memberStorePo));
            Cus361SapAndCorpBo memberInfoSapAndCorpBo = null;
            String serviceStoregroupCodes = "";
            if (memberInfoModel == null) {
                log.info("orderNo {},361\u8ba2\u5355\u672a\u67e5\u5230\u4f1a\u5458,\u4e0d\u4e88\u7b97\u79ef\u5206,\u65e0\u9700\u5411\u4e0b\u6267\u884c,\u4f1a\u5458MemberCode {}", (Object)vo.getOrderModel().getOrderNo(), (Object)vo.getOrderModel().getMemberCode());
                return Action.CommitMessage;
            }
            memberInfoSapAndCorpBo = this.queryStoreInfoByStoreCode(memberStorePo.getSysStoreOnlineCode(), "");
            if (memberInfoSapAndCorpBo == null) {
                memberInfoSapAndCorpBo = new Cus361SapAndCorpBo();
            }
            log.info("orderNo {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u6e20\u9053\u7ecf\u9500\u5546\u4fe1\u606f,memberInfoSapAndCorpBo {}", (Object)vo.getOrderModel().getOrderNo(), (Object)com.bizvane.utils.jacksonutils.JacksonUtil.bean2Json((Object)memberInfoSapAndCorpBo));
            List orderDetailModels = vo.getDetailModels();
            int orderPointCount = 0;
            String changeType = OrderEnum.COUPON_CONSUMPTION_TYPE.getCode();
            if (vo.getOrderModel().getOrderFlag() == 2) {
                changeType = OrderEnum.ORDER_CHARGEBACK_TYPE.getCode();
                Cus361GoodsPointsDetailsPOExample example = new Cus361GoodsPointsDetailsPOExample();
                example.createCriteria().andOrderNoEqualTo(vo.getOrderModel().getOriginalOrderNo());
                List salesOrder = this.cus361GoodsPointsDetailsPOMapper.selectByExample(example);
                log.info("orderNo {},\u539f\u59cb\u8ba2\u5355\u6240\u5f97\u7684\u79ef\u5206\u8bb0\u5f55,memberInfoSapAndCorpBo {}", (Object)vo.getOrderModel().getOrderNo(), (Object)com.bizvane.utils.jacksonutils.JacksonUtil.bean2Json((Object)salesOrder));
                block2: for (OrderDetailModel model : orderDetailModels) {
                    for (int i = 0; i < salesOrder.size(); ++i) {
                        int goodPoints;
                        Cus361GoodsPointsDetailsPO po = (Cus361GoodsPointsDetailsPO)salesOrder.get(i);
                        log.info("orderNo {},361\u9000\u5355\u9000\u79ef\u5206,\u589e\u52a0\u6298\u6263\u4ef7\u5224\u65ad,\u9000\u5355sku={},\u539f\u5355sku={},\u9000\u5355\u6298\u6263\u4ef7={},\u539f\u5355\u6298\u6263\u4ef7={}", new Object[]{vo.getOrderModel().getOrderNo(), model.getSku(), po.getSkuCode(), model.getDiscountPrice(), po.getDiscountPrice()});
                        if (!model.getSku().equals(po.getSkuCode()) || model.getDiscountPrice() == null || po.getDiscountPrice() == null || model.getDiscountPrice().compareTo(po.getDiscountPrice()) != 0) continue;
                        log.info("orderNo {},361\u9000\u5355\u9000\u79ef\u5206,\u6298\u6263\u4ef7\u5224\u65ad\u901a\u8fc7,\u9000\u5355sku={},\u539f\u5355sku={},\u9000\u5355\u6298\u6263\u4ef7={},\u539f\u5355\u6298\u6263\u4ef7={}", new Object[]{vo.getOrderModel().getOrderNo(), model.getSku(), po.getSkuCode(), model.getDiscountPrice(), po.getDiscountPrice()});
                        if (Math.abs(model.getQuantity()) == Math.abs(po.getGoodsNum())) {
                            goodPoints = po.getGoodsPoints();
                            orderPointCount += goodPoints;
                            log.info("orderNo {},361\u9000\u5355\u9000\u79ef\u5206,\u9000\u5355sku={},\u8be5\u5546\u54c1\u9000\u5355\u6570\u91cf\u4e0e\u6b63\u5355\u6570\u91cf\u76f8\u540c,\u76f4\u63a5\u62ff\u53d6\u5546\u54c1\u6b63\u5355\u6240\u5f97\u79ef\u5206:{}", new Object[]{vo.getOrderModel().getOrderNo(), model.getSku(), goodPoints});
                        } else {
                            goodPoints = new BigDecimal(po.getGoodsPoints()).multiply(new BigDecimal(Math.abs(model.getQuantity()))).divide(new BigDecimal(Math.abs(po.getGoodsNum())), 0, 1).intValue();
                            orderPointCount += goodPoints;
                            log.info("orderNo {},361\u9000\u5355\u9000\u79ef\u5206,\u9000\u5355sku={},\u8be5\u5546\u54c1\u9000\u5355\u6570\u91cf\u4e0e\u6b63\u5355\u6570\u91cf\u4e0d\u540c,\u8ba1\u7b97\u5546\u54c1\u6240\u9000\u79ef\u5206:{}", new Object[]{vo.getOrderModel().getOrderNo(), model.getSku(), goodPoints});
                        }
                        log.info("orderNo {},361\u9000\u5355\u9000\u79ef\u5206\uff0csku={},\u9000\u5355\u7d2f\u8ba1\u79ef\u5206 orderPointCount {}", new Object[]{vo.getOrderModel().getOrderNo(), model.getSku(), orderPointCount});
                        this.saveGoodsPointsDetail(model, Integer.valueOf(goodPoints), OrderEnum.ORDER_CHARGEBACK_TYPE.getCode());
                        continue block2;
                    }
                }
            } else {
                Boolean isTemp = false;
                Boolean isGroupIsolation = true;
                BigDecimal integralRatioBD = new BigDecimal(1);
                double configdistCount = 0.0;
                Boolean isSendPointFlag = false;
                if (configurationPO != null) {
                    isGroupIsolation = "2".equals(configurationPO.getIsEnable());
                    log.info("orderNo {},\u68c0\u67e5\u79ef\u5206\u89c4\u5219\u8de8\u533a\u57df\u8bbe\u7f6e\u6761\u4ef6,\u8de8\u533a\u57df\u662f\u5426\u4e0d\u4ea7\u751f\u6d88\u8d39\u79ef\u5206:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)isGroupIsolation);
                    if (isGroupIsolation.booleanValue()) {
                        log.info("orderNo {},\u68c0\u67e5\u79ef\u5206\u89c4\u5219\u8de8\u533a\u57df\u8bbe\u7f6e\u6761\u4ef6,\u8de8\u533a\u57df\u4e0d\u4ea7\u751f\u6d88\u8d39\u79ef\u5206,verifyGroupIsolation isGroupIsolation {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u7ecf\u9500\u5546memberStoreCorpCode:{},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u52a0\u76df\u5546memberStoreSapCustomerCode:{},\u8ba2\u5355\u95e8\u5e97\u7ecf\u9500\u5546serviceStoreCorpCode:{},\u8ba2\u5355\u95e8\u5e97\u52a0\u76df\u5546serviceStoreSapCustomerCode:{}", new Object[]{vo.getOrderModel().getOrderNo(), isGroupIsolation, memberInfoSapAndCorpBo.getCorpCode(), memberInfoSapAndCorpBo.getSapCustomerCode(), servicecus361SapAndCorpBo.getCorpCode(), servicecus361SapAndCorpBo.getSapCustomerCode()});
                        isTemp = this.verifyGroupIsolation(isGroupIsolation, memberInfoSapAndCorpBo.getCorpCode(), memberInfoSapAndCorpBo.getSapCustomerCode(), servicecus361SapAndCorpBo.getCorpCode(), servicecus361SapAndCorpBo.getSapCustomerCode(), vo.getOrderModel().getOrderNo());
                        log.info("orderNo {},\u68c0\u67e5\u79ef\u5206\u89c4\u5219\u8de8\u533a\u57df\u8bbe\u7f6e\u6761\u4ef6,\u8de8\u533a\u57df\u4e0d\u4ea7\u751f\u6d88\u8d39\u79ef\u5206,\u9a8c\u8bc1\u662f\u4f1a\u5458\u95e8\u5e97\u548c\u8ba2\u5355\u95e8\u5e97\u662f\u5426\u7b26\u5408\u4e0d\u8de8\u533a\u57df\u6761\u4ef6:{},verifyGroupIsolation isGroupIsolation {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u7ecf\u9500\u5546memberStoreCorpCode:{},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u52a0\u76df\u5546memberStoreSapCustomerCode:{},\u8ba2\u5355\u95e8\u5e97\u7ecf\u9500\u5546serviceStoreCorpCode:{},\u8ba2\u5355\u95e8\u5e97\u52a0\u76df\u5546serviceStoreSapCustomerCode:{}", new Object[]{vo.getOrderModel().getOrderNo(), isTemp, isGroupIsolation, memberInfoSapAndCorpBo.getCorpCode(), memberInfoSapAndCorpBo.getSapCustomerCode(), servicecus361SapAndCorpBo.getCorpCode(), servicecus361SapAndCorpBo.getSapCustomerCode()});
                    } else {
                        isTemp = true;
                        log.info("orderNo {},\u68c0\u67e5\u79ef\u5206\u89c4\u5219\u8de8\u533a\u57df\u8bbe\u7f6e\u6761\u4ef6,\u8de8\u533a\u57df\u53ef\u4ee5\u4ea7\u751f\u6d88\u8d39\u79ef\u5206,verifyGroupIsolation isGroupIsolation {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u7ecf\u9500\u5546memberStoreCorpCode:{},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u52a0\u76df\u5546memberStoreSapCustomerCode:{},\u8ba2\u5355\u95e8\u5e97\u7ecf\u9500\u5546serviceStoreCorpCode:{},\u8ba2\u5355\u95e8\u5e97\u52a0\u76df\u5546serviceStoreSapCustomerCode:{}", new Object[]{vo.getOrderModel().getOrderNo(), isGroupIsolation, memberInfoSapAndCorpBo.getCorpCode(), memberInfoSapAndCorpBo.getSapCustomerCode(), servicecus361SapAndCorpBo.getCorpCode(), servicecus361SapAndCorpBo.getSapCustomerCode()});
                    }
                }
                log.info("orderNo {}, \u7b26\u5408\u79ef\u5206\u89c4\u5219\u533a\u57df\u8bbe\u7f6e\u6761\u4ef6:{} \u4f1a\u5458\u5361\u7b49\u7ea7Id:{}", new Object[]{vo.getOrderModel().getOrderNo(), isTemp, memberInfoModel.getLevelId()});
                MbrLevelModel levelModel = this.queryLevelCode(memberInfoModel.getLevelId().longValue());
                log.info("orderNo {}, \u9002\u7528\u5361\u7b49\u7ea7\u6761\u4ef6,\u4f1a\u5458\u5361\u7b49\u7ea7code:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)levelModel.getOfflineLevelCode());
                Boolean isApplicableCardGrade = this.isApplicableCardGrade(configurationPO.getLevelCodes(), levelModel.getOfflineLevelCode());
                log.info("orderNo {}, \u9002\u7528\u5361\u7b49\u7ea7\u6761\u4ef6,\u662f\u5426\u5728\u9001\u79ef\u5206\u7684\u8303\u56f4:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)isApplicableCardGrade);
                if (isTemp.booleanValue() && isApplicableCardGrade.booleanValue()) {
                    isSendPointFlag = true;
                }
                log.info("orderNo {}, \u662f\u5426\u540c\u65f6\u7b26\u5408\u79ef\u5206\u89c4\u5219\u533a\u57df\u8bbe\u7f6e\u6761\u4ef6\u548c\u9002\u7528\u5361\u7b49\u7ea7\u6761\u4ef6:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)isSendPointFlag);
                Boolean isOpenIntegraRatio = "1".equals(configurationPO.getIsIntegralRatio());
                log.info("orderNo {},\u662f\u5426\u5f00\u542f\u79ef\u5206\u500d\u7387:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)isOpenIntegraRatio);
                if (isSendPointFlag.booleanValue() && isOpenIntegraRatio.booleanValue()) {
                    integralRatioBD = this.integralRatio(levelModel.getOfflineLevelCode(), configurationPO.getIntegralRatios());
                }
                log.info("orderNo {},\u4e0d\u540c\u7b49\u7ea7 \u79ef\u5206\u500d\u7387:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)integralRatioBD);
                List payTypeList = this.payTypeService.queryPayTypeListByParam(vo.getOrderModel().getSysCompanyId().longValue());
                log.info("orderNo {} \u914d\u7f6e\u652f\u4ed8\u65b9\u5f0f\u4e3a:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)payTypeList);
                BigDecimal integrableAmount = this.integrableAmount(vo, payTypeList);
                log.info("orderNo {} \u7b26\u5408\u914d\u7f6e\u652f\u4ed8\u7c7b\u578b\u8981\u6c42\u7684\u8ba2\u5355\u603b\u91d1\u989d:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)integrableAmount);
                SysStoreVo serviceStoregroupCode = new SysStoreVo();
                if (sysStorePo != null) {
                    serviceStoregroupCode = this.queryStoreGroup(sysStorePo.getSysStoreOfflineCode(), sysStorePo.getSysCompanyId());
                    log.info("orderNo {},\u8ba2\u5355\u670d\u52a1\u95e8\u5e97\u7684\u7fa4\u7ec4\u4fe1\u606f:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)com.bizvane.utils.jacksonutils.JacksonUtil.bean2Json((Object)serviceStoregroupCode));
                }
                if (serviceStoregroupCode != null) {
                    serviceStoregroupCodes = serviceStoregroupCode.getSysStoreGroupCodes();
                    configdistCount = this.verifyConfigDistCount(serviceStoregroupCodes, configurationPO);
                }
                log.info("orderNo {},\u8be5\u5e97\u94fa\u6700\u4f4e\u7fa4\u7ec4\u6298\u6263\u4e3a:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)configdistCount);
                log.info("orderNo {},\u5546\u54c1\u8be6\u60c5\u4e2a\u6570:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)orderDetailModels.size());
                for (OrderDetailModel model : orderDetailModels) {
                    log.info("orderNo {},\u5546\u54c1sku:{},\u5546\u54c1\u6298\u6263rebate:{}", new Object[]{vo.getOrderModel().getOrderNo(), model.getSku(), model.getRebate()});
                    int goodPoints = 0;
                    if (model.getRebate().compareTo(new BigDecimal(configdistCount)) == 1 || model.getRebate().compareTo(new BigDecimal(configdistCount)) == 0) {
                        log.info("orderNo {} \u5546\u54c1\u6298\u6263\u5927\u4e8e\u7b49\u4e8e\u7fa4\u7ec4\u6700\u4f4e\u6298\u6263,\u7b26\u5408\u6298\u6263\u6761\u4ef6,\u5546\u54c1sku:{},\u662f\u5426\u540c\u65f6\u7b26\u5408\u79ef\u5206\u89c4\u5219\u533a\u57df\u8bbe\u7f6e\u6761\u4ef6\u548c\u9002\u7528\u5361\u7b49\u7ea7\u6761\u4ef6:{},\u7b26\u5408\u914d\u7f6e\u652f\u4ed8\u7c7b\u578b\u8981\u6c42\u7684\u8ba2\u5355\u603b\u91d1\u989d:{},\u8ba2\u5355\u652f\u4ed8\u91d1\u989d:{},\u5546\u54c1\u6298\u6263\u4ef7:{},\u79ef\u5206\u500d\u7387:{}", new Object[]{vo.getOrderModel().getOrderNo(), model.getSku(), isSendPointFlag, integrableAmount, vo.getOrderModel().getPayMoney(), model.getDiscountPrice(), integralRatioBD});
                        goodPoints = this.integralCalculation(isSendPointFlag, integrableAmount, vo.getOrderModel().getPayMoney(), model.getDiscountPrice(), model.getQuantity(), integralRatioBD);
                        log.info("orderNo {} \u5546\u54c1\u6298\u6263\u5927\u4e8e\u7b49\u4e8e\u7fa4\u7ec4\u6700\u4f4e\u6298\u6263,\u7b26\u5408\u6298\u6263\u6761\u4ef6,\u5546\u54c1sku:{},\u5546\u54c1\u8ba1\u7b97\u79ef\u5206\u4e3a:{}", new Object[]{vo.getOrderModel().getOrderNo(), model.getSku(), goodPoints});
                        orderPointCount += goodPoints;
                    } else {
                        log.info("orderNo {} \u5546\u54c1\u6298\u6263\u5c0f\u4e8e\u7fa4\u7ec4\u6700\u4f4e\u6298\u6263,\u4e0d\u7b26\u5408\u6298\u6263\u6761\u4ef6,\u5546\u54c1sku:{},\u5546\u54c1\u8ba1\u7b97\u79ef\u5206\u4e3a:0", (Object)vo.getOrderModel().getOrderNo(), (Object)model.getSku());
                    }
                    this.saveGoodsPointsDetail(model, Integer.valueOf(goodPoints), OrderEnum.COUPON_CONSUMPTION_TYPE.getCode());
                }
            }
            log.info("orderNo {},\u8ba2\u5355\u6700\u7ec8\u8ba1\u7b97\u79ef\u5206\u4e3a:{}", (Object)vo.getOrderModel().getOrderNo(), (Object)orderPointCount);
            if (configurationPO == null) {
                configurationPO = new Cus361PonitsCalculationConfigurationPO();
                configurationPO.setCus361PonitsCalculationConfigurationId(Long.valueOf(0L));
            }
            SysStoreVo memberTmStoregroupCode = this.queryStoreGroup(memberStorePo.getSysStoreOfflineCode(), memberStorePo.getSysCompanyId());
            String serviceStoreGroupCodes = "";
            if (memberTmStoregroupCode != null) {
                serviceStoreGroupCodes = memberTmStoregroupCode.getSysStoreGroupCodes();
            }
            this.saveCus361OrderPointsDetails(vo.getOrderModel(), servicecus361SapAndCorpBo.getCorpCode(), servicecus361SapAndCorpBo.getSapCustomerCode(), servicecus361SapAndCorpBo.getAreaCode(), memberInfoSapAndCorpBo.getCorpCode(), memberInfoSapAndCorpBo.getSapCustomerCode(), memberInfoSapAndCorpBo.getAreaCode(), configurationPO.getCus361PonitsCalculationConfigurationId(), orderPointCount, memberInfoModel, serviceStoreGroupCodes, sysStorePo.getSysStoreOfflineCode(), serviceStoregroupCodes, changeType);
            if (orderPointCount != 0) {
                SysBrandVo sysBrandVo = this.querySysBrandVo(vo.getOrderModel().getBrandId());
                this.integralChangeOperateOffline(memberInfoModel.getErpId(), orderPointCount, sysBrandVo.getSysBrandId(), vo.getOrderModel().getOrderNo(), sysStorePo.getSysStoreOnlineCode(), changeType);
                this.integralChangeOfflineICEM(vo.getOrderModel().getErpId(), orderPointCount, vo.getOrderModel().getSysCompanyId(), vo.getOrderModel().getBrandId(), memberInfoModel.getMemberCode(), vo.getOrderModel().getOrderNo(), memberInfoModel.getCardNo(), memberInfoModel.getOfflineCardNo(), Integer.valueOf(orderPointCount), sysStorePo.getStoreId(), sysStorePo.getSysStoreOfflineCode(), changeType);
            }
            this.redisTemplateService.stringSetValueAndExpireTime((Object)vo.getOrderModel().getOrderNo(), (Object)"1", this.expireTime.longValue());
            return Action.CommitMessage;
        }
        catch (Exception e) {
            log.error("oderNO {},\u5f02\u5e38 {}", (Object)vo.getOrderModel().getOrderNo(), (Object)e);
            this.redisTemplateService.deleteFromRedis((Object)message.getKey());
            return null;
        }
    }

    private MbrLevelModel queryLevelCode(long levelId) {
        ResponseData result = this.memberLevelApiService.queryLevelModel(Long.valueOf(levelId));
        if (result.getCode() == 0 && result.getData() != null) {
            return (MbrLevelModel)result.getData();
        }
        return new MbrLevelModel();
    }

    private Boolean isApplicableCardGrade(String levelCodesStr, String levelCode) {
        String[] levelCodes = levelCodesStr.split(",");
        Boolean flag = false;
        if (levelCodes != null) {
            for (int i = 0; i < levelCodes.length; ++i) {
                if (!levelCodes[i].equals(levelCode)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private BigDecimal integralRatio(String levelCode, String integralRatioStr) {
        JSONArray integralRatioDatas = JSONArray.parseArray((String)integralRatioStr);
        BigDecimal integralRatio = new BigDecimal(1);
        if (integralRatioDatas != null) {
            for (int i = 0; i < integralRatioDatas.size(); ++i) {
                JSONObject object = integralRatioDatas.getJSONObject(i);
                if (!object.getString("levelCode").equals(levelCode)) continue;
                integralRatio = object.getBigDecimal("ratio");
                break;
            }
        }
        return integralRatio;
    }

    private BigDecimal integrableAmount(Order361Bo vo, List<Cus361PointsCalculationPayType> payTypeList) {
        BigDecimal integrableAmount = new BigDecimal(0);
        for (int i = 0; i < vo.getOrderPayMent().size(); ++i) {
            OrderUsedPaymentVo orderUsedPaymentVo = (OrderUsedPaymentVo)vo.getOrderPayMent().get(i);
            String payType = orderUsedPaymentVo.getPayType();
            Boolean isCalculateFalg = this.isCalculateByPayType(payType, payTypeList);
            log.info("orderNo {},\u662f\u5426\u7b26\u5408\u914d\u7f6e\u652f\u4ed8\u7c7b\u578b\u8981\u6c42:{},\u652f\u4ed8\u7c7b\u578b:{},\u91d1\u989d:{}", new Object[]{vo.getOrderModel().getOrderNo(), isCalculateFalg, payType, orderUsedPaymentVo.getPayAmount()});
            if (!isCalculateFalg.booleanValue()) continue;
            integrableAmount = integrableAmount.add(orderUsedPaymentVo.getPayAmount());
        }
        return integrableAmount;
    }

    private SysStorePo queryStoreInfo(String sysStoreOfflineCode, Long sysCompanyId) {
        log.info("queryStoreInfo   sysStoreOfflineCode:{},sysCompanyId {}", (Object)sysStoreOfflineCode, (Object)sysCompanyId);
        ResponseData responseData = this.storeServiceRpc.getStoreByOfflineCode(sysStoreOfflineCode, sysCompanyId);
        if (responseData.getCode() == 0 && responseData.getData() != null) {
            return (SysStorePo)responseData.getData();
        }
        return null;
    }

    private SysBrandVo querySysBrandVo(Long brandId) {
        ResponseData responseData = this.brandServiceRpc.getBrandId(brandId);
        if (responseData.getCode() == 0 && responseData.getData() != null) {
            return (SysBrandVo)responseData.getData();
        }
        return null;
    }

    private SysStorePo queryStoreInfoById(Long storeId) {
        ResponseData responseData = this.storeServiceRpc.getStoreById(storeId);
        if (responseData.getCode() == 0 && responseData.getData() != null) {
            return (SysStorePo)responseData.getData();
        }
        return null;
    }

    public boolean isCalculateByPayType(String paymentTypeParam, List<Cus361PointsCalculationPayType> payTypePOS) {
        boolean paymentFlag = false;
        List filterList = payTypePOS.stream().filter(payType -> payType.getPayCode().equals(paymentTypeParam)).collect(Collectors.toList());
        if (filterList == null) {
            paymentFlag = true;
        }
        if (filterList.size() == 0) {
            paymentFlag = true;
        }
        if (filterList != null && filterList.size() > 0 && "1".equals(((Cus361PointsCalculationPayType)filterList.get(0)).getIsSendPoint())) {
            paymentFlag = true;
        }
        return paymentFlag;
    }

    private void integralChangeOfflineICEM(String erpid, int integral, Long sysCompanyId, Long brandId, String memberCode, String changeBills, String cardNo, String offlineCardNo, Integer changeIntegral, String storeId, String storeCode, String changeType) {
        IntegralChange361ApiRequestModel model = new IntegralChange361ApiRequestModel();
        model.setErpid(erpid);
        String point = "1".equals(changeType) ? String.valueOf(integral) : String.valueOf(-integral);
        model.setIntegral(point);
        model.setBusinessType("0");
        model.setSysCompanyId(sysCompanyId);
        Integer point1 = "1".equals(changeType) ? integral : -integral;
        model.setBrandId(brandId);
        model.setMemberCode(memberCode);
        model.setCardNo(cardNo);
        model.setOfflineCardNo(offlineCardNo);
        model.setChangeDate(DateUtil.getNow((String)"yyyy-MM-dd HH:mm:ss"));
        model.setChangeType(changeType);
        model.setChangeBills(UUIDUtil.getUUID16());
        model.setPointsAmount(changeIntegral);
        model.setStoreId(storeId);
        model.setStoreCode(storeCode);
        model.setSource("999");
        model.setChangeIntegral(changeIntegral);
        model.setChangeDetails("\u8ba2\u5355\u6d88\u8d39\u5355\u636e\u751f\u6210\u79ef\u5206[" + changeBills + "]");
        log.info("oderNO {} integralChangeOfflineICEM param:{}", (Object)changeBills, (Object)com.bizvane.utils.jacksonutils.JacksonUtil.bean2Json((Object)model));
        ResponseData result = this.integralChange361ApiService.integralChangeOperateOffline(model);
        log.info("oderNO {} integralChangeOfflineICEM result message:{},code:{},changeBills:{}", new Object[]{changeBills, result.getMessage(), result.getCode()});
    }

    private void integralChangeOperateOffline(String erpid, int integral, Long brandId, String changeBills, String storeCode, String changeType) {
        try {
            IntegralChangeOtherBrandVO vo = new IntegralChangeOtherBrandVO();
            vo.setSysBrandId(brandId);
            vo.setBusinessType(BusinessTypeEnum.ACTIVITY_TYPE_ORDER.getMsg());
            Integer point = "1".equals(changeType) ? integral : -integral;
            vo.setChangeBills(changeBills);
            vo.setChangeIntegral(point);
            vo.setChangeRemark("\u8ba2\u5355\u6d88\u8d39\u5355\u636e\u751f\u6210\u79ef\u5206[" + changeBills + "]");
            vo.setErpId(erpid);
            vo.setOfflineIntegralId(UUIDUtil.getUUID16());
            vo.setSource("1");
            vo.setStoreCode(storeCode);
            ResponseData responseData = this.integralChange361ApiService.integralChangeOtherBrandNew(vo);
            log.info("oderNO {} integralChangeOperateOffline result :{}", (Object)changeBills, (Object)com.bizvane.utils.jacksonutils.JacksonUtil.bean2Json((Object)responseData));
        }
        catch (Exception e) {
            log.info("oderNO {} integralChangeOperateOffline {}", (Object)changeBills, (Object)e.getMessage());
        }
    }

    private void saveGoodsPointsDetail(OrderDetailModel model, Integer goodsPoints, String changeType) {
        Cus361GoodsPointsDetailsPO po = new Cus361GoodsPointsDetailsPO();
        po.setBrandId(model.getBrandId());
        po.setSysCompanyId(model.getSysCompanyId());
        po.setDiscount(Long.valueOf(model.getRebate().longValue()));
        po.setDiscountPrice(model.getDiscountPrice());
        po.setGoodsCode(model.getProductNo());
        po.setGoodsNum(model.getQuantity());
        po.setGoodsName(model.getProductName());
        po.setGoodsPoints(goodsPoints);
        po.setOrderNo(model.getOrderNo());
        po.setSkuCode(model.getSku());
        po.setChangeType(changeType);
        po.setValid("1");
        int flag = this.cus361GoodsPointsDetailsPOMapper.insert(po);
        log.info("orderNo {} saveGoodsPointsDetail save flag:{}", (Object)model.getOrderNo(), (Object)flag);
    }

    private void saveCus361OrderPointsDetails(OrderModel model, String serviceStoreCorpCode, String serviceStoreSapCustomerCode, String serviceAreaCode, String memberStoreCorpCode, String memberStoreSapCustomerCode, String memberStoreAreaCode, Long ruleId, int orderPointCount, MemberInfoModel memberInfo, String tmStoreGroupCode, String consumeShopCode, String consumeGroupCode, String changeType) {
        Cus361OrderPointsDetailsPO po = new Cus361OrderPointsDetailsPO();
        po.setSysCompanyId(model.getSysCompanyId());
        po.setBrandId(model.getBrandId());
        po.setOrderNo(model.getOrderNo());
        po.setOrderIntegral(Integer.valueOf(orderPointCount));
        po.setCardNo(memberInfo.getCardNo());
        po.setMemberName(memberInfo.getName());
        po.setMemberCode(model.getMemberCode());
        po.setChangeType(changeType);
        po.setSysStoreCode(consumeShopCode);
        po.setTmStoreGroupCode(tmStoreGroupCode);
        po.setTmStoreAreaCode(memberStoreAreaCode);
        po.setTmFranchiseeCode(memberStoreCorpCode);
        po.setTmDistributorCode(memberStoreSapCustomerCode);
        po.setConsumeShopCode(consumeShopCode);
        po.setConsumeAreaCode(serviceAreaCode);
        po.setConsumeDistributorCode(serviceStoreCorpCode);
        po.setConsumeFranchiseeCode(serviceStoreSapCustomerCode);
        po.setConsumeGroupCode(consumeGroupCode);
        po.setRuleId(ruleId);
        int flag = this.cus361OrderPointsDetailsPOMapper.insert(po);
        log.info("orderNo {} saveCus361OrderPointsDetails save flag:{}", (Object)model.getOrderNo(), (Object)flag);
        OrderModel orderModel = new OrderModel();
        orderModel.setSysCompanyId(model.getSysCompanyId());
        orderModel.setBrandId(model.getBrandId());
        orderModel.setOrderNo(model.getOrderNo());
        orderModel.setGetedIntegral(Integer.valueOf(orderPointCount));
        this.updateOrderGetedIntegral(orderModel);
    }

    private void updateOrderGetedIntegral(OrderModel orderModel) {
        log.info("updateOrderGetedIntegral param:{}", (Object)JacksonUtil.bean2Json((Object)orderModel));
        this.memberOrderApiService.updateOrderGetedIntegral(orderModel);
    }

    private MemberInfoModel queryMemberInfo(String memberCode) {
        MemberInfoModel model = new MemberInfoModel();
        model.setMemberCode(memberCode);
        ResponseData modelResponseData = this.memberInfoApiService.getSingleMemberModel(model);
        if (modelResponseData.getCode() == 0 && modelResponseData.getData() != null) {
            return (MemberInfoModel)modelResponseData.getData();
        }
        return null;
    }

    private Cus361PonitsCalculationConfigurationPO queryConfiguration(Long sysCompanyId) {
        Cus361PonitsCalculationConfigurationPOExample example = new Cus361PonitsCalculationConfigurationPOExample();
        example.setOrderByClause("create_date desc");
        example.createCriteria().andSysCompanyIdEqualTo(sysCompanyId);
        List resultList = this.cus361PonitsCalculationConfigurationPOMapper.selectByExample(example);
        if (resultList.size() > 0) {
            return (Cus361PonitsCalculationConfigurationPO)resultList.get(0);
        }
        return null;
    }

    private Cus361SapAndCorpBo queryStoreInfoByStoreCode(String storeCode, String originStoreCode) {
        ResponseData list = this.cus361StoreGroupService.get361CodeByStoreCode(storeCode, originStoreCode);
        if (list.getCode() == 0 && list.getData() != null) {
            return (Cus361SapAndCorpBo)list.getData();
        }
        return null;
    }

    private Boolean verifyGroupIsolation(Boolean isGroupIsolation, String memberStoreCorpCode, String memberStoreSapCustomerCode, String serviceStoreCorpCode, String serviceStoreSapCustomerCode, String orderNo) {
        Boolean flag = false;
        if (isGroupIsolation.booleanValue()) {
            if (StringUtils.isBlank((String)memberStoreCorpCode) && StringUtils.isBlank((String)serviceStoreCorpCode)) {
                if (StringUtils.isBlank((String)memberStoreSapCustomerCode) && StringUtils.isBlank((String)serviceStoreSapCustomerCode)) {
                    flag = true;
                    log.info("orderNo {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u7ecf\u9500\u5546\u3001\u8ba2\u5355\u95e8\u5e97\u7ecf\u9500\u5546\u5747\u4e3a\u7a7a\uff0c\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u4e0e\u8ba2\u5355\u670d\u52a1\u95e8\u5e97\u52a0\u76df\u5546\u5747\u4e3a\u7a7a,\u6309\u4e0d\u8de8\u533a\u57df\u5904\u7406,\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u7ecf\u9500\u5546memberStoreCorpCode {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u52a0\u76df\u5546memberStoreSapCustomerCode {},\u8ba2\u5355\u95e8\u5e97\u7ecf\u9500\u5546serviceStoreCorpCode {},\u8ba2\u5355\u95e8\u5e97\u52a0\u76df\u5546serviceStoreSapCustomerCode {}", new Object[]{memberStoreCorpCode, memberStoreSapCustomerCode, serviceStoreCorpCode, serviceStoreSapCustomerCode});
                } else if (StringUtils.isNotBlank((String)memberStoreSapCustomerCode) && StringUtils.isNotBlank((String)serviceStoreSapCustomerCode) && memberStoreSapCustomerCode.equals(serviceStoreSapCustomerCode)) {
                    flag = true;
                    log.info("orderNo {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u7ecf\u9500\u5546\u3001\u8ba2\u5355\u95e8\u5e97\u7ecf\u9500\u5546\u5747\u4e3a\u7a7a,\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u4e0e\u8ba2\u5355\u670d\u52a1\u95e8\u5e97\u52a0\u76df\u5546\u5747\u4e0d\u4e3a\u7a7a\u4e14\u76f8\u540c,\u6309\u4e0d\u8de8\u533a\u57df\u5904\u7406,\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u7ecf\u9500\u5546memberStoreCorpCode {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u52a0\u76df\u5546memberStoreSapCustomerCode {},\u8ba2\u5355\u95e8\u5e97\u7ecf\u9500\u5546serviceStoreCorpCode {},\u8ba2\u5355\u95e8\u5e97\u52a0\u76df\u5546serviceStoreSapCustomerCode {}", new Object[]{memberStoreCorpCode, memberStoreSapCustomerCode, serviceStoreCorpCode, serviceStoreSapCustomerCode});
                }
            } else if (StringUtils.isNotBlank((String)memberStoreCorpCode) && StringUtils.isNotBlank((String)serviceStoreCorpCode) && memberStoreCorpCode.equals(serviceStoreCorpCode)) {
                if (StringUtils.isBlank((String)memberStoreSapCustomerCode) && StringUtils.isBlank((String)serviceStoreSapCustomerCode)) {
                    flag = true;
                    log.info("orderNo {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u7ecf\u9500\u5546\u3001\u8ba2\u5355\u95e8\u5e97\u7ecf\u9500\u5546\u5747\u4e0d\u4e3a\u7a7a\u4e14\u76f8\u540c,\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u4e0e\u8ba2\u5355\u670d\u52a1\u95e8\u5e97\u52a0\u76df\u5546\u5747\u4e3a\u7a7a,\u6309\u4e0d\u8de8\u533a\u57df\u5904\u7406,\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u7ecf\u9500\u5546memberStoreCorpCode {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u52a0\u76df\u5546memberStoreSapCustomerCode {},\u8ba2\u5355\u95e8\u5e97\u7ecf\u9500\u5546serviceStoreCorpCode {},\u8ba2\u5355\u95e8\u5e97\u52a0\u76df\u5546serviceStoreSapCustomerCode {}", new Object[]{memberStoreCorpCode, memberStoreSapCustomerCode, serviceStoreCorpCode, serviceStoreSapCustomerCode});
                } else if (StringUtils.isNotBlank((String)memberStoreSapCustomerCode) && StringUtils.isNotBlank((String)serviceStoreSapCustomerCode) && memberStoreSapCustomerCode.equals(serviceStoreSapCustomerCode)) {
                    flag = true;
                    log.info("orderNo {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u7ecf\u9500\u5546\u3001\u8ba2\u5355\u95e8\u5e97\u7ecf\u9500\u5546\u5747\u4e0d\u4e3a\u7a7a\u4e14\u76f8\u540c,\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u4e0e\u8ba2\u5355\u670d\u52a1\u95e8\u5e97\u52a0\u76df\u5546\u5747\u4e0d\u4e3a\u7a7a\u4e14\u76f8\u540c,\u6309\u4e0d\u8de8\u533a\u57df\u5904\u7406,\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u7ecf\u9500\u5546memberStoreCorpCode {},\u4f1a\u5458\u670d\u52a1\u95e8\u5e97\u52a0\u76df\u5546memberStoreSapCustomerCode {},\u8ba2\u5355\u95e8\u5e97\u7ecf\u9500\u5546serviceStoreCorpCode {},\u8ba2\u5355\u95e8\u5e97\u52a0\u76df\u5546serviceStoreSapCustomerCode {}", new Object[]{memberStoreCorpCode, memberStoreSapCustomerCode, serviceStoreCorpCode, serviceStoreSapCustomerCode});
                }
            }
        } else {
            flag = true;
        }
        return flag;
    }

    private int integralCalculation(Boolean isSendPointFlag, BigDecimal integrableAmount, BigDecimal orderPayMoney, BigDecimal discountPrice, Integer quantity, BigDecimal integralRatioBD) {
        int point = 0;
        if (isSendPointFlag.booleanValue()) {
            if (orderPayMoney.compareTo(new BigDecimal("0.0")) == 0) {
                return point;
            }
            point = integrableAmount.divide(orderPayMoney, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(quantity)).multiply(discountPrice).divide(integralRatioBD, 4, RoundingMode.HALF_UP).setScale(0, RoundingMode.CEILING).intValue();
        }
        return point;
    }

    private SysStoreVo queryStoreGroup(String storeId, Long sysCompanyId) {
        try {
            SysStoreVo vo = new SysStoreVo();
            vo.setSysCompanyId(sysCompanyId);
            ArrayList<String> list = new ArrayList<String>();
            list.add(storeId);
            vo.setStoreIds(list);
            ResponseData result = this.storeServiceRpc.getStoreGroupCodeByStoreCodes(vo);
            Map serviceStoremap = null;
            if (result.getCode() == 0 && null != result.getData()) {
                serviceStoremap = (Map)result.getData();
                return (SysStoreVo)serviceStoremap.get(storeId);
            }
        }
        catch (Exception e) {
            log.error(" queryStoreGroup {}", (Throwable)e);
        }
        return null;
    }

    private double verifyConfigDistCount(String storegroupCodes, Cus361PonitsCalculationConfigurationPO configuration) {
        if (configuration == null) {
            return 0.0;
        }
        if (StringUtils.isBlank((String)storegroupCodes)) {
            return 0.0;
        }
        double distcountDouble = 0.0;
        ArrayList<Double> distCountList = new ArrayList<Double>();
        try {
            JSONArray configurationArray = JSON.parseArray((String)configuration.getDiscountStoreGroup());
            for (int i = 0; i < configurationArray.size(); ++i) {
                String[] discountStoreGroupCodes;
                String discountStoreGroupCodesStr = configurationArray.getJSONObject(i).getString("discountStoreGroupCode");
                for (String configStoreGroupCode : discountStoreGroupCodes = discountStoreGroupCodesStr.split(",")) {
                    String[] storegroups;
                    for (String storegroup : storegroups = storegroupCodes.split(",")) {
                        if (!configStoreGroupCode.equals(storegroup)) continue;
                        distCountList.add(Double.valueOf(configurationArray.getJSONObject(i).getString("distCount")));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("verifyConfigDistCount erro", (Throwable)e);
        }
        distcountDouble = distCountList.size() == 0 ? 0.0 : distCountList.stream().min(Comparator.comparingDouble(Double::doubleValue)).get();
        return distcountDouble;
    }

    public String setTopic() {
        return this.topic;
    }

    public String setTag() {
        return "order_361_tag";
    }

    public String getConsumeId() {
        return this.consumeId;
    }

    @Test
    public void test() {
        Cus361PointsCalculationPayType payType = new Cus361PointsCalculationPayType();
        payType.setPayCode("12");
        payType.setIsSendPoint("1");
        ArrayList<Cus361PointsCalculationPayType> list = new ArrayList<Cus361PointsCalculationPayType>();
        list.add(payType);
        Boolean flag = this.isCalculateByPayType("112", list);
        log.info("\u6d4b\u8bd5\u7ed3\u679c\u4e3a: {}", (Object)flag);
        String string = "[{\"levelCode\":\"361\",\"ratio\":\"1\"},{\"levelCode\":\"362\",\"ratio\":\"2\"},{\"levelCode\":\"363\",\"ratio\":\"3\"}]";
        BigDecimal ratio = this.integralRatio("364", string);
        log.info("\u6d4b\u8bd5\u7ed3\u679c\u4e3a: {}", (Object)ratio);
    }
}

