/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.yiwen.service.impl;

import com.bizvane.centerstageservice.utils.TimeUtils;
import com.bizvane.customized.company.yiwen.service.RechargeService;
import com.bizvane.customized.facade.models.po.CusYwQuickRechargePO;
import com.bizvane.customized.facade.models.po.CusYwQuickRechargePOExample;
import com.bizvane.customized.facade.models.po.CusYwRechargeCardStylePO;
import com.bizvane.customized.facade.models.po.CusYwRechargeCardStylePOExample;
import com.bizvane.customized.facade.models.po.CusYwRechargeExplainPo;
import com.bizvane.customized.facade.models.po.CusYwRechargeExplainPoExample;
import com.bizvane.customized.facade.models.po.CusYwRechargeRulePO;
import com.bizvane.customized.facade.models.po.CusYwRechargeRulePOExample;
import com.bizvane.customized.facade.models.vo.yiwen.CusYwRechargeRuleVo;
import com.bizvane.customized.facade.models.vo.yiwen.RechargeJudgeVo;
import com.bizvane.customized.mappers.CusYwQuickRechargePOMapper;
import com.bizvane.customized.mappers.CusYwRechargeCardStylePOMapper;
import com.bizvane.customized.mappers.CusYwRechargeExplainPoMapper;
import com.bizvane.customized.mappers.CusYwRechargeRulePOMapper;
import com.bizvane.mktcenterservice.rpc.ActivityPayServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RechargeServiceImpl
implements RechargeService {
    private static final Logger log = LoggerFactory.getLogger(RechargeServiceImpl.class);
    @Autowired
    private CusYwRechargeCardStylePOMapper cusYwRechargeCardStylePOMapper;
    @Autowired
    private ActivityPayServiceRpc activityPayServiceRpc;
    @Autowired
    private CusYwRechargeExplainPoMapper cusYwRechargeExplainPoMapper;
    @Autowired
    private CusYwQuickRechargePOMapper cusYwQuickRechargePOMapper;
    @Autowired
    private CusYwRechargeRulePOMapper cusYwRechargeRulePOMapper;

    public ResponseData saveMbrRechargeStyle(CusYwRechargeCardStylePO po) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        Long sysCompanyId = po.getSysCompanyId();
        if (sysCompanyId == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e3a\u7a7a!");
            return responseData;
        }
        Long sysBrandId = po.getSysBrandId();
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e3a\u7a7a!");
            return responseData;
        }
        String url = po.getStyleUrl();
        if (StringUtils.isEmpty((CharSequence)url)) {
            responseData.setMessage("\u5361\u9762url\u4e3a\u7a7a!");
            return responseData;
        }
        Long cardType = po.getCardType();
        if (cardType == null) {
            responseData.setMessage("\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!!");
            return responseData;
        }
        CusYwRechargeCardStylePO cusYwRechargeCardStylePO = new CusYwRechargeCardStylePO();
        cusYwRechargeCardStylePO.setStyleUrl(url);
        cusYwRechargeCardStylePO.setModifiedDate(new Date());
        cusYwRechargeCardStylePO.setModifiedUserId(po.getCreateUserId());
        cusYwRechargeCardStylePO.setModifiedUserName(po.getCreateUserName());
        CusYwRechargeCardStylePOExample example = new CusYwRechargeCardStylePOExample();
        example.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        int i = this.cusYwRechargeCardStylePOMapper.updateByExampleSelective(cusYwRechargeCardStylePO, example);
        if (i == 0) {
            po.setCreateDate(new Date());
            po.setCreateUserId(po.getCreateUserId());
            cusYwRechargeCardStylePO.setModifiedDate(null);
            cusYwRechargeCardStylePO.setModifiedUserId(null);
            cusYwRechargeCardStylePO.setModifiedUserName(null);
            this.cusYwRechargeCardStylePOMapper.insertSelective(po);
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData<List<CusYwRechargeCardStylePO>> getMbrRechargeStyle(CusYwRechargeCardStylePO po) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        Long sysBrandId = po.getSysBrandId();
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e3a\u7a7a!");
            return responseData;
        }
        Long cardType = po.getCardType();
        CusYwRechargeCardStylePOExample example = new CusYwRechargeCardStylePOExample();
        example.setOrderByClause("card_type asc");
        if (cardType != null) {
            example.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        } else {
            example.createCriteria().andSysBrandIdEqualTo(sysBrandId).andValidEqualTo(Boolean.TRUE);
        }
        List list = this.cusYwRechargeCardStylePOMapper.selectByExample(example);
        responseData.setData((Object)list);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @Transactional
    public ResponseData saveMbrRechargeRule(CusYwRechargeRuleVo vo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        Long sysCompanyId = vo.getSysCompanyId();
        if (sysCompanyId == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e3a\u7a7a!");
            return responseData;
        }
        Long sysBrandId = vo.getSysBrandId();
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e3a\u7a7a!");
            return responseData;
        }
        Long cardType = vo.getCardType();
        if (cardType == null) {
            responseData.setMessage("cardType\u4e3a\u7a7a!");
            return responseData;
        }
        String explainContent = vo.getExplainContent();
        if (StringUtils.isBlank((CharSequence)explainContent)) {
            responseData.setMessage("\u5145\u503c\u8bf4\u660e\u4e3a\u7a7a!");
            return responseData;
        }
        Integer giveSet = vo.getGiveSet();
        if (giveSet == null) {
            responseData.setMessage("\u8d60\u9001\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        List ruleList = vo.getRuleList();
        if (CollectionUtils.isEmpty((Collection)ruleList)) {
            responseData.setMessage("\u8bf7\u81f3\u5c11\u6709\u4e00\u4e2a\u8d60\u9001\u8bbe\u7f6e!");
            return responseData;
        }
        List quickList = vo.getQuickList();
        if (CollectionUtils.isEmpty((Collection)quickList)) {
            responseData.setMessage("\u8bf7\u81f3\u5c11\u6709\u4e00\u4e2a\u5feb\u6377\u5145\u503c!");
            return responseData;
        }
        Boolean holdRechargeActivity = (Boolean)this.activityPayServiceRpc.judgeIsOrNoActiviryPay(vo.getSysBrandId()).getData();
        if (holdRechargeActivity.booleanValue()) {
            responseData.setData((Object)holdRechargeActivity);
            responseData.setMessage("\u5f53\u524d\u5b58\u5728\u50a8\u503c\u9001\u793c\u6d3b\u52a8\uff0c\u8bf7\u524d\u5f80\u50a8\u503c\u9001\u793c\u6d3b\u52a8\u4fee\u6539!");
            return responseData;
        }
        Integer customLimit = vo.getCustomLimit();
        if (customLimit == 2) {
            Double customStartMoney = vo.getCustomStartMoney();
            Double customEndMoney = vo.getCustomEndMoney();
            if (customEndMoney < customStartMoney) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                responseData.setMessage("\u81ea\u5b9a\u4e49\u7ed3\u675f\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u91d1\u989d!");
                return responseData;
            }
        }
        CusYwRechargeExplainPo cusYwRechargeExplainPo = new CusYwRechargeExplainPo();
        BeanUtils.copyProperties((Object)vo, (Object)cusYwRechargeExplainPo);
        cusYwRechargeExplainPo.setModifiedUserId(vo.getCreateUserId());
        cusYwRechargeExplainPo.setModifiedUserName(vo.getCreateUserName());
        cusYwRechargeExplainPo.setModifiedDate(new Date());
        CusYwRechargeExplainPoExample example = new CusYwRechargeExplainPoExample();
        example.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        int i = this.cusYwRechargeExplainPoMapper.updateByExampleSelective(cusYwRechargeExplainPo, example);
        if (i == 0) {
            cusYwRechargeExplainPo.setCreateDate(new Date());
            cusYwRechargeExplainPo.setCreateUserId(vo.getCreateUserId());
            cusYwRechargeExplainPo.setCreateUserName(vo.getCreateUserName());
            cusYwRechargeExplainPo.setCreateDate(new Date());
            cusYwRechargeExplainPo.setModifiedUserId(null);
            cusYwRechargeExplainPo.setModifiedUserName(null);
            cusYwRechargeExplainPo.setModifiedDate(null);
            this.cusYwRechargeExplainPoMapper.insertSelective(cusYwRechargeExplainPo);
        }
        LinkedList<RechargeJudgeVo> linkedList = new LinkedList<RechargeJudgeVo>();
        for (int m = 0; m < ruleList.size(); ++m) {
            RechargeJudgeVo rechargeJudgeVo = new RechargeJudgeVo();
            CusYwRechargeRulePO cusYwRechargeRulePO = (CusYwRechargeRulePO)ruleList.get(m);
            Double startMoney = cusYwRechargeRulePO.getStartMoney();
            Double endMoney = cusYwRechargeRulePO.getEndMoney();
            if (startMoney > endMoney) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                responseData.setMessage("\u8d77\u59cb\u91d1\u989dstartMoney:" + startMoney + "\u5927\u4e8eendMoney:" + endMoney);
                return responseData;
            }
            if (cusYwRechargeRulePO.getLevelSort() == null) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                responseData.setMessage("\u7b49\u7ea7\u6392\u5e8f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                return responseData;
            }
            if (StringUtils.isEmpty((CharSequence)cusYwRechargeRulePO.getLevelName())) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                responseData.setMessage("\u5361\u7b49\u7ea7\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                return responseData;
            }
            if (StringUtils.isEmpty((CharSequence)cusYwRechargeRulePO.getLevelImg())) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                responseData.setMessage("\u5361\u7b49\u7ea7\u80cc\u666f\u56fe\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                return responseData;
            }
            rechargeJudgeVo.setMin(Integer.valueOf(startMoney.intValue()));
            rechargeJudgeVo.setMax(Integer.valueOf(endMoney.intValue()));
            linkedList.add(rechargeJudgeVo);
        }
        Boolean isOverLap = RechargeServiceImpl.isOverLap(linkedList);
        if (isOverLap.booleanValue()) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            responseData.setMessage("\u8d60\u9001\u8bbe\u7f6e\u533a\u95f4\u91cd\u590d!");
            return responseData;
        }
        List levelSort = ruleList.stream().collect(Collectors.groupingBy(rule -> rule.getLevelSort(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(entry -> (Integer)entry.getKey()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(levelSort)) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            responseData.setMessage("\u7b49\u7ea7\u6392\u5e8f\u91cd\u590d!");
            return responseData;
        }
        List levelName = ruleList.stream().collect(Collectors.groupingBy(rule -> rule.getLevelName(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(levelName)) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            responseData.setMessage("\u5361\u7b49\u7ea7\u540d\u79f0\u91cd\u590d!");
            return responseData;
        }
        List idList = ruleList.stream().map(CusYwRechargeRulePO::getMbrRechargeRuleId).filter(x -> x != null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(idList)) {
            CusYwRechargeRulePOExample cusYwRechargeRulePOExample1 = new CusYwRechargeRulePOExample();
            cusYwRechargeRulePOExample1.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE).andMbrRechargeRuleIdNotIn(idList);
            CusYwRechargeRulePO cusYwRechargeRulePO = new CusYwRechargeRulePO();
            cusYwRechargeRulePO.setValid(Boolean.FALSE);
            this.cusYwRechargeRulePOMapper.updateByExampleSelective(cusYwRechargeRulePO, cusYwRechargeRulePOExample1);
        }
        ruleList.stream().forEach(rechargeRulePO -> {
            if (rechargeRulePO.getMbrRechargeRuleId() != null) {
                rechargeRulePO.setCardType(cardType);
                rechargeRulePO.setModifiedDate(new Date());
                rechargeRulePO.setModifiedUserId(vo.getCreateUserId());
                rechargeRulePO.setModifiedUserName(vo.getCreateUserName());
                this.cusYwRechargeRulePOMapper.updateByPrimaryKeySelective(rechargeRulePO);
            } else {
                rechargeRulePO.setCardType(cardType);
                rechargeRulePO.setCreateDate(new Date());
                rechargeRulePO.setCreateUserId(vo.getCreateUserId());
                rechargeRulePO.setCreateUserName(vo.getCreateUserName());
                rechargeRulePO.setValid(Boolean.TRUE);
                rechargeRulePO.setSysCompanyId(sysCompanyId);
                rechargeRulePO.setSysBrandId(sysBrandId);
                this.cusYwRechargeRulePOMapper.insertSelective(rechargeRulePO);
            }
        });
        for (int k = 0; k < quickList.size(); ++k) {
            CusYwQuickRechargePO cusYwQuickRechargePO2 = (CusYwQuickRechargePO)quickList.get(k);
            cusYwQuickRechargePO2.setCardType(cardType);
            cusYwQuickRechargePO2.setGiveSet(giveSet);
            Double rechargeMoney = cusYwQuickRechargePO2.getRechargeMoney();
            ruleList.sort(Comparator.comparing(CusYwRechargeRulePO::getStartMoney));
            Boolean flag = ruleList.stream().anyMatch(rulePO -> {
                Double start = rulePO.getStartMoney();
                Double end = rulePO.getEndMoney();
                Boolean inSection = RechargeServiceImpl.inSection((Integer)start.intValue(), (Integer)end.intValue(), (Integer)rechargeMoney.intValue());
                return inSection;
            });
            if (flag.booleanValue()) continue;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            responseData.setMessage("\u5feb\u6377\u652f\u4ed8\u4e0d\u5728\u8d60\u9001\u8bbe\u7f6e\u533a\u95f4\u5185!");
            return responseData;
        }
        CusYwQuickRechargePOExample cusYwQuickRechargePOExample = new CusYwQuickRechargePOExample();
        cusYwQuickRechargePOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        CusYwQuickRechargePO record = new CusYwQuickRechargePO();
        record.setValid(Boolean.FALSE);
        this.cusYwQuickRechargePOMapper.updateByExampleSelective(record, cusYwQuickRechargePOExample);
        quickList.stream().forEach(cusYwQuickRechargePO -> {
            cusYwQuickRechargePO.setCreateUserId(vo.getCreateUserId());
            cusYwQuickRechargePO.setCreateUserName(vo.getCreateUserName());
            cusYwQuickRechargePO.setCreateDate(TimeUtils.getNowTime());
            cusYwQuickRechargePO.setValid(Boolean.TRUE);
            cusYwQuickRechargePO.setSysCompanyId(sysCompanyId);
            cusYwQuickRechargePO.setSysBrandId(sysBrandId);
            this.cusYwQuickRechargePOMapper.insertSelective(cusYwQuickRechargePO);
        });
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData saveRechargeExplain(CusYwRechargeExplainPo po) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        Long sysCompanyId = po.getSysCompanyId();
        if (sysCompanyId == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        Long sysBrandId = po.getSysBrandId();
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        String explainContent = po.getExplainContent();
        if (StringUtils.isBlank((CharSequence)explainContent)) {
            responseData.setMessage("\u4f1a\u5458\u5145\u503c\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        Long cardType = po.getCardType();
        if (cardType == null) {
            responseData.setMessage("cardType\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        CusYwRechargeExplainPoExample example = new CusYwRechargeExplainPoExample();
        example.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        int i = this.cusYwRechargeExplainPoMapper.updateByExampleSelective(po, example);
        if (i == 0) {
            po.setCreateDate(new Date());
            this.cusYwRechargeExplainPoMapper.insertSelective(po);
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData getRechargeExplain(CusYwRechargeExplainPo po) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        Long sysCompanyId = po.getSysCompanyId();
        if (sysCompanyId == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        Long sysBrandId = po.getSysBrandId();
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        Long cardType = po.getCardType();
        if (cardType == null) {
            responseData.setMessage("cardType\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        CusYwRechargeExplainPoExample cusYwRechargeExplainPoExample = new CusYwRechargeExplainPoExample();
        cusYwRechargeExplainPoExample.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        List cusYwRechargeExplainPoList = this.cusYwRechargeExplainPoMapper.selectByExample(cusYwRechargeExplainPoExample);
        if (CollectionUtils.isEmpty((Collection)cusYwRechargeExplainPoList)) {
            log.info("\u54c1\u724c:{},\u4e0b\u6ca1\u6709\u5145\u503c\u8bbe\u7f6e");
            responseData.setMessage("\u8be5\u54c1\u724c\u6ca1\u6709\u5145\u503c\u8bbe\u7f6e");
            return responseData;
        }
        CusYwRechargeExplainPo cusYwRechargeExplainPo = (CusYwRechargeExplainPo)cusYwRechargeExplainPoList.get(0);
        CusYwRechargeRuleVo cusYwRechargeRuleVo = new CusYwRechargeRuleVo();
        cusYwRechargeRuleVo.setExplainContent(cusYwRechargeExplainPo.getExplainContent());
        cusYwRechargeRuleVo.setCustomLimit(cusYwRechargeExplainPo.getCustomLimit());
        cusYwRechargeRuleVo.setGiveSet(cusYwRechargeExplainPo.getGiveSet());
        cusYwRechargeRuleVo.setCustomStartMoney(cusYwRechargeExplainPo.getCustomStartMoney());
        cusYwRechargeRuleVo.setCustomEndMoney(cusYwRechargeExplainPo.getCustomEndMoney());
        CusYwQuickRechargePOExample cusYwQuickRechargePOExample = new CusYwQuickRechargePOExample();
        cusYwQuickRechargePOExample.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        this.cusYwQuickRechargePOMapper.selectByExample(cusYwQuickRechargePOExample);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public static Boolean inSection(Integer start, Integer end, Integer current) {
        if (current >= start && current <= end) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Boolean isOverLap(LinkedList<RechargeJudgeVo> rechargeJudgeVoLinkedList) {
        rechargeJudgeVoLinkedList.sort(Comparator.comparing(RechargeJudgeVo::getMin));
        Integer temp = rechargeJudgeVoLinkedList.poll().getMax();
        for (RechargeJudgeVo rechargeJudgeVo : rechargeJudgeVoLinkedList) {
            if (temp >= rechargeJudgeVo.getMin()) {
                log.info("\u8d60\u9001\u8bbe\u7f6e\u533a\u95f4\u6709\u91cd\u590d");
                return true;
            }
            temp = rechargeJudgeVo.getMax();
        }
        return false;
    }
}

