/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.yiwen.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.common.utils.DateUtil;
import com.bizvane.customized.facade.models.po.CusYwRechargeRecordPo;
import com.bizvane.customized.facade.models.po.CusYwRechargeRecordPoExample;
import com.bizvane.customized.facade.models.po.CusYwRechargeRulePO;
import com.bizvane.customized.facade.models.po.CusYwRechargeRulePOExample;
import com.bizvane.customized.facade.models.vo.yiwen.RechargeToAccountEnum;
import com.bizvane.customized.facade.models.vo.yiwen.YwRechargeRecordOfflineBO;
import com.bizvane.customized.facade.models.vo.yiwen.YwRechargeRecordVo;
import com.bizvane.customized.mappers.CusYwRechargeRecordPoMapper;
import com.bizvane.customized.mappers.CusYwRechargeRulePOMapper;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.redis.canal.dto.StoreCacheDto;
import com.bizvane.redis.canal.service.IRedisCacheService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

@RocketMQMessageListener(topic="public_yiwen_recharge_record_offline")
public class RechargeRecordOfflineConsumer
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(RechargeRecordOfflineConsumer.class);
    @Autowired
    RocketMQTemplate rocketMQTemplate;
    @Autowired
    private CusYwRechargeRecordPoMapper cusYwRechargeRecordPoMapper;
    @Autowired
    private CusYwRechargeRulePOMapper cusYwRechargeRulePOMapper;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplateService;
    @Autowired
    private IRedisCacheService iRedisCacheService;
    private static final String YW_RECHARGE = "YW_RECHARGE:";

    public void onMessage(ConsumerMessage<String> message) {
        String messageContent = (String)message.getMessage();
        log.info("RechargeRecordOfflineConsumer consume one record:{}", (Object)messageContent);
        JSONObject jsonObject = JSON.parseObject((String)messageContent);
        YwRechargeRecordOfflineBO ywRechargeRecordOfflineBO = (YwRechargeRecordOfflineBO)JSONObject.toJavaObject((JSON)jsonObject, YwRechargeRecordOfflineBO.class);
        this.deal(ywRechargeRecordOfflineBO);
    }

    public void deal(YwRechargeRecordOfflineBO ywRechargeRecordOfflineBO) {
        String petCard = ywRechargeRecordOfflineBO.getCardCode();
        Long sysBrandId = ywRechargeRecordOfflineBO.getSysBrandId();
        Long cardType = ywRechargeRecordOfflineBO.getCardType();
        String serialnumber = ywRechargeRecordOfflineBO.getRechargeRecord();
        String erpId = ywRechargeRecordOfflineBO.getErpId();
        Double recharge = ywRechargeRecordOfflineBO.getRecharge();
        String key = YW_RECHARGE + erpId;
        if (this.redisTemplateService.opsForValue().setIfAbsent((Object)key, (Object)"1").booleanValue()) {
            this.redisTemplateService.expire((Object)key, 3L, TimeUnit.SECONDS);
        } else {
            log.info("RechargeRecordOfflineConsumer_erpId\u5df2\u5b58\u5728:" + key);
            try {
                Thread.sleep(3000L + (long)new Random().nextInt(60000));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        MemberInfoModel memberInfoModel = this.getMember(sysBrandId, erpId);
        if (memberInfoModel == null) {
            log.error("RechargeRecordOfflineConsumer_\u4f1a\u5458\u4e0d\u5b58\u5728");
            return;
        }
        String cardNo = memberInfoModel.getCardNo();
        YwRechargeRecordVo ywRechargeRecordVo = new YwRechargeRecordVo();
        ywRechargeRecordVo.setSysCompanyId(memberInfoModel.getSysCompanyId());
        ywRechargeRecordVo.setSysBrandId(sysBrandId);
        ywRechargeRecordVo.setSerialNumber(serialnumber);
        ywRechargeRecordVo.setRechargeMoney(recharge);
        ywRechargeRecordVo.setCardType(cardType);
        ywRechargeRecordVo.setErpId(erpId);
        ywRechargeRecordVo.setState(Long.valueOf(0L));
        ywRechargeRecordVo.setName(memberInfoModel.getName());
        ywRechargeRecordVo.setCardNo(cardNo);
        ywRechargeRecordVo.setGiveMoney(ywRechargeRecordOfflineBO.getRewards());
        ywRechargeRecordVo.setPaymentDate(DateUtil.parse((String)ywRechargeRecordOfflineBO.getRechargeTime(), (String)DateUtil.ymdhms));
        ywRechargeRecordVo.setPetcard(petCard);
        ywRechargeRecordVo.setCreateDate(new Date());
        ywRechargeRecordVo.setValid(Boolean.TRUE);
        ywRechargeRecordVo.setOnlineToAccountStatus(RechargeToAccountEnum.IS_TO_ACCOUNT.getCode());
        ywRechargeRecordVo.setOfflineToAccountStatus(RechargeToAccountEnum.IS_TO_ACCOUNT.getCode());
        StoreCacheDto storeCacheDto = this.getStore(sysBrandId, ywRechargeRecordOfflineBO.getShopCode());
        if (storeCacheDto != null) {
            ywRechargeRecordVo.setSysStoreId(storeCacheDto.getStoreId());
            ywRechargeRecordVo.setStoreName(storeCacheDto.getStoreName());
        }
        boolean flag = false;
        CusYwRechargeRulePOExample ruleExample = new CusYwRechargeRulePOExample();
        ruleExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andStartMoneyLessThanOrEqualTo(recharge).andEndMoneyGreaterThanOrEqualTo(recharge).andValidEqualTo(Boolean.valueOf(true));
        List rulePOList = this.cusYwRechargeRulePOMapper.selectByExample(ruleExample);
        YwRechargeRecordVo ywRecordVo = new YwRechargeRecordVo();
        ywRecordVo.setSysBrandId(sysBrandId);
        ywRecordVo.setCardNo(cardNo);
        ywRecordVo.setCardType(cardType);
        CusYwRechargeRecordPo historyMaxRechargeLevelRule = this.cusYwRechargeRecordPoMapper.queryHistoryMaxRechargeLevelRule(ywRecordVo);
        if (historyMaxRechargeLevelRule != null) {
            CusYwRechargeRulePO cusYwRechargeRulePO = this.cusYwRechargeRulePOMapper.selectByPrimaryKey(historyMaxRechargeLevelRule.getCusYiwenMbrRechargeRuleId());
            if (cusYwRechargeRulePO != null && cusYwRechargeRulePO.getValid().booleanValue()) {
                flag = true;
                ywRechargeRecordVo.setCusYiwenMbrRechargeRuleId(cusYwRechargeRulePO.getMbrRechargeRuleId());
                ywRechargeRecordVo.setCusYiwenMbrRechargeRuleJson(JSONObject.toJSONString((Object)cusYwRechargeRulePO));
            }
            if (CollectionUtils.isNotEmpty((Collection)rulePOList) && cusYwRechargeRulePO.getLevelSort() > ((CusYwRechargeRulePO)rulePOList.get(0)).getLevelSort()) {
                flag = false;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)rulePOList) && !flag) {
            ywRechargeRecordVo.setCusYiwenMbrRechargeRuleId(((CusYwRechargeRulePO)rulePOList.get(0)).getMbrRechargeRuleId());
            ywRechargeRecordVo.setCusYiwenMbrRechargeRuleJson(JSONObject.toJSONString(rulePOList.get(0)));
        }
        CusYwRechargeRecordPoExample cusYwRechargeRecordPoExample = new CusYwRechargeRecordPoExample();
        cusYwRechargeRecordPoExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andCardNoEqualTo(cardNo).andValidEqualTo(Boolean.TRUE).andSerialNumberEqualTo(serialnumber);
        List cusYwRechargeRecordPoList = this.cusYwRechargeRecordPoMapper.selectByExample(cusYwRechargeRecordPoExample);
        if (CollectionUtils.isNotEmpty((Collection)cusYwRechargeRecordPoList)) {
            log.info("RechargeRecordOfflineConsumer_\u6570\u636e\u5df2\u5b58\u5728");
            return;
        }
        this.cusYwRechargeRecordPoMapper.insertSelective((CusYwRechargeRecordPo)ywRechargeRecordVo);
    }

    private MemberInfoModel getMember(Long sysBrandId, String erpId) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setBrandId(sysBrandId);
        memberInfoModel.setErpId(erpId);
        return (MemberInfoModel)this.memberInfoApiService.getMemberModel(memberInfoModel).getData();
    }

    private StoreCacheDto getStore(Long sysBrandId, String storeOfflineCode) {
        if (StringUtils.isEmpty((CharSequence)storeOfflineCode)) {
            return null;
        }
        return this.iRedisCacheService.getStoreCache(sysBrandId, storeOfflineCode);
    }
}

