/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.yiwen.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.MessageDelayLevel;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.baisonBase.facade.models.yw.YwRechargeRecordInfoRequestVo;
import com.bizvane.baisonBase.facade.models.yw.YwRechargeRecordInfoResponseVo;
import com.bizvane.baisonBase.facade.rpc.YwRechargeCardServiceRpc;
import com.bizvane.customized.common.constants.SysResponseEnum;
import com.bizvane.customized.facade.models.po.CusYwRechargeRecordPo;
import com.bizvane.customized.facade.models.po.CusYwRechargeRecordPoExample;
import com.bizvane.customized.facade.models.po.CusYwRechargeRulePO;
import com.bizvane.customized.facade.models.po.CusYwRechargeRulePOExample;
import com.bizvane.customized.facade.models.vo.yiwen.RechargeToAccountEnum;
import com.bizvane.customized.facade.models.vo.yiwen.YwRechargeRecordVo;
import com.bizvane.customized.mappers.CusYwRechargeRecordPoMapper;
import com.bizvane.customized.mappers.CusYwRechargeRulePOMapper;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="public_yiwen_recharge_record")
public class RechargeRecordConsumer
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(RechargeRecordConsumer.class);
    @Autowired
    RocketMQTemplate rocketMQTemplate;
    @Autowired
    private CusYwRechargeRecordPoMapper cusYwRechargeRecordPoMapper;
    private List<MessageDelayLevel> messageDelayLevelList;
    @Autowired
    private YwRechargeCardServiceRpc ywRechargeCardServiceRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private CusYwRechargeRulePOMapper cusYwRechargeRulePOMapper;
    private static final String YW_RECHARGE = "YW_RECHARGE";

    public void onMessage(ConsumerMessage<String> message) {
        String messageContent = (String)message.getMessage();
        log.info("RechargeRecordConsumer consume one record:{}", (Object)messageContent);
        JSONObject jsonObject = JSON.parseObject((String)messageContent);
        YwRechargeRecordVo ywRechargeRecordVo = (YwRechargeRecordVo)JSONObject.toJavaObject((JSON)jsonObject, YwRechargeRecordVo.class);
        String petCard = ywRechargeRecordVo.getPetcard();
        String cardNo = ywRechargeRecordVo.getCardNo();
        Long sysBrandId = ywRechargeRecordVo.getSysBrandId();
        Long cardType = ywRechargeRecordVo.getCardType();
        String wxPayVoucherNo = ywRechargeRecordVo.getWxPayVoucherNo();
        CusYwRechargeRecordPoExample cusYwRechargeRecordPoExample = new CusYwRechargeRecordPoExample();
        cusYwRechargeRecordPoExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andCardNoEqualTo(cardNo).andValidEqualTo(Boolean.TRUE).andWxPayVoucherNoEqualTo(wxPayVoucherNo);
        List cusYwRechargeRecordPoList = this.cusYwRechargeRecordPoMapper.selectByExample(cusYwRechargeRecordPoExample);
        if (CollectionUtils.isNotEmpty((Collection)cusYwRechargeRecordPoList)) {
            Integer offlineToAccountStatus = ((CusYwRechargeRecordPo)cusYwRechargeRecordPoList.get(0)).getOfflineToAccountStatus();
            if (RechargeToAccountEnum.IS_TO_ACCOUNT.getCode().equals(offlineToAccountStatus)) {
                return;
            }
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String serialNumber = "RE" + sdf.format(new Date()) + (int)((Math.random() * 9.0 + 1.0) * 1000.0);
            ywRechargeRecordVo.setSerialNumber(serialNumber);
            ywRechargeRecordVo.setCreateDate(new Date());
            ywRechargeRecordVo.setValid(Boolean.TRUE);
            ywRechargeRecordVo.setOnlineToAccountStatus(RechargeToAccountEnum.IS_TO_ACCOUNT.getCode());
            ywRechargeRecordVo.setOfflineToAccountStatus(RechargeToAccountEnum.NOT_TO_ACCOUNT.getCode());
            boolean flag = false;
            CusYwRechargeRulePOExample ruleExample = new CusYwRechargeRulePOExample();
            ruleExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andStartMoneyLessThanOrEqualTo(ywRechargeRecordVo.getRechargeMoney()).andEndMoneyGreaterThanOrEqualTo(ywRechargeRecordVo.getRechargeMoney()).andValidEqualTo(Boolean.valueOf(true));
            List rulePOList = this.cusYwRechargeRulePOMapper.selectByExample(ruleExample);
            CusYwRechargeRecordPo historyMaxRechargeLevelRule = this.cusYwRechargeRecordPoMapper.queryHistoryMaxRechargeLevelRule(ywRechargeRecordVo);
            if (historyMaxRechargeLevelRule != null) {
                CusYwRechargeRulePO cusYwRechargeRulePO = this.cusYwRechargeRulePOMapper.selectByPrimaryKey(historyMaxRechargeLevelRule.getCusYiwenMbrRechargeRuleId());
                if (cusYwRechargeRulePO != null && cusYwRechargeRulePO.getValid().booleanValue()) {
                    flag = true;
                    ywRechargeRecordVo.setCusYiwenMbrRechargeRuleId(cusYwRechargeRulePO.getMbrRechargeRuleId());
                    ywRechargeRecordVo.setCusYiwenMbrRechargeRuleJson(JSONObject.toJSONString((Object)cusYwRechargeRulePO));
                }
                if (CollectionUtils.isNotEmpty((Collection)rulePOList) && cusYwRechargeRulePO.getLevelSort() > ((CusYwRechargeRulePO)rulePOList.get(0)).getLevelSort()) {
                    flag = false;
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)rulePOList) && !flag) {
                ywRechargeRecordVo.setCusYiwenMbrRechargeRuleId(((CusYwRechargeRulePO)rulePOList.get(0)).getMbrRechargeRuleId());
                ywRechargeRecordVo.setCusYiwenMbrRechargeRuleJson(JSONObject.toJSONString(rulePOList.get(0)));
            }
            this.cusYwRechargeRecordPoMapper.insertSelective((CusYwRechargeRecordPo)ywRechargeRecordVo);
        }
        YwRechargeRecordInfoRequestVo ywRechargeRecordInfoRequestVo = new YwRechargeRecordInfoRequestVo();
        ywRechargeRecordInfoRequestVo.setVipCode(cardNo);
        ywRechargeRecordInfoRequestVo.setStoredCardCode(petCard);
        ywRechargeRecordInfoRequestVo.setRechargeAmount(Double.valueOf(ywRechargeRecordVo.getRechargeMoney() + ywRechargeRecordVo.getGiveMoney()));
        ywRechargeRecordInfoRequestVo.setRechargePay(ywRechargeRecordVo.getRechargeMoney());
        ywRechargeRecordInfoRequestVo.setRechargeGift(ywRechargeRecordVo.getGiveMoney());
        ywRechargeRecordInfoRequestVo.setTradeNo(wxPayVoucherNo);
        ywRechargeRecordInfoRequestVo.setAssistantCode(ywRechargeRecordVo.getStaffCode());
        if (cardType != null) {
            ywRechargeRecordInfoRequestVo.setCategoryCode(String.valueOf(cardType));
        }
        log.info("\u5f00\u59cb\u8c03\u7528bayStoredCard params :{}", (Object)JSON.toJSONString((Object)ywRechargeRecordInfoRequestVo));
        ResponseData rechargeResponse = null;
        try {
            rechargeResponse = this.ywRechargeCardServiceRpc.bayStoredCard(ywRechargeRecordInfoRequestVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528bayStoredCard\u5931\u8d25:{}", (Object)e.getMessage());
            this.reSendMessage(ywRechargeRecordVo);
            return;
        }
        log.info("bayStoredCard response :{}", (Object)JSON.toJSONString((Object)rechargeResponse));
        if (rechargeResponse.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            CusYwRechargeRecordPo cusYwRechargeRecordPo = new CusYwRechargeRecordPo();
            if (StringUtils.isEmpty((CharSequence)petCard)) {
                String storedCardCode = ((YwRechargeRecordInfoResponseVo)rechargeResponse.getData()).getStoredCardCode();
                cusYwRechargeRecordPo.setPetcard(storedCardCode);
            }
            cusYwRechargeRecordPo.setOfflineToAccountStatus(RechargeToAccountEnum.IS_TO_ACCOUNT.getCode());
            this.cusYwRechargeRecordPoMapper.updateByExampleSelective(cusYwRechargeRecordPo, cusYwRechargeRecordPoExample);
        } else {
            log.info("\u8c03\u7528\u7ebf\u4e0b\u50a8\u503c\u63a5\u53e3\u5931\u8d25:\u652f\u4ed8\u51ed\u8bc1:{},\u5931\u8d25\u539f\u56e0:{}", (Object)ywRechargeRecordVo.getWxPayVoucherNo(), (Object)rechargeResponse.getMessage());
            this.reSendMessage(ywRechargeRecordVo);
        }
    }

    public void reSendMessage(YwRechargeRecordVo ywRechargeRecordVo) {
        String cardNo = ywRechargeRecordVo.getCardNo();
        String wxPayVoucherNo = ywRechargeRecordVo.getWxPayVoucherNo();
        String key = YW_RECHARGE + cardNo + wxPayVoucherNo;
        String s = (String)this.redisTemplateService.stringGetStringByKey((Object)key);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            int retry = Integer.valueOf(s);
            if (retry >= this.messageDelayLevelList.size()) {
                log.info("\u652f\u4ed8\u51ed\u8bc1\u4e3a:{},\u91cd\u8bd5:{},\u4ecd\u7136\u5931\u8d25,\u653e\u5f03\u91cd\u8bd5", (Object)ywRechargeRecordVo.getWxPayVoucherNo(), (Object)this.messageDelayLevelList.size());
                return;
            }
        } else {
            s = "0";
        }
        int retryTime = Integer.valueOf(s);
        MessageDelayLevel messageDelayLevel = (MessageDelayLevel)this.messageDelayLevelList.get(retryTime);
        ywRechargeRecordVo.setRetryTime(Integer.valueOf(++retryTime));
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("public_yiwen_recharge_record").delayLevel(messageDelayLevel).build(), (Object)JSON.toJSONString((Object)ywRechargeRecordVo));
        this.redisTemplateService.stringSetValueAndExpireTime((Object)key, (Object)String.valueOf(retryTime), 3600000L);
        String messageId = sendResult.getMsgId();
        log.info("\u652f\u4ed8\u51ed\u8bc1:{},reSendMessage\t\u6d88\u606f\u91cd\u65b0\u53d1\u9001\u5b8c\u6210mq\u8fd4\u56de\u7684msgId:{},\u5ef6\u8fdf\u7684\u7b49\u7ea7\u662f:{},\u5f53\u524d\u91cd\u8bd5\u6b21\u6570:{}", new Object[]{ywRechargeRecordVo.getWxPayVoucherNo(), messageId, messageDelayLevel.getLevel(), retryTime});
    }

    @PostConstruct
    public void init() {
        this.messageDelayLevelList = Arrays.asList(MessageDelayLevel._10s, MessageDelayLevel._30s, MessageDelayLevel._2m, MessageDelayLevel._5m, MessageDelayLevel._10m, MessageDelayLevel._30m);
    }
}

