/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.wm.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.vo.SysStoreRelationVo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.interfaces.rpc.WmConnectorServiceFeign;
import com.bizvane.connectorservice.util.HttpClientUtil;
import com.bizvane.core.facade.interfaces.SysSyncThirdFailLogFeign;
import com.bizvane.core.facade.models.bo.SysSyncThirdFailLogAddRequest;
import com.bizvane.couponfacade.interfaces.CouponQueryServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.CouponDetailModelVO;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.wm.service.WmCouponSyncService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class WmCouponSyncServiceImpl
implements WmCouponSyncService {
    private static final Logger log = LoggerFactory.getLogger(WmCouponSyncServiceImpl.class);
    @Value(value="${connector.361weimeng.urlPrefix}")
    private String wmUrlPrefix;
    @Value(value="${connector.mjweimeng.urlPrefix}")
    private String mjWmUrlPrefix;
    @Value(value="${connector.mjweimeng.mjcompanyId}")
    private Long mjWmCompanyId;
    @Value(value="#{'${connector.weimeng.companyIdList}'.split(',')}")
    private List<Long> weimengCompanyIdList;
    @Autowired
    private WmConnectorServiceFeign wmConnectorServiceFeign;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    @Autowired
    private CouponQueryServiceFeign couponQueryServiceFeign;
    @Autowired
    private SysSyncThirdFailLogFeign sysSyncThirdFailLogFeign;

    public Result sendUserCoupon(CouponDefinitionPOWithBLOBs definitionPo, CouponEntityPO couponEntityPO, Long memberWid) {
        Result result = new Result();
        try {
            String data;
            Long sysBrandId = definitionPo.getSysBrandId();
            Result resultToken = this.wmConnectorServiceFeign.queryWmToken(sysBrandId);
            if (resultToken.getCode().equals(SysResponseEnum.FAILED.getCode())) {
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                result.setMessage(resultToken.getMessage());
                return result;
            }
            Long mainStoreId = this.wmConnectorServiceFeign.getMainStoreId(sysBrandId);
            if (mainStoreId == null) {
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                result.setMessage("\u672a\u83b7\u53d6\u5230\u54c1\u724c:" + sysBrandId + ":\u5bf9\u5e94\u603b\u5e97ID!");
                return result;
            }
            String accessToken = String.valueOf(resultToken.getData());
            String sendCouponUrl = this.wmUrlPrefix + "ec/coupon/sendUserCoupon" + "?accesstoken=" + accessToken;
            JSONObject jsonCouponRequest = new JSONObject();
            jsonCouponRequest.put("storeId", (Object)mainStoreId);
            jsonCouponRequest.put("cardTemplateId", (Object)definitionPo.getErpCouponDefinitionCode());
            jsonCouponRequest.put("sendWid", (Object)memberWid);
            jsonCouponRequest.put("recipientIdent", (Object)"1");
            jsonCouponRequest.put("code", (Object)couponEntityPO.getCouponCode());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=utf-8");
            headers.put("accept", "application/json; charset=utf-8");
            log.info("WmCouponSyncServiceImpl sendUserCoupon\uff0curl:{}\uff0cparam:{}", (Object)sendCouponUrl, (Object)jsonCouponRequest.toJSONString());
            String resultStr = HttpClientUtil.dopost((String)sendCouponUrl, (String)jsonCouponRequest.toJSONString(), headers);
            log.info("\u5238\u53d1\u653e\u540c\u6b65\u5fae\u76df\u4e1a\u52a1\uff0c\u54c1\u724cid:{}\uff0c\u8bf7\u6c42\u5fae\u76df\u7aef\u5730\u5740:{}\uff0c\u8bf7\u6c42\u5fae\u76df\u7aef\u53c2\u6570:{}\uff0c\u5fae\u76df\u7aef\u54cd\u5e94\u7ed3\u679c:{}", new Object[]{sysBrandId, sendCouponUrl, jsonCouponRequest.toJSONString(), resultStr});
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                result.setMessage(SysResponseEnum.FAILED.getMessage());
                return result;
            }
            JSONObject jsonObject = JSON.parseObject((String)resultStr);
            String codeMain = jsonObject.getString("code");
            if (StringUtils.isNotEmpty((CharSequence)codeMain)) {
                JSONObject codeJson = JSONObject.parseObject((String)codeMain);
                String errCode = codeJson.getString("errcode");
                String errMsg = codeJson.getString("errmsg");
                if (!"0".equals(errCode)) {
                    result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                    result.setMessage(errMsg);
                    return result;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(data = jsonObject.getString("data")))) {
                JSONObject dataJson = JSONObject.parseObject((String)data);
                Integer state = dataJson.getInteger("state");
                String code = dataJson.getString("code");
                if (1 == state) {
                    log.info("WmCouponSyncServiceImpl sendUserCoupon is success\uff0ccoupon:{}", (Object)code);
                    result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                    result.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    result.setData((Object)dataJson);
                }
            }
        }
        catch (Exception e) {
            log.info("WmCouponSyncServiceImpl sendUserCoupon error:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            result.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return result;
    }

    public Result consumeCouponForOffline(CouponEntityPO couponEntityPO) {
        Result result = new Result();
        try {
            String data;
            SysStoreRelationVo storeRelationVo;
            Long sysBrandId = couponEntityPO.getSysBrandId();
            Result resultToken = this.wmConnectorServiceFeign.queryWmToken(sysBrandId);
            if (resultToken.getCode().equals(SysResponseEnum.FAILED.getCode())) {
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                result.setMessage(resultToken.getMessage());
                return result;
            }
            String accessToken = String.valueOf(resultToken.getData());
            String url = this.wmUrlPrefix;
            if (!CollectionUtils.isEmpty((Collection)this.weimengCompanyIdList) && this.weimengCompanyIdList.contains(couponEntityPO.getSysCompanyId())) {
                url = this.mjWmUrlPrefix;
            }
            String uesCouponUrl = url + "ec/coupon/consumeCouponForOffline" + "?accesstoken=" + accessToken;
            JSONObject jsonCouponRequest = new JSONObject();
            jsonCouponRequest.put("code", (Object)couponEntityPO.getCouponCode());
            ResponseData sysStoreRelationVoRes = this.getWmStoreInfo(couponEntityPO.getUseStoreId(), couponEntityPO.getSysBrandId(), couponEntityPO.getSysCompanyId());
            if (sysStoreRelationVoRes.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                result.setMessage(sysStoreRelationVoRes.getMessage());
                return result;
            }
            if (sysStoreRelationVoRes.getData() != null && (storeRelationVo = (SysStoreRelationVo)sysStoreRelationVoRes.getData()).getWmStoreId() != null) {
                jsonCouponRequest.put("useScene", (Object)7);
                jsonCouponRequest.put("storeId", (Object)storeRelationVo.getWmStoreId());
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=utf-8");
            headers.put("accept", "application/json; charset=utf-8");
            log.info("WmCouponSyncServiceImpl consumeCouponForOffline\uff0curl:{}\uff0cparam:{}", (Object)uesCouponUrl, (Object)jsonCouponRequest.toJSONString());
            String resultStr = HttpClientUtil.dopost((String)uesCouponUrl, (String)jsonCouponRequest.toJSONString(), headers);
            log.info("\u5238\u6838\u9500\u540c\u6b65\u5fae\u76df\u4e1a\u52a1\uff0c\u54c1\u724cid:{}\uff0c\u8bf7\u6c42\u5fae\u76df\u7aef\u5730\u5740:{}\uff0c\u8bf7\u6c42\u5fae\u76df\u7aef\u53c2\u6570:{}\uff0c\u5fae\u76df\u7aef\u54cd\u5e94\u7ed3\u679c:{}", new Object[]{sysBrandId, uesCouponUrl, jsonCouponRequest.toJSONString(), resultStr});
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                this.sysSyncThirdFailLogFeign.add(new SysSyncThirdFailLogAddRequest(couponEntityPO.getSysCompanyId(), sysBrandId, "1", "1", couponEntityPO.getCouponCode(), jsonCouponRequest.toJSONString(), resultStr));
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                result.setMessage(SysResponseEnum.FAILED.getMessage());
                return result;
            }
            JSONObject jsonObject = JSON.parseObject((String)resultStr);
            String codeMain = jsonObject.getString("code");
            if (StringUtils.isNotEmpty((CharSequence)codeMain)) {
                JSONObject codeJson = JSONObject.parseObject((String)codeMain);
                String errCode = codeJson.getString("errcode");
                String errMsg = codeJson.getString("errmsg");
                if (!"0".equals(errCode)) {
                    this.sysSyncThirdFailLogFeign.add(new SysSyncThirdFailLogAddRequest(couponEntityPO.getSysCompanyId(), sysBrandId, "1", "1", couponEntityPO.getCouponCode(), jsonCouponRequest.toJSONString(), resultStr));
                    result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                    result.setMessage(errMsg);
                    return result;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(data = jsonObject.getString("data")))) {
                JSONObject dataJson = JSONObject.parseObject((String)data);
                Boolean success = dataJson.getBoolean("success");
                if (success.booleanValue()) {
                    log.info("WmCouponSyncServiceImpl consumeCouponForOffline is success\uff0ccoupon:{}", (Object)couponEntityPO.getCouponCode());
                    result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                    result.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    result.setData((Object)couponEntityPO.getCouponCode());
                } else {
                    this.sysSyncThirdFailLogFeign.add(new SysSyncThirdFailLogAddRequest(couponEntityPO.getSysCompanyId(), sysBrandId, "1", "1", couponEntityPO.getCouponCode(), jsonCouponRequest.toJSONString(), resultStr));
                }
            }
        }
        catch (Exception e) {
            log.info("WmCouponSyncServiceImpl consumeCouponForOffline error:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            result.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return result;
    }

    private ResponseData<SysStoreRelationVo> getWmStoreInfo(String useStoreId, Long sysBrandId, Long sysCompanyId) {
        log.info("useStoreId:{},sysBrandId:{},sysCompanyId:{}", new Object[]{useStoreId, sysBrandId, sysCompanyId});
        if (StringUtils.isBlank((CharSequence)useStoreId)) {
            return new ResponseData();
        }
        if (sysBrandId == null) {
            return new ResponseData();
        }
        if (sysCompanyId == null) {
            return new ResponseData();
        }
        ResponseData storeRelationVoRes = this.storeServiceRpc.getSysStoreRelationVoByOfflineStoreId(useStoreId, sysBrandId, sysCompanyId);
        if (storeRelationVoRes == null || SysResponseEnum.SUCCESS.getCode() != storeRelationVoRes.getCode()) {
            log.info("\u95e8\u5e97\u4fe1\u606f\u67e5\u8be2\u5931\u8d25,storePoRes:{}", (Object)JacksonUtil.bean2Json((Object)storeRelationVoRes));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u95e8\u5e97\u4fe1\u606f\u67e5\u8be2\u5931\u8d25,\u9700\u8981\u91cd\u8bd5");
        }
        SysStoreRelationVo sysStoreRelationVo = (SysStoreRelationVo)storeRelationVoRes.getData();
        if (sysStoreRelationVo == null) {
            return new ResponseData();
        }
        log.info("\u95e8\u5e97\u4fe1\u606f\u67e5\u8be2\u6210\u529f,\u5bf9\u5e94\u5fae\u76df\u95e8\u5e97id\u4e3a:{}", (Object)sysStoreRelationVo.getWmStoreId());
        return new ResponseData((Object)sysStoreRelationVo);
    }

    public Result sendUserCouponForMj(CouponDefinitionPOWithBLOBs definitionPo, CouponEntityPO couponEntityPO, String phone) {
        Result result = new Result();
        try {
            String data;
            Long sysBrandId = definitionPo.getSysBrandId();
            Result resultToken = this.wmConnectorServiceFeign.queryWmToken(sysBrandId);
            if (resultToken.getCode().equals(SysResponseEnum.FAILED.getCode())) {
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                result.setMessage(resultToken.getMessage());
                return result;
            }
            Long mainStoreId = this.wmConnectorServiceFeign.getMainStoreId(sysBrandId);
            if (mainStoreId == null) {
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                result.setMessage("\u672a\u83b7\u53d6\u5230\u54c1\u724c:" + sysBrandId + ":\u5bf9\u5e94\u603b\u5e97ID!");
                return result;
            }
            String accessToken = String.valueOf(resultToken.getData());
            String sendCouponUrl = this.mjWmUrlPrefix + "ec/coupon/sendUserCoupon" + "?accesstoken=" + accessToken;
            JSONObject jsonCouponRequest = new JSONObject();
            jsonCouponRequest.put("storeId", (Object)mainStoreId);
            jsonCouponRequest.put("cardTemplateId", (Object)definitionPo.getWmCouponDefinitionCode());
            jsonCouponRequest.put("phone", (Object)phone);
            jsonCouponRequest.put("recipientIdent", (Object)"2");
            jsonCouponRequest.put("code", (Object)couponEntityPO.getCouponCode());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=utf-8");
            headers.put("accept", "application/json; charset=utf-8");
            log.info("WmCouponSyncServiceImpl sendUserCoupon\uff0curl:{}\uff0cparam:{}", (Object)sendCouponUrl, (Object)jsonCouponRequest.toJSONString());
            String resultStr = HttpClientUtil.dopost((String)sendCouponUrl, (String)jsonCouponRequest.toJSONString(), headers);
            log.info("\u5238\u53d1\u653e\u540c\u6b65\u5fae\u76df\u4e1a\u52a1\uff0c\u54c1\u724cid:{}\uff0c\u8bf7\u6c42\u5fae\u76df\u7aef\u5730\u5740:{}\uff0c\u8bf7\u6c42\u5fae\u76df\u7aef\u53c2\u6570:{}\uff0c\u5fae\u76df\u7aef\u54cd\u5e94\u7ed3\u679c:{}", new Object[]{sysBrandId, sendCouponUrl, jsonCouponRequest.toJSONString(), resultStr});
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                result.setMessage(SysResponseEnum.FAILED.getMessage());
                return result;
            }
            JSONObject jsonObject = JSON.parseObject((String)resultStr);
            String codeMain = jsonObject.getString("code");
            if (StringUtils.isNotEmpty((CharSequence)codeMain)) {
                JSONObject codeJson = JSONObject.parseObject((String)codeMain);
                String errCode = codeJson.getString("errcode");
                String errMsg = codeJson.getString("errmsg");
                if ("900010010006003".equals(errCode)) {
                    log.info("sendUserCouponForMj \u53d1\u5238\u624b\u673a\u53f7\u4e0d\u5b58\u5728:{}", (Object)phone);
                    JSONObject redisJson = new JSONObject();
                    redisJson.put("definitionPo", (Object)definitionPo);
                    redisJson.put("couponEntityPO", (Object)couponEntityPO);
                    String redisKey = "customized:coupon:mj:retry:" + phone;
                    this.redisTemplate.opsForList().leftPush((Object)redisKey, (Object)redisJson);
                    this.redisTemplate.expire((Object)redisKey, 30L, TimeUnit.DAYS);
                    log.info("\u7f13\u5b58redis\u5b8c\u6210:" + couponEntityPO.getCouponCode());
                    result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                    result.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    return result;
                }
                if (!"0".equals(errCode)) {
                    result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                    result.setMessage(errMsg);
                    return result;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(data = jsonObject.getString("data")))) {
                JSONObject dataJson = JSONObject.parseObject((String)data);
                Integer state = dataJson.getInteger("state");
                String code = dataJson.getString("code");
                if (1 == state) {
                    log.info("WmCouponSyncServiceImpl sendUserCoupon is success\uff0ccoupon:{}", (Object)code);
                    result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                    result.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    result.setData((Object)dataJson);
                }
            }
        }
        catch (Exception e) {
            log.info("WmCouponSyncServiceImpl sendUserCoupon error:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            result.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return result;
    }

    public boolean sendUserCouponForMjRetry(String phone) {
        log.info("\u68a6\u6d01\u53d1\u5238\u91cd\u8bd5:" + phone);
        String redisKey = "customized:coupon:mj:retry:" + phone;
        List list = this.redisTemplate.opsForList().range((Object)redisKey, 0L, -1L);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Object object : list) {
                JSONObject redisJson = (JSONObject)object;
                CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)redisJson.getObject("definitionPo", CouponDefinitionPOWithBLOBs.class);
                CouponEntityPO couponEntityPO = (CouponEntityPO)redisJson.getObject("couponEntityPO", CouponEntityPO.class);
                log.info("\u68a6\u6d01\u53d1\u5238\u91cd\u8bd5:" + couponEntityPO.getCouponCode());
                CouponDetailModelVO couponDetailModelVO = (CouponDetailModelVO)this.couponQueryServiceFeign.findCouponByCouponCode(couponEntityPO.getCouponCode()).getData();
                if (couponDetailModelVO != null && Byte.valueOf("20").equals(couponDetailModelVO.getCouponEntityPO().getCouponStatus())) {
                    this.sendUserCouponForMj(definitionPo, couponEntityPO, phone);
                    continue;
                }
                log.info("\u5238\u4e0d\u5b58\u5728\u6216\u5df2\u65e0\u6548\u65e0\u6cd5\u8865\u53d1:" + couponEntityPO.getCouponCode());
            }
        }
        this.redisTemplate.delete((Object)redisKey);
        return true;
    }
}

