/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.wm.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.customized.company.wm.service.WmCouponSyncService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="wm_topic_use_channel_coupon")
public class UseOmniChannelCouponConsumer
implements RocketMQListener<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(UseOmniChannelCouponConsumer.class);
    @Autowired
    private WmCouponSyncService wmCouponSyncService;

    public void onMessage(ConsumerMessage<JSONObject> message) {
        log.info("UseOmniChannelCouponConsumer\u89e3\u6790\u6210\u529f\uff1a" + message.getMessage());
        JSONObject body = (JSONObject)message.getMessage();
        CouponEntityPO couponEntityPO = (CouponEntityPO)JacksonUtil.json2Objs((String)JSONObject.toJSONString((Object)body), CouponEntityPO.class);
        Result result = this.wmCouponSyncService.consumeCouponForOffline(couponEntityPO);
        if (result.getCode().equals(SysResponseEnum.FAILED.getCode())) {
            log.info("UseOmniChannelCouponConsumer consumeCouponForOffline is error\uff0cmessage:{}\uff01", (Object)result.getMessage());
            throw new BizException("\u4e1a\u52a1\u5f02\u5e38");
        }
    }
}

