/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.wm.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.interfaces.rpc.WmConnectorServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.customized.company.wm.service.WmCouponSyncService;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.vo.MemberInfoSimpleVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@RocketMQMessageListener(topic="wm_topic_omni_channel_coupon")
public class OmniChannelCouponConsumer
implements RocketMQListener<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(OmniChannelCouponConsumer.class);
    @Autowired
    private WmConnectorServiceFeign wmConnectorServiceFeign;
    @Autowired
    private WmCouponSyncService wmCouponSyncService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Value(value="${connector.mjweimeng.mjcompanyId}")
    private Long mjWmCompanyId;
    @Value(value="#{'${connector.weimeng.companyIdList}'.split(',')}")
    private List<Long> weimengCompanyIdList;

    public void onMessage(ConsumerMessage<JSONObject> message) {
        log.info("OmniChannelCouponConsumer\u89e3\u6790\u6210\u529f\uff1a" + message.getMessage());
        JSONObject body = (JSONObject)message.getMessage();
        CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)JacksonUtil.json2Objs((String)body.getString("definitionPO"), CouponDefinitionPOWithBLOBs.class);
        SendCouponBatchRequestVO requestVo = (SendCouponBatchRequestVO)JacksonUtil.json2Objs((String)body.getString("requestVO"), SendCouponBatchRequestVO.class);
        List entityPoList = JacksonUtil.json2List((String)body.getString("entityPOList"), CouponEntityPO.class);
        Long sysBrandId = definitionPo.getSysBrandId();
        List memberListManual = requestVo.getMemberListManual();
        if (CollectionUtils.isEmpty((Collection)memberListManual)) {
            throw new BizException("OmniChannelCouponConsumer memberInfo is null");
        }
        if (!CollectionUtils.isEmpty((Collection)this.weimengCompanyIdList) && this.weimengCompanyIdList.contains(definitionPo.getSysCompanyId())) {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setBrandId(definitionPo.getSysBrandId());
            memberInfoModel.setMemberCode(((CouponEntityPO)entityPoList.get(0)).getMemberCode());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (singleMemberModel.getCode() == SysResponseEnum.SUCCESS.getCode() && singleMemberModel.getData() != null) {
                String phone = ((MemberInfoModel)singleMemberModel.getData()).getPhone();
                Result result = this.wmCouponSyncService.sendUserCouponForMj(definitionPo, (CouponEntityPO)entityPoList.get(0), phone);
                if (result.getCode().equals(SysResponseEnum.FAILED.getCode())) {
                    log.info("OmniChannelCouponConsumer sendUserCoupon is error\uff0cmessage:{}\uff01", (Object)result.getMessage());
                    throw new BizException("\u4e1a\u52a1\u5f02\u5e38");
                }
            }
        } else {
            String cardNo = ((MemberInfoSimpleVO)memberListManual.get(0)).getCardNo();
            Long memberWid = this.wmConnectorServiceFeign.getMemberWid(sysBrandId, cardNo);
            if (memberWid == null) {
                log.info("OmniChannelCouponConsumer getMemberWid is null, cardNo:{}", (Object)cardNo);
                return;
            }
            Result result = this.wmCouponSyncService.sendUserCoupon(definitionPo, (CouponEntityPO)entityPoList.get(0), memberWid);
            if (result.getCode().equals(SysResponseEnum.FAILED.getCode())) {
                log.info("OmniChannelCouponConsumer sendUserCoupon is error\uff0cmessage:{}\uff01", (Object)result.getMessage());
                throw new BizException("\u4e1a\u52a1\u5f02\u5e38");
            }
        }
    }
}

