/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.FileImportTempPo;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.po.SysCheckConfigPo;
import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.centerstageservice.models.vo.SysAccountVo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.SysAccountServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCheckConfigServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCheckServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.StorageCardListRequestVO;
import com.bizvane.connectorservice.entity.common.StorageCardRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.ConnectorServiceFeign;
import com.bizvane.customized.common.constants.SysConstants;
import com.bizvane.customized.common.thread.ThreadPool;
import com.bizvane.customized.common.utils.Aes32;
import com.bizvane.customized.common.utils.Assert;
import com.bizvane.customized.common.utils.CommonExportExcelUtil;
import com.bizvane.customized.common.utils.DateUtil;
import com.bizvane.customized.common.utils.DownLoadFileUtil;
import com.bizvane.customized.common.utils.ExportExcelUtil;
import com.bizvane.customized.common.utils.FileNameUtil;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.QiNiuConfig;
import com.bizvane.customized.common.utils.QiNiuUtil;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.common.utils.ResponseUtil;
import com.bizvane.customized.common.utils.StreamingExportExcelPageInfoUtilForStorage;
import com.bizvane.customized.common.utils.StreamingExportExcelUtil;
import com.bizvane.customized.common.utils.ThreadPoolUtils;
import com.bizvane.customized.common.utils.UUIDGenerator;
import com.bizvane.customized.company.ur.members.models.storage.Model.StorageCardExcelModel;
import com.bizvane.customized.company.ur.members.models.storage.Model.StorageCardModel;
import com.bizvane.customized.company.ur.members.models.storage.Model.StorageMoneyModel;
import com.bizvane.customized.company.ur.members.models.storage.dto.ConsumeStorageDto;
import com.bizvane.customized.company.ur.members.models.storage.dto.SendStorageDTO;
import com.bizvane.customized.company.ur.members.models.storage.vo.AuditAddBatchVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryRecordResponseVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryStorageCardRecordVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryStorageRequestVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryStorageResponseVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryTaskDetailVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryTaskVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.StorageRecordVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.TaskDetailVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.UpdateStorageRequestVo;
import com.bizvane.customized.company.ur.members.service.StorageCardService;
import com.bizvane.customized.company.ur.members.service.StorageOpsService;
import com.bizvane.customized.facade.enums.AddBatchEnum;
import com.bizvane.customized.facade.enums.StorageCardDonate.StorageCardDonateFromStatusEnum;
import com.bizvane.customized.facade.enums.StorageCardDonate.StorageCardDonateOverStatusEnum;
import com.bizvane.customized.facade.enums.StorageCardDonate.StorageCardDonateToStatusEnum;
import com.bizvane.customized.facade.enums.StorageOpsTypeEnum;
import com.bizvane.customized.facade.exception.CustomizedException;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardDonate;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardDonateExample;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardPO;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardPOExample;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardRecordPO;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardRecordPOExample;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardTASKDETAILPO;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardTASKDETAILPOExample;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardTASKPO;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardTASKPOExample;
import com.bizvane.customized.facade.models.vo.CusUrStorageCardReceivedVO;
import com.bizvane.customized.facade.models.vo.CusUrStorageCardSendVO;
import com.bizvane.customized.facade.models.vo.StorageCardConsumeRequestVO;
import com.bizvane.customized.facade.models.vo.StorageCardQueryStorageCardRequestVO;
import com.bizvane.customized.facade.models.vo.StorageCardQueryStorageCardResponseVO;
import com.bizvane.customized.facade.models.vo.StorageCardQueryVipCardRequestVO;
import com.bizvane.customized.facade.models.vo.StorageCardQueryVipCardResponseVO;
import com.bizvane.customized.mappers.CusUrMbrStorageCardDonateMapper;
import com.bizvane.customized.mappers.CusUrMbrStorageCardPOMapper;
import com.bizvane.customized.mappers.CusUrMbrStorageCardRecordPOMapper;
import com.bizvane.customized.mappers.CusUrMbrStorageCardTASKDETAILPOMapper;
import com.bizvane.customized.mappers.CusUrMbrStorageCardTASKPOMapper;
import com.bizvane.members.facade.service.api.CardGenerateApiService;
import com.bizvane.members.facade.service.ur.UrMemberApiService;
import com.bizvane.members.facade.ur.vo.MemberRequestCardNoVo;
import com.bizvane.members.facade.ur.vo.MemberResponseCardNoVo;
import com.bizvane.members.facade.ur.vo.MembersEsRequestVo;
import com.bizvane.members.facade.ur.vo.MembersEsResponseVo;
import com.bizvane.members.facade.ur.vo.MembersExistRequestVo;
import com.bizvane.members.facade.ur.vo.SingleMembersInfoWithLevelRequestVo;
import com.bizvane.members.facade.ur.vo.SingleMembersInfoWithLevelResponseVo;
import com.bizvane.members.facade.vo.CardGenerateVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import io.jsonwebtoken.lang.Collections;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;
import org.thymeleaf.util.ListUtils;
import tk.mybatis.mapper.util.StringUtil;

@Service
public class StorageCardServiceImpl
implements StorageCardService {
    private static final Logger log = LoggerFactory.getLogger(StorageCardServiceImpl.class);
    private static final Integer MIN_SEND_BALANCE = 50;
    private static final long ONEDAY_MS = 86400000L;
    @Autowired
    private CusUrMbrStorageCardPOMapper cusUrMbrStorageCardPOMapper;
    @Autowired
    private CusUrMbrStorageCardRecordPOMapper cusUrMbrStorageCardRecordPOMapper;
    @Autowired
    private CusUrMbrStorageCardDonateMapper cusUrMbrStorageCardDonateMapper;
    @Autowired
    private UrMemberApiService urMemberApiService;
    @Autowired
    private StorageOpsService storageOpsService;
    @Autowired
    private CardGenerateApiService cardGenerateApiService;
    @Autowired
    private ConnectorServiceFeign connectorServiceFeign;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private SysCheckConfigServiceRpc sysCheckConfigServiceRpc;
    @Autowired
    private CusUrMbrStorageCardTASKPOMapper cusUrMbrStorageCardTASKPOMapper;
    @Autowired
    private SysCheckServiceRpc sysCheckServiceRpc;
    @Autowired
    private CusUrMbrStorageCardTASKDETAILPOMapper cusUrMbrStorageCardTASKDETAILPOMapper;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Autowired
    private SysAccountServiceRpc sysAccountServiceRpc;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    private final String cardPropertyCode = "urCardNo";
    private final String cardDonatePropertyCode = "urCardDonateNo";
    private final String regex = "^[A-Za-z0-9]+$";
    private final String updateRegex = "^-?[1-9]\\d*|0$";
    private final Pattern pattern = Pattern.compile("^-?[1-9]\\d*|0$");
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public PageInfo<QueryStorageResponseVo> queryStorageCardList(QueryStorageRequestVo queryStorageRequestVo, Optional<SysAccountPO> optional, Pageable pageable) {
        log.info("enter StorageCardServiceImpl queryStorageCardList param {}", (Object)JacksonUtil.bean2Json((Object)queryStorageRequestVo));
        ResponseData pageInfoResponseDataRes = new ResponseData();
        SysAccountPO currentUser = optional.get();
        HashMap storageResMap = new HashMap();
        MembersEsRequestVo membersEsRequestVo = new MembersEsRequestVo();
        membersEsRequestVo.setSysCompanyId(currentUser.getSysCompanyId());
        membersEsRequestVo.setBrandId(currentUser.getBrandId());
        Page page = null;
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{queryStorageRequestVo.getCondition(), queryStorageRequestVo.getMemberName(), queryStorageRequestVo.getPhone(), queryStorageRequestVo.getVipCardNo()})) {
            ArrayList cusUrMbrStorageCardPOS = new ArrayList();
            ArrayList memberCodeList = new ArrayList();
            if (StringUtils.isEmpty((CharSequence)queryStorageRequestVo.getStorageCardNo())) {
                CusUrMbrStorageCardPOExample cusUrMbrStorageCardPOExample = new CusUrMbrStorageCardPOExample();
                cusUrMbrStorageCardPOExample.setOrderByClause("create_date desc");
                CusUrMbrStorageCardPOExample.Criteria criteria = cusUrMbrStorageCardPOExample.createCriteria();
                criteria.andSysCompanyIdEqualTo(currentUser.getSysCompanyId());
                criteria.andBrandIdEqualTo(currentUser.getBrandId());
                page = PageHelper.startPage((int)pageable.getPageNumber(), (int)pageable.getPageSize()).doSelectPage(() -> this.cusUrMbrStorageCardPOMapper.selectByExample(cusUrMbrStorageCardPOExample));
                this.assembleObject(page.getResult(), memberCodeList, storageResMap);
            } else {
                page = PageHelper.startPage((int)pageable.getPageNumber(), (int)pageable.getPageSize()).doSelectPage(() -> this.cusUrMbrStorageCardPOMapper.queryStorageCard(queryStorageRequestVo.getStorageCardNo()));
                if (page.getResult().size() == 0) {
                    throw new CustomizedException("\u67e5\u8be2\u50a8\u503c\u5361\u5931\u8d25");
                }
                cusUrMbrStorageCardPOS.add(page.getResult().get(0));
                this.assembleObject(page.getResult(), memberCodeList, storageResMap);
            }
            membersEsRequestVo.setMemberCodeList(memberCodeList);
            membersEsRequestVo.setPageNum(Integer.valueOf(1));
            membersEsRequestVo.setPageSize(Integer.valueOf(1000));
            ResponseData membersList = this.urMemberApiService.getMembersListPageable(membersEsRequestVo);
            if (membersList.getCode() == SysResponseEnum.FAILED.getCode()) {
                throw new CustomizedException("\u67e5\u8be2\u4f1a\u5458\u5931\u8d25");
            }
            List list = ((PageInfo)membersList.getData()).getList();
            list.forEach(member -> {
                if (storageResMap.containsKey(member.getMemberCode())) {
                    QueryStorageResponseVo storageResponseVo = (QueryStorageResponseVo)storageResMap.get(member.getMemberCode());
                    storageResponseVo.setVipName(member.getName());
                    storageResponseVo.setVipCardNo(member.getCardNo());
                    storageResponseVo.setPhone(member.getPhone());
                }
            });
            ArrayList queryStorageResponseVos = new ArrayList(storageResMap.values());
            queryStorageResponseVos.sort((o1, o2) -> {
                try {
                    Date former = o1.getCreateDate();
                    Date latter = o2.getCreateDate();
                    return Long.compare(latter.getTime(), former.getTime());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            });
            PageInfo pageInfo = new PageInfo(queryStorageResponseVos);
            pageInfo.setTotal(page.getTotal());
            return pageInfo;
        }
        if (StringUtils.isNotBlank((CharSequence)queryStorageRequestVo.getCondition())) {
            membersEsRequestVo.setCondition(queryStorageRequestVo.getCondition());
        }
        if (StringUtils.isNotBlank((CharSequence)queryStorageRequestVo.getMemberName())) {
            membersEsRequestVo.setName(queryStorageRequestVo.getMemberName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryStorageRequestVo.getPhone())) {
            membersEsRequestVo.setPhone(queryStorageRequestVo.getPhone());
        }
        if (StringUtils.isNotBlank((CharSequence)queryStorageRequestVo.getVipCardNo())) {
            membersEsRequestVo.setCardNo(queryStorageRequestVo.getVipCardNo());
        }
        membersEsRequestVo.setPageNum(Integer.valueOf(1));
        membersEsRequestVo.setPageSize(Integer.valueOf(1000));
        ResponseData membersList = this.urMemberApiService.getMembersListPageable(membersEsRequestVo);
        if (membersList.getCode() == SysResponseEnum.FAILED.getCode()) {
            throw new CustomizedException("\u67e5\u8be2\u4f1a\u5458\u5931\u8d25");
        }
        if (((PageInfo)membersList.getData()).getList().size() == 0) {
            throw new CustomizedException("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        ArrayList memberCodeList = new ArrayList();
        ((PageInfo)membersList.getData()).getList().forEach(member -> {
            memberCodeList.add(member.getMemberCode());
            QueryStorageResponseVo storageResponseVo = new QueryStorageResponseVo();
            storageResponseVo.setVipName(member.getName());
            storageResponseVo.setPhone(member.getPhone());
            storageResponseVo.setVipCardNo(member.getCardNo());
            storageResMap.put(member.getMemberCode(), storageResponseVo);
        });
        QueryStorageRequestVo queryStorageRequestParam = new QueryStorageRequestVo();
        queryStorageRequestParam.setMemberCodeList(memberCodeList);
        if (StringUtils.isNotBlank((CharSequence)queryStorageRequestVo.getStorageCardNo())) {
            queryStorageRequestParam.setStorageCardNo(queryStorageRequestVo.getStorageCardNo());
        }
        page = PageHelper.startPage((int)pageable.getPageNumber(), (int)pageable.getPageSize()).doSelectPage(() -> this.cusUrMbrStorageCardPOMapper.queryStorageCardList(queryStorageRequestParam));
        ArrayList responseVos = new ArrayList();
        page.getResult().forEach(storageCard -> {
            if (storageResMap.containsKey(storageCard.getMemberCode())) {
                QueryStorageResponseVo storageResponseVo = (QueryStorageResponseVo)storageResMap.get(storageCard.getMemberCode());
                storageResponseVo.setStorageCardNo(storageCard.getStorageCardNo());
                storageResponseVo.setCreateUserName(storageCard.getCreateUserName());
                storageResponseVo.setBalance(storageCard.getBalance());
                storageResponseVo.setCreateDate(storageCard.getCreateDate());
                responseVos.add(storageResponseVo);
            }
        });
        responseVos.sort((o1, o2) -> {
            try {
                Date former = o1.getCreateDate();
                Date latter = o2.getCreateDate();
                return Long.compare(latter.getTime(), former.getTime());
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        });
        PageInfo pageInfo = new PageInfo(responseVos);
        pageInfo.setTotal(page.getTotal());
        return pageInfo;
    }

    public void assembleObject(List<CusUrMbrStorageCardPO> cusUrMbrStorageCardPOS, ArrayList<String> memberCodeList, HashMap<String, QueryStorageResponseVo> storageResMap) {
        cusUrMbrStorageCardPOS.forEach(storageCard -> {
            memberCodeList.add(storageCard.getMemberCode());
            QueryStorageResponseVo storageResponseVo = new QueryStorageResponseVo();
            storageResponseVo.setStorageCardNo(storageCard.getStorageCardNo());
            storageResponseVo.setCreateUserName(storageCard.getCreateUserName());
            storageResponseVo.setBalance(storageCard.getBalance());
            storageResponseVo.setCreateDate(storageCard.getCreateDate());
            storageResMap.put(storageCard.getMemberCode(), storageResponseVo);
        });
    }

    public ResponseData<String> updateStorageCard(UpdateStorageRequestVo updateStorageRequestVo) {
        log.info("enter StorageCardServiceImpl updateStorageCardList param {}", (Object)JacksonUtil.bean2Json((Object)updateStorageRequestVo));
        CusUrMbrStorageCardPO cusUrMbrStorageCardPO = CusUrMbrStorageCardPO.builder().build();
        if ("2".equals(updateStorageRequestVo.getOpsType())) {
            cusUrMbrStorageCardPO.setBalance(updateStorageRequestVo.getBalance().multiply(new BigDecimal(-1)));
        } else {
            cusUrMbrStorageCardPO.setBalance(updateStorageRequestVo.getBalance());
        }
        cusUrMbrStorageCardPO.setSysCompanyId(updateStorageRequestVo.getSysCompanyId());
        cusUrMbrStorageCardPO.setBrandId(updateStorageRequestVo.getBrandId());
        cusUrMbrStorageCardPO.setVipCardNo(updateStorageRequestVo.getVipCardNo());
        cusUrMbrStorageCardPO.setStorageCardNo(updateStorageRequestVo.getStorageCardNum());
        cusUrMbrStorageCardPO.setCreateUserName(updateStorageRequestVo.getName());
        return this.storageOpsService.updateStorageOps(cusUrMbrStorageCardPO);
    }

    public ResponseData<String> addStorageCard(StorageCardModel storageCardPo) {
        ResponseData cardRes;
        log.info("enter StorageCardServiceImpl addStorageCard param {}", (Object)JacksonUtil.bean2Json((Object)storageCardPo));
        ResponseData responseData = new ResponseData();
        MemberRequestCardNoVo memberRequestCardNoVo = new MemberRequestCardNoVo();
        memberRequestCardNoVo.setSysCompanyId(storageCardPo.getSysCompanyId());
        memberRequestCardNoVo.setBrandId(storageCardPo.getBrandId());
        memberRequestCardNoVo.setCardNo(storageCardPo.getVipCardNo());
        memberRequestCardNoVo.setWxMembers(Boolean.valueOf(true));
        ResponseData membersInfoByCardNoRes = this.urMemberApiService.getMembersInfoByCardNo(memberRequestCardNoVo);
        if (membersInfoByCardNoRes.getCode() == SysResponseEnum.FAILED.getCode() || membersInfoByCardNoRes.getData() == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u8be5\u5361\u53f7\u6301\u6709\u8005\u4e0d\u662f\u4f1a\u5458");
        }
        StorageRecordVo storageRecordVo = StorageRecordVo.builder().build();
        storageRecordVo.setVipName(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getName());
        storageRecordVo.setPhone(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getPhone());
        if (StringUtils.isBlank((CharSequence)((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getPhone())) {
            return ResponseDataUtil.getFailedData(null, (String)"\u8be5\u4f1a\u5458\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        String phone = ((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getPhone();
        storageRecordVo.setPassword(Aes32.Encrypt((String)phone.substring(phone.length() - 6)));
        storageRecordVo.setMemberCode(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getMemberCode());
        CardGenerateVO cardGenerateVO = new CardGenerateVO();
        cardGenerateVO.setSysCompanyId(storageCardPo.getSysCompanyId());
        cardGenerateVO.setBrandId(storageCardPo.getBrandId());
        if ("1".equals(storageCardPo.getRemark())) {
            cardGenerateVO.setCode("urCardNo");
            cardGenerateVO.setPrecision(Long.valueOf(9L));
            cardRes = this.cardGenerateApiService.generateCardNo(cardGenerateVO);
            if (cardRes.getData() == null || cardRes.getCode() == SysResponseEnum.FAILED.getCode()) {
                return ResponseDataUtil.getFailedData(null, (String)"\u751f\u6210\u5361\u53f7\u5931\u8d25");
            }
            storageRecordVo.setStorageCardNum("URV" + (String)((List)cardRes.getData()).get(0));
        } else if ("3".equals(storageCardPo.getRemark())) {
            this.getClass();
            cardGenerateVO.setCode("urCardDonateNo");
            cardGenerateVO.setPrecision(Long.valueOf(8L));
            cardRes = this.cardGenerateApiService.generateCardNo(cardGenerateVO);
            if (cardRes.getData() == null || cardRes.getCode() == SysResponseEnum.FAILED.getCode()) {
                return ResponseDataUtil.getFailedData(null, (String)"\u751f\u6210\u5361\u53f7\u5931\u8d25");
            }
            storageRecordVo.setStorageCardNum("URV" + (String)((List)cardRes.getData()).get(0));
        } else {
            if (storageCardPo.getStorageCardNo().startsWith("URV")) {
                return ResponseDataUtil.getFailedData(null, (String)"\u50a8\u503c\u5361\u5361\u53f7\u51b2\u7a81");
            }
            storageRecordVo.setStorageCardNum(storageCardPo.getStorageCardNo());
        }
        storageRecordVo.setBrandId(storageCardPo.getBrandId());
        storageRecordVo.setSysCompanyId(storageCardPo.getSysCompanyId());
        storageRecordVo.setCreateUserId(storageCardPo.getCreateUserId());
        storageRecordVo.setCreateUserName(storageCardPo.getCreateUserName());
        storageRecordVo.setCreateDate(new Date());
        storageRecordVo.setVipCardNum(storageCardPo.getVipCardNo());
        storageRecordVo.setBalance(storageCardPo.getBalance());
        storageRecordVo.setRemark(storageCardPo.getRemark());
        CusUrMbrStorageCardPO po = CusUrMbrStorageCardPO.builder().memberCode(storageRecordVo.getMemberCode()).vipCardNo(storageRecordVo.getVipCardNum()).storageCardNo(storageRecordVo.getStorageCardNum()).build();
        int storageCardNumRes = this.cusUrMbrStorageCardPOMapper.selectStorageCardByMemberCode(po);
        if (storageCardNumRes > 0) {
            return ResponseDataUtil.getFailedData(null, (String)"\u8be5\u4f1a\u5458\u5df2\u5b58\u5728\u50a8\u503c\u5361\u6216\u50a8\u503c\u5361\u53f7\u5df2\u5b58\u5728");
        }
        try {
            responseData = this.storageOpsService.addStorageOps(storageRecordVo);
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8be5\u4f1a\u5458\u5df2\u5b58\u5728\u50a8\u503c\u5361");
        }
        return responseData;
    }

    public void updateTaskDetail(TaskDetailVo taskDetailVo) {
        CusUrMbrStorageCardTASKDETAILPOExample cusUrMbrStorageCardTASKDETAILPOExample = new CusUrMbrStorageCardTASKDETAILPOExample();
        CusUrMbrStorageCardTASKDETAILPOExample.Criteria criteria = cusUrMbrStorageCardTASKDETAILPOExample.createCriteria();
        criteria.andMbrStorageCardTaskDetailEqualTo(Long.valueOf(taskDetailVo.getTaskId()));
        CusUrMbrStorageCardTASKDETAILPO cusUrMbrStorageCardTASKDETAILPO = new CusUrMbrStorageCardTASKDETAILPO();
        cusUrMbrStorageCardTASKDETAILPO.setStatus(taskDetailVo.getStatus());
        if (StringUtils.isNotBlank((CharSequence)taskDetailVo.getFailReason())) {
            cusUrMbrStorageCardTASKDETAILPO.setFailReason(taskDetailVo.getFailReason());
        }
        this.cusUrMbrStorageCardTASKDETAILPOMapper.updateByExampleSelective(cusUrMbrStorageCardTASKDETAILPO, cusUrMbrStorageCardTASKDETAILPOExample);
    }

    public void insertRepeatExcelModels(String taskCode, ArrayList<StorageCardExcelModel> list, SysAccountPO po) {
        ArrayList cardTASKDETAILPOS = new ArrayList();
        list.forEach(storageCardExcelModel -> {
            CusUrMbrStorageCardTASKDETAILPO taskdetailpo = CusUrMbrStorageCardTASKDETAILPO.builder().sysCompanyId(po.getSysCompanyId()).brandId(po.getBrandId()).taskCode(taskCode).vipCardNo(storageCardExcelModel.getMemberCardNum()).storageCardNo(storageCardExcelModel.getStorageCardNum()).status(Integer.valueOf(2)).failReason("Excel\u5185\u5361\u53f7\u91cd\u590d").createDate(new Date()).memberName("-").phone("-").build();
            cardTASKDETAILPOS.add(taskdetailpo);
        });
        this.cusUrMbrStorageCardTASKDETAILPOMapper.addBatch(cardTASKDETAILPOS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    public ResponseData importStorageCardExcel(String url, Optional<SysAccountPO> optional) {
        CusUrMbrStorageCardTASKPO cardTASKPO;
        ArrayList repeatList;
        ArrayList vipCardNo;
        SysAccountPO currentUser;
        block16: {
            CusUrMbrStorageCardTASKPO taskpo;
            CountDownLatch countDownLatch;
            AtomicInteger count;
            ArrayList storageCardExcelModels;
            ResponseData responseData;
            block18: {
                block19: {
                    block17: {
                        log.info("enter StorageCardServiceImpl importStorageCardExcel param :", (Object)url);
                        responseData = new ResponseData();
                        currentUser = optional.get();
                        url = QiNiuUtil.httpUrlCompatible((String)(this.qiNiuConfig.getDomain() + "/"), (String)url);
                        storageCardExcelModels = new ArrayList();
                        ArrayList ExcelModels = new ArrayList();
                        vipCardNo = new ArrayList();
                        repeatList = new ArrayList();
                        CommonExportExcelUtil re = null;
                        count = new AtomicInteger(0);
                        AtomicBoolean flag = new AtomicBoolean(false);
                        try {
                            re = DownLoadFileUtil.urlToExcel((String)url);
                            log.info(re.getNumberOfSheets() + "");
                            AtomicInteger a = new AtomicInteger();
                            re.read(0, 0, 1, 0, row -> {
                                if (a.compareAndSet(0, 0)) {
                                    String col1 = (String)row[0];
                                    String col2 = (String)row[1];
                                    if (!"\u4f1a\u5458\u5361\u53f7".equals(col1) || !"\u50a8\u503c\u5361\u53f7".equals(col2)) {
                                        flag.set(true);
                                        return;
                                    }
                                    a.incrementAndGet();
                                    return;
                                }
                                String memberCardNum = (String)row[0];
                                String storageCardNum = (String)row[1];
                                if (StringUtil.isEmpty((String)memberCardNum) || StringUtils.isEmpty((CharSequence)storageCardNum)) {
                                    return;
                                }
                                vipCardNo.add(memberCardNum);
                                StorageCardExcelModel storageCardExcelModel = new StorageCardExcelModel(memberCardNum, storageCardNum);
                                ExcelModels.add(storageCardExcelModel);
                            });
                            Map resultMap = this.analyList(ExcelModels);
                            if (resultMap.get(false) != null) {
                                repeatList.addAll((Collection)resultMap.get(false));
                            }
                            if (resultMap.get(true) != null) {
                                storageCardExcelModels.addAll((Collection)resultMap.get(true));
                            }
                            if (a.compareAndSet(0, 0)) {
                                flag.set(true);
                            }
                        }
                        catch (Exception e) {
                            responseData.setCode(SysResponseEnum.FAILED.getCode());
                            responseData.setMessage("excel\u6587\u4ef6url\u89e3\u6790\u51fa\u9519!");
                            e.printStackTrace();
                            return responseData;
                        }
                        if (flag.get()) {
                            responseData.setCode(SysResponseEnum.FAILED.getCode());
                            responseData.setMessage("\u5bfc\u5165excel\u6587\u4ef6\u548c\u6a21\u677f\u6587\u4ef6\u4e0d\u540c!");
                            return responseData;
                        }
                        if (!CollectionUtils.isNotEmpty(storageCardExcelModels)) break block16;
                        if (storageCardExcelModels.size() > 50000) {
                            return ResponseDataUtil.getFailedData((Object)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc750000\u6761");
                        }
                        cardTASKPO = new CusUrMbrStorageCardTASKPO();
                        cardTASKPO.setType(Integer.valueOf(1));
                        cardTASKPO.setCount(Integer.valueOf(vipCardNo.size()));
                        MembersExistRequestVo membersExistRequestVo = new MembersExistRequestVo();
                        membersExistRequestVo.setSysCompanyId(currentUser.getSysCompanyId());
                        membersExistRequestVo.setBrandId(currentUser.getBrandId());
                        membersExistRequestVo.setCardList(vipCardNo);
                        ResponseData allNotMember = this.urMemberApiService.existMembers(membersExistRequestVo);
                        if (!((Boolean)allNotMember.getData()).booleanValue()) break block17;
                        cardTASKPO.setStatus(AddBatchEnum.AUDIT_WAIT.getCode());
                        countDownLatch = new CountDownLatch(storageCardExcelModels.size());
                        taskpo = this.addNewTask(url, currentUser, cardTASKPO);
                        if (repeatList.size() <= 0) break block18;
                        break block19;
                    }
                    cardTASKPO.setStatus(AddBatchEnum.FAILED.getCode());
                    CusUrMbrStorageCardTASKPO taskpo2 = this.addNewTask(url, currentUser, cardTASKPO);
                    storageCardExcelModels.forEach(storageCardExcelModel -> {
                        TaskDetailVo taskDetailVo = new TaskDetailVo();
                        taskDetailVo.setTaskId(taskpo2.getTaskCode());
                        taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                        taskDetailVo.setFailReason("\u4e0d\u662f\u4f1a\u5458");
                        this.addToTaskDetail(storageCardExcelModel, currentUser, taskDetailVo);
                    });
                    if (repeatList.size() > 0) {
                        this.insertRepeatExcelModels(taskpo2.getTaskCode(), repeatList, currentUser);
                    }
                    return ResponseDataUtil.getFailedData(null, (String)("\u5bfc\u5165\u5931\u8d25,\u5931\u8d25" + vipCardNo.size() + "\u6761,\u5bfc\u5165\u5361\u53f7\u90fd\u4e0d\u662f\u4f1a\u5458"));
                }
                this.insertRepeatExcelModels(taskpo.getTaskCode(), repeatList, currentUser);
            }
            SysCheckConfigPo checkConfigPO = new SysCheckConfigPo();
            checkConfigPO.setSysBrandId(currentUser.getBrandId());
            checkConfigPO.setFunctionCode("C0004");
            ResponseData checkConfigResult = this.sysCheckConfigServiceRpc.ifCheckConfig(checkConfigPO);
            if (SysResponseEnum.SUCCESS.getCode() != checkConfigResult.getCode()) {
                responseData.setMessage(checkConfigResult.getMessage());
                return responseData;
            }
            if (SysConstants.CHECK_UNNEED.equals(checkConfigResult.getData())) {
                storageCardExcelModels.forEach(storageCardExcelModel -> {
                    Runnable runnable = () -> {
                        TaskDetailVo taskDetailVo = new TaskDetailVo();
                        if (StringUtils.isEmpty((CharSequence)storageCardExcelModel.getStorageCardNum()) || !storageCardExcelModel.getStorageCardNum().matches("^[A-Za-z0-9]+$") || StringUtils.isEmpty((CharSequence)storageCardExcelModel.getStorageCardNum())) {
                            taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                            taskDetailVo.setFailReason("\u50a8\u503c\u5361\u53f7\u5b57\u6bb5\u4e0d\u7b26\u5408\u6821\u9a8c");
                        } else {
                            StorageCardModel storageCardModel = new StorageCardModel();
                            storageCardModel.setRemark("2");
                            storageCardModel.setSysCompanyId(currentUser.getSysCompanyId());
                            storageCardModel.setBrandId(currentUser.getBrandId());
                            storageCardModel.setVipCardNo(storageCardExcelModel.getMemberCardNum());
                            storageCardModel.setStorageCardNo(storageCardExcelModel.getStorageCardNum());
                            storageCardModel.setCreateUserName(currentUser.getName());
                            storageCardModel.setCreateUserId(currentUser.getSysAccountId());
                            storageCardModel.setBalance(new BigDecimal(0));
                            ResponseData stringResponseData = this.addStorageCard(storageCardModel);
                            if (!SysResponseEnum.SUCCESS.getMessage().equals(stringResponseData.getMessage())) {
                                taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                                taskDetailVo.setFailReason(stringResponseData.getMessage());
                            } else {
                                count.getAndIncrement();
                                taskDetailVo.setStatus(SysConstants.ADD_SUCCESS);
                            }
                        }
                        taskDetailVo.setTaskId(taskpo.getTaskCode());
                        this.addToTaskDetail(storageCardExcelModel, currentUser, taskDetailVo);
                        countDownLatch.countDown();
                    };
                    ThreadPool.run((Runnable)runnable);
                });
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                CusUrMbrStorageCardTASKPO updateUrMbrStorageCardTASKPO = new CusUrMbrStorageCardTASKPO();
                updateUrMbrStorageCardTASKPO.setTaskCode(taskpo.getTaskCode());
                if (count.get() == 0) {
                    updateUrMbrStorageCardTASKPO.setStatus(AddBatchEnum.FAILED.getCode());
                } else {
                    updateUrMbrStorageCardTASKPO.setStatus(AddBatchEnum.FINISHED.getCode());
                }
                CusUrMbrStorageCardTASKPOExample cusUrMbrStorageCardTASKPOExample = new CusUrMbrStorageCardTASKPOExample();
                CusUrMbrStorageCardTASKPOExample.Criteria criteria = cusUrMbrStorageCardTASKPOExample.createCriteria();
                criteria.andTaskCodeEqualTo(taskpo.getTaskCode());
                this.cusUrMbrStorageCardTASKPOMapper.updateByExampleSelective(updateUrMbrStorageCardTASKPO, cusUrMbrStorageCardTASKPOExample);
                int remain = vipCardNo.size() - count.get();
                return ResponseDataUtil.getSuccessData(null, (String)("\u5bfc\u5165\u5b8c\u6210,\u6210\u529f" + count.get() + "\u6761,\u5931\u8d25" + remain + "\u6761"));
            }
            SysCheckPo checkPo = new SysCheckPo();
            checkPo.setSysBrandId(currentUser.getBrandId());
            checkPo.setFunctionCode("C0004");
            checkPo.setBusinessId(taskpo.getMbrStorageCardTask());
            checkPo.setBusinessCode(taskpo.getTaskCode());
            checkPo.setBusinessName("\u50a8\u503c\u5361\u6279\u91cf\u65b0\u589e");
            checkPo.setBizName("\u50a8\u503c\u5361\u6279\u91cf\u65b0\u589e");
            checkPo.setCheckStatus(SysConstants.CHECK_STATUS_WAIT);
            checkPo.setCreateUserId(currentUser.getSysAccountId());
            checkPo.setCreateUserName(currentUser.getName());
            checkPo.setCreateDate(new Date());
            checkPo.setRemark("1");
            checkPo.setValid(SysConstants.TABLE_VALID_EFFECTIVE);
            ResponseData checkResult = this.sysCheckServiceRpc.addCheck(checkPo);
            if (SysResponseEnum.SUCCESS.getCode() != checkResult.getCode()) {
                responseData.setData((Object)Integer.parseInt(checkResult.getData() + ""));
                responseData.setMessage(checkResult.getMessage());
                return ResponseDataUtil.getFailedData(null, (String)"\u65b0\u589e\u5ba1\u6838\u8bb0\u5f55\u5931\u8d25");
            }
            storageCardExcelModels.forEach(storageCardExcelModel -> {
                TaskDetailVo taskDetailVo = new TaskDetailVo();
                taskDetailVo.setTaskId(taskpo.getTaskCode());
                taskDetailVo.setStatus(SysConstants.INIT_VALUE);
                this.addToTaskDetail(storageCardExcelModel, currentUser, taskDetailVo);
            });
            return ResponseDataUtil.getSuccessData(null, (String)"\u8be5\u64cd\u4f5c\u9700\u8981\u5ba1\u6838,\u8bf7\u5ba1\u6838");
        }
        if (repeatList.size() != 0) {
            cardTASKPO = new CusUrMbrStorageCardTASKPO();
            cardTASKPO.setType(Integer.valueOf(1));
            cardTASKPO.setCount(Integer.valueOf(vipCardNo.size()));
            cardTASKPO.setStatus(AddBatchEnum.FAILED.getCode());
            CusUrMbrStorageCardTASKPO taskpo = this.addNewTask(url, currentUser, cardTASKPO);
            this.insertRepeatExcelModels(taskpo.getTaskCode(), repeatList, currentUser);
        }
        return ResponseDataUtil.getFailedData(null, (String)"\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
    }

    private Map<Boolean, List<StorageCardExcelModel>> analyList(List<StorageCardExcelModel> orignList) {
        Set collect1 = orignList.stream().collect(Collectors.groupingBy(StorageCardExcelModel::getMemberCardNum)).values().stream().filter(list -> list.size() > 1).flatMap(Collection::stream).map(StorageCardExcelModel::getMemberCardNum).collect(Collectors.toSet());
        Set collect2 = orignList.stream().collect(Collectors.groupingBy(StorageCardExcelModel::getStorageCardNum)).values().stream().filter(list -> list.size() > 1).flatMap(Collection::stream).map(StorageCardExcelModel::getStorageCardNum).collect(Collectors.toSet());
        return orignList.stream().collect(Collectors.groupingBy(u -> !collect1.contains(u.getMemberCardNum()) && !collect2.contains(u.getStorageCardNum())));
    }

    public CusUrMbrStorageCardTASKPO addNewTask(String url, SysAccountPO currentUser, CusUrMbrStorageCardTASKPO taskPO) {
        CusUrMbrStorageCardTASKPO cusUrMbrStorageCardTASKPO = new CusUrMbrStorageCardTASKPO();
        cusUrMbrStorageCardTASKPO.setSysCompanyId(currentUser.getSysCompanyId());
        cusUrMbrStorageCardTASKPO.setBrandId(currentUser.getBrandId());
        cusUrMbrStorageCardTASKPO.setCreateUserName(currentUser.getName());
        cusUrMbrStorageCardTASKPO.setStatus(taskPO.getStatus());
        cusUrMbrStorageCardTASKPO.setCreateDate(new Date());
        if (taskPO.getType() == 1) {
            cusUrMbrStorageCardTASKPO.setTaskName("\u50a8\u503c\u5361\u6279\u91cf\u65b0\u589e");
        } else {
            cusUrMbrStorageCardTASKPO.setTaskName("\u50a8\u503c\u5361\u6279\u91cf\u5145\u503c");
        }
        cusUrMbrStorageCardTASKPO.setTaskUrl(url);
        cusUrMbrStorageCardTASKPO.setType(taskPO.getType());
        cusUrMbrStorageCardTASKPO.setCount(taskPO.getCount());
        cusUrMbrStorageCardTASKPO.setTaskCode("CZK" + UUIDGenerator.getLocalTrmSeqNum());
        this.cusUrMbrStorageCardTASKPOMapper.insertSelective(cusUrMbrStorageCardTASKPO);
        return cusUrMbrStorageCardTASKPO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResponseData importStorageCardPay(String url, Optional<SysAccountPO> optional) {
        CusUrMbrStorageCardTASKPO updateUrMbrStorageCardTASKPO;
        log.info("enter StorageCardServiceImpl importStorageCardPay param :", (Object)url);
        ResponseData responseData = new ResponseData();
        SysAccountPO currentUser = optional.get();
        url = QiNiuUtil.httpUrlCompatible((String)(this.qiNiuConfig.getDomain() + "/"), (String)url);
        ArrayList storageMoneyModels = new ArrayList();
        AtomicInteger count = new AtomicInteger(0);
        ArrayList storageCardNumList = new ArrayList();
        ArrayList errorList = new ArrayList();
        CommonExportExcelUtil re = null;
        AtomicBoolean flag = new AtomicBoolean(false);
        try {
            re = DownLoadFileUtil.urlToExcel((String)url);
            log.info(re.getNumberOfSheets() + "");
            AtomicInteger a = new AtomicInteger();
            re.read(0, 0, 1, 0, row -> {
                if (a.compareAndSet(0, 0)) {
                    String col1 = (String)row[0];
                    String col2 = (String)row[1];
                    if (!"\u50a8\u503c\u5361\u53f7".equals(col1) || !"\u91d1\u989d".equals(col2)) {
                        flag.set(true);
                        return;
                    }
                    a.incrementAndGet();
                    return;
                }
                String storageCardNum = (String)row[0];
                String balance = (String)row[1];
                if (StringUtil.isEmpty((String)storageCardNum)) {
                    return;
                }
                storageCardNumList.add(storageCardNum);
                StorageMoneyModel storageCardExcelModel = new StorageMoneyModel();
                storageCardExcelModel.setStorageCardNum(storageCardNum);
                storageCardExcelModel.setBalance(balance);
                storageMoneyModels.add(storageCardExcelModel);
            });
            if (a.compareAndSet(0, 0)) {
                flag.set(true);
            }
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("excel\u6587\u4ef6url\u89e3\u6790\u51fa\u9519!");
            e.printStackTrace();
            return responseData;
        }
        if (flag.get()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5bfc\u5165excel\u6587\u4ef6\u548c\u6a21\u677f\u6587\u4ef6\u4e0d\u540c!");
            return responseData;
        }
        if (!CollectionUtils.isNotEmpty(storageMoneyModels)) return ResponseDataUtil.getFailedData((Object)"\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        if (storageMoneyModels.size() > 50000) {
            return ResponseDataUtil.getFailedData((Object)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc750000\u6761");
        }
        CusUrMbrStorageCardTASKPO cardTASKPO = new CusUrMbrStorageCardTASKPO();
        cardTASKPO.setType(Integer.valueOf(2));
        cardTASKPO.setCount(Integer.valueOf(storageMoneyModels.size() + errorList.size()));
        CusUrMbrStorageCardPOExample cardPOExample = new CusUrMbrStorageCardPOExample();
        CusUrMbrStorageCardPOExample.Criteria query = cardPOExample.createCriteria();
        query.andStorageCardNoIn(storageCardNumList);
        List cusUrMbrStorageCardPOS = this.cusUrMbrStorageCardPOMapper.selectByExample(cardPOExample);
        if (cusUrMbrStorageCardPOS.size() <= 0) {
            cardTASKPO.setStatus(AddBatchEnum.FAILED.getCode());
            CusUrMbrStorageCardTASKPO taskpo = this.addNewTask(url, currentUser, cardTASKPO);
            storageMoneyModels.forEach(storageMoneyModel -> {
                TaskDetailVo taskDetailVo = new TaskDetailVo();
                taskDetailVo.setTaskId(taskpo.getTaskCode());
                taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                taskDetailVo.setFailReason("\u50a8\u503c\u5361\u5168\u90e8\u4e0d\u5b58\u5728");
                this.addToTaskDetailForRecharge(storageMoneyModel, currentUser, taskDetailVo);
            });
            this.addErrorMoneyDetail(currentUser, errorList, taskpo);
            return ResponseDataUtil.getFailedData(null, (String)("\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25" + storageMoneyModels.size() + "\u6761\uff0c\u5bfc\u5165\u50a8\u503c\u5361\u5168\u90e8\u4e0d\u5b58\u5728"));
        }
        cardTASKPO.setStatus(AddBatchEnum.AUDIT_WAIT.getCode());
        CusUrMbrStorageCardTASKPO task = this.addNewTask(url, currentUser, cardTASKPO);
        this.addErrorMoneyDetail(currentUser, errorList, task);
        SysCheckConfigPo checkConfigPO = new SysCheckConfigPo();
        checkConfigPO.setSysBrandId(currentUser.getBrandId());
        checkConfigPO.setFunctionCode("C0004");
        ResponseData checkConfigResult = this.sysCheckConfigServiceRpc.ifCheckConfig(checkConfigPO);
        if (SysResponseEnum.SUCCESS.getCode() != checkConfigResult.getCode()) {
            responseData.setMessage(checkConfigResult.getMessage());
            return responseData;
        }
        CountDownLatch countDownLatch = new CountDownLatch(storageMoneyModels.size());
        if (SysConstants.CHECK_UNNEED.equals(checkConfigResult.getData())) {
            storageMoneyModels.forEach(storageCardMoneyModel -> {
                Runnable runnable = () -> {
                    TaskDetailVo taskDetailVo = new TaskDetailVo();
                    UpdateStorageRequestVo updateStorageVo = new UpdateStorageRequestVo();
                    updateStorageVo.setStorageCardNum(storageCardMoneyModel.getStorageCardNum());
                    if (StringUtils.isNotEmpty((CharSequence)storageCardMoneyModel.getBalance()) && this.pattern.matcher(storageCardMoneyModel.getBalance()).matches()) {
                        updateStorageVo.setBalance(new BigDecimal(storageCardMoneyModel.getBalance()));
                        updateStorageVo.setSysCompanyId(currentUser.getSysCompanyId());
                        updateStorageVo.setBrandId(currentUser.getBrandId());
                        updateStorageVo.setName(currentUser.getName());
                        CusUrMbrStorageCardPOExample cusUrMbrStorageCardPOExample = new CusUrMbrStorageCardPOExample();
                        CusUrMbrStorageCardPOExample.Criteria queryMemberCode = cusUrMbrStorageCardPOExample.createCriteria();
                        queryMemberCode.andStorageCardNoEqualTo(storageCardMoneyModel.getStorageCardNum());
                        List storageCardPOS = this.cusUrMbrStorageCardPOMapper.selectByExample(cusUrMbrStorageCardPOExample);
                        if (storageCardPOS.size() > 0) {
                            updateStorageVo.setMemberCode(((CusUrMbrStorageCardPO)storageCardPOS.get(0)).getMemberCode());
                            updateStorageVo.setVipCardNo(((CusUrMbrStorageCardPO)storageCardPOS.get(0)).getVipCardNo());
                            storageCardMoneyModel.setVipCardNum(((CusUrMbrStorageCardPO)storageCardPOS.get(0)).getVipCardNo());
                            MemberRequestCardNoVo memberRequestCardNoVo = new MemberRequestCardNoVo();
                            memberRequestCardNoVo.setSysCompanyId(currentUser.getSysCompanyId());
                            memberRequestCardNoVo.setBrandId(currentUser.getBrandId());
                            memberRequestCardNoVo.setCardNo(((CusUrMbrStorageCardPO)storageCardPOS.get(0)).getVipCardNo());
                            ResponseData membersInfoByCardNoRes = this.urMemberApiService.getMembersInfoByCardNo(memberRequestCardNoVo);
                            if (membersInfoByCardNoRes.getCode() == SysResponseEnum.FAILED.getCode() || membersInfoByCardNoRes.getData() == null) {
                                taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                                taskDetailVo.setFailReason("\u67e5\u8be2\u4f1a\u5458\u5931\u8d25");
                            } else {
                                storageCardMoneyModel.setVipName(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getName());
                                storageCardMoneyModel.setPhone(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getPhone());
                                if (storageCardMoneyModel.getBalance() == null) {
                                    taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                                    taskDetailVo.setFailReason("\u91d1\u989d\u5b57\u6bb5\u4e3a\u7a7a");
                                } else {
                                    ResponseData updateRes = this.updateStorageCard(updateStorageVo);
                                    if (!SysResponseEnum.SUCCESS.getMessage().equals(updateRes.getMessage())) {
                                        taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                                        taskDetailVo.setFailReason(updateRes.getMessage());
                                    } else {
                                        count.getAndIncrement();
                                        taskDetailVo.setStatus(SysConstants.ADD_SUCCESS);
                                    }
                                }
                            }
                        } else {
                            taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                            taskDetailVo.setFailReason("\u50a8\u503c\u5361\u53f7\u4e0d\u5b58\u5728");
                        }
                    } else {
                        taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                        taskDetailVo.setFailReason("\u91d1\u989d\u5b57\u6bb5\u6821\u9a8c\u5931\u8d25");
                    }
                    taskDetailVo.setTaskId(task.getTaskCode());
                    this.addToTaskDetailForRecharge(storageCardMoneyModel, currentUser, taskDetailVo);
                    countDownLatch.countDown();
                };
                ThreadPool.run((Runnable)runnable);
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            updateUrMbrStorageCardTASKPO = new CusUrMbrStorageCardTASKPO();
            if (count.get() == 0) {
                updateUrMbrStorageCardTASKPO.setStatus(AddBatchEnum.FAILED.getCode());
            } else {
                updateUrMbrStorageCardTASKPO.setStatus(AddBatchEnum.FINISHED.getCode());
            }
        } else {
            SysCheckPo checkPo = new SysCheckPo();
            checkPo.setSysBrandId(currentUser.getBrandId());
            checkPo.setFunctionCode("C0004");
            checkPo.setBusinessId(task.getMbrStorageCardTask());
            checkPo.setBusinessCode(task.getTaskCode());
            checkPo.setBusinessName("\u50a8\u503c\u5361\u6279\u91cf\u5145\u503c");
            checkPo.setBizName("\u50a8\u503c\u5361\u6279\u91cf\u5145\u503c");
            checkPo.setCheckStatus(SysConstants.CHECK_STATUS_WAIT);
            checkPo.setCreateUserId(currentUser.getSysAccountId());
            checkPo.setCreateUserName(currentUser.getName());
            checkPo.setCreateDate(new Date());
            checkPo.setRemark("2");
            checkPo.setValid(SysConstants.TABLE_VALID_EFFECTIVE);
            ResponseData checkResult = this.sysCheckServiceRpc.addCheck(checkPo);
            if (SysResponseEnum.SUCCESS.getCode() != checkResult.getCode()) {
                responseData.setData((Object)Integer.parseInt(checkResult.getData() + ""));
                responseData.setMessage(checkResult.getMessage());
                return ResponseDataUtil.getFailedData((Object)"\u65b0\u589e\u5ba1\u6838\u8bb0\u5f55\u5931\u8d25");
            }
            storageMoneyModels.forEach(storageCardMoneyModel -> {
                TaskDetailVo taskDetailVo = new TaskDetailVo();
                CusUrMbrStorageCardPOExample cusUrMbrStorageCardPOExample = new CusUrMbrStorageCardPOExample();
                CusUrMbrStorageCardPOExample.Criteria queryMemberCode = cusUrMbrStorageCardPOExample.createCriteria();
                queryMemberCode.andStorageCardNoEqualTo(storageCardMoneyModel.getStorageCardNum());
                List storageCardPOS = this.cusUrMbrStorageCardPOMapper.selectByExample(cusUrMbrStorageCardPOExample);
                if (storageCardPOS.size() > 0) {
                    MemberRequestCardNoVo memberRequestCardNoVo = new MemberRequestCardNoVo();
                    memberRequestCardNoVo.setSysCompanyId(currentUser.getSysCompanyId());
                    memberRequestCardNoVo.setBrandId(currentUser.getBrandId());
                    memberRequestCardNoVo.setCardNo(((CusUrMbrStorageCardPO)storageCardPOS.get(0)).getVipCardNo());
                    ResponseData membersInfoByCardNoRes = this.urMemberApiService.getMembersInfoByCardNo(memberRequestCardNoVo);
                    if (membersInfoByCardNoRes.getCode() == SysResponseEnum.FAILED.getCode() || membersInfoByCardNoRes.getData() == null) {
                        taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                        taskDetailVo.setFailReason("\u67e5\u8be2\u4f1a\u5458\u5931\u8d25");
                    } else {
                        taskDetailVo.setStatus(SysConstants.INIT_VALUE);
                        storageCardMoneyModel.setVipCardNum(((CusUrMbrStorageCardPO)storageCardPOS.get(0)).getVipCardNo());
                        storageCardMoneyModel.setVipName(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getName());
                        storageCardMoneyModel.setPhone(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getPhone());
                    }
                } else {
                    taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                    taskDetailVo.setFailReason("\u50a8\u503c\u5361\u53f7\u4e0d\u5b58\u5728");
                }
                taskDetailVo.setTaskId(task.getTaskCode());
                this.addToTaskDetailForRecharge(storageCardMoneyModel, currentUser, taskDetailVo);
            });
            return ResponseDataUtil.getSuccessData((Object)"\u8be5\u64cd\u4f5c\u9700\u5ba1\u6838,\u8bf7\u5ba1\u6838");
        }
        CusUrMbrStorageCardTASKPOExample cusUrMbrStorageCardTASKPOExample = new CusUrMbrStorageCardTASKPOExample();
        CusUrMbrStorageCardTASKPOExample.Criteria criteria = cusUrMbrStorageCardTASKPOExample.createCriteria();
        criteria.andTaskCodeEqualTo(task.getTaskCode());
        this.cusUrMbrStorageCardTASKPOMapper.updateByExampleSelective(updateUrMbrStorageCardTASKPO, cusUrMbrStorageCardTASKPOExample);
        int remain = storageMoneyModels.size() - count.get();
        return ResponseDataUtil.getSuccessData((Object)("\u5bfc\u5165\u5b8c\u6210,\u6210\u529f" + count.get() + "\u6761,\u5931\u8d25" + remain + "\u6761"));
    }

    private void addErrorMoneyDetail(SysAccountPO currentUser, ArrayList<String> errorList, CusUrMbrStorageCardTASKPO taskpo) {
        if (errorList.size() > 0) {
            errorList.forEach(cardNo -> {
                StorageMoneyModel moneyModel = StorageMoneyModel.builder().storageCardNum(cardNo).vipName("-").phone("-").vipCardNum("-").build();
                TaskDetailVo taskDetailVo = new TaskDetailVo();
                taskDetailVo.setTaskId(taskpo.getTaskCode());
                taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                taskDetailVo.setFailReason("\u91d1\u989d\u5b57\u6bb5\u4e0d\u7b26\u5408\u6821\u9a8c");
                this.addToTaskDetailForRecharge(moneyModel, currentUser, taskDetailVo);
            });
        }
    }

    @Transactional
    public ResponseData auditAddBatchStorageCard(AuditAddBatchVo addBatchVo, Optional<SysAccountPO> optional) {
        log.info("enter StorageCardServiceImpl auditAddBatchStorageCard param {}", (Object)JacksonUtil.bean2Json((Object)addBatchVo));
        SysAccountPO currentUser = optional.get();
        CusUrMbrStorageCardTASKPOExample taskExample = new CusUrMbrStorageCardTASKPOExample();
        CusUrMbrStorageCardTASKPOExample.Criteria taskExampleCriteria = taskExample.createCriteria();
        taskExampleCriteria.andBrandIdEqualTo(currentUser.getBrandId());
        taskExampleCriteria.andSysCompanyIdEqualTo(currentUser.getSysCompanyId());
        taskExampleCriteria.andTaskCodeEqualTo(addBatchVo.getTaskCode());
        List taskpos = this.cusUrMbrStorageCardTASKPOMapper.selectByExample(taskExample);
        if (taskpos.size() > 0 && ((CusUrMbrStorageCardTASKPO)taskpos.get(0)).getStatus() != 3) {
            return ResponseDataUtil.getFailedData(null, (String)"\u8be5\u4efb\u52a1\u5df2\u5ba1\u6838");
        }
        CusUrMbrStorageCardTASKDETAILPOExample cusUrMbrStorageCardTASKDETAILPOExample = new CusUrMbrStorageCardTASKDETAILPOExample();
        CusUrMbrStorageCardTASKDETAILPOExample.Criteria criteria = cusUrMbrStorageCardTASKDETAILPOExample.createCriteria();
        criteria.andTaskCodeEqualTo(addBatchVo.getTaskCode());
        criteria.andSysCompanyIdEqualTo(currentUser.getSysCompanyId());
        criteria.andBrandIdEqualTo(currentUser.getBrandId());
        criteria.andStatusEqualTo(Integer.valueOf(0));
        CusUrMbrStorageCardTASKPO updateUrMbrStorageCardTASKPO = new CusUrMbrStorageCardTASKPO();
        List cusUrMbrStorageCardTASKDETAILPOS = this.cusUrMbrStorageCardTASKDETAILPOMapper.selectByExample(cusUrMbrStorageCardTASKDETAILPOExample);
        SysCheckPo checkPo = new SysCheckPo();
        checkPo.setFunctionCode("C0004");
        AtomicInteger count = new AtomicInteger(0);
        CountDownLatch countDownLatch = new CountDownLatch(cusUrMbrStorageCardTASKDETAILPOS.size());
        if (addBatchVo.getIsPass().booleanValue()) {
            if ("1".equals(addBatchVo.getType())) {
                cusUrMbrStorageCardTASKDETAILPOS.forEach(taskDetail -> {
                    Runnable runnable = () -> {
                        TaskDetailVo taskDetailVo = new TaskDetailVo();
                        if (StringUtils.isEmpty((CharSequence)taskDetail.getStorageCardNo()) || !taskDetail.getStorageCardNo().matches("^[A-Za-z0-9]+$") || StringUtils.isEmpty((CharSequence)taskDetail.getVipCardNo())) {
                            taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                            taskDetailVo.setFailReason("\u50a8\u503c\u5361\u53f7\u5b57\u6bb5\u4e0d\u7b26\u5408\u6821\u9a8c");
                        } else {
                            StorageCardModel storageCardModel = new StorageCardModel();
                            storageCardModel.setRemark("2");
                            storageCardModel.setSysCompanyId(taskDetail.getSysCompanyId());
                            storageCardModel.setBrandId(taskDetail.getBrandId());
                            storageCardModel.setVipCardNo(taskDetail.getVipCardNo());
                            storageCardModel.setStorageCardNo(taskDetail.getStorageCardNo());
                            storageCardModel.setCreateUserName(taskDetail.getCreateUserName());
                            storageCardModel.setCreateUserId(taskDetail.getCreateUserId());
                            storageCardModel.setBalance(new BigDecimal(0));
                            ResponseData stringResponseData = this.addStorageCard(storageCardModel);
                            if (!SysResponseEnum.SUCCESS.getMessage().equals(stringResponseData.getMessage())) {
                                taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                                taskDetailVo.setFailReason(stringResponseData.getMessage());
                            } else {
                                count.getAndIncrement();
                                taskDetailVo.setStatus(SysConstants.ADD_SUCCESS);
                            }
                        }
                        taskDetailVo.setTaskId(taskDetail.getMbrStorageCardTaskDetail().toString());
                        this.updateTaskDetail(taskDetailVo);
                        countDownLatch.countDown();
                    };
                    ThreadPool.run((Runnable)runnable);
                });
            } else {
                cusUrMbrStorageCardTASKDETAILPOS.forEach(taskDetail -> {
                    Runnable runnable = () -> {
                        UpdateStorageRequestVo updateStorageVo = new UpdateStorageRequestVo();
                        updateStorageVo.setSysCompanyId(taskDetail.getSysCompanyId());
                        updateStorageVo.setBrandId(taskDetail.getBrandId());
                        updateStorageVo.setStorageCardNum(taskDetail.getStorageCardNo());
                        TaskDetailVo taskDetailVo = new TaskDetailVo();
                        if (taskDetail.getBalance() != null) {
                            updateStorageVo.setBalance(taskDetail.getBalance());
                            updateStorageVo.setName(taskDetail.getCreateUserName());
                            ResponseData stringResponseData = this.updateStorageCard(updateStorageVo);
                            if (!SysResponseEnum.SUCCESS.getMessage().equals(stringResponseData.getMessage())) {
                                taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                                taskDetailVo.setFailReason(stringResponseData.getMessage());
                            } else {
                                count.getAndIncrement();
                                taskDetailVo.setStatus(SysConstants.ADD_SUCCESS);
                            }
                        } else {
                            taskDetailVo.setStatus(SysConstants.ADD_FAILED);
                            taskDetailVo.setFailReason("\u91d1\u989d\u5b57\u6bb5\u6821\u9a8c\u5931\u8d25");
                        }
                        taskDetailVo.setTaskId(taskDetail.getMbrStorageCardTaskDetail().toString());
                        this.updateTaskDetail(taskDetailVo);
                        countDownLatch.countDown();
                    };
                    ThreadPool.run((Runnable)runnable);
                });
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (count.get() == 0) {
                updateUrMbrStorageCardTASKPO.setStatus(AddBatchEnum.FAILED.getCode());
            } else {
                updateUrMbrStorageCardTASKPO.setStatus(AddBatchEnum.AUDIT_FINISHED.getCode());
            }
            checkPo.setCheckStatus(Integer.valueOf(3));
        } else {
            CusUrMbrStorageCardTASKDETAILPOExample taskdetailpoExample = new CusUrMbrStorageCardTASKDETAILPOExample();
            CusUrMbrStorageCardTASKDETAILPOExample.Criteria criteria1 = taskdetailpoExample.createCriteria();
            CusUrMbrStorageCardTASKDETAILPO cusUrMbrStorageCardTASKDETAILPO = new CusUrMbrStorageCardTASKDETAILPO();
            criteria1.andTaskCodeEqualTo(addBatchVo.getTaskCode());
            criteria1.andStatusEqualTo(Integer.valueOf(0));
            cusUrMbrStorageCardTASKDETAILPO.setStatus(SysConstants.AUDIT_REJECT);
            cusUrMbrStorageCardTASKDETAILPO.setFailReason("\u5ba1\u6838\u672a\u901a\u8fc7");
            this.cusUrMbrStorageCardTASKDETAILPOMapper.updateByExampleSelective(cusUrMbrStorageCardTASKDETAILPO, taskdetailpoExample);
            updateUrMbrStorageCardTASKPO.setStatus(AddBatchEnum.NO_PASS.getCode());
            checkPo.setCheckStatus(Integer.valueOf(4));
        }
        checkPo.setSysBrandId(currentUser.getBrandId());
        checkPo.setBusinessId(addBatchVo.getTaskId());
        checkPo.setRemark(addBatchVo.getRemark());
        ResponseData responseData = this.sysCheckServiceRpc.updateCheck(checkPo);
        if (responseData.getCode() == SysResponseEnum.FAILED.getCode()) {
            return ResponseDataUtil.getFailedData(null, (String)"\u4fee\u6539\u5ba1\u6838\u72b6\u6001\u5931\u8d25");
        }
        CusUrMbrStorageCardTASKPOExample cusUrMbrStorageCardTASKPOExample = new CusUrMbrStorageCardTASKPOExample();
        CusUrMbrStorageCardTASKPOExample.Criteria query = cusUrMbrStorageCardTASKPOExample.createCriteria();
        query.andTaskCodeEqualTo(addBatchVo.getTaskCode());
        this.cusUrMbrStorageCardTASKPOMapper.updateByExampleSelective(updateUrMbrStorageCardTASKPO, cusUrMbrStorageCardTASKPOExample);
        int remain = cusUrMbrStorageCardTASKDETAILPOS.size() - count.get();
        return ResponseDataUtil.getSuccessData((Object)("\u5bfc\u5165\u5b8c\u6210,\u6210\u529f" + count.get() + "\u6761,\u5931\u8d25" + remain + "\u6761"));
    }

    public void addToTaskDetail(StorageCardExcelModel storageCardExcelModel, SysAccountPO currentUser, TaskDetailVo taskDetailVo) {
        CusUrMbrStorageCardTASKDETAILPO cusUrMbrStorageCardTASKDETAILPO = new CusUrMbrStorageCardTASKDETAILPO();
        MemberRequestCardNoVo memberRequestCardNoVo = new MemberRequestCardNoVo();
        memberRequestCardNoVo.setSysCompanyId(currentUser.getSysCompanyId());
        memberRequestCardNoVo.setBrandId(currentUser.getBrandId());
        memberRequestCardNoVo.setCardNo(storageCardExcelModel.getMemberCardNum());
        ResponseData membersInfoByCardNoRes = this.urMemberApiService.getMembersInfoByCardNo(memberRequestCardNoVo);
        if (membersInfoByCardNoRes.getData() != null) {
            cusUrMbrStorageCardTASKDETAILPO.setMemberName(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getName());
            cusUrMbrStorageCardTASKDETAILPO.setPhone(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getPhone());
        } else {
            cusUrMbrStorageCardTASKDETAILPO.setMemberName("-");
            cusUrMbrStorageCardTASKDETAILPO.setPhone("-");
        }
        cusUrMbrStorageCardTASKDETAILPO.setSysCompanyId(currentUser.getSysCompanyId());
        cusUrMbrStorageCardTASKDETAILPO.setBrandId(currentUser.getBrandId());
        cusUrMbrStorageCardTASKDETAILPO.setCreateUserId(currentUser.getSysAccountId());
        cusUrMbrStorageCardTASKDETAILPO.setCreateUserName(currentUser.getName());
        cusUrMbrStorageCardTASKDETAILPO.setTaskCode(taskDetailVo.getTaskId());
        cusUrMbrStorageCardTASKDETAILPO.setVipCardNo(storageCardExcelModel.getMemberCardNum());
        cusUrMbrStorageCardTASKDETAILPO.setStorageCardNo(storageCardExcelModel.getStorageCardNum());
        cusUrMbrStorageCardTASKDETAILPO.setRemark("2");
        cusUrMbrStorageCardTASKDETAILPO.setStatus(taskDetailVo.getStatus());
        cusUrMbrStorageCardTASKDETAILPO.setCreateDate(new Date());
        if (StringUtils.isNotBlank((CharSequence)taskDetailVo.getFailReason())) {
            cusUrMbrStorageCardTASKDETAILPO.setFailReason(taskDetailVo.getFailReason());
        }
        this.cusUrMbrStorageCardTASKDETAILPOMapper.insertSelective(cusUrMbrStorageCardTASKDETAILPO);
    }

    public void addToTaskDetailForRecharge(StorageMoneyModel storageMoneyModel, SysAccountPO currentUser, TaskDetailVo taskDetailVo) {
        CusUrMbrStorageCardTASKDETAILPO cusUrMbrStorageCardTASKDETAILPO = new CusUrMbrStorageCardTASKDETAILPO();
        cusUrMbrStorageCardTASKDETAILPO.setSysCompanyId(currentUser.getSysCompanyId());
        cusUrMbrStorageCardTASKDETAILPO.setBrandId(currentUser.getBrandId());
        cusUrMbrStorageCardTASKDETAILPO.setCreateUserId(currentUser.getSysAccountId());
        cusUrMbrStorageCardTASKDETAILPO.setCreateUserName(currentUser.getName());
        cusUrMbrStorageCardTASKDETAILPO.setTaskCode(taskDetailVo.getTaskId());
        cusUrMbrStorageCardTASKDETAILPO.setStorageCardNo(storageMoneyModel.getStorageCardNum());
        if (StringUtils.isNotEmpty((CharSequence)storageMoneyModel.getBalance()) && this.pattern.matcher(storageMoneyModel.getBalance()).matches()) {
            cusUrMbrStorageCardTASKDETAILPO.setBalance(new BigDecimal(storageMoneyModel.getBalance()));
        }
        cusUrMbrStorageCardTASKDETAILPO.setStatus(taskDetailVo.getStatus());
        cusUrMbrStorageCardTASKDETAILPO.setVipCardNo(storageMoneyModel.getVipCardNum());
        cusUrMbrStorageCardTASKDETAILPO.setMemberName(storageMoneyModel.getVipName());
        cusUrMbrStorageCardTASKDETAILPO.setPhone(storageMoneyModel.getPhone());
        cusUrMbrStorageCardTASKDETAILPO.setCreateDate(new Date());
        if (StringUtils.isNotBlank((CharSequence)taskDetailVo.getFailReason())) {
            cusUrMbrStorageCardTASKDETAILPO.setFailReason(taskDetailVo.getFailReason());
        }
        this.cusUrMbrStorageCardTASKDETAILPOMapper.insertSelective(cusUrMbrStorageCardTASKDETAILPO);
    }

    public ResponseData sendStorageCard(CusUrStorageCardSendVO vo) {
        BigDecimal balance = vo.getBalance();
        Assert.isTrue((balance.intValue() >= MIN_SEND_BALANCE ? 1 : 0) != 0, (String)"\u60a8\u6bcf\u6b21\u6700\u5c11\u8f6c\u589e50\u50a8\u503c");
        String truePwd = this.cusUrMbrStorageCardPOMapper.queryPwdByMemberCode(vo.getMemberCode());
        String encrypt = Aes32.Encrypt((String)vo.getPwd());
        Assert.hasText((String)encrypt, (String)"\u8f6c\u589e\u5bc6\u7801\u9519\u8bef");
        Assert.isTrue((boolean)encrypt.equals(truePwd), (String)"\u8f6c\u589e\u5bc6\u7801\u4e0d\u6b63\u786e");
        MembersEsRequestVo membersEsRequestVo = new MembersEsRequestVo();
        membersEsRequestVo.setSysCompanyId(vo.getSysCompanyId());
        membersEsRequestVo.setBrandId(vo.getBrandId());
        membersEsRequestVo.setMemberCodeList(Arrays.asList(vo.getMemberCode(), vo.getTargetMemberCode()));
        log.info("StorageCardServiceImpl sendStorageCard check members params : {}", (Object)membersEsRequestVo.toString());
        ResponseData membersListPageable = this.urMemberApiService.getMembersListPageable(membersEsRequestVo);
        PageInfo data = (PageInfo)membersListPageable.getData();
        log.info("StorageCardServiceImpl sendStorageCard check members result : {}", (Object)data.getList());
        Assert.isTrue((data.getTotal() == 2L ? 1 : 0) != 0, (String)"\u65e0\u6548\u64cd\u4f5c");
        List dataList = data.getList();
        MembersEsResponseVo fromMember = null;
        MembersEsResponseVo toMember = null;
        for (MembersEsResponseVo membersEsResponseVo : dataList) {
            if (vo.getMemberCode().equals(membersEsResponseVo.getMemberCode())) {
                fromMember = membersEsResponseVo;
                continue;
            }
            if (!vo.getTargetMemberCode().equals(membersEsResponseVo.getMemberCode())) continue;
            toMember = membersEsResponseVo;
        }
        Assert.notNull(fromMember, (String)"\u83b7\u53d6\u8f6c\u8d60\u4eba\u4fe1\u606f\u51fa\u9519");
        Assert.notNull(toMember, (String)"\u83b7\u53d6\u8f6c\u8d60\u4eba\u4fe1\u606f\u51fa\u9519");
        StorageCardModel storageCardModel = this.cusUrMbrStorageCardPOMapper.queryStorageCardByMemberCode(vo.getMemberCode());
        Assert.notNull((Object)storageCardModel, (String)"\u60a8\u8fd8\u6ca1\u6709\u50a8\u503c\u5361");
        log.info("StorageCardServiceImpl queryStorageResponseVo : {}", (Object)storageCardModel.toString());
        BigDecimal oldBalance = storageCardModel.getBalance();
        Assert.isTrue((oldBalance.compareTo(balance) >= 0 ? 1 : 0) != 0, (String)"\u60a8\u7684\u50a8\u503c\u5361\u4f59\u989d\u4e0d\u8db3\u4ee5\u8f6c\u589e");
        String billNo = UUIDGenerator.get20UUID();
        SendStorageDTO sendStorageDTO = SendStorageDTO.builder().sysCompanyId(vo.getSysCompanyId()).brandId(vo.getBrandId()).fromMemberCode(vo.getMemberCode()).fromPhone(fromMember.getPhone()).fromVipCardNo(storageCardModel.getVipCardNo()).fromVipName(fromMember.getName()).fromStorageCardNo(storageCardModel.getStorageCardNo()).toTargetMemberCode(vo.getTargetMemberCode()).toTargetName(vo.getTargetName()).balance(balance).oldBalance(oldBalance).billNo(billNo).build();
        this.storageOpsService.sendStorageOps(sendStorageDTO);
        StorageCardListRequestVO requestVO = new StorageCardListRequestVO();
        requestVO.setBrandId(vo.getBrandId());
        StorageCardRequestVO storageCardRequestVO = new StorageCardRequestVO();
        storageCardRequestVO.setCardCode(storageCardModel.getVipCardNo());
        storageCardRequestVO.setVipName(fromMember.getName());
        storageCardRequestVO.setSex(fromMember.getGender());
        storageCardRequestVO.setPhone(fromMember.getPhone());
        storageCardRequestVO.setUpdateBalance(balance.negate());
        storageCardRequestVO.setBalance(oldBalance.subtract(balance));
        storageCardRequestVO.setStoredCardNo(storageCardModel.getStorageCardNo());
        storageCardRequestVO.setCreater(fromMember.getName());
        storageCardRequestVO.setTransferPerson(fromMember.getName());
        storageCardRequestVO.setDonee(vo.getTargetName());
        storageCardRequestVO.setType(String.valueOf(StorageOpsTypeEnum.SEND.getCode()));
        storageCardRequestVO.setDocumentNo(billNo);
        storageCardRequestVO.setCorpCode(String.valueOf(vo.getSysCompanyId()));
        requestVO.setList(java.util.Collections.singletonList(storageCardRequestVO));
        Result result = this.connectorServiceFeign.batchSaveStorageCard(requestVO);
        log.info("StorageCardServiceImpl sendStorageCard result code : {}, message : {}, data : {}", new Object[]{result.getCode(), result.getMessage(), result.getData()});
        return new ResponseData();
    }

    public ResponseData receivedSendStorageCard(CusUrStorageCardReceivedVO vo) {
        StorageCardModel storageCardModel;
        log.info("StorageCardServiceImpl receivedSendStorageCard receivedSendStorageCard by memberCode : {}", (Object)vo.getMemberCode());
        CusUrMbrStorageCardDonateExample example = new CusUrMbrStorageCardDonateExample();
        example.createCriteria().andToTargetMemberCodeEqualTo(vo.getMemberCode()).andFromStatusEqualTo(Integer.valueOf(StorageCardDonateFromStatusEnum.SED.getState())).andToStatusEqualTo(Integer.valueOf(StorageCardDonateToStatusEnum.PENDING_RECEPTION.getState())).andOverStatusEqualTo(Integer.valueOf(StorageCardDonateOverStatusEnum.UNDONE.getState())).andValidEqualTo(Boolean.valueOf(true));
        List cusUrMbrStorageCardDonates = this.cusUrMbrStorageCardDonateMapper.selectByExample(example);
        if (ListUtils.isEmpty((List)cusUrMbrStorageCardDonates)) {
            return ResponseUtil.success((Object)"0");
        }
        CusUrMbrStorageCardPOExample example2 = new CusUrMbrStorageCardPOExample();
        example2.createCriteria().andMemberCodeEqualTo(vo.getMemberCode());
        List cusUrMbrStorageCardPOS = this.cusUrMbrStorageCardPOMapper.selectByExample(example2);
        BigDecimal oldBlance = new BigDecimal(0);
        if (CollectionUtils.isEmpty((Collection)cusUrMbrStorageCardPOS)) {
            storageCardModel = StorageCardModel.builder().sysCompanyId(vo.getSysCompanyId()).brandId(vo.getBrandId()).balance(new BigDecimal(0)).remark("3").vipCardNo(vo.getVipCardNo()).build();
            log.info("create storage card request params : {}", (Object)storageCardModel.toString());
            ResponseData addResult = this.addStorageCard(storageCardModel);
            log.info("create storage card result --> code : {}, message : {}", (Object)addResult.getCode(), (Object)addResult.getMessage());
            Assert.isTrue((SysResponseEnum.SUCCESS.getCode() == addResult.getCode() ? 1 : 0) != 0, (String)addResult.getMessage());
        } else {
            oldBlance = ((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getBalance();
        }
        storageCardModel = this.cusUrMbrStorageCardPOMapper.queryStorageCardByMemberCode(vo.getMemberCode());
        log.info("storageCardModel value : {}", (Object)storageCardModel.toString());
        MembersEsRequestVo membersEsRequestVo = new MembersEsRequestVo();
        membersEsRequestVo.setSysCompanyId(vo.getSysCompanyId());
        membersEsRequestVo.setBrandId(vo.getBrandId());
        membersEsRequestVo.setMemberCodeList(java.util.Collections.singletonList(vo.getMemberCode()));
        log.info("StorageCardServiceImpl receivedSendStorageCard get member phone params : {}", (Object)membersEsRequestVo.toString());
        ResponseData membersListPageable = this.urMemberApiService.getMembersListPageable(membersEsRequestVo);
        PageInfo data = (PageInfo)membersListPageable.getData();
        log.info("StorageCardServiceImpl receivedSendStorageCard get member phone result : {}", (Object)data.getList());
        Assert.isTrue((data.getTotal() == 1L ? 1 : 0) != 0, (String)"\u65e0\u6548\u64cd\u4f5c");
        return this.storageOpsService.batchReceivedStorageOps(vo, cusUrMbrStorageCardDonates, oldBlance, storageCardModel.getStorageCardNo(), (MembersEsResponseVo)data.getList().get(0));
    }

    public JSONArray scanTaskReceivedStorageCard(String arg) {
        CusUrMbrStorageCardDonateExample example = new CusUrMbrStorageCardDonateExample();
        example.createCriteria().andFromStatusEqualTo(Integer.valueOf(StorageCardDonateFromStatusEnum.SED.getState())).andToStatusEqualTo(Integer.valueOf(StorageCardDonateToStatusEnum.PENDING_RECEPTION.getState())).andOverStatusEqualTo(Integer.valueOf(StorageCardDonateOverStatusEnum.UNDONE.getState())).andValidEqualTo(Boolean.valueOf(true));
        List cusUrMbrStorageCardDonates = this.cusUrMbrStorageCardDonateMapper.selectByExample(example);
        Assert.isTrue((!ListUtils.isEmpty((List)cusUrMbrStorageCardDonates) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u8d85\u65f6\u9700\u8981\u9000\u8fd8\u7684\u8f6c\u589e");
        JSONArray result = new JSONArray(cusUrMbrStorageCardDonates.size());
        for (CusUrMbrStorageCardDonate donate : cusUrMbrStorageCardDonates) {
            log.info("auto scan received storage card donate id : {}", (Object)donate.getMbrStorageDonate());
            if (System.currentTimeMillis() - donate.getCreateDate().getTime() < 86400000L) continue;
            JSONObject jo = new JSONObject();
            jo.put("donate_id", (Object)donate.getMbrStorageDonate());
            try {
                this.storageOpsService.singleReceived(donate);
                jo.put("result", (Object)"success");
            }
            catch (RuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
                jo.put("result", (Object)"fail");
            }
            result.add((Object)jo);
        }
        return result;
    }

    public ResponseData<PageInfo<CusUrMbrStorageCardRecordPO>> queryStorageCardRecord(QueryStorageCardRecordVo queryStorageCardRecordVo, Optional<SysAccountPO> optional) {
        log.info("enter StorageCardServiceImpl queryStorageCardRecord param: {}", (Object)JacksonUtil.bean2Json((Object)queryStorageCardRecordVo));
        SysAccountPO currentUser = optional.get();
        CusUrMbrStorageCardRecordPOExample storageCardRecordPOExample = new CusUrMbrStorageCardRecordPOExample();
        CusUrMbrStorageCardRecordPOExample.Criteria criteria = storageCardRecordPOExample.createCriteria();
        if (queryStorageCardRecordVo.getStartDate() != null && queryStorageCardRecordVo.getEndDate() != null) {
            criteria.andCreateDateBetween(queryStorageCardRecordVo.getStartDate(), queryStorageCardRecordVo.getEndDate());
        }
        criteria.andMbrCardNoEqualTo(queryStorageCardRecordVo.getVipCardNo());
        criteria.andSysCompanyIdEqualTo(currentUser.getSysCompanyId());
        criteria.andBrandIdEqualTo(currentUser.getBrandId());
        storageCardRecordPOExample.setOrderByClause("create_date DESC");
        Page page = PageHelper.startPage((int)queryStorageCardRecordVo.getPageNum(), (int)queryStorageCardRecordVo.getPageSize()).doSelectPage(() -> this.cusUrMbrStorageCardRecordPOMapper.selectByExample(storageCardRecordPOExample));
        PageInfo pageInfo = new PageInfo((List)page);
        return ResponseDataUtil.getSuccessData((Object)pageInfo, (String)SysResponseEnum.SUCCESS.getMessage());
    }

    public List<CusUrMbrStorageCardRecordPO> assembleExportData(QueryStorageCardRecordVo vo, Long start, Long size) {
        List cusUrMbrStorageCardRecordPOS = this.cusUrMbrStorageCardRecordPOMapper.listExportDataCondition(vo, start, size);
        return cusUrMbrStorageCardRecordPOS;
    }

    public Boolean getMemberDataDesensitizeByAccountConfig(Long sysAccountId) {
        SysAccountVo sysAccountVo;
        ResponseData sysAccountVoResponseData;
        if (Objects.nonNull(sysAccountId) && Objects.nonNull(sysAccountVoResponseData = this.sysAccountServiceRpc.getByAccountId(sysAccountId)) && Objects.nonNull(sysAccountVoResponseData.getData()) && Objects.nonNull((sysAccountVo = (SysAccountVo)sysAccountVoResponseData.getData()).getMemberDataDesensitize()) && sysAccountVo.getMemberDataDesensitize().booleanValue()) {
            return true;
        }
        return false;
    }

    public ResponseData<PageInfo<CusUrMbrStorageCardRecordPO>> storageCardRecordExport(QueryStorageCardRecordVo storageCardRecordVo, Optional<SysAccountPO> optional) {
        log.info("\u5bfc\u51fa\u50a8\u503c\u5361\u660e\u7ec6\u5165\u53c2 param: {}", (Object)JacksonUtil.bean2Json((Object)storageCardRecordVo));
        ResponseData responseData = new ResponseData();
        SysAccountPO sysAccountPO = optional.get();
        if (StringUtils.isEmpty((CharSequence)storageCardRecordVo.getVipCardNo())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4f1a\u5458\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (sysAccountPO.getSysCompanyId() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        try {
            SysAccountPO currentUser = optional.get();
            storageCardRecordVo.setSysCompanyId(currentUser.getSysCompanyId());
            storageCardRecordVo.setBrandId(currentUser.getBrandId());
            long sum = this.cusUrMbrStorageCardRecordPOMapper.countExportDataCondition(storageCardRecordVo);
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = new FileTaskPo();
            fileTaskPo.setTaskId(taskId);
            fileTaskPo.setFileId(String.valueOf(taskId));
            fileTaskPo.setTaskTypeCode(sum + "\u6761");
            fileTaskPo.setTaskName("\u50a8\u503c\u5361\u660e\u7ec6\u8bb0\u5f55");
            fileTaskPo.setSysBrandId(sysAccountPO.getBrandId());
            fileTaskPo.setCreateUserId(sysAccountPO.getSysAccountId());
            fileTaskPo.setCreateUserName(sysAccountPO.getName());
            fileTaskPo.setFileStatus(Long.valueOf(0L));
            fileTaskPo.setFileType("EXPORT");
            fileTaskPo.setValid(Boolean.valueOf(true));
            this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(sum));
            ThreadPoolUtils.newTask(() -> {
                try {
                    exportExcelUtil.setExportProcessId((Object)taskId);
                    Method method = this.getClass().getMethod("assembleExportData", QueryStorageCardRecordVo.class, Long.class, Long.class);
                    exportExcelUtil.read("storageCardServiceImpl", method, (model, row) -> {
                        if (row.getRowNum() == 0) {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue("\u53d8\u66f4\u7c7b\u578b");
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue("\u53d8\u52a8\u91d1\u989d");
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue("\u4f59\u989d");
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue("\u65f6\u95f4");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue("\u5907\u6ce8");
                        } else {
                            Cell cell0 = row.createCell(0);
                            if (model.getOpType() != null) {
                                cell0.setCellValue(StorageOpsTypeEnum.getTypeName((int)model.getOpType()));
                            } else {
                                cell0.setCellValue("");
                            }
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue(model.getBalance() + "");
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue(model.getOverage() + "");
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue(model.getCreateDate() != null ? DateUtil.format((Date)model.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss") : "");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue(model.getRemark());
                        }
                    }, new Object[]{storageCardRecordVo});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            ThreadPoolUtils.newTask(() -> ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"\u50a8\u503c\u5361\u660e\u7ec6\u8bb0\u5f55"));
        }
        catch (Exception e) {
            log.error("method storageCardRecordExport error:" + e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f!");
        return responseData;
    }

    public PageInfo<QueryRecordResponseVo> queryStorageCardRecordList(QueryStorageCardRecordVo queryRecordVo, Optional<SysAccountPO> optional, Pageable pageable) {
        log.info("enter StorageCardServiceImpl queryStorageCardRecordList param: {}", (Object)JacksonUtil.bean2Json((Object)queryRecordVo));
        SysAccountPO currentUser = optional.get();
        queryRecordVo.setBrandId(currentUser.getBrandId());
        queryRecordVo.setSysCompanyId(currentUser.getSysCompanyId());
        Page page = PageHelper.startPage((int)pageable.getPageNumber(), (int)pageable.getPageSize()).doSelectPage(() -> this.cusUrMbrStorageCardRecordPOMapper.selectByCondition(queryRecordVo));
        PageInfo pageInfo = new PageInfo((List)page);
        return pageInfo;
    }

    public ResponseData<String> exportStorageCardExcel(QueryStorageRequestVo vo, Optional<SysAccountPO> optional) {
        log.info("enter StorageCardServiceImpl exportStorageCardExcel");
        PageRequest pageable = PageRequest.of((int)0, (int)1);
        PageInfo pageInfo = this.queryStorageCardList(vo, optional, (Pageable)pageable);
        long sum = pageInfo.getTotal();
        Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        fileTaskPo.setFileId(String.valueOf(taskId));
        fileTaskPo.setTaskTypeCode(sum + "\u6761");
        fileTaskPo.setTaskName("\u5bfc\u51fa\u50a8\u503c\u5361\u4fe1\u606f");
        SysAccountPO currentUser = optional.get();
        fileTaskPo.setSysCompanyId(currentUser.getSysCompanyId());
        fileTaskPo.setSysBrandId(currentUser.getBrandId());
        fileTaskPo.setCreateUserId(currentUser.getSysAccountId());
        fileTaskPo.setCreateUserName(currentUser.getName());
        fileTaskPo.setFileStatus(Long.valueOf(0L));
        fileTaskPo.setFileType("EXPORT");
        fileTaskPo.setValid(Boolean.valueOf(true));
        ResponseData response = this.fileTaskServiceRpc.addFileTask(fileTaskPo);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"});
        StreamingExportExcelPageInfoUtilForStorage excelUtil = new StreamingExportExcelPageInfoUtilForStorage(Long.valueOf(sum));
        excelUtil.setExportProcessId((Object)taskId);
        Method method = ReflectionUtils.findMethod(this.getClass(), (String)"queryStorageCardList", (Class[])new Class[]{QueryStorageRequestVo.class, Optional.class, Pageable.class});
        new Thread(() -> {
            try {
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                excelUtil.read("storageCardServiceImpl", method, (model, row) -> {
                    if (row.getRowNum() == 0) {
                        row.createCell(0).setCellValue("\u4f1a\u5458\u59d3\u540d");
                        row.createCell(1).setCellValue("\u624b\u673a\u53f7");
                        row.createCell(2).setCellValue("\u4f1a\u5458\u5361\u53f7");
                        row.createCell(3).setCellValue("\u50a8\u503c\u5361\u53f7");
                        row.createCell(4).setCellValue("\u50a8\u503c\u5361\u4f59\u989d");
                        row.createCell(5).setCellValue("\u521b\u5efa\u65e5\u671f");
                        row.createCell(6).setCellValue("\u521b\u5efa\u4eba");
                    } else {
                        row.createCell(0).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getVipName(), (Object)""));
                        row.createCell(1).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getPhone(), (Object)""));
                        row.createCell(2).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getVipCardNo(), (Object)""));
                        row.createCell(3).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getStorageCardNo(), (Object)""));
                        row.createCell(4).setCellValue(model.getBalance() != null ? model.getBalance().toString() : "");
                        row.createCell(5).setCellValue(model.getCreateDate() != null ? sd.format(model.getCreateDate()) : "");
                        row.createCell(6).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getCreateUserName(), (Object)""));
                    }
                }, sort, new Object[]{vo, optional});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        new Thread(() -> {
            OutputStream out = null;
            ByteArrayInputStream in = null;
            try {
                BigDecimal process = null;
                while (true) {
                    if ((process = StreamingExportExcelPageInfoUtilForStorage.getExportPercentageProcess((Object)taskId)).compareTo(new BigDecimal(0)) < 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(-1L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    if (process.compareTo(new BigDecimal(1)) == 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(99L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMddHHmmss");
                        Date currentDate = new Date();
                        String fileNameXls = FileNameUtil.getFileName((String)"\u50a8\u503c\u5361\u5bfc\u51fa-", (String)sd.format(currentDate), (String)".xlsx");
                        String fileNameZip = FileNameUtil.getFileName((String)"\u50a8\u503c\u5361\u5bfc\u51fa_", (String)sd.format(currentDate), (String)".zip");
                        out = new ByteArrayOutputStream();
                        excelUtil.exprotToZipOutputStream(out, fileNameXls, fileNameZip);
                        in = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                        String qiniuUrl = QiNiuUtil.upload((InputStream)in, (String)fileNameZip);
                        fileTaskPo.setFileStatus(Long.valueOf(100L));
                        fileTaskPo.setFileUnl(qiniuUrl);
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    fileTaskPo.setFileStatus(Long.valueOf(process.multiply(new BigDecimal(100)).longValue()));
                    this.fileTaskServiceRpc.update(fileTaskPo);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                fileTaskPo.setFileStatus(Long.valueOf(-1L));
                this.fileTaskServiceRpc.update(fileTaskPo);
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
        return response;
    }

    public ResponseData<PageInfo<CusUrMbrStorageCardTASKPO>> queryTaskList(QueryTaskVo vo, Optional<SysAccountPO> optional) {
        log.info("enter StorageCardServiceImpl queryTaskList param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO currentUser = optional.get();
        CusUrMbrStorageCardTASKPOExample taskpoExample = new CusUrMbrStorageCardTASKPOExample();
        CusUrMbrStorageCardTASKPOExample.Criteria criteria = taskpoExample.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)vo.getTaskName())) {
            criteria.andTaskNameLike(vo.getTaskName());
        }
        if (vo.getStatus() != null) {
            criteria.andStatusEqualTo(vo.getStatus());
        }
        if (vo.getStartDate() != null && vo.getEndDate() != null) {
            criteria.andCreateDateBetween(vo.getStartDate(), vo.getEndDate());
        }
        criteria.andSysCompanyIdEqualTo(currentUser.getSysCompanyId());
        criteria.andBrandIdEqualTo(currentUser.getBrandId());
        taskpoExample.setOrderByClause("create_date desc");
        Page page = PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize()).doSelectPage(() -> this.cusUrMbrStorageCardTASKPOMapper.selectByExample(taskpoExample));
        PageInfo pageInfo = new PageInfo((List)page);
        return ResponseDataUtil.getSuccessData((Object)pageInfo, (String)SysResponseEnum.SUCCESS.getMessage());
    }

    public ResponseData<PageInfo<CusUrMbrStorageCardTASKDETAILPO>> queryTaskDetail(QueryTaskDetailVo vo, Optional<SysAccountPO> optional) {
        log.info("enter StorageCardServiceImpl queryTaskDetail param : {}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO currentUser = optional.get();
        vo.setBrandId(currentUser.getBrandId());
        vo.setSysCompanyId(currentUser.getSysCompanyId());
        Page page = PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize()).doSelectPage(() -> this.cusUrMbrStorageCardTASKDETAILPOMapper.selectByConditionDetail(vo));
        PageInfo pageInfo = new PageInfo((List)page);
        return ResponseDataUtil.getSuccessData((Object)pageInfo, (String)SysResponseEnum.SUCCESS.getMessage());
    }

    public ResponseData<String> exportStorageCardRecordExcel(QueryStorageCardRecordVo vo, Optional<SysAccountPO> optional) {
        log.info("enter StorageCardServiceImpl exportStorageCardRecordExcel param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        PageRequest pageable = PageRequest.of((int)0, (int)1);
        PageInfo responseData = this.queryStorageCardRecordList(vo, optional, (Pageable)pageable);
        long sum = responseData.getTotal();
        Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        fileTaskPo.setFileId(String.valueOf(taskId));
        fileTaskPo.setTaskTypeCode(sum + "\u6761");
        fileTaskPo.setTaskName("\u5bfc\u51fa\u50a8\u503c\u5361\u65e5\u5fd7\u4fe1\u606f");
        SysAccountPO currentUser = optional.get();
        fileTaskPo.setSysCompanyId(currentUser.getSysCompanyId());
        fileTaskPo.setSysBrandId(currentUser.getBrandId());
        fileTaskPo.setCreateUserId(currentUser.getSysAccountId());
        fileTaskPo.setCreateUserName(currentUser.getName());
        fileTaskPo.setFileStatus(Long.valueOf(0L));
        fileTaskPo.setFileType("EXPORT");
        fileTaskPo.setValid(Boolean.valueOf(true));
        ResponseData response = this.fileTaskServiceRpc.addFileTask(fileTaskPo);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"});
        StreamingExportExcelPageInfoUtilForStorage excelUtil = new StreamingExportExcelPageInfoUtilForStorage(Long.valueOf(sum));
        Method method = ReflectionUtils.findMethod(this.getClass(), (String)"queryStorageCardRecordList", (Class[])new Class[]{QueryStorageCardRecordVo.class, Optional.class, Pageable.class});
        excelUtil.setExportProcessId((Object)taskId);
        new Thread(() -> {
            try {
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                excelUtil.read("storageCardServiceImpl", method, (model, row) -> {
                    if (row.getRowNum() == 0) {
                        row.createCell(0).setCellValue("\u59d3\u540d");
                        row.createCell(1).setCellValue("\u624b\u673a\u53f7");
                        row.createCell(2).setCellValue("\u4f1a\u5458\u5361\u53f7");
                        row.createCell(3).setCellValue("\u50a8\u503c\u5361\u53f7");
                        row.createCell(4).setCellValue("\u64cd\u4f5c\u7c7b\u578b");
                        row.createCell(5).setCellValue("\u53d8\u66f4\u91d1\u989d");
                        row.createCell(6).setCellValue("\u5355\u636e\u7f16\u53f7");
                        row.createCell(7).setCellValue("\u5907\u6ce8");
                        row.createCell(8).setCellValue("\u64cd\u4f5c\u65f6\u95f4");
                    } else {
                        row.createCell(0).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getVipName(), (Object)""));
                        row.createCell(1).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getPhone(), (Object)""));
                        row.createCell(2).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getVipCardNo(), (Object)""));
                        row.createCell(3).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getStorageCardNo(), (Object)""));
                        String opType = "";
                        if (model.getOpType() != null) {
                            switch (model.getOpType()) {
                                case 1: {
                                    opType = "\u65b0\u589e";
                                    break;
                                }
                                case 2: {
                                    opType = "\u7f16\u8f91";
                                    break;
                                }
                                case 3: {
                                    opType = "\u8f6c\u8d60";
                                    break;
                                }
                                case 4: {
                                    opType = "\u53d7\u8d60";
                                    break;
                                }
                                case 5: {
                                    opType = "\u6d88\u8d39";
                                    break;
                                }
                                case 6: {
                                    opType = "\u9000\u56de";
                                }
                            }
                        }
                        row.createCell(4).setCellValue(opType);
                        row.createCell(5).setCellValue(model.getBalance() != null ? model.getBalance().toString() : "");
                        row.createCell(6).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getBillNo(), (Object)""));
                        row.createCell(7).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getRemark(), (Object)""));
                        row.createCell(8).setCellValue(model.getCreateDate() != null ? sd.format(model.getCreateDate()) : "");
                    }
                }, sort, new Object[]{vo, optional});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        new Thread(() -> {
            OutputStream out = null;
            ByteArrayInputStream in = null;
            try {
                BigDecimal process = null;
                while (true) {
                    if ((process = StreamingExportExcelPageInfoUtilForStorage.getExportPercentageProcess((Object)taskId)).compareTo(new BigDecimal(0)) < 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(-1L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    if (process.compareTo(new BigDecimal(1)) == 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(99L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMddHHmmss");
                        Date currentDate = new Date();
                        String fileNameXls = FileNameUtil.getFileName((String)"\u50a8\u503c\u5361\u6d41\u6c34\u65e5\u5fd7_", (String)sd.format(currentDate), (String)".xlsx");
                        String fileNameZip = FileNameUtil.getFileName((String)"\u50a8\u503c\u5361\u6d41\u6c34\u65e5\u5fd7_", (String)sd.format(currentDate), (String)".zip");
                        out = new ByteArrayOutputStream();
                        excelUtil.exprotToZipOutputStream(out, fileNameXls, fileNameZip);
                        in = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                        String qiniuUrl = QiNiuUtil.upload((InputStream)in, (String)fileNameZip);
                        fileTaskPo.setFileStatus(Long.valueOf(100L));
                        fileTaskPo.setFileUnl(qiniuUrl);
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    fileTaskPo.setFileStatus(Long.valueOf(process.multiply(new BigDecimal(100)).longValue()));
                    this.fileTaskServiceRpc.update(fileTaskPo);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                fileTaskPo.setFileStatus(Long.valueOf(-1L));
                this.fileTaskServiceRpc.update(fileTaskPo);
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
        return response;
    }

    public ResponseData<StorageCardQueryVipCardResponseVO> getStorageCardByVipCard(StorageCardQueryVipCardRequestVO storageCardQueryVipCardRequestVO) {
        log.info("enter getStorageCardByVipCard param:{}", (Object)JacksonUtil.bean2Json((Object)storageCardQueryVipCardRequestVO));
        SingleMembersInfoWithLevelRequestVo singleMembersInfoWithLevelRequestVo = new SingleMembersInfoWithLevelRequestVo();
        singleMembersInfoWithLevelRequestVo.setBrandId(storageCardQueryVipCardRequestVO.getBrandId());
        singleMembersInfoWithLevelRequestVo.setSysCompanyId(storageCardQueryVipCardRequestVO.getSysCompanyId());
        singleMembersInfoWithLevelRequestVo.setCardNo(storageCardQueryVipCardRequestVO.getVipCardNo());
        ResponseData singleMembersInfoWithLevelResponseVoResponseData = this.urMemberApiService.getSingleMembersInfoWithLevel(singleMembersInfoWithLevelRequestVo);
        if (singleMembersInfoWithLevelResponseVoResponseData == null || singleMembersInfoWithLevelResponseVoResponseData.getCode() == SysResponseEnum.FAILED.getCode()) {
            log.error("getMembersInfoByCardNo\u63a5\u53e3\u67e5\u8be2\u5931\u8d25");
            return ResponseDataUtil.getFailedData(null, (String)"\u4f1a\u5458\u63a5\u53e3\u67e5\u8be2\u5931\u8d25");
        }
        if (singleMembersInfoWithLevelResponseVoResponseData.getData() == null) {
            log.error("getStorageCardByVipCard\u67e5\u4e0d\u5230\u4f1a\u5458");
            return ResponseDataUtil.getFailedData(null, (String)"\u67e5\u4e0d\u5230\u4f1a\u5458");
        }
        SingleMembersInfoWithLevelResponseVo singleMembersInfo = (SingleMembersInfoWithLevelResponseVo)singleMembersInfoWithLevelResponseVoResponseData.getData();
        CusUrMbrStorageCardPOExample example = new CusUrMbrStorageCardPOExample();
        CusUrMbrStorageCardPOExample.Criteria criteria = example.createCriteria();
        criteria.andSysCompanyIdEqualTo(storageCardQueryVipCardRequestVO.getSysCompanyId());
        criteria.andBrandIdEqualTo(storageCardQueryVipCardRequestVO.getBrandId());
        criteria.andMemberCodeEqualTo(singleMembersInfo.getMemberCode());
        List cusUrMbrStorageCardPOList = this.cusUrMbrStorageCardPOMapper.selectByExample(example);
        if (cusUrMbrStorageCardPOList == null || cusUrMbrStorageCardPOList.size() == 0) {
            log.error("\u65e0\u50a8\u503c\u5361\u8bb0\u5f55");
            return ResponseDataUtil.getFailedData(null, (String)"\u65e0\u50a8\u503c\u5361\u8bb0\u5f55");
        }
        StorageCardQueryVipCardResponseVO responseVO = new StorageCardQueryVipCardResponseVO();
        CusUrMbrStorageCardPO cusUrMbrStorageCardPO = (CusUrMbrStorageCardPO)cusUrMbrStorageCardPOList.get(0);
        responseVO.setCardTypeID(singleMembersInfo.getLevelCode());
        responseVO.setCardTypeName(singleMembersInfo.getLevelName());
        responseVO.setJdCardCode(cusUrMbrStorageCardPO.getStorageCardNo());
        responseVO.setPassword(cusUrMbrStorageCardPO.getPassword());
        responseVO.setRemainAmount(cusUrMbrStorageCardPO.getBalance());
        return ResponseDataUtil.getSuccessData((Object)responseVO);
    }

    public ResponseData<StorageCardQueryStorageCardResponseVO> getStorageCardByStorageCard(StorageCardQueryStorageCardRequestVO storageCardQueryStorageCardRequestVO) {
        CusUrMbrStorageCardPOExample example = new CusUrMbrStorageCardPOExample();
        CusUrMbrStorageCardPOExample.Criteria criteria = example.createCriteria();
        criteria.andSysCompanyIdEqualTo(storageCardQueryStorageCardRequestVO.getSysCompanyId());
        criteria.andBrandIdEqualTo(storageCardQueryStorageCardRequestVO.getBrandId());
        criteria.andStorageCardNoEqualTo(storageCardQueryStorageCardRequestVO.getStorageCard());
        List cusUrMbrStorageCardPOList = this.cusUrMbrStorageCardPOMapper.selectByExample(example);
        if (cusUrMbrStorageCardPOList == null || cusUrMbrStorageCardPOList.size() == 0) {
            log.error("\u65e0\u50a8\u503c\u5361\u8bb0\u5f55");
            return ResponseDataUtil.getFailedData(null, (String)"\u65e0\u50a8\u503c\u5361\u8bb0\u5f55");
        }
        CusUrMbrStorageCardPO storageCardPO = (CusUrMbrStorageCardPO)cusUrMbrStorageCardPOList.get(0);
        SingleMembersInfoWithLevelRequestVo singleMembersInfoWithLevelRequestVo = new SingleMembersInfoWithLevelRequestVo();
        singleMembersInfoWithLevelRequestVo.setBrandId(storageCardQueryStorageCardRequestVO.getBrandId());
        singleMembersInfoWithLevelRequestVo.setSysCompanyId(storageCardQueryStorageCardRequestVO.getSysCompanyId());
        singleMembersInfoWithLevelRequestVo.setMemberCode(storageCardPO.getMemberCode());
        ResponseData singleMembersInfoWithLevelResponseVoResponseData = this.urMemberApiService.getSingleMembersInfoWithLevel(singleMembersInfoWithLevelRequestVo);
        if (singleMembersInfoWithLevelResponseVoResponseData == null || singleMembersInfoWithLevelResponseVoResponseData.getCode() == SysResponseEnum.FAILED.getCode()) {
            log.error("getSingleMembersInfoWithLevel\u63a5\u53e3\u67e5\u8be2\u5931\u8d25");
            return ResponseDataUtil.getFailedData(null, (String)"\u4f1a\u5458\u63a5\u53e3\u67e5\u8be2\u5931\u8d25");
        }
        if (singleMembersInfoWithLevelResponseVoResponseData.getData() == null) {
            log.error("getStorageCardByVipCard\u67e5\u4e0d\u5230\u4f1a\u5458");
            return ResponseDataUtil.getFailedData(null, (String)"\u67e5\u4e0d\u5230\u4f1a\u5458");
        }
        SingleMembersInfoWithLevelResponseVo singleMembersInfo = (SingleMembersInfoWithLevelResponseVo)singleMembersInfoWithLevelResponseVoResponseData.getData();
        StorageCardQueryVipCardResponseVO responseVO = new StorageCardQueryVipCardResponseVO();
        CusUrMbrStorageCardPO cusUrMbrStorageCardPO = (CusUrMbrStorageCardPO)cusUrMbrStorageCardPOList.get(0);
        responseVO.setCardTypeID(singleMembersInfo.getLevelCode());
        responseVO.setCardTypeName(singleMembersInfo.getLevelName());
        responseVO.setJdCardCode(cusUrMbrStorageCardPO.getStorageCardNo());
        responseVO.setPassword(cusUrMbrStorageCardPO.getPassword());
        responseVO.setRemainAmount(cusUrMbrStorageCardPO.getBalance());
        return ResponseDataUtil.getSuccessData((Object)responseVO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResponseData<String> storageConsume(StorageCardConsumeRequestVO storageCardConsumeRequestVO) {
        try {
            if (StringUtils.isNotBlank((CharSequence)storageCardConsumeRequestVO.getVerifyId())) {
                String redisKey = storageCardConsumeRequestVO.getSysCompanyId() + "_" + storageCardConsumeRequestVO.getBrandId() + "_" + storageCardConsumeRequestVO.getVerifyId();
                boolean check = this.redisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)"1");
                if (!check) {
                    return ResponseDataUtil.getFailedData(null, (String)"\u50a8\u503c\u5361\u91cd\u590d\u6d88\u8d39");
                }
                this.redisTemplate.expire((Object)check, 3L, TimeUnit.SECONDS);
            }
            SingleMembersInfoWithLevelRequestVo singleMembersInfoWithLevelRequestVo = new SingleMembersInfoWithLevelRequestVo();
            singleMembersInfoWithLevelRequestVo.setBrandId(storageCardConsumeRequestVO.getBrandId());
            singleMembersInfoWithLevelRequestVo.setSysCompanyId(storageCardConsumeRequestVO.getSysCompanyId());
            if (StringUtils.isBlank((CharSequence)storageCardConsumeRequestVO.getVipCardNo())) {
                CusUrMbrStorageCardPOExample mbrStorageCardPOExample = new CusUrMbrStorageCardPOExample();
                CusUrMbrStorageCardPOExample.Criteria criteria = mbrStorageCardPOExample.createCriteria();
                criteria.andStorageCardNoEqualTo(storageCardConsumeRequestVO.getStoredCardNo()).andBrandIdEqualTo(storageCardConsumeRequestVO.getBrandId()).andSysCompanyIdEqualTo(storageCardConsumeRequestVO.getSysCompanyId()).andValidEqualTo(Boolean.valueOf(true));
                List storageCardPOS = this.cusUrMbrStorageCardPOMapper.selectByExample(mbrStorageCardPOExample);
                if (storageCardPOS.size() <= 0) return ResponseDataUtil.getFailedData(null, (String)"\u50a8\u503c\u5361\u53f7\u4e0d\u5b58\u5728");
                singleMembersInfoWithLevelRequestVo.setCardNo(((CusUrMbrStorageCardPO)storageCardPOS.get(0)).getVipCardNo());
            } else {
                singleMembersInfoWithLevelRequestVo.setCardNo(storageCardConsumeRequestVO.getVipCardNo());
            }
            ResponseData singleMembersInfoWithLevelResponseVoResponseData = this.urMemberApiService.getSingleMembersInfoWithLevel(singleMembersInfoWithLevelRequestVo);
            if (singleMembersInfoWithLevelResponseVoResponseData == null || singleMembersInfoWithLevelResponseVoResponseData.getCode() == SysResponseEnum.FAILED.getCode()) {
                log.error("getSingleMembersInfoWithLevel\u63a5\u53e3\u67e5\u8be2\u5931\u8d25");
                return ResponseDataUtil.getFailedData(null, (String)"\u4f1a\u5458\u63a5\u53e3\u67e5\u8be2\u5931\u8d25");
            }
            if (singleMembersInfoWithLevelResponseVoResponseData.getData() == null) {
                log.error("getStorageCardByVipCard\u67e5\u4e0d\u5230\u4f1a\u5458");
                return ResponseDataUtil.getFailedData(null, (String)"\u67e5\u4e0d\u5230\u4f1a\u5458");
            }
            SingleMembersInfoWithLevelResponseVo responseVo = (SingleMembersInfoWithLevelResponseVo)singleMembersInfoWithLevelResponseVoResponseData.getData();
            ConsumeStorageDto consumeStorageDto = new ConsumeStorageDto();
            consumeStorageDto.setOpType(storageCardConsumeRequestVO.getOpType());
            consumeStorageDto.setOrderNo(storageCardConsumeRequestVO.getOrderNo());
            consumeStorageDto.setVerifyId(storageCardConsumeRequestVO.getVerifyId());
            consumeStorageDto.setSysCompanyId(storageCardConsumeRequestVO.getSysCompanyId());
            consumeStorageDto.setBrandId(storageCardConsumeRequestVO.getBrandId());
            consumeStorageDto.setBalance(storageCardConsumeRequestVO.getBalance().multiply(new BigDecimal(-1)));
            consumeStorageDto.setMemberCode(responseVo.getMemberCode());
            consumeStorageDto.setPhone(responseVo.getPhone());
            consumeStorageDto.setOpsCode(storageCardConsumeRequestVO.getUserCode());
            consumeStorageDto.setVipCardNo(responseVo.getCardNo());
            consumeStorageDto.setVipName(responseVo.getName());
            consumeStorageDto.setStorageCardNo(storageCardConsumeRequestVO.getStoredCardNo());
            try {
                CusUrMbrStorageCardRecordPOExample repeatExample = new CusUrMbrStorageCardRecordPOExample();
                CusUrMbrStorageCardRecordPOExample.Criteria repeatCriteria = repeatExample.createCriteria();
                repeatCriteria.andSysCompanyIdEqualTo(storageCardConsumeRequestVO.getSysCompanyId()).andBrandIdEqualTo(storageCardConsumeRequestVO.getBrandId()).andVerifyIdEqualTo(storageCardConsumeRequestVO.getVerifyId());
                List cusUrMbrStorageCardRecordPOList = this.cusUrMbrStorageCardRecordPOMapper.selectByExample(repeatExample);
                log.info("cusUrMbrStorageCardRecordPOList param:{}", (Object)JacksonUtil.bean2Json((Object)cusUrMbrStorageCardRecordPOList));
                if (!Collections.isEmpty((Collection)cusUrMbrStorageCardRecordPOList)) {
                    return ResponseDataUtil.getFailedData(null, (String)"\u50a8\u503c\u5361\u91cd\u590d\u6d88\u8d39");
                }
                this.storageOpsService.consumeStorageOps(consumeStorageDto);
                return ResponseDataUtil.getSuccessData((Object)"\u64cd\u4f5c\u6210\u529f");
            }
            catch (CustomizedException e) {
                return ResponseDataUtil.getFailedData((Object)e.getMessage());
            }
        }
        catch (Exception e) {
            return ResponseDataUtil.getFailedData((Object)e.getMessage());
        }
    }

    public ResponseData<FileImportTempPo> downloadTemplate(String fileTemplateType) {
        log.info("enter StorageCardServiceImpl downloadTemplate method !");
        ResponseData responseData = new ResponseData();
        try {
            responseData = this.fileTaskServiceRpc.getUrlByFileTemplateType(fileTemplateType);
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8c03\u7528\u6a21\u677f\u63a5\u53e3\u51fa\u9519!");
            e.printStackTrace();
        }
        return responseData;
    }

    private BigDecimal getBig(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal)value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String)value);
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger)value);
            } else if (value instanceof Number) {
                ret = new BigDecimal(((Number)value).doubleValue());
            } else {
                throw new ClassCastException("Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }
}

