/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.facade.models.vo.SendTemplateVo;
import com.bizvane.messagebase.model.vo.StandardMessageVo;
import com.bizvane.messagebase.model.vo.StandardTemplateResponseVO;
import com.bizvane.messagebase.model.vo.StandardTemplateVo;
import com.bizvane.messagefacade.enums.MsgTemplateType;
import com.bizvane.messagefacade.interfaces.StandardMessageSmsFeign;
import com.bizvane.messagefacade.interfaces.TemplateMessageServiceFeign;
import com.bizvane.messagefacade.models.vo.GenMessageVO;
import com.bizvane.messagefacade.models.vo.MsgWxTempMessageVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thymeleaf.util.StringUtils;

@Component
public class SendWxNotificationUtil {
    private static final Logger log = LoggerFactory.getLogger(SendWxNotificationUtil.class);
    @Autowired
    private TemplateMessageServiceFeign templateMessageServiceFeign;
    @Autowired
    private StandardMessageSmsFeign standardMessageSmsFeign;

    public void sendMemberBalanceTempalteMsg(SendTemplateVo templateVo) {
        log.info("enter sendMemberBalanceTempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
        if (templateVo == null) {
            log.error("sendMemberBalanceTempalteMsg\u627e\u4e0d\u5230\u4f1a\u5458 param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        GenMessageVO vo = new GenMessageVO();
        vo.setMemberCode(templateVo.getMemberCode());
        vo.setSysBrandId(templateVo.getSysBrandId());
        vo.setSysCompanyId(templateVo.getSysCompanyId());
        vo.setTemplateType(MsgTemplateType.CHU_ZHI_GEN_WXTEMPLATE_MESSAGE.getCode());
        StandardTemplateVo standardTemplateVo = new StandardTemplateVo();
        standardTemplateVo.setSysBrandId(templateVo.getSysBrandId());
        standardTemplateVo.setTemplateType(MsgTemplateType.CHU_ZHI_GEN_WXTEMPLATE_MESSAGE.getCode());
        ResponseData msgResponseData = this.standardMessageSmsFeign.getTemplateByTemType(standardTemplateVo);
        if (msgResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("sendMemberBalanceTempalteMsg\u627e\u4e0d\u5230\u5bf9\u5e94\u6a21\u677f param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        JSONObject messagejo = new JSONObject();
        messagejo.put("first", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTitle());
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        messagejo.put("keyword1", (Object)"\u8d26\u6237\u4f59\u989d\u53d8\u52a8");
        messagejo.put("keyword2", (Object)templateVo.getRechargeMoney());
        messagejo.put("keyword3", templateVo.getBalance() != null ? templateVo.getBalance() : "");
        messagejo.put("keyword4", (Object)"");
        messagejo.put("keyword5", (Object)sd.format(templateVo.getPaymentDate()));
        messagejo.put("keyword6", (Object)templateVo.getVipNo());
        messagejo.put("keyword7", (Object)templateVo.getSerialNumber());
        messagejo.put("keyword8", (Object)templateVo.getName());
        messagejo.put("keyword9", (Object)templateVo.getCardNo());
        messagejo.put("remark", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTail());
        messagejo.put("phoneStr", (Object)templateVo.getPhone());
        vo.setMessagejo(messagejo);
        log.info("sendMemberBalanceTempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        this.templateMessageServiceFeign.sendOnlyWxGenTemplateMessage(vo);
    }

    public void sendMemberConsumeTempalteMsg(SendTemplateVo templateVo) {
        log.info("enter sendMemberConsumeTempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
        if (templateVo == null) {
            log.error("sendMemberConsumeTempalteMsg\u627e\u4e0d\u5230\u4f1a\u5458 param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        GenMessageVO vo = new GenMessageVO();
        vo.setMemberCode(templateVo.getMemberCode());
        vo.setSysBrandId(templateVo.getSysBrandId());
        vo.setSysCompanyId(templateVo.getSysCompanyId());
        vo.setTemplateType(MsgTemplateType.CONSUME_GEN_WXTEMPLATE_MESSAGE.getCode());
        StandardTemplateVo standardTemplateVo = new StandardTemplateVo();
        standardTemplateVo.setSysBrandId(templateVo.getSysBrandId());
        standardTemplateVo.setTemplateType(MsgTemplateType.CONSUME_GEN_WXTEMPLATE_MESSAGE.getCode());
        ResponseData msgResponseData = this.standardMessageSmsFeign.getTemplateByTemType(standardTemplateVo);
        if (msgResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("sendMemberConsumeTempalteMsg\u627e\u4e0d\u5230\u5bf9\u5e94\u6a21\u677f param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        JSONObject messagejo = new JSONObject();
        messagejo.put("first", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTitle());
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        messagejo.put("keyword1", (Object)"\u8d26\u6237\u4f59\u989d\u53d8\u52a8");
        messagejo.put("keyword2", (Object)templateVo.getRechargeMoney());
        messagejo.put("keyword3", templateVo.getBalance() != null ? templateVo.getBalance() : "");
        messagejo.put("keyword4", (Object)templateVo.getStoreName());
        messagejo.put("keyword5", (Object)sd.format(templateVo.getPaymentDate()));
        messagejo.put("keyword6", (Object)templateVo.getVipNo());
        messagejo.put("keyword7", (Object)templateVo.getSerialNumber());
        messagejo.put("keyword8", (Object)templateVo.getName());
        messagejo.put("keyword9", (Object)templateVo.getCardNo());
        messagejo.put("remark", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTail());
        messagejo.put("phoneStr", (Object)templateVo.getPhone());
        vo.setMessagejo(messagejo);
        log.info("sendMemberBalanceTempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        this.templateMessageServiceFeign.sendOnlyWxGenTemplateMessage(vo);
    }

    public void sendRechargeGiveBalanceTempalteMsg(SendTemplateVo templateVo) {
        log.info("enter sendRechargeGiveBalanceTempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
        if (templateVo == null) {
            log.error("sendRechargeGiveBalanceTempalteMsg\u627e\u4e0d\u5230\u4f1a\u5458 param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        GenMessageVO vo = new GenMessageVO();
        vo.setMemberCode(templateVo.getMemberCode());
        vo.setSysBrandId(templateVo.getSysBrandId());
        vo.setSysCompanyId(templateVo.getSysCompanyId());
        vo.setTemplateType(MsgTemplateType.RECHARGE_GIVE_BALANCE_MESSAGE.getCode());
        StandardTemplateVo standardTemplateVo = new StandardTemplateVo();
        standardTemplateVo.setSysBrandId(templateVo.getSysBrandId());
        standardTemplateVo.setTemplateType(MsgTemplateType.RECHARGE_GIVE_BALANCE_MESSAGE.getCode());
        ResponseData msgResponseData = this.standardMessageSmsFeign.getTemplateByTemType(standardTemplateVo);
        if (msgResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("sendRechargeGiveBalanceTempalteMsg\u627e\u4e0d\u5230\u5bf9\u5e94\u6a21\u677f param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        JSONObject messagejo = new JSONObject();
        messagejo.put("first", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTitle());
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        messagejo.put("keyword1", (Object)"\u8f6c\u8d60\u4f59\u989d\u53d8\u52a8");
        messagejo.put("keyword2", (Object)templateVo.getGiveMoney());
        messagejo.put("keyword3", templateVo.getBalance() != null ? templateVo.getBalance() : "");
        messagejo.put("keyword4", (Object)templateVo.getGiverNick());
        messagejo.put("keyword5", (Object)sd.format(templateVo.getGiveDate()));
        messagejo.put("remark", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTail());
        messagejo.put("phoneStr", (Object)templateVo.getPhone());
        vo.setMessagejo(messagejo);
        log.info("sendRechargeGiveBalanceTempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        this.templateMessageServiceFeign.sendOnlyWxGenTemplateMessage(vo);
    }

    public void sendRechargeGiveOverduetempalteMsg(SendTemplateVo templateVo) {
        log.info("enter sendRechargeGiveOverduetempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
        if (templateVo == null) {
            log.error("sendRechargeGiveOverduetempalteMsg\u627e\u4e0d\u5230\u4f1a\u5458 param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        if (StringUtils.isEmpty((String)templateVo.getGiverNick())) {
            templateVo.setGiverNick(templateVo.getName());
        }
        GenMessageVO vo = new GenMessageVO();
        vo.setMemberCode(templateVo.getMemberCode());
        vo.setSysBrandId(templateVo.getSysBrandId());
        vo.setSysCompanyId(templateVo.getSysCompanyId());
        vo.setTemplateType(MsgTemplateType.RECHARGE_GIVE_OVERDUE_MESSAGE.getCode());
        StandardTemplateVo standardTemplateVo = new StandardTemplateVo();
        standardTemplateVo.setSysBrandId(templateVo.getSysBrandId());
        standardTemplateVo.setTemplateType(MsgTemplateType.RECHARGE_GIVE_OVERDUE_MESSAGE.getCode());
        ResponseData msgResponseData = this.standardMessageSmsFeign.getTemplateByTemType(standardTemplateVo);
        if (msgResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("sendRechargeGiveOverduetempalteMsg\u627e\u4e0d\u5230\u5bf9\u5e94\u6a21\u677f param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        JSONObject messagejo = new JSONObject();
        messagejo.put("first", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTitle());
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        messagejo.put("keyword1", (Object)"\u8f6c\u8d60\u4f59\u989d\u53d8\u52a8");
        messagejo.put("keyword2", (Object)templateVo.getGiveMoney());
        messagejo.put("keyword3", templateVo.getBalance() != null ? templateVo.getBalance() : "");
        messagejo.put("keyword4", (Object)templateVo.getGiverNick());
        messagejo.put("keyword5", (Object)sd.format(templateVo.getGiveDate()));
        messagejo.put("remark", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTail());
        messagejo.put("phoneStr", (Object)templateVo.getPhone());
        vo.setMessagejo(messagejo);
        log.info("sendRechargeGiveOverduetempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        this.templateMessageServiceFeign.sendOnlyWxGenTemplateMessage(vo);
    }

    public void sendRechargeReceiveBalanceTempalteMsg(SendTemplateVo templateVo) {
        log.info("enter sendRechargeReceiveBalanceTempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
        if (templateVo == null) {
            log.error("sendRechargeReceiveBalanceTempalteMsg\u627e\u4e0d\u5230\u4f1a\u5458 param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        GenMessageVO vo = new GenMessageVO();
        vo.setMemberCode(templateVo.getMemberCode());
        vo.setSysBrandId(templateVo.getSysBrandId());
        vo.setSysCompanyId(templateVo.getSysCompanyId());
        vo.setTemplateType(MsgTemplateType.RECHARGE_RECEIVE_BALANCE_MESSAGE.getCode());
        StandardTemplateVo standardTemplateVo = new StandardTemplateVo();
        standardTemplateVo.setSysBrandId(templateVo.getSysBrandId());
        standardTemplateVo.setTemplateType(MsgTemplateType.RECHARGE_RECEIVE_BALANCE_MESSAGE.getCode());
        ResponseData msgResponseData = this.standardMessageSmsFeign.getTemplateByTemType(standardTemplateVo);
        if (msgResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("sendRechargeReceiveBalanceTempalteMsg\u627e\u4e0d\u5230\u5bf9\u5e94\u6a21\u677f param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        JSONObject messagejo = new JSONObject();
        messagejo.put("first", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTitle());
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        messagejo.put("keyword1", (Object)"\u8f6c\u8d60\u4f59\u989d\u9000\u56de");
        messagejo.put("keyword2", (Object)templateVo.getGiveMoney());
        messagejo.put("keyword3", templateVo.getBalance() != null ? templateVo.getBalance() : "");
        messagejo.put("keyword4", (Object)templateVo.getGiverNick());
        messagejo.put("keyword5", (Object)sd.format(templateVo.getGiveDate()));
        messagejo.put("keyword6", (Object)templateVo.getReceiverNick());
        messagejo.put("remark", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTail());
        messagejo.put("phoneStr", (Object)templateVo.getPhone());
        vo.setMessagejo(messagejo);
        log.info("sendRechargeReceiveBalanceTempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        this.templateMessageServiceFeign.sendOnlyWxGenTemplateMessage(vo);
    }

    public void sendRechargeBalanceOverdueTempalteMsg(SendTemplateVo templateVo) {
        log.info("enter sendRechargeBalanceOverdueTempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
        if (templateVo == null) {
            log.error("sendRechargeBalanceOverdueTempalteMsg\u627e\u4e0d\u5230\u4f1a\u5458 param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        GenMessageVO vo = new GenMessageVO();
        vo.setMemberCode(templateVo.getMemberCode());
        vo.setSysBrandId(templateVo.getSysBrandId());
        vo.setSysCompanyId(templateVo.getSysCompanyId());
        vo.setTemplateType(MsgTemplateType.RECHARGE_BALANCE_OVERDUE_MESSAGE.getCode());
        StandardTemplateVo standardTemplateVo = new StandardTemplateVo();
        standardTemplateVo.setSysBrandId(templateVo.getSysBrandId());
        standardTemplateVo.setTemplateType(MsgTemplateType.RECHARGE_BALANCE_OVERDUE_MESSAGE.getCode());
        ResponseData msgResponseData = this.standardMessageSmsFeign.getTemplateByTemType(standardTemplateVo);
        if (msgResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.error("sendRechargeBalanceOverdueTempalteMsg\u627e\u4e0d\u5230\u5bf9\u5e94\u6a21\u677f param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        JSONObject messagejo = new JSONObject();
        messagejo.put("first", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTitle());
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        messagejo.put("keyword1", (Object)"\u8f6c\u8d60\u4f59\u989d\u53d8\u52a8");
        messagejo.put("keyword2", (Object)sd.format(templateVo.getValidDate()));
        messagejo.put("keyword3", templateVo.getBalance() != null ? templateVo.getBalance() : "");
        messagejo.put("keyword4", (Object)templateVo.getName());
        messagejo.put("remark", (Object)((MsgWxTempMessageVO)msgResponseData.getData()).getTail());
        messagejo.put("phoneStr", (Object)templateVo.getPhone());
        vo.setMessagejo(messagejo);
        log.info("sendRechargeBalanceOverdueTempalteMsg param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        this.templateMessageServiceFeign.sendOnlyWxGenTemplateMessage(vo);
    }

    public void sendSmsTempalteMsg(StandardMessageVo messageVo, StandardTemplateVo templateVo, SendTemplateVo sendTemplateVo) {
        log.info("enter snedSmsTempalteMsg messageVo:{},templateVo:{}", (Object)JacksonUtil.bean2Json((Object)messageVo), (Object)JacksonUtil.bean2Json((Object)templateVo));
        if (templateVo == null || messageVo == null) {
            log.error("snedSmsTempalteMsg\u627e\u4e0d\u5230\u4f1a\u5458 param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        ResponseData standardTemplateResponseVOResponseData = this.standardMessageSmsFeign.getTemplateInfoByTempType(templateVo);
        if (standardTemplateResponseVOResponseData == null || SysResponseEnum.FAILED.getCode() == standardTemplateResponseVOResponseData.getCode()) {
            log.error("\u67e5\u8be2\u77ed\u4fe1\u6a21\u677f\u5931\u8d25 param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        StandardTemplateResponseVO standardTemplateResponseVO = (StandardTemplateResponseVO)standardTemplateResponseVOResponseData.getData();
        if (standardTemplateResponseVO == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getTemplateCodeCn()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getTemplateCodeIntl()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)standardTemplateResponseVO.getContent())) {
            log.info("\u6a21\u677f\u672a\u914d\u7f6e param:{}", (Object)JacksonUtil.bean2Json((Object)templateVo));
            return;
        }
        String content = standardTemplateResponseVO.getContent();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)content)) {
            content = content.replace("@[\u4f1a\u5458\u59d3\u540d]", sendTemplateVo.getName() != null ? sendTemplateVo.getName() : "").replace("@[\u4f59\u989d\u53d8\u52a8\u7c7b\u578b]", messageVo.getChannelName() != null ? messageVo.getChannelName() : "").replace("@[\u4f59\u989d\u53d8\u52a8\u65f6\u95f4]", formatter.format(new Date())).replace("@[\u4f59\u989d\u53d8\u52a8\u989d\u5143]", sendTemplateVo.getRechargeMoney() != null ? sendTemplateVo.getRechargeMoney().toString() : "").replace("@[\u5f53\u524d\u4f59\u989d\u5143]", sendTemplateVo.getBalance() != null ? sendTemplateVo.getBalance().toString() : "").replace("@[\u4f1a\u5458\u5361\u53f7]", sendTemplateVo.getVipNo() != null ? sendTemplateVo.getVipNo() : "").replace("@[\u50a8\u503c\u5361\u53f7]", sendTemplateVo.getCardNo() != null ? sendTemplateVo.getCardNo() : "").replace("@[\u6d88\u8d39\u95e8\u5e97]", sendTemplateVo.getStoreName() != null ? sendTemplateVo.getStoreName() : "").replace("@[\u516c\u4f17\u53f7]", "UrbanRevivo").replace("@[\u5173\u8054\u8ba2\u5355\u53f7]", sendTemplateVo.getSerialNumber() != null ? sendTemplateVo.getSerialNumber() : "").replace("@[\u597d\u53cb\u59d3\u540d]", sendTemplateVo.getGiverNick() != null ? sendTemplateVo.getGiverNick() : "").replace("@[\u8fc7\u671f\u65f6\u95f4]", formatter.format(sendTemplateVo.getValidDate() != null ? sendTemplateVo.getValidDate() : new Date()));
            content = content + " \u9000\u8ba2\u56de\u590dTD";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("memberName", sendTemplateVo.getName());
        paramMap.put("balanceChangeType", messageVo.getChannelName());
        paramMap.put("balaceChangeTime", formatter.format(new Date()));
        paramMap.put("balanceChangeNum", sendTemplateVo.getRechargeMoney() != null ? sendTemplateVo.getRechargeMoney().toString() : "");
        paramMap.put("balanceCount", sendTemplateVo.getBalance() != null ? sendTemplateVo.getBalance().toString() : "");
        paramMap.put("memberCardNo", sendTemplateVo.getVipNo() != null ? sendTemplateVo.getVipNo() : "");
        paramMap.put("relationOrder", sendTemplateVo.getSerialNumber() != null ? sendTemplateVo.getSerialNumber() : "");
        paramMap.put("consumePrice", sendTemplateVo.getRechargeMoney() != null ? sendTemplateVo.getRechargeMoney().toString() : "");
        paramMap.put("consumeStore", sendTemplateVo.getStoreName() != null ? sendTemplateVo.getStoreName() : "");
        paramMap.put("consumeTime", formatter.format(new Date()));
        paramMap.put("rechargeCardNo", sendTemplateVo.getCardNo() != null ? sendTemplateVo.getCardNo() : "");
        paramMap.put("forwardName", sendTemplateVo.getGiverNick() != null ? sendTemplateVo.getGiverNick() : "");
        paramMap.put("forwardBalance", sendTemplateVo.getRechargeMoney() != null ? sendTemplateVo.getRechargeMoney().toString() : "");
        paramMap.put("forwardTime", formatter.format(new Date()));
        paramMap.put("accountBalance", sendTemplateVo.getBalance() != null ? sendTemplateVo.getBalance().toString() : "");
        paramMap.put("returnName", sendTemplateVo.getReceiverNick());
        paramMap.put("expireTime", formatter.format(sendTemplateVo.getValidDate() != null ? sendTemplateVo.getValidDate() : new Date()));
        messageVo.setMsgContent(content);
        messageVo.setScene(templateVo.getTemplateType());
        messageVo.setTemplateCodeCn(standardTemplateResponseVO.getTemplateCodeCn());
        messageVo.setTemplateCodeIntl(standardTemplateResponseVO.getTemplateCodeIntl());
        messageVo.setParamMap(paramMap);
        messageVo.setMsgTaskType(Integer.valueOf(5));
        this.standardMessageSmsFeign.sendSingleMessage(messageVo);
    }
}

