/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.common.utils.Assert;
import com.bizvane.customized.common.utils.NumberUtil;
import com.bizvane.customized.common.utils.ResponseUtil;
import com.bizvane.customized.company.ur.members.service.IntegralUseCodeService;
import com.bizvane.customized.facade.models.vo.CusUrIntegralUseCodeVO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class IntegralUseCodeServiceImpl
implements IntegralUseCodeService {
    private static final Logger log = LoggerFactory.getLogger(IntegralUseCodeServiceImpl.class);
    private static final String CODE_KEY = "cus-ur-integral-code-";
    @Autowired
    private StringRedisTemplate rs;

    public ResponseData checkCode(CusUrIntegralUseCodeVO vo) {
        log.info("IntegralUseCodeServiceImpl checkCode vo : {}", (Object)vo.toString());
        String integralUseCode = vo.getIntegralUseCode();
        String offCardNo = vo.getOffCardNo();
        Long brandId = vo.getBrandId();
        Assert.anyElementNotNull((String)"integralUseCode or offCardNo is empty !", (Object[])new Object[]{integralUseCode, offCardNo});
        String value = (String)this.rs.opsForValue().get((Object)(CODE_KEY + brandId + "_" + offCardNo));
        return integralUseCode.equals(value) ? ResponseUtil.success() : ResponseUtil.error((String)"\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u4f1a\u5458\u5237\u65b0\u540e\u91cd\u8bd5\u3002");
    }

    public ResponseData createNewCode(String offCardNo, Long brandId) {
        String pwd = NumberUtil.random((int)8);
        this.rs.opsForValue().set((Object)(CODE_KEY + brandId + "_" + offCardNo), (Object)pwd, 120L, TimeUnit.SECONDS);
        JSONObject data = new JSONObject();
        data.put("integralUseCode", (Object)pwd);
        return ResponseUtil.success((Object)data);
    }
}

