/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.controller.rpc;

import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.ur.members.service.StorageCardService;
import com.bizvane.customized.facade.models.vo.CusUrStorageCardReceivedVO;
import com.bizvane.customized.facade.models.vo.CusUrStorageCardSendVO;
import com.bizvane.customized.facade.models.vo.StorageCardConsumeRequestVO;
import com.bizvane.customized.facade.models.vo.StorageCardQueryStorageCardRequestVO;
import com.bizvane.customized.facade.models.vo.StorageCardQueryStorageCardResponseVO;
import com.bizvane.customized.facade.models.vo.StorageCardQueryVipCardRequestVO;
import com.bizvane.customized.facade.models.vo.StorageCardQueryVipCardResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u50a8\u503c\u5361\u5fae\u4fe1\u6e20\u9053"})
@RequestMapping(value={"/ur/storageCardRpc"})
@RestController
public class StorageCardRpcController {
    private static final Logger log = LoggerFactory.getLogger(StorageCardRpcController.class);
    @Autowired
    private StorageCardService storageCardService;

    @ApiOperation(value="\u50a8\u503c\u5361\u8f6c\u589e", notes="\u5fae\u4fe1\u516c\u4f17\u53f7\u5c0f\u7a0b\u5e8f\u8c03\u7528\u6b64\u63a5\u53e3\u8f6c\u8d60\u50a8\u503c\u5361")
    @PostMapping(value={"/sendStorageCard"})
    public ResponseData sendStorageCard(@RequestBody CusUrStorageCardSendVO vo) {
        return this.storageCardService.sendStorageCard(vo);
    }

    @ApiOperation(value="\u50a8\u503c\u5361\u53d7\u8d60", notes="\u5fae\u4fe1\u516c\u4f17\u53f7\u5c0f\u7a0b\u5e8f\u8c03\u7528\u6b64\u63a5\u53e3\u83b7\u53d6\u53d7\u8d60\u7684\u50a8\u503c\u5361")
    @PostMapping(value={"/receivedStorageCard"})
    public ResponseData receivedSendStorageCard(@RequestBody CusUrStorageCardReceivedVO vo) {
        return this.storageCardService.receivedSendStorageCard(vo);
    }

    @PostMapping(value={"/getStorageCardByVipCard"})
    ResponseData<StorageCardQueryVipCardResponseVO> getStorageCardByVipCard(@RequestBody @Valid StorageCardQueryVipCardRequestVO storageQueryCardRequestVO) {
        log.info("enter getStorageCardByVipCard param:{}", (Object)JacksonUtil.bean2Json((Object)storageQueryCardRequestVO));
        return this.storageCardService.getStorageCardByVipCard(storageQueryCardRequestVO);
    }

    @PostMapping(value={"/storageConsume"})
    ResponseData<String> storageConsume(@RequestBody @Valid StorageCardConsumeRequestVO storageCardConsumeRequestVO) {
        log.info("enter storageConsume param:{}", (Object)JacksonUtil.bean2Json((Object)storageCardConsumeRequestVO));
        return this.storageCardService.storageConsume(storageCardConsumeRequestVO);
    }

    @PostMapping(value={"/getStorageCardByStorageCard"})
    ResponseData<StorageCardQueryStorageCardResponseVO> getStorageCardByStorageCard(@RequestBody @Valid StorageCardQueryStorageCardRequestVO storageCardQueryStorageCardRequestVO) {
        log.info("enter getStorageCardByCardNo param:{}", (Object)JacksonUtil.bean2Json((Object)storageCardQueryStorageCardRequestVO));
        return this.storageCardService.getStorageCardByStorageCard(storageCardQueryStorageCardRequestVO);
    }
}

