/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.controller.rpc;

import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.ur.members.service.EvaluationOrderService;
import com.bizvane.customized.company.ur.members.service.EvaluationQuestionnaireService;
import com.bizvane.customized.facade.models.po.CusUrMbrEvaluationConfigPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePO;
import com.bizvane.customized.facade.models.vo.CusUrMbrEvalConfigVO;
import com.bizvane.customized.facade.models.vo.CusUrMbrQuestionnaireTemplateVO;
import com.bizvane.customized.facade.models.vo.EvaluationOrderRequestVO;
import com.bizvane.customized.facade.models.vo.EvaluationSaveTempRequestVO;
import com.bizvane.customized.facade.models.vo.questionnaire.QuestionnaireTempRequestVO;
import com.bizvane.customized.facade.models.vo.questionnaire.QuestionnaireTempVO;
import com.bizvane.customized.facade.models.vo.questionnaire.SaveQuestionnaireRequestVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8c03\u67e5\u95ee\u5377"})
@RequestMapping(value={"/ur/mbr/evaluationQuestionnaireRpc"})
@RestController
public class EvaluationQuestionnaireRpcController {
    private static final Logger log = LoggerFactory.getLogger(EvaluationQuestionnaireRpcController.class);
    @Autowired
    private EvaluationOrderService evaluationOrderService;
    @Autowired
    private EvaluationQuestionnaireService evaluationQuestionnaireService;

    @PostMapping(value={"/queryEvalConfig"})
    ResponseData<PageInfo<CusUrMbrEvaluationConfigPO>> queryEvalConfig(@RequestBody @Valid CusUrMbrEvalConfigVO vo) {
        log.info("enter queryEvalConfig param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.evaluationQuestionnaireService.getEvalConfig(vo);
    }

    @PostMapping(value={"/queryQuestionTemplate"})
    ResponseData<CusUrMbrQuestionnaireTemplatePO> queryQuestionTemplate(@RequestBody @Valid CusUrMbrQuestionnaireTemplateVO vo) {
        log.info("enter queryQuestionTemplate param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.evaluationQuestionnaireService.getQuestionnaireTemplateByCode(vo);
    }

    @PostMapping(value={"/queryAnswerOrderDetail"})
    ResponseData<CusUrMbrQuestionnaireOrderPO> queryAnswerOrderDetail(@RequestBody @Valid EvaluationOrderRequestVO vo) {
        log.info("enter queryAnswerOrderDetail param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.evaluationOrderService.getAnswerOrderDetail(vo);
    }

    @PostMapping(value={"/saveQuestionnaireOrder"})
    ResponseData<String> saveQuestionnaireOrder(@RequestBody @Valid EvaluationSaveTempRequestVO vo) {
        log.info("enter saveQuestionnaireOrder param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.evaluationOrderService.save(vo);
    }

    @PostMapping(value={"/saveQuestionnaireTask"})
    ResponseData saveQuestionnaireTask(@RequestBody @Valid EvaluationSaveTempRequestVO vo) {
        log.info("enter saveQuestionnaireTask param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.evaluationOrderService.saveByTask(vo);
    }

    @PostMapping(value={"queryAnswerOrderByTaskId"})
    ResponseData<CusUrMbrQuestionnaireOrderPO> queryAnswerOrderByTaskId(@RequestBody @Valid CusUrMbrQuestionnaireTemplateVO vo) {
        log.info("enter queryAnswerOrderByTaskId param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.evaluationQuestionnaireService.queryAnswerOrderByTaskId(vo);
    }

    @PostMapping(value={"/checkQuestionnaireTempValid"})
    ResponseData<Integer> checkQuestionnaireTempValid(@RequestBody QuestionnaireTempRequestVO vo) {
        return this.evaluationQuestionnaireService.checkQuestionnaireTempValid(vo);
    }

    @PostMapping(value={"/queryQuestionnaireTemp"})
    ResponseData<QuestionnaireTempVO> queryQuestionnaireTemp(@RequestBody @Valid QuestionnaireTempRequestVO vo) {
        return this.evaluationOrderService.queryQuestionnaireTemp(vo);
    }

    @PostMapping(value={"/saveCommonQuestionnaire"})
    ResponseData<String> saveCommonQuestionnaire(@RequestBody @Valid SaveQuestionnaireRequestVO vo) {
        return this.evaluationOrderService.saveCommonQuestionnaire(vo);
    }

    @PostMapping(value={"/saveOrderQuestionnaire"})
    ResponseData<String> saveOrderQuestionnaire(@RequestBody @Valid SaveQuestionnaireRequestVO vo) {
        return this.evaluationOrderService.saveOrderQuestionnaire(vo);
    }

    @PostMapping(value={"/saveTaskQuestionnaire"})
    ResponseData<String> saveTaskQuestionnaire(@RequestBody @Valid SaveQuestionnaireRequestVO vo) {
        return this.evaluationOrderService.saveTaskQuestionnaire(vo);
    }
}

