/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.controller;

import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.company.ur.members.service.EvaluationOrderService;
import com.bizvane.customized.company.ur.members.service.EvaluationQuestionnaireService;
import com.bizvane.customized.facade.enums.QuestionnaireTemplateTypeEnum;
import com.bizvane.customized.facade.models.po.CusUrMbrEvaluationConfigPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePO;
import com.bizvane.customized.facade.models.vo.CusUrMbrEvalConfigVO;
import com.bizvane.customized.facade.models.vo.CusUrMbrGiftCardVO;
import com.bizvane.customized.facade.models.vo.CusUrMbrQuestionnaireTemplateVO;
import com.bizvane.customized.facade.models.vo.EvaluationOrderListRequestVO;
import com.bizvane.customized.facade.models.vo.EvaluationOrderRequestVO;
import com.bizvane.customized.facade.models.vo.EvaluationSaveTempRequestVO;
import com.bizvane.customized.facade.models.vo.EvaluationSumVO;
import com.bizvane.customized.facade.models.vo.questionnaire.QuestionnaireAnalysisRequestVO;
import com.bizvane.customized.facade.models.vo.questionnaire.QuestionnaireAnalysisVO;
import com.bizvane.customized.facade.models.vo.questionnaire.SurveyQuestionnaireVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8c03\u67e5\u95ee\u5377\u6a21\u677f"}, description="EvaluationQuestionnaireController")
@RestController
@RequestMapping(value={"/ur/mbr/evaluationQuestionnaire"})
public class EvaluationQuestionnaireController {
    private static final Logger log = LoggerFactory.getLogger(EvaluationQuestionnaireController.class);
    @Autowired
    private EvaluationQuestionnaireService evaluationQuestionnaireService;
    @Autowired
    private EvaluationOrderService evaluationOrderService;

    @ApiOperation(value="\u65b0\u589e\u4fee\u6539\u89e6\u53d1\u8bbe\u7f6e", notes="", tags={""}, httpMethod="POST")
    @PostMapping(value={"/addAndUpdateEvalConfig"})
    public ResponseData<CusUrMbrEvaluationConfigPO> addAndUpdateEvalConfig(CusUrMbrEvalConfigVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        vo.setCreateUserId(sysAccountPO.getSysAccountId());
        vo.setCreateUserName(sysAccountPO.getName());
        return this.evaluationQuestionnaireService.addAndUpdateEvalConfig(vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u89e6\u53d1\u8bbe\u7f6e", notes="", tags={""}, httpMethod="POST")
    @PostMapping(value={"/getEvalConfig"})
    public ResponseData<PageInfo<CusUrMbrEvaluationConfigPO>> getEvalConfig(CusUrMbrEvalConfigVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        return this.evaluationQuestionnaireService.getEvalConfig(vo);
    }

    @PostMapping(value={"/sendPointsAndCoupons"})
    public ResponseData sendPointsAndCoupons(CusUrMbrGiftCardVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        return null;
    }

    @PostMapping(value={"/getQuestionnaireTemplate"})
    public ResponseData<List<CusUrMbrQuestionnaireTemplatePO>> getQuestionnaireTemplate(CusUrMbrQuestionnaireTemplateVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        return this.evaluationQuestionnaireService.getQuestionnaireTemplate(vo);
    }

    @PostMapping(value={"/getQuestionnaireTemplateByCode"})
    public ResponseData<CusUrMbrQuestionnaireTemplatePO> getQuestionnaireTemplateByCode(CusUrMbrQuestionnaireTemplateVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        return this.evaluationQuestionnaireService.getQuestionnaireTemplateByCode(vo);
    }

    @PostMapping(value={"/getQuestionnaireTemplateList"})
    public ResponseData<PageInfo<CusUrMbrQuestionnaireTemplatePO>> getQuestionnaireTemplateList(CusUrMbrQuestionnaireTemplateVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        vo.setTemplateType(Integer.valueOf(QuestionnaireTemplateTypeEnum.OLD.getTemplateType()));
        return this.evaluationQuestionnaireService.getQuestionnaireTemplateList(vo);
    }

    @PostMapping(value={"/getAnswerOrderList"})
    public ResponseData<PageInfo<CusUrMbrQuestionnaireOrderPO>> getAnswerOrderList(@Valid EvaluationOrderListRequestVO vo, HttpServletRequest request) {
        log.info("enter EvaluationQuestionnaireController getAnswerOrderList param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        if (vo.getExport() != null && vo.getExport().booleanValue()) {
            return this.evaluationOrderService.getAnswerOrderListExport(vo, request);
        }
        return this.evaluationOrderService.getAnswerOrderList(vo, sysAccountPO);
    }

    @PostMapping(value={"/getAnswerSum"})
    public ResponseData<EvaluationSumVO> getAnswerSum(@Valid EvaluationOrderListRequestVO vo, HttpServletRequest request) {
        log.info("enter EvaluationQuestionnaireController getAnswerSum param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        return this.evaluationOrderService.getAnswerSum(vo);
    }

    @PostMapping(value={"/getAnswerOrderDetail"})
    public ResponseData<CusUrMbrQuestionnaireOrderPO> getAnswerOrderDetail(EvaluationOrderRequestVO vo, HttpServletRequest request) {
        log.info("enter CusUrMbrGiftCardController giftCardToExamine param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        return this.evaluationOrderService.getAnswerOrderDetail(vo);
    }

    @PostMapping(value={"/saveTemplate"})
    public ResponseData<String> saveTemplate(EvaluationSaveTempRequestVO vo, HttpServletRequest request) {
        log.info("enter EvaluationQuestionnaireController saveTemplate param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.evaluationQuestionnaireService.saveTemplate(vo, TokenUtils.getStageUser((HttpServletRequest)request));
    }

    @ApiOperation(value="\u95ee\u5377\u6a21\u677f\u7f16\u8f91")
    @ApiImplicitParams(value={@ApiImplicitParam(name="templateCode", value="\u95ee\u5377\u6a21\u677fcode", required=true, dataType="String")})
    @PostMapping(value={"/editTemplate"})
    public ResponseData editTemplate(EvaluationSaveTempRequestVO vo, HttpServletRequest request) {
        try {
            this.evaluationQuestionnaireService.editTemplate(vo, TokenUtils.getStageUser((HttpServletRequest)request));
        }
        catch (Exception e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return new ResponseData();
    }

    @ApiOperation(value="\u95ee\u5377\u6a21\u677f\u6295\u653e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="templateCode", value="\u95ee\u5377\u6a21\u677fcode", required=true, dataType="String")})
    @PostMapping(value={"/releaseTemplate"})
    public ResponseData releaseTemplate(CusUrMbrQuestionnaireTemplatePO vo, HttpServletRequest request) {
        try {
            this.evaluationQuestionnaireService.releaseTemplate(vo, TokenUtils.getStageUser((HttpServletRequest)request));
        }
        catch (Exception e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return new ResponseData();
    }

    @ApiOperation(value="\u95ee\u5377\u6a21\u677f\u903b\u8f91\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="templateCode", value="\u95ee\u5377\u6a21\u677fcode", required=true, dataType="String")})
    @PostMapping(value={"/deleteTemplate"})
    public ResponseData deleteTemplate(CusUrMbrQuestionnaireTemplatePO vo, HttpServletRequest request) {
        try {
            this.evaluationQuestionnaireService.deleteTemplate(vo, TokenUtils.getStageUser((HttpServletRequest)request));
        }
        catch (Exception e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return new ResponseData();
    }

    @PostMapping(value={"/addQuestionnaireTemplate"})
    public ResponseData<String> addQuestionnaireTemplate(@RequestBody SurveyQuestionnaireVO requestVO, HttpServletRequest request) {
        log.info("addQuestionnaireTemplate:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.evaluationQuestionnaireService.addQuestionnaireTemplate(requestVO, sysAccountPO);
    }

    @PostMapping(value={"/getQuestionnaireTemplateDetail"})
    public ResponseData<CusUrMbrQuestionnaireTemplatePO> getQuestionnaireTemplateDetail(CusUrMbrQuestionnaireTemplateVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.evaluationQuestionnaireService.getQuestionnaireTemplateDetail(vo, sysAccountPO);
    }

    @PostMapping(value={"/getQuestionnaireTemplateListNew"})
    public ResponseData<PageInfo<CusUrMbrQuestionnaireTemplatePO>> getQuestionnaireTemplateListNew(@RequestBody CusUrMbrQuestionnaireTemplateVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        vo.setTemplateType(Integer.valueOf(QuestionnaireTemplateTypeEnum.NEW.getTemplateType()));
        return this.evaluationQuestionnaireService.getQuestionnaireTemplateList(vo);
    }

    @PostMapping(value={"/editQuestionnaireTemplate"})
    public ResponseData<String> editQuestionnaireTemplate(@RequestBody SurveyQuestionnaireVO requestVO, HttpServletRequest request) {
        log.info("editQuestionnaireTemplate:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.evaluationQuestionnaireService.editQuestionnaireTemplate(requestVO, sysAccountPO);
    }

    @PostMapping(value={"/enableQuestionnaireTemplate"})
    public ResponseData<Boolean> enableQuestionnaireTemplate(CusUrMbrQuestionnaireTemplateVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.evaluationQuestionnaireService.enableQuestionnaireTemplate(vo, sysAccountPO);
    }

    @PostMapping(value={"/disableQuestionnaireTemplate"})
    public ResponseData<Boolean> disableQuestionnaireTemplate(CusUrMbrQuestionnaireTemplateVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.evaluationQuestionnaireService.disableQuestionnaireTemplate(vo, sysAccountPO);
    }

    @PostMapping(value={"/getQuestionnaireTempAnalysis"})
    public ResponseData<List<QuestionnaireAnalysisVO>> getQuestionnaireTempAnalysis(@RequestBody QuestionnaireAnalysisRequestVO requestVO, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.evaluationQuestionnaireService.getQuestionnaireTempAnalysis(requestVO, sysAccountPO);
    }

    @PostMapping(value={"/getQuestionnaireTempAnswerList"})
    public ResponseData<PageInfo<CusUrMbrQuestionnaireOrderPO>> getQuestionnaireTempAnswerList(@RequestBody QuestionnaireAnalysisRequestVO requestVO, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        requestVO.setSysCompanyId(sysAccountPO.getSysCompanyId());
        requestVO.setSysBrandId(sysAccountPO.getBrandId());
        return this.evaluationQuestionnaireService.getQuestionnaireTempAnswerList(requestVO, sysAccountPO);
    }

    @PostMapping(value={"/memberAnswerDetailDataExport"})
    public ResponseData<Boolean> memberAnswerDetailDataExport(@RequestBody QuestionnaireAnalysisRequestVO requestVO, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        requestVO.setSysCompanyId(sysAccountPO.getSysCompanyId());
        requestVO.setSysBrandId(sysAccountPO.getBrandId());
        return this.evaluationQuestionnaireService.memberAnswerDetailDataExport(requestVO, sysAccountPO);
    }
}

