/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.teddy.service.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.customized.common.constants.SysConstants;
import com.bizvane.customized.common.utils.Assert;
import com.bizvane.customized.common.utils.DateUtil;
import com.bizvane.customized.common.utils.FileNameUtil;
import com.bizvane.customized.common.utils.NumberUtil;
import com.bizvane.customized.common.utils.QiNiuConfig;
import com.bizvane.customized.common.utils.QiNiuUtil;
import com.bizvane.customized.common.utils.QiNiuUtils;
import com.bizvane.customized.common.utils.UUIDGenerator;
import com.bizvane.customized.company.teddy.service.CusTeddyGoodsVerifyService;
import com.bizvane.customized.facade.enums.teddy.CusTeddyGoodsTaskStatusEnum;
import com.bizvane.customized.facade.enums.teddy.CusTeddyGoodsVerifyStatusEnum;
import com.bizvane.customized.facade.exception.CustomizedException;
import com.bizvane.customized.facade.models.po.CusTeddyGoodsVerifyBatchPO;
import com.bizvane.customized.facade.models.po.CusTeddyGoodsVerifyDetailPO;
import com.bizvane.customized.facade.models.vo.QiNiuVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsVerifyBatchCodeGenerateConfig;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsVerifyBatchQueryVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsVerifyDetailQueryVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyPageQuery;
import com.bizvane.customized.mappers.CusTeddyGoodsVerifyBatchPOMapper;
import com.bizvane.customized.mappers.CusTeddyGoodsVerifyDetailPOMapper;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.SpringContextHolder;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CusTeddyGoodsVerifyServiceImpl
implements CusTeddyGoodsVerifyService {
    private static final Logger log = LoggerFactory.getLogger(CusTeddyGoodsVerifyServiceImpl.class);
    private static Integer BATCH_MAX_NUMBER = 1000000;
    private static Integer ALL_MAX_NUMBER = 100000000;
    @Autowired
    private CusTeddyGoodsVerifyBatchPOMapper cusTeddyGoodsVerifyBatchPOMapper;
    @Autowired
    private CusTeddyGoodsVerifyDetailPOMapper cusTeddyGoodsVerifyDetailPOMapper;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;

    public PageInfo<CusTeddyGoodsVerifyBatchPO> queryBatchPage(CusTeddyGoodsVerifyBatchQueryVo queryVo, CusTeddyPageQuery pageQuery, SysAccountPO currentUser) {
        log.info("\u5bc6\u7801\u6279\u6b21\u5206\u9875\u67e5\u8be2\u5165\u53c2:{}", JSON.toJSON((Object)queryVo));
        PageHelper.startPage((int)pageQuery.getPageNum(), (int)pageQuery.getPageSize());
        List poList = this.cusTeddyGoodsVerifyBatchPOMapper.selectListByVo(queryVo, currentUser);
        PageInfo pageInfo = new PageInfo(poList);
        return pageInfo;
    }

    public void add(CusTeddyGoodsVerifyBatchPO batchPO, SysAccountPO currentUser) {
        log.info("\u5bc6\u7801\u521b\u5efa\u5165\u53c2:{}", JSON.toJSON((Object)batchPO));
        if (batchPO.getCodeCount() == null || batchPO.getCodeCount() <= 0 || batchPO.getCodeCount() > BATCH_MAX_NUMBER) {
            throw new CustomizedException("\u5bc6\u7801\u5355\u6b21\u751f\u6210\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5927\u4e8e0\uff0c\u5c0f\u4e8e100\u4e07\u4e2a\uff01");
        }
        Integer currCodeCount = this.cusTeddyGoodsVerifyDetailPOMapper.getCodeCount(currentUser);
        if (currCodeCount + batchPO.getCodeCount() > ALL_MAX_NUMBER) {
            throw new CustomizedException("\u5f53\u524d\u5bc6\u7801\u5df2\u8d85\u51fa\u4e0a\u9650\uff0c\u5269\u4f59\u53ef\u7528\u5bc6\u7801\u6570 " + (ALL_MAX_NUMBER - currCodeCount) + " \u4e2a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        ResponseData brandVoResponseData = this.brandServiceRpc.getBrandId(currentUser.getBrandId());
        Assert.isTrue((brandVoResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() ? 1 : 0) != 0, (String)("\u83b7\u53d6\u54c1\u724c\u4fe1\u606f\u5931\u8d25 " + brandVoResponseData.getMessage()));
        Assert.isTrue((brandVoResponseData.getData() != null ? 1 : 0) != 0, (String)"\u83b7\u53d6\u54c1\u724c\u4fe1\u606f\u5931\u8d25\uff0c\u6ca1\u6709\u6b64\u54c1\u724c");
        String batchNoPrefix = ((SysBrandVo)brandVoResponseData.getData()).getBrandCode() + DateUtil.getTodateString();
        int sequenceNum = 1;
        String batchNoMax = this.cusTeddyGoodsVerifyBatchPOMapper.getMaxBatchNoByBatchNoPrefix(batchNoPrefix, currentUser);
        if (!StringUtils.isBlank((CharSequence)batchNoMax)) {
            String sequenceNumStr = batchNoMax.replace(batchNoPrefix, "");
            sequenceNum = Integer.parseInt(sequenceNumStr) + 1;
        }
        CusTeddyGoodsVerifyBatchCodeGenerateConfig codeGenerateConfig = CusTeddyGoodsVerifyBatchCodeGenerateConfig.builder().genCount(batchPO.getCodeCount()).batchNoPrefix(batchNoPrefix).build();
        String batchNo = batchNoPrefix + UUIDGenerator.addLeftZero((String)Integer.toString(sequenceNum), (int)6);
        batchPO.setBatchNo(batchNo);
        batchPO.setTaskStatus(Byte.valueOf((byte)CusTeddyGoodsTaskStatusEnum.PROCEED.getCode().intValue()));
        batchPO.setTaskExecuteTime(new Date());
        batchPO.setVerifyCount(Integer.valueOf(0));
        batchPO.setCodeGenerateConfig(JSON.toJSONString((Object)codeGenerateConfig));
        batchPO.setSysCompanyId(currentUser.getSysCompanyId());
        batchPO.setSysBrandId(currentUser.getBrandId());
        batchPO.setCreateUserId(currentUser.getSysAccountId());
        batchPO.setCreateUserName(currentUser.getName());
        batchPO.setCreateDate(new Date());
        batchPO.setValid(SysConstants.TABLE_VALID_EFFECTIVE);
        this.cusTeddyGoodsVerifyBatchPOMapper.insert(batchPO);
        this.execGenCodeTask(batchPO, currentUser, codeGenerateConfig);
    }

    public void repeat(String batchNo, SysAccountPO currentUser) {
        CusTeddyGoodsVerifyBatchPO batchPO = this.cusTeddyGoodsVerifyBatchPOMapper.getByBatchNo(batchNo, currentUser);
        Assert.isTrue(((byte)CusTeddyGoodsTaskStatusEnum.FAIL.getCode().intValue() == batchPO.getTaskStatusCalculate() ? 1 : 0) != 0, (String)"\u4efb\u52a1\u72b6\u6001\u5f02\u5e38");
        batchPO.setTaskStatus(Byte.valueOf((byte)CusTeddyGoodsTaskStatusEnum.PROCEED.getCode().intValue()));
        batchPO.setTaskExecuteTime(new Date());
        batchPO.setModifiedUserId(currentUser.getSysAccountId());
        batchPO.setModifiedUserName(currentUser.getName());
        batchPO.setModifiedDate(new Date());
        batchPO.setRemark("");
        this.cusTeddyGoodsVerifyBatchPOMapper.updateTaskStatus(batchPO);
        Integer countYet = this.cusTeddyGoodsVerifyDetailPOMapper.getCountByBatchNo(batchNo, currentUser);
        Integer countWill = batchPO.getCodeCount() - countYet;
        CusTeddyGoodsVerifyBatchCodeGenerateConfig codeGenerateConfig = (CusTeddyGoodsVerifyBatchCodeGenerateConfig)JSON.parseObject((String)batchPO.getCodeGenerateConfig(), CusTeddyGoodsVerifyBatchCodeGenerateConfig.class);
        codeGenerateConfig.setGenCount(countWill);
        this.execGenCodeTask(batchPO, currentUser, codeGenerateConfig);
    }

    public void execGenCodeTask(CusTeddyGoodsVerifyBatchPO batchPO, SysAccountPO currentUser, CusTeddyGoodsVerifyBatchCodeGenerateConfig codeGenerateConfig) {
        Callable<String> task = () -> {
            try {
                for (int i = 0; i < codeGenerateConfig.getGenCount(); ++i) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new CustomizedException("thread is timeout");
                    }
                    CusTeddyGoodsVerifyDetailPO detail = new CusTeddyGoodsVerifyDetailPO();
                    detail.setBatchNo(batchPO.getBatchNo());
                    detail.setCode(NumberUtil.random((int)8));
                    detail.setVerifyStatus(Byte.valueOf((byte)CusTeddyGoodsVerifyStatusEnum.VERIFY_NOT.getCode().intValue()));
                    detail.setSysCompanyId(currentUser.getSysCompanyId());
                    detail.setSysBrandId(currentUser.getBrandId());
                    detail.setCreateUserId(currentUser.getSysAccountId());
                    detail.setCreateUserName(currentUser.getName());
                    detail.setCreateDate(new Date());
                    detail.setValid(SysConstants.TABLE_VALID_EFFECTIVE);
                    int r = this.cusTeddyGoodsVerifyDetailPOMapper.insertWhenCodeNotRepeat(detail);
                    log.info("\u5f53\u524d\u7b2c{}\u4e2a\uff0ccode={}, \u662f\u5426\u5df2\u6709\u6570\u636e={}", new Object[]{i + 1, detail.getCode(), r <= 0 ? "y" : "n"});
                    if (r > 0) continue;
                    --i;
                }
                batchPO.setTaskStatus(Byte.valueOf((byte)CusTeddyGoodsTaskStatusEnum.FINISH.getCode().intValue()));
                batchPO.setTaskExecuteTime(null);
                batchPO.setModifiedUserId(currentUser.getSysAccountId());
                batchPO.setModifiedUserName(currentUser.getName());
                batchPO.setModifiedDate(new Date());
                batchPO.setRemark("");
                this.cusTeddyGoodsVerifyBatchPOMapper.updateTaskStatus(batchPO);
            }
            catch (Exception e) {
                log.error("verifyDetail insert error", (Throwable)e);
                batchPO.setTaskStatus(Byte.valueOf((byte)CusTeddyGoodsTaskStatusEnum.FAIL.getCode().intValue()));
                batchPO.setTaskExecuteTime(null);
                batchPO.setModifiedUserId(currentUser.getSysAccountId());
                batchPO.setModifiedUserName(currentUser.getName());
                batchPO.setModifiedDate(new Date());
                batchPO.setRemark(e.getMessage());
                this.cusTeddyGoodsVerifyBatchPOMapper.updateTaskStatus(batchPO);
            }
            return "success";
        };
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<String> future = executorService.submit(task);
        new Thread(() -> {
            try {
                String result = (String)future.get(2L, TimeUnit.HOURS);
                System.out.println(result);
            }
            catch (TimeoutException e) {
                log.error("VerifyBatch insert error, thread is timeout", (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error("VerifyBatch insert error", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error("VerifyBatch insert error", (Throwable)e);
            }
            finally {
                future.cancel(true);
                executorService.shutdown();
            }
        }).start();
    }

    public void exportVerifyDetailTxt(CusTeddyGoodsVerifyDetailQueryVo queryVo, SysAccountPO currentUser) {
        log.info("\u5bfc\u51fa\u5bc6\u7801\u4fe1\u606f,\u67e5\u8be2\u6761\u4ef6:{}", (Object)JSONObject.toJSONString((Object)queryVo));
        List poList = this.cusTeddyGoodsVerifyDetailPOMapper.selectListByVo(queryVo, currentUser);
        long count = poList.size();
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"\u5185\u5bb9\u4e3a\u7a7a,\u65e0\u9700\u5bfc\u51fa");
        Long taskId = Long.valueOf(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        fileTaskPo.setFileId(taskId.toString());
        fileTaskPo.setTaskTypeCode(count + "\u6761");
        fileTaskPo.setTaskName("\u5bfc\u51fa\u5bc6\u7801\u4fe1\u606f");
        fileTaskPo.setSysCompanyId(currentUser.getSysCompanyId());
        fileTaskPo.setSysBrandId(currentUser.getBrandId());
        fileTaskPo.setCreateUserId(currentUser.getSysAccountId());
        fileTaskPo.setCreateUserName(currentUser.getName());
        fileTaskPo.setFileStatus(Long.valueOf(0L));
        fileTaskPo.setFileType("EXPORT");
        fileTaskPo.setValid(SysConstants.TABLE_VALID_EFFECTIVE);
        this.fileTaskServiceRpc.addFileTask(fileTaskPo);
        StringBuffer text = new StringBuffer();
        for (CusTeddyGoodsVerifyDetailPO detail : poList) {
            text.append(detail.getCode());
            text.append("\r\n");
        }
        String moduleName = "\u5bc6\u7801\u4fe1\u606f\u5bfc\u51fa_";
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(text.toString().getBytes());
            QiNiuUtils niuUtil = new QiNiuUtils();
            String bucket = ((QiNiuConfig)SpringContextHolder.getApplicationContext().getBean(QiNiuConfig.class)).getBucketNm();
            String fileName = FileNameUtil.getFileName((String)moduleName, (String)DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"), (String)".txt");
            QiNiuVo qiniuUrl = niuUtil.upload(bucket, (InputStream)in, fileName);
            fileTaskPo.setFileStatus(Long.valueOf(100L));
            String domain = ((QiNiuConfig)SpringContextHolder.getApplicationContext().getBean(QiNiuConfig.class)).getDomain();
            fileTaskPo.setFileUnl(QiNiuUtil.httpUrlCompatible((String)(domain + "/"), (String)qiniuUrl.getUrl().toString()));
            log.info("fileTask\u5bfc\u51fa\u5730\u5740\uff1a" + fileTaskPo.getFileUnl());
            this.fileTaskServiceRpc.update(fileTaskPo);
        }
        catch (Exception e) {
            fileTaskPo.setFileStatus(Long.valueOf(-1L));
            this.fileTaskServiceRpc.update(fileTaskPo);
            log.error("gen file error:", (Throwable)e);
        }
    }
}

