/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.teddy.controller;

import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.company.teddy.service.CusTeddyGoodsVerifyService;
import com.bizvane.customized.facade.models.po.CusTeddyGoodsVerifyBatchPO;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsVerifyBatchQueryVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsVerifyDetailQueryVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyPageQuery;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6cf0\u8fea\u718a\u5546\u54c1\u5bc6\u7801CusTeddyGoodsVerifyController"})
@RequestMapping(value={"/teddy/goodsVerify"})
@RestController
public class CusTeddyGoodsVerifyController {
    private static final Logger log = LoggerFactory.getLogger(CusTeddyGoodsVerifyController.class);
    @Autowired
    private CusTeddyGoodsVerifyService cusTeddyGoodsVerifyService;
    @Autowired
    private HttpServletRequest request;

    @ApiOperation(value="\u5bc6\u7801\u6279\u6b21\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/queryBatchPage"})
    public ResponseData<PageInfo<CusTeddyGoodsVerifyBatchPO>> queryBatchPage(CusTeddyGoodsVerifyBatchQueryVo queryVo, CusTeddyPageQuery pageQuery) {
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)this.request);
        return new ResponseData((Object)this.cusTeddyGoodsVerifyService.queryBatchPage(queryVo, pageQuery, currentUser));
    }

    @ApiOperation(value="\u5bc6\u7801\u521b\u5efa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="codeCount", value="\u751f\u6210\u4e2a\u6570", required=true, dataType="Integer")})
    @PostMapping(value={"/add"})
    public ResponseData add(CusTeddyGoodsVerifyBatchPO batchPO) {
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)this.request);
        try {
            this.cusTeddyGoodsVerifyService.add(batchPO, currentUser);
        }
        catch (Exception e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return new ResponseData("\u6dfb\u52a0\u521b\u5efa\u4efb\u52a1\u6210\u529f", null);
    }

    @ApiOperation(value="\u5bc6\u7801\u5bfc\u51fa-\u6309\u6279\u6b21\u53f7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="batchNo", value="\u6279\u6b21\u53f7", required=true, dataType="String")})
    @PostMapping(value={"/export"})
    public ResponseData export(@RequestParam String batchNo) {
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)this.request);
        try {
            CusTeddyGoodsVerifyDetailQueryVo queryVo = new CusTeddyGoodsVerifyDetailQueryVo();
            queryVo.setBatchNo(batchNo);
            this.cusTeddyGoodsVerifyService.exportVerifyDetailTxt(queryVo, currentUser);
        }
        catch (Exception e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return new ResponseData("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f", null);
    }

    @ApiOperation(value="\u5bc6\u7801\u91cd\u65b0\u751f\u6210")
    @PostMapping(value={"/repeat"})
    public ResponseData repeat(@RequestParam String batchNo) {
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)this.request);
        try {
            this.cusTeddyGoodsVerifyService.repeat(batchNo, currentUser);
        }
        catch (Exception e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return new ResponseData("\u6dfb\u52a0\u91cd\u65b0\u751f\u6210\u4efb\u52a1\u6210\u529f", null);
    }
}

