/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.teddy.controller;

import com.alibaba.fastjson.JSON;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.company.teddy.service.CusTeddyGoodsCodeService;
import com.bizvane.customized.facade.models.po.CusTeddyGoodsCodeBatchPO;
import com.bizvane.customized.facade.models.po.CusTeddyGoodsCodeDetailPO;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsCodeBatchQueryVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsCodeDetailQueryVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyPageQuery;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenSupport;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6cf0\u8fea\u718a\u5546\u54c1\u7801\u5e93CusTeddyGoodsCodeController"})
@RequestMapping(value={"/teddy/goodsCode"})
@RestController
public class CusTeddyGoodsCodeController {
    private static final Logger log = LoggerFactory.getLogger(CusTeddyGoodsCodeController.class);
    private static final String LOCK_KEY = "teddyGoodsVerify_";
    @Autowired
    private CusTeddyGoodsCodeService cusTeddyGoodsCodeService;
    @Autowired
    private RedissonTemplate redissonTemplate;
    @Autowired
    private HttpServletRequest request;

    @ApiOperation(value="\u5546\u54c1\u7801\u5e93\u6279\u6b21\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/queryBatchPage"})
    public ResponseData<PageInfo<CusTeddyGoodsCodeBatchPO>> queryBatchPage(CusTeddyGoodsCodeBatchQueryVo queryVo, CusTeddyPageQuery pageQuery) {
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)this.request);
        return new ResponseData((Object)this.cusTeddyGoodsCodeService.queryBatchPage(queryVo, pageQuery, currentUser));
    }

    @ApiOperation(value="\u5546\u54c1\u7801\u521b\u5efa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="skuCode", value="sku\u7f16\u53f7", required=true, dataType="String"), @ApiImplicitParam(name="codeCount", value="\u751f\u6210\u4e2a\u6570", required=true, dataType="Integer")})
    @PostMapping(value={"/add"})
    public ResponseData add(CusTeddyGoodsCodeBatchPO batchPO) {
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)this.request);
        try {
            this.cusTeddyGoodsCodeService.add(batchPO, currentUser);
        }
        catch (Exception e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return new ResponseData("\u6dfb\u52a0\u521b\u5efa\u4efb\u52a1\u6210\u529f", null);
    }

    @ApiOperation(value="\u5546\u54c1\u7801\u5bfc\u51fa-\u6309\u6279\u6b21\u53f7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="batchNo", value="\u6279\u6b21\u53f7", required=true, dataType="String")})
    @PostMapping(value={"/exportByBatchNo"})
    public ResponseData exportByBatchNo(@RequestParam String batchNo) {
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)this.request);
        try {
            CusTeddyGoodsCodeDetailQueryVo queryVo = new CusTeddyGoodsCodeDetailQueryVo();
            queryVo.setBatchNo(batchNo);
            this.cusTeddyGoodsCodeService.exportCodeDetailTxt(queryVo, currentUser);
        }
        catch (Exception e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return new ResponseData("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f", null);
    }

    @ApiOperation(value="\u5546\u54c1\u7801\u5bfc\u51fa-\u6309\u67e5\u8be2\u6761\u4ef6")
    @PostMapping(value={"/export"})
    public ResponseData export(CusTeddyGoodsCodeDetailQueryVo queryVo) {
        try {
            SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)this.request);
            this.cusTeddyGoodsCodeService.exportCodeDetailTxt(queryVo, currentUser);
        }
        catch (Exception e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return new ResponseData("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f", null);
    }

    @ApiOperation(value="\u5546\u54c1\u7801\u91cd\u65b0\u751f\u6210")
    @ApiImplicitParams(value={@ApiImplicitParam(name="batchNo", value="\u6279\u6b21\u53f7", required=true, dataType="String")})
    @PostMapping(value={"/repeat"})
    public ResponseData repeat(@RequestParam String batchNo) {
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)this.request);
        try {
            this.cusTeddyGoodsCodeService.repeat(batchNo, currentUser);
        }
        catch (Exception e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return new ResponseData("\u6dfb\u52a0\u91cd\u65b0\u751f\u6210\u4efb\u52a1\u6210\u529f", null);
    }

    @ApiOperation(value="\u5546\u54c1\u7801\u5e93\u660e\u7ec6\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/queryDetailPage"})
    public ResponseData<PageInfo<CusTeddyGoodsCodeDetailPO>> queryDetailPage(CusTeddyGoodsCodeDetailQueryVo queryVo, CusTeddyPageQuery pageQuery) {
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)this.request);
        return new ResponseData((Object)this.cusTeddyGoodsCodeService.queryDetailPage(queryVo, pageQuery, currentUser));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TokenSupport(sysCompanyId="${teddy.sysCompanyId}")
    @ApiOperation(value="\u5546\u54c1\u7801\u6821\u9a8c", notes="\u5546\u54c1\u7801\u6821\u9a8c")
    @PostMapping(value={"verify"})
    public ResponseData verify(@RequestBody CusTeddyGoodsVo cusTeddyGoodsVo) {
        log.info("\u5546\u54c1\u7801\u6821\u9a8c.verify-->cusTeddyGoodsVo:{}", (Object)JSON.toJSONString((Object)cusTeddyGoodsVo));
        String key = LOCK_KEY + cusTeddyGoodsVo.getCode();
        this.redissonTemplate.getRLock(key, 60L, TimeUnit.SECONDS);
        log.info("key:{}", (Object)key);
        try {
            this.cusTeddyGoodsCodeService.verify(cusTeddyGoodsVo);
        }
        catch (Exception e) {
            log.error("goods verify error", (Throwable)e);
            ResponseData responseData = ResponseDataUtil.getFailedData(null, (String)e.getMessage());
            return responseData;
        }
        finally {
            this.redissonTemplate.getRUnLook(key);
        }
        return new ResponseData((Object)"\u4fe1\u606f\u8865\u767b\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u7801\u4fe1\u606f", notes="\u6839\u636ecode\u67e5\u8be2\u5546\u54c1\u7801\u4fe1\u606f")
    @PostMapping(value={"detail"})
    public ResponseData<CusTeddyGoodsCodeDetailPO> detail(@RequestBody CusTeddyGoodsVo cusTeddyGoodsVo) {
        log.info("\u6839\u636e\u5546\u54c1\u7801\u67e5\u8be2\u5546\u54c1\u4fe1\u606f.detail-->cusTeddyGoodsVo:{}", (Object)JSON.toJSONString((Object)cusTeddyGoodsVo));
        try {
            CusTeddyGoodsCodeDetailPO detailPO = this.cusTeddyGoodsCodeService.detail(cusTeddyGoodsVo);
            return new ResponseData((Object)detailPO);
        }
        catch (Exception e) {
            log.error("goods detail error", (Throwable)e);
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
    }
}

