/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.store361.service.MbrFrozenRecordService;
import com.bizvane.customized.facade.constants.MbrFrozenRecordConstants;
import com.bizvane.customized.facade.enums.MbrFrozenEnum;
import com.bizvane.customized.facade.models.bo.cus361.MQMbrConsumeDTO;
import com.bizvane.customized.facade.models.vo.CusMbrFrozenRecordVo;
import com.bizvane.customized.facade.utils.UUIDUtil;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.vo.BatchUpdateMemberInfoVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="tso_mbr_auto_frozen")
public class MQMbrFrozenConsumeImpl
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(MQMbrFrozenConsumeImpl.class);
    @Autowired
    private MbrFrozenRecordService mbrFrozenRecordService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    RedissonTemplate redissonTemplate;
    public static final Integer WEEK = 1;
    public static final Integer MONTH = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ConsumerMessage<String> consumerMessage) {
        String message = (String)consumerMessage.getMessage();
        log.info("\u4f1a\u5458\u81ea\u52a8\u51bb\u7ed3topic:tso_mbr_auto_frozen,\u6d88\u8d39\u5185\u5bb9\uff1a{}", (Object)message);
        MQMbrConsumeDTO messageDTO = (MQMbrConsumeDTO)JacksonUtil.json2Objs((String)message, MQMbrConsumeDTO.class);
        try {
            this.redissonTemplate.getRLock(messageDTO.getMemberCode(), 1L, TimeUnit.MINUTES);
            this.consumeMessage(messageDTO);
        }
        catch (Exception e) {
            log.error("\u4f1a\u5458\u81ea\u52a8\u51bb\u7ed3\u51fa\u73b0\u5f02\u5e38!" + e);
        }
        finally {
            this.redissonTemplate.getRUnLook(messageDTO.getMemberCode());
        }
    }

    private void consumeMessage(MQMbrConsumeDTO messageDTO) {
        ResponseData responseData = this.getMemberInfo(messageDTO);
        if (null == responseData.getData() || SysResponseEnum.SUCCESS.getCode() != responseData.getCode()) {
            log.info("\u672a\u67e5\u8be2\u5230\u8be5\u4f1a\u5458!");
            return;
        }
        CusMbrFrozenRecordVo cusMbrFrozenRecordVo = new CusMbrFrozenRecordVo();
        cusMbrFrozenRecordVo.setMemberCode(messageDTO.getMemberCode());
        cusMbrFrozenRecordVo.setSysCompanyId(messageDTO.getSysCompanyId());
        cusMbrFrozenRecordVo.setCardNo(((MemberInfoModel)responseData.getData()).getCardNo());
        ResponseData whitelist = this.mbrFrozenRecordService.existWhitelist(cusMbrFrozenRecordVo);
        if (MbrFrozenRecordConstants.WHITELIST_Y.equals(whitelist.getData())) {
            log.info("\u8be5\u4f1a\u5458\u5728\u767d\u540d\u5355\u5185,\u4e0d\u53ef\u51bb\u7ed3\uff01");
            return;
        }
        StringBuilder sb = new StringBuilder();
        String frozenReason = "";
        String frozenDetail = "";
        if (messageDTO.getUnit() != null && messageDTO.getUnit().equals(WEEK)) {
            if (messageDTO.getStoreIntegralKey() > 0) {
                frozenReason = MbrFrozenEnum.WEEK_INTEGRAL.getMsg();
                frozenDetail = sb.append(messageDTO.getStoreName()).append("\u5e97\u94fa\u6d88\u8d39").append(messageDTO.getStoreIntegralKey()).append("\u79ef\u5206").toString();
            }
            if (messageDTO.getStoreConsumeNumber() != null && messageDTO.getStoreConsumeNumber() > 0) {
                frozenReason = MbrFrozenEnum.WEEK_CONSUME.getMsg();
                frozenDetail = sb.append(messageDTO.getStoreName()).append("\u5e97\u94fa\u6d88\u8d39").append(messageDTO.getStoreConsumeNumber()).append("\u6b21").toString();
            }
            if (messageDTO.getAreaIntegralKey() != null && messageDTO.getAreaIntegralKey() > 0) {
                frozenReason = MbrFrozenEnum.WEEK_AREA_INTEGRAL.getMsg();
                frozenDetail = sb.append(messageDTO.getAreaName()).append("\u533a\u57df\u6d88\u8d39").append(messageDTO.getAreaIntegralKey()).append("\u79ef\u5206").toString();
            }
            if (messageDTO.getAreaConsumeNumber() != null && messageDTO.getAreaConsumeNumber() > 0) {
                frozenReason = MbrFrozenEnum.WEEK_AREA_CONSUME.getMsg();
                frozenDetail = sb.append(messageDTO.getAreaName()).append("\u533a\u57df\u6d88\u8d39").append(messageDTO.getAreaConsumeNumber()).append("\u6b21").toString();
            }
        }
        if (messageDTO.getUnit() != null && messageDTO.getUnit().equals(MONTH)) {
            if (messageDTO.getStoreIntegralKey() != null && messageDTO.getStoreIntegralKey() > 0) {
                frozenReason = MbrFrozenEnum.MONTH_INTEGRAL.getMsg();
                frozenDetail = sb.append(messageDTO.getStoreName()).append("\u5e97\u94fa\u6d88\u8d39").append(messageDTO.getStoreIntegralKey()).append("\u79ef\u5206").toString();
            }
            if (messageDTO.getStoreConsumeNumber() != null && messageDTO.getStoreConsumeNumber() > 0) {
                frozenReason = MbrFrozenEnum.MONTH_CONSUME.getMsg();
                frozenDetail = sb.append(messageDTO.getStoreName()).append("\u5e97\u94fa\u6d88\u8d39").append(messageDTO.getStoreConsumeNumber()).append("\u6b21").toString();
            }
            if (messageDTO.getAreaIntegralKey() != null && messageDTO.getAreaIntegralKey() > 0) {
                frozenReason = MbrFrozenEnum.MONTH_AREA_INTEGRAL.getMsg();
                frozenDetail = sb.append(messageDTO.getAreaName()).append("\u533a\u57df\u6d88\u8d39").append(messageDTO.getAreaIntegralKey()).append("\u79ef\u5206").toString();
            }
            if (messageDTO.getAreaConsumeNumber() != null && messageDTO.getAreaConsumeNumber() > 0) {
                frozenReason = MbrFrozenEnum.MONTH_AREA_CONSUME.getMsg();
                frozenDetail = sb.append(messageDTO.getAreaName()).append("\u533a\u57df\u6d88\u8d39").append(messageDTO.getAreaConsumeNumber()).append("\u6b21").toString();
            }
        }
        cusMbrFrozenRecordVo.setFrozenType(MbrFrozenEnum.getMsg((String)frozenReason).getCode());
        cusMbrFrozenRecordVo.setFrozenDetail(frozenDetail);
        cusMbrFrozenRecordVo.setStatus(MbrFrozenRecordConstants.STATUS_N);
        cusMbrFrozenRecordVo.setWhiteList(MbrFrozenRecordConstants.WHITELIST_N);
        cusMbrFrozenRecordVo.setFrozenRecord(UUIDUtil.getUUID16());
        this.getMbrInfo(cusMbrFrozenRecordVo, responseData);
        this.getTime(cusMbrFrozenRecordVo);
        try {
            cusMbrFrozenRecordVo.setCreateUserName("\u7cfb\u7edf\u64cd\u4f5c");
            this.mbrFrozenRecordService.addRecord(cusMbrFrozenRecordVo);
            BatchUpdateMemberInfoVo batchUpdateMemberInfoVo = this.fullDate(cusMbrFrozenRecordVo.getSysCompanyId(), cusMbrFrozenRecordVo);
            responseData = this.memberInfoApiService.batchUpdateMemberValid(batchUpdateMemberInfoVo);
            if (responseData != null && SysResponseEnum.SUCCESS.getCode() == responseData.getCode()) {
                log.info("\u4f1a\u5458\u51bb\u7ed3\u6210\u529f\uff01");
            }
        }
        catch (MemberException e) {
            log.error("\u4f1a\u5458\u51bb\u7ed3\u5f02\u5e38:{}" + (Object)((Object)e));
        }
    }

    private BatchUpdateMemberInfoVo fullDate(Long sysCompanyId, CusMbrFrozenRecordVo recordVo) {
        BatchUpdateMemberInfoVo batchUpdateMemberInfoVo = new BatchUpdateMemberInfoVo();
        batchUpdateMemberInfoVo.setSysCompanyId(sysCompanyId);
        ArrayList<MemberInfoModel> list = new ArrayList<MemberInfoModel>();
        MemberInfoModel model = new MemberInfoModel();
        model.setSysCompanyId(sysCompanyId);
        model.setMemberCode(recordVo.getMemberCode());
        model.setPhone(recordVo.getPhone());
        model.setCardNo(recordVo.getCardNo());
        model.setCardUseStatus(Integer.valueOf(1));
        list.add(model);
        batchUpdateMemberInfoVo.setList(list);
        return batchUpdateMemberInfoVo;
    }

    private ResponseData<MemberInfoModel> getMemberInfo(MQMbrConsumeDTO messageDTO) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(messageDTO.getMemberCode());
        return this.memberInfoApiService.memberInfoAndStoreInfo(memberInfoModel);
    }

    private void getTime(CusMbrFrozenRecordVo cusMbrFrozenRecordVo) {
        Date nowTime = new Date();
        cusMbrFrozenRecordVo.setFrozenDate(nowTime);
        cusMbrFrozenRecordVo.setCreateDate(nowTime);
        cusMbrFrozenRecordVo.setModifiedDate(nowTime);
    }

    private void getMbrInfo(CusMbrFrozenRecordVo cusMbrFrozenRecordVo, ResponseData<MemberInfoModel> responseData) {
        MemberInfoModel mbrModel = (MemberInfoModel)responseData.getData();
        cusMbrFrozenRecordVo.setSysBrandId(mbrModel.getBrandId());
        cusMbrFrozenRecordVo.setErpId(mbrModel.getErpId());
        cusMbrFrozenRecordVo.setPhone(mbrModel.getPhone());
        cusMbrFrozenRecordVo.setCardNo(mbrModel.getCardNo());
        cusMbrFrozenRecordVo.setName(mbrModel.getName());
        cusMbrFrozenRecordVo.setServiceStoreName(mbrModel.getServiceGuideName());
        cusMbrFrozenRecordVo.setServiceStoreCode(mbrModel.getServiceStoreCode());
        cusMbrFrozenRecordVo.setLevelCode(String.valueOf(mbrModel.getLevelId()));
        cusMbrFrozenRecordVo.setLevelName(mbrModel.getLevelName());
    }
}

