/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.common.constants.SysResponseEnum;
import com.bizvane.customized.company.store361.service.IntegralCalculationRuleConfigurationService;
import com.bizvane.customized.facade.models.po.Cus361PonitsCalculationConfigurationPO;
import com.bizvane.customized.facade.models.po.Cus361PonitsCalculationConfigurationPOExample;
import com.bizvane.customized.mappers.Cus361PonitsCalculationConfigurationPOMapper;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegralCalculationRuleConfigurationServiceImpl
implements IntegralCalculationRuleConfigurationService {
    @Autowired
    private Cus361PonitsCalculationConfigurationPOMapper cus361PonitsCalculationConfigurationPOMapper;

    public ResponseData saveIntegralCalculationRuleConfiguration(Cus361PonitsCalculationConfigurationPO cus361PonitsCalculationConfigurationPO) {
        int count;
        ResponseData result = new ResponseData();
        JSONArray discountStoreGroupArray = JSONObject.parseArray((String)cus361PonitsCalculationConfigurationPO.getDiscountStoreGroup());
        if (this.checkDistCountRepeat(discountStoreGroupArray).booleanValue()) {
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage(SysResponseEnum.REDUPLICATE_STORE.getMessage());
            return result;
        }
        HashMap discountStoreGroupMap = this.checkDiscountStoreGroup(discountStoreGroupArray);
        String distCount = (String)discountStoreGroupMap.get("distCount");
        String discountStoreGroupCode = (String)discountStoreGroupMap.get("discountStoreGroupCode");
        if (StringUtils.isNotEmpty((String)distCount) && StringUtils.isNotEmpty((String)discountStoreGroupCode)) {
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage(SysResponseEnum.REDUPLICATE_STORE.getMessage() + "\u8be5\u7fa4\u7ec4\u5df2\u5728\u6298\u6263\u4e3a:" + distCount + "\u4e2d\u5b58\u5728");
            return result;
        }
        String levelCodes = cus361PonitsCalculationConfigurationPO.getLevelCodes();
        if (StringUtils.isEmpty((String)levelCodes)) {
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return result;
        }
        if ("1".equals(cus361PonitsCalculationConfigurationPO.getIsIntegralRatio())) {
            JSONArray integtalRatios = JSONArray.parseArray((String)cus361PonitsCalculationConfigurationPO.getIntegralRatios());
            if (this.checkIsZero(integtalRatios).booleanValue()) {
                result.setCode(SysResponseEnum.FAILED.getCode());
                result.setMessage(SysResponseEnum.RATIOS_NOT_ZERO.getMessage());
                return result;
            }
            if (this.checkIntegtalRatiosRepeat(integtalRatios).booleanValue()) {
                result.setCode(SysResponseEnum.FAILED.getCode());
                result.setMessage(SysResponseEnum.REDUPLICATE_INTEGRARATIO.getMessage());
                return result;
            }
        }
        if ((count = this.cus361PonitsCalculationConfigurationPOMapper.insert(cus361PonitsCalculationConfigurationPO)) > 0) {
            result.setMessage(SysResponseEnum.SUCCESS.getMessage());
            result.setCode(SysResponseEnum.SUCCESS.getCode());
        } else {
            result.setMessage(SysResponseEnum.FAILED.getMessage());
            result.setCode(SysResponseEnum.FAILED.getCode());
        }
        return result;
    }

    public ResponseData<Cus361PonitsCalculationConfigurationPO> queryIntegralCalculationRuleConfiguration(Long sys_company_id, Long sys_brand_id) {
        ResponseData responseData = new ResponseData();
        Cus361PonitsCalculationConfigurationPOExample example = new Cus361PonitsCalculationConfigurationPOExample();
        example.setOrderByClause("create_date desc");
        example.createCriteria().andBrandIdEqualTo(sys_brand_id).andSysCompanyIdEqualTo(sys_company_id);
        List resultList = this.cus361PonitsCalculationConfigurationPOMapper.selectByExample(example);
        if (resultList.size() > 0) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData(resultList.get(0));
        } else {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)new Cus361PonitsCalculationConfigurationPO());
        }
        return responseData;
    }

    private Boolean checkRepeat(String[] array) {
        HashSet<String> set = new HashSet<String>();
        for (String str : array) {
            set.add(str);
        }
        if (set.size() != array.length) {
            return true;
        }
        return false;
    }

    private Boolean checkIsZero(JSONArray array) {
        Boolean flag = false;
        for (Object obj : array) {
            JSONObject jsonObject = (JSONObject)obj;
            BigDecimal ratio = jsonObject.getBigDecimal("ratio");
            if (ratio.compareTo(new BigDecimal(0)) != 0 && ratio.compareTo(new BigDecimal(0)) != -1) continue;
            flag = true;
        }
        return flag;
    }

    private Boolean checkIntegtalRatiosRepeat(JSONArray array) {
        Boolean flag = false;
        HashSet<String> set = new HashSet<String>();
        for (Object obj : array) {
            JSONObject jsonObject = (JSONObject)obj;
            String levelCode = jsonObject.getString("levelCode");
            if (set.contains(levelCode)) {
                flag = true;
                continue;
            }
            set.add(levelCode);
        }
        return flag;
    }

    private Boolean checkDistCountRepeat(JSONArray array) {
        Boolean flag = false;
        HashSet<String> set = new HashSet<String>();
        for (Object obj : array) {
            JSONObject jsonObject = (JSONObject)obj;
            String distcount = jsonObject.getString("distCount");
            if (set.contains(distcount)) {
                flag = true;
                continue;
            }
            set.add(distcount);
        }
        return flag;
    }

    private HashMap<String, String> checkDiscountStoreGroup(JSONArray array) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < array.size(); ++i) {
            String[] discountStoreGroupCodeList;
            JSONObject object = array.getJSONObject(i);
            String distCount = object.getString("distCount");
            String discountStoreGroupCode = object.getString("discountStoreGroupCode");
            for (String storeGroupCode : discountStoreGroupCodeList = discountStoreGroupCode.split(",")) {
                if (set.contains(storeGroupCode)) {
                    result.put("distCount", distCount);
                    result.put("discountStoreGroupCode", storeGroupCode);
                    return result;
                }
                set.add(storeGroupCode);
            }
        }
        return result;
    }
}

