/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.org.apache.commons.codec.binary.Base64;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.store361.cus361utils.Cus361ResponseConfig;
import com.bizvane.customized.company.store361.service.Cus361ResponseFailedDataService;
import com.bizvane.customized.facade.models.po.Cus361FailedBatchDataPO;
import com.bizvane.customized.facade.models.vo.Cus361AreaFailedListVo;
import com.bizvane.customized.facade.models.vo.Cus361AreaFailedVo;
import com.bizvane.customized.facade.models.vo.Cus361ChannelFailedListVo;
import com.bizvane.customized.facade.models.vo.Cus361ChannelFailedVo;
import com.bizvane.customized.facade.models.vo.Cus361ResponseStoreFailedListVo;
import com.bizvane.customized.facade.models.vo.Cus361ResponseStoreFailedVo;
import com.bizvane.customized.mappers.Cus361FailedBatchDataPOMapper;
import com.bizvane.utils.commonutils.HttpUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class Cus361ResponseFailedDataServiceImpl
implements Cus361ResponseFailedDataService {
    private static final Logger log = LoggerFactory.getLogger(Cus361ResponseFailedDataServiceImpl.class);
    @Value(value="${cus361response.userName}")
    public String userName;
    @Value(value="${cus361response.password}")
    public String password;
    @Autowired
    Cus361FailedBatchDataPOMapper cus361FailedBatchDataPOMapper;
    @Autowired
    Cus361ResponseConfig cus361ResponseConfig;
    private String channelType = "10";
    private String areaType = "20";
    private String storeType = "30";

    public void get361ChannelFailedData(String batchNo) {
        log.info("Cus361ResponseFailedDataServiceImpl get361ChannelFailedData start param:{}", (Object)batchNo);
        Cus361ChannelFailedListVo listVo = new Cus361ChannelFailedListVo();
        ArrayList<Cus361ChannelFailedVo> channelFailedList = new ArrayList<Cus361ChannelFailedVo>();
        String channelUrl = this.cus361ResponseConfig.getChannelUrl();
        List channelList = this.cus361FailedBatchDataPOMapper.queryFailedData(this.channelType, batchNo);
        if (null == channelList || channelList.size() == 0) {
            log.info("Cus361ResponseFailedDataServiceImpl query channel data according to batchNo is empty");
            return;
        }
        for (int j = 0; j < channelList.size(); ++j) {
            Cus361ChannelFailedVo channelFailedVo = new Cus361ChannelFailedVo();
            channelFailedVo.setSapCustomerCode(((Cus361FailedBatchDataPO)channelList.get(j)).getErrorPk());
            channelFailedVo.setType("E");
            channelFailedVo.setMessage(((Cus361FailedBatchDataPO)channelList.get(j)).getErrorReason());
            channelFailedList.add(channelFailedVo);
        }
        listVo.setRequestBatchNo(batchNo);
        listVo.setItem(channelFailedList);
        log.info("Cus361ResponseFailedDataServiceImpl get361ChannelBatchFailedData param:{}", (Object)JacksonUtil.bean2Json((Object)listVo));
        this.responseFailedData(channelUrl, JSON.toJSONString((Object)listVo));
        Cus361ResponseFailedDataServiceImpl.updateStatus((String)batchNo, (Cus361FailedBatchDataPOMapper)this.cus361FailedBatchDataPOMapper, (String)this.channelType);
    }

    public void get361AreaFailedData(String batchNo) {
        log.info("Cus361ResponseFailedDataServiceImpl get361AreaFailedData start param:{}", (Object)batchNo);
        Cus361AreaFailedListVo listVo = new Cus361AreaFailedListVo();
        ArrayList<Cus361AreaFailedVo> areaFailedList = new ArrayList<Cus361AreaFailedVo>();
        String areaUrl = this.cus361ResponseConfig.getAreaUrl();
        List areaList = this.cus361FailedBatchDataPOMapper.queryFailedData(this.areaType, batchNo);
        if (null == areaList || areaList.size() == 0) {
            log.info("Cus361ResponseFailedDataServiceImpl query area data according to batchNo is empty");
            return;
        }
        for (int j = 0; j < areaList.size(); ++j) {
            Cus361AreaFailedVo areaFailedVo = new Cus361AreaFailedVo();
            areaFailedVo.setAreaCode(((Cus361FailedBatchDataPO)areaList.get(j)).getErrorPk());
            areaFailedVo.setType("E");
            areaFailedVo.setMessage(((Cus361FailedBatchDataPO)areaList.get(j)).getErrorReason());
            areaFailedList.add(areaFailedVo);
        }
        listVo.setRequestBatchNo(batchNo);
        listVo.setItem(areaFailedList);
        log.info("Cus361ResponseFailedDataServiceImpl get361AreaBatchFailedData param:{}", (Object)JacksonUtil.bean2Json((Object)listVo));
        this.responseFailedData(areaUrl, JSON.toJSONString((Object)listVo));
        Cus361ResponseFailedDataServiceImpl.updateStatus((String)batchNo, (Cus361FailedBatchDataPOMapper)this.cus361FailedBatchDataPOMapper, (String)this.areaType);
    }

    public void get361StoreFailedData(String batchNo) {
        log.info("Cus361ResponseFailedDataServiceImpl get361StoreFailedData start param:{}", (Object)batchNo);
        Cus361ResponseStoreFailedListVo listVo = new Cus361ResponseStoreFailedListVo();
        ArrayList<Cus361ResponseStoreFailedVo> storeFailedList = new ArrayList<Cus361ResponseStoreFailedVo>();
        String storeUrl = this.cus361ResponseConfig.getStoreUrl();
        List storeList = this.cus361FailedBatchDataPOMapper.queryFailedData(this.storeType, batchNo);
        if (null == storeList || storeList.size() == 0) {
            log.info("Cus361ResponseFailedDataServiceImpl query store data according to batchNo is empty");
            return;
        }
        for (int j = 0; j < storeList.size(); ++j) {
            Cus361ResponseStoreFailedVo storeFailedVo = new Cus361ResponseStoreFailedVo();
            storeFailedVo.setStoreCode(((Cus361FailedBatchDataPO)storeList.get(j)).getErrorPk());
            storeFailedVo.setType("E");
            storeFailedVo.setMessage(((Cus361FailedBatchDataPO)storeList.get(j)).getErrorReason());
            storeFailedList.add(storeFailedVo);
        }
        listVo.setRequestBatchNo(batchNo);
        listVo.setItem(storeFailedList);
        log.info("Cus361ResponseFailedDataServiceImpl get361StoreBatchFailedData param:{}", (Object)JacksonUtil.bean2Json((Object)listVo));
        this.responseFailedData(storeUrl, JSON.toJSONString((Object)listVo));
        Cus361ResponseFailedDataServiceImpl.updateStatus((String)batchNo, (Cus361FailedBatchDataPOMapper)this.cus361FailedBatchDataPOMapper, (String)this.storeType);
    }

    private void responseFailedData(String url, String text) {
        JSONObject jsonObject = JSONObject.parseObject((String)text);
        String body = String.valueOf(jsonObject);
        HashMap<String, String> headers = new HashMap<String, String>();
        log.info("Cus361ResponseFailedDataServiceImpl responseFailedData param:{}", (Object)url);
        headers.put("Authorization", "Basic " + Base64.encodeBase64String((byte[])(this.userName + ":" + this.password).getBytes()));
        try {
            String result = HttpUtil.post((String)url, (String)body, headers, (int)10);
            System.out.println(result);
        }
        catch (IOException e) {
            log.info("Cus361ResponseFailedDataServiceImpl responseFailedData error:{}, param:{}", (Object)e, (Object)text);
            e.printStackTrace();
        }
    }

    private static void updateStatus(String batchNo, Cus361FailedBatchDataPOMapper cus361FailedBatchDataPOMapper, String type) {
        List callBackList = cus361FailedBatchDataPOMapper.queryFailedData(type, batchNo);
        for (int j = 0; j < callBackList.size(); ++j) {
            Cus361FailedBatchDataPO batchDataPO = (Cus361FailedBatchDataPO)callBackList.get(j);
            batchDataPO.setStatus("1");
            cus361FailedBatchDataPOMapper.updateByPrimaryKeySelective(batchDataPO);
        }
    }
}

