/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.icrm.RechargeCardListResponseVO;
import com.bizvane.connectorservice.entity.icrm.RechargeCardRecordListResponseVO;
import com.bizvane.connectorservice.entity.icrm.RechargeCardRecordRequestVO;
import com.bizvane.connectorservice.entity.icrm.RechargeCardRecordResponseVO;
import com.bizvane.connectorservice.entity.icrm.RechargeCardRequestVO;
import com.bizvane.connectorservice.entity.icrm.RechargeCardResponseVO;
import com.bizvane.connectorservice.interfaces.rpc.IcrmConnectorServiceFeign;
import com.bizvane.customized.common.constants.Cus361ResponseEnum;
import com.bizvane.customized.common.constants.SysResponseEnum;
import com.bizvane.customized.company.store361.service.Cus361RechargeService;
import com.bizvane.customized.facade.models.vo.Cus361RechargeCardListResponseVO;
import com.bizvane.customized.facade.models.vo.Cus361RechargeCardVO;
import com.bizvane.customized.facade.models.vo.Cus361RechargeInfoRequestVo;
import com.bizvane.customized.facade.models.vo.Cus361RechargeRecordListResponseVo;
import com.bizvane.customized.facade.models.vo.Cus361RechargeRecordRequestVo;
import com.bizvane.customized.facade.models.vo.Cus361RechargeRecordResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Cus361RechargeServiceImpl
implements Cus361RechargeService {
    private static final Logger log = LoggerFactory.getLogger(Cus361RechargeServiceImpl.class);
    @Autowired
    private IcrmConnectorServiceFeign icrmConnectorServiceFeign;

    public ResponseData<Cus361RechargeCardListResponseVO> getCardNoRechargeList(Cus361RechargeInfoRequestVo rechargeInfoVo) {
        log.info("enter getCardNoRechargeList request:" + JSON.toJSONString((Object)rechargeInfoVo));
        ResponseData responseData = new ResponseData();
        Cus361RechargeCardListResponseVO cus361RechargeCardListResponseVO = new Cus361RechargeCardListResponseVO();
        RechargeCardRequestVO rechargeCardRequestVO = new RechargeCardRequestVO();
        rechargeCardRequestVO.setPrepaid_card_code(rechargeInfoVo.getPetCard());
        rechargeCardRequestVO.setData(rechargeInfoVo.getCardNo());
        rechargeCardRequestVO.setBrandId(rechargeInfoVo.getBrandId());
        rechargeCardRequestVO.setPageNum(rechargeInfoVo.getPageNum());
        rechargeCardRequestVO.setPageSize(rechargeInfoVo.getPageSize());
        log.info("enter getCardNoRechargeList \u8c03\u7528connector request:" + JSON.toJSONString((Object)rechargeCardRequestVO));
        Result rechargeCard = this.icrmConnectorServiceFeign.getRechargeCard(rechargeCardRequestVO);
        log.info("enter getCardNoRechargeList \u8c03\u7528connector response:" + JSON.toJSONString((Object)rechargeCard));
        ArrayList<Cus361RechargeCardVO> list = new ArrayList<Cus361RechargeCardVO>();
        if (0 == rechargeCard.getCode()) {
            RechargeCardListResponseVO listResponseVO = (RechargeCardListResponseVO)rechargeCard.getData();
            for (RechargeCardResponseVO vo : listResponseVO.getRechargeCardResponseVOList()) {
                Cus361RechargeCardVO cus361RechargeCardVO = new Cus361RechargeCardVO();
                cus361RechargeCardVO.setBalance(vo.getSurplus_money());
                cus361RechargeCardVO.setIntegral(vo.getIntegral());
                cus361RechargeCardVO.setPassword(vo.getPassword());
                cus361RechargeCardVO.setPetCard(vo.getPrepaid_card_code());
                cus361RechargeCardVO.setName(vo.getName());
                list.add(cus361RechargeCardVO);
            }
            cus361RechargeCardListResponseVO.setCus361RechargeCardVOList(list);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)cus361RechargeCardListResponseVO);
            return responseData;
        }
        if (Cus361ResponseEnum.CUS_361_FAILED_GET_BATCH_NO.getCode() == rechargeCard.getCode().intValue()) {
            responseData.setCode(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
            responseData.setMessage(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return responseData;
    }

    public ResponseData<Cus361RechargeRecordListResponseVo> getRechargeRecordListByPetCard(Cus361RechargeRecordRequestVo rechargeRecordVo) {
        log.info("enter getRechargeRecordListByPetCard request:" + JSON.toJSONString((Object)rechargeRecordVo));
        ResponseData responseData = new ResponseData();
        Cus361RechargeRecordListResponseVo cus361RechargeRecordListResponseVo = new Cus361RechargeRecordListResponseVo();
        ArrayList<Cus361RechargeRecordResponseVo> list = new ArrayList<Cus361RechargeRecordResponseVo>();
        RechargeCardRecordRequestVO rechargeCardRecordRequestVO = new RechargeCardRecordRequestVO();
        rechargeCardRecordRequestVO.setBrandId(rechargeRecordVo.getBrandId());
        rechargeCardRecordRequestVO.setPrepaid_card_code(rechargeRecordVo.getPetCard());
        rechargeCardRecordRequestVO.setCardNo(rechargeRecordVo.getCardNo());
        rechargeCardRecordRequestVO.setNum(rechargeRecordVo.getNum());
        rechargeCardRecordRequestVO.setPageNum(rechargeRecordVo.getPageNum());
        log.info("enter getRechargeRecordListByPetCard request:" + JSON.toJSONString((Object)rechargeCardRecordRequestVO));
        Result rechargeCardRecord = this.icrmConnectorServiceFeign.getRechargeCardRecord(rechargeCardRecordRequestVO);
        log.info("enter getRechargeRecordListByPetCard response:" + JSON.toJSONString((Object)rechargeCardRecord));
        if (0 == rechargeCardRecord.getCode()) {
            RechargeCardRecordListResponseVO rechargeCardRecordListResponseVO = (RechargeCardRecordListResponseVO)rechargeCardRecord.getData();
            for (RechargeCardRecordResponseVO vo : rechargeCardRecordListResponseVO.getRechargeCardRecordResponseVOList()) {
                Cus361RechargeRecordResponseVo cus361RechargeRecordResponseVo = new Cus361RechargeRecordResponseVo();
                cus361RechargeRecordResponseVo.setBalance(vo.getMoney_after());
                cus361RechargeRecordResponseVo.setChangeBalance(vo.getMoney_change());
                cus361RechargeRecordResponseVo.setChangeTime(vo.getIs_add_time());
                cus361RechargeRecordResponseVo.setChangeType(vo.getChange_type());
                cus361RechargeRecordResponseVo.setPetCard(vo.getPcode());
                cus361RechargeRecordResponseVo.setBrandId(rechargeRecordVo.getBrandId());
                cus361RechargeRecordResponseVo.setIntegralChangeType(vo.getIntegral_type());
                cus361RechargeRecordResponseVo.setMoneyChangeType(vo.getMoney_type());
                list.add(cus361RechargeRecordResponseVo);
                cus361RechargeRecordListResponseVo.setBalance(vo.getMoney_after());
                cus361RechargeRecordListResponseVo.setPetCard(vo.getPcode());
            }
            cus361RechargeRecordListResponseVo.setCount(rechargeCardRecordListResponseVO.getCount());
            cus361RechargeRecordListResponseVo.setCus361RechargeRecordResponseVoList(list);
            cus361RechargeRecordListResponseVo.setCountPage(rechargeCardRecordListResponseVO.getCountPage());
            cus361RechargeRecordListResponseVo.setPageNum(rechargeCardRecordListResponseVO.getPageNum());
            cus361RechargeRecordListResponseVo.setNum(rechargeCardRecordListResponseVO.getNum());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)cus361RechargeRecordListResponseVo);
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        return responseData;
    }
}

