/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.icrm.DistributorRequestVO;
import com.bizvane.connectorservice.entity.icrm.DistributorResponseVO;
import com.bizvane.connectorservice.entity.icrm.StoreResponseVO;
import com.bizvane.connectorservice.interfaces.rpc.IcrmConnectorServiceFeign;
import com.bizvane.customized.company.store361.service.Cus361GetAllIcrmCodeService;
import com.bizvane.customized.facade.models.po.Cus361StoreCodeMappingPO;
import com.bizvane.customized.mappers.Cus361StoreCodeMappingPOMapper;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Cus361GetAllIcrmCodeServiceImpl
implements Cus361GetAllIcrmCodeService {
    private static final Logger log = LoggerFactory.getLogger(Cus361GetAllIcrmCodeServiceImpl.class);
    @Autowired
    IcrmConnectorServiceFeign icrmConnectorServiceFeign;
    @Autowired
    Cus361StoreCodeMappingPOMapper storeCodeMappingPOMapper;
    public static final String CODE_PARAM = "distributor_code,zipcode,store_code";

    public void getIcrmCode() {
        DistributorRequestVO vo = new DistributorRequestVO();
        vo.setFields(CODE_PARAM);
        vo.setBrandId(Long.valueOf(63L));
        try {
            log.info("\u8c03Icrm\u63a5\u53e3\u66f4\u65b0\u6620\u5c04\u8868\u4e2dIcrmCode");
            Result result = this.icrmConnectorServiceFeign.getDistributorList(vo);
            if (this.isResultFailed(result)) {
                return;
            }
            StoreResponseVO storeResponseVO = (StoreResponseVO)result.getData();
            Integer count = storeResponseVO.getCount();
            for (int i = 1; i <= count / 100 + 1; ++i) {
                vo = new DistributorRequestVO();
                vo.setFields(CODE_PARAM);
                vo.setNum("100");
                vo.setPageNum(String.valueOf(i));
                vo.setBrandId(Long.valueOf(63L));
                Result newResult = this.icrmConnectorServiceFeign.getDistributorList(vo);
                if (this.isResultFailed(newResult)) {
                    return;
                }
                storeResponseVO = (StoreResponseVO)newResult.getData();
                List codeList = storeResponseVO.getDistributorResponseVOList();
                if (codeList.size() == 0) {
                    log.info("Cus361GetAllIcrmCodeServiceImpl getIcrmCode method \u67e5\u4e0d\u5230\u6570\u636e");
                    return;
                }
                for (DistributorResponseVO responseVO : codeList) {
                    String icrmCode = responseVO.getDistributor_code();
                    String zipCode = responseVO.getZipcode();
                    String originStoreCode = responseVO.getStore_code();
                    log.info("Cus361GetAllIcrmCodeServiceImpl getIcrmCode param:{},{},{}", new Object[]{icrmCode, zipCode, originStoreCode});
                    int queryCount = this.storeCodeMappingPOMapper.queryCodeMapping(zipCode, originStoreCode);
                    Cus361StoreCodeMappingPO codeMappingPO = new Cus361StoreCodeMappingPO();
                    if (queryCount == 0) {
                        codeMappingPO.setIcrmCode(icrmCode);
                        codeMappingPO.setZipCode(zipCode);
                        codeMappingPO.setOriginStoreCode(originStoreCode);
                        codeMappingPO.setValid(Boolean.valueOf(true));
                        this.storeCodeMappingPOMapper.insertSelective(codeMappingPO);
                        continue;
                    }
                    int x = this.storeCodeMappingPOMapper.updateIcrmCode(zipCode, originStoreCode, icrmCode);
                    if (x == 0) {
                        log.info("getStoreCodeMappingByIcrm \u66f4\u65b0\u5931\u8d25 param\uff1a{},icrmCode:{},zipCode:{},originStoreCode:{}", new Object[]{new Date(), icrmCode, zipCode, originStoreCode});
                        continue;
                    }
                    log.info("\u66f4\u65b0\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isResultFailed(Result<StoreResponseVO> result) {
        if (result.getCode() == 100) {
            log.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
            return true;
        }
        return false;
    }
}

