/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.controller;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatenterprise.service.entity.po.WxqyStaffSyncLogPO;
import io.swagger.annotations.Api;
import java.util.HashMap;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test"})
@Api(value="\u6d4b\u8bd5\u7c7b\u63a7\u5236\u5668", tags={"\u6d4b\u8bd5\u7c7b\u63a7\u5236\u5668"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    RocketMQTemplate rocketMQTemplate;
    @Autowired
    StoreServiceRpc storeServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;

    @PostMapping(value={"/syncStore"})
    public ResponseData syncStore(@RequestParam(value="sysCompanyId") Long sysCompanyId, @RequestParam(value="storeOfflineCode") String storeOfflineCode) {
        long start = System.currentTimeMillis();
        log.info("[TestController-syncStore-info-],\u540c\u6b65\u5e97\u94fa\u5f00\u59cb:{}", (Object)start);
        SysStorePo sysStorePo = (SysStorePo)this.storeServiceRpc.getStoreByOfflineCode(storeOfflineCode, sysCompanyId).getData();
        log.info("[TestController-syncStore-info-],sendRequest:{}", (Object)JSONObject.toJSONString((Object)sysStorePo));
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("topic_361_customized_store_sync_message").build(), (Object)JSON.toJSONString((Object)sysStorePo));
        log.info("[TestController-syncStore-info-],sendResult:{}", (Object)JSONObject.toJSONString((Object)sendResult));
        long end = System.currentTimeMillis();
        log.info("[TestController-syncStore-info-],\u540c\u6b65\u5e97\u94fa\u7ed3\u675f,\u5171\u7528\u65f6:{}\u6beb\u79d2", (Object)(end - start));
        return new ResponseData();
    }

    @PostMapping(value={"/syncStaff"})
    public ResponseData syncStaff(@RequestParam(value="brandCode") String brandCode, @RequestParam(value="storeCode") String storeCode, @RequestParam(value="storeName") String storeName) {
        SysBrandPo brandPO = new SysBrandPo();
        brandPO.setBrandCode(brandCode);
        ResponseData brandResponse = this.brandServiceRpc.getBrandIdAndCompanyIdByCode(brandPO);
        if (brandResponse.getCode() != SysResponseEnum.SUCCESS.getCode() || brandResponse.getData() == null) {
            log.info("[TestController-syncStaff-info-],\u672a\u627e\u5230\u54c1\u724c:{}", (Object)brandCode);
            return new ResponseData();
        }
        brandPO = (SysBrandPo)brandResponse.getData();
        WxqyStaffSyncLogPO wxqyStaffSyncLogPO = new WxqyStaffSyncLogPO();
        wxqyStaffSyncLogPO.setSysCompanyId(brandPO.getSysCompanyId());
        wxqyStaffSyncLogPO.setSysBrandId(brandPO.getSysBrandId());
        wxqyStaffSyncLogPO.setSysBrandCode(brandCode);
        wxqyStaffSyncLogPO.setSyncType(Integer.valueOf(1));
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("storeCode", storeCode);
        infoMap.put("storeName", storeName);
        infoMap.put("message", "SAP\u64cd\u4f5c\u5173\u5e97,\u4e0d\u5141\u8bb8\u8c03\u7528CRM\u63a5\u53e3");
        wxqyStaffSyncLogPO.setLogInfo(JSON.toJSONString(infoMap));
        log.info("[TestController-syncStaff-info-],sendRequest:{}", (Object)JSON.toJSONString((Object)wxqyStaffSyncLogPO));
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("topic_361_staff_sync_log_message").build(), (Object)wxqyStaffSyncLogPO);
        log.info("[TestController-syncStaff-info-],sendResult:{}", (Object)JSON.toJSONString((Object)sendResult));
        return new ResponseData();
    }
}

