/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.company.store361.service.Cus361StoreGroupService;
import com.bizvane.customized.facade.models.bo.Cus361ChannelDataBo;
import com.bizvane.customized.facade.models.bo.Cus361DistributorDataBo;
import com.bizvane.customized.facade.models.bo.Cus361PrecinctAreaBo;
import com.bizvane.customized.facade.models.bo.Cus361SapAndCorpBo;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/storeGroup"})
public class Cus361StoreGroupController {
    private static final Logger log = LoggerFactory.getLogger(Cus361StoreGroupController.class);
    @Autowired
    Cus361StoreGroupService cus361StoreGroupService;

    @RequestMapping(value={"/getInfoByAreaCondition"}, method={RequestMethod.POST})
    ResponseData<Cus361PrecinctAreaBo> getInfoByAreaCondition(Cus361PrecinctAreaBo areaBo) {
        log.info("Cus361StoreGroupController getInfoByAreaCondition  param : {}", (Object)JSONObject.toJSONString((Object)areaBo));
        return this.cus361StoreGroupService.getInfoByAreaCondition(areaBo);
    }

    @RequestMapping(value={"/getInfoBySapCondition"}, method={RequestMethod.POST})
    ResponseData<Cus361ChannelDataBo> getInfoBySapCondition(Cus361ChannelDataBo sapBo, HttpServletRequest request) {
        SysAccountPO stageUser = null;
        try {
            stageUser = TokenUtils.getStageUser((HttpServletRequest)request);
        }
        catch (MemberException me) {
            log.info(me.getMessage());
            me.getStackTrace();
        }
        if (stageUser != null) {
            sapBo.setSysCompanyId(stageUser.getSysCompanyId());
        }
        log.info("Cus361StoreGroupController getInfoBySapCondition  param : {}", (Object)JSONObject.toJSONString((Object)sapBo));
        return this.cus361StoreGroupService.getInfoBySapCondition(sapBo);
    }

    @RequestMapping(value={"/getInfoByCorpCondition"}, method={RequestMethod.POST})
    ResponseData<Cus361DistributorDataBo> getInfoByCorpCondition(Cus361DistributorDataBo corpBo) {
        log.info("Cus361StoreGroupController getInfoByCorpCondition  param : {}", (Object)JSONObject.toJSONString((Object)corpBo));
        return this.cus361StoreGroupService.getInfoByCorpCondition(corpBo);
    }

    @PostMapping(value={"/get361CodeByStoreCode"})
    @ResponseBody
    ResponseData<Cus361SapAndCorpBo> get361CodeByStoreCode(@RequestParam(value="storeCode") String storeCode, @RequestParam(value="originStoreCode", required=false) String originStoreCode) {
        log.info("CusStoreFieldsController get361CodeByStoreOnlineCode param : {}", (Object)storeCode);
        return this.cus361StoreGroupService.get361CodeByStoreCode(storeCode, originStoreCode);
    }
}

