/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.controller;

import com.bizvane.customized.common.utils.HeadUtil;
import com.bizvane.customized.company.store361.service.Cus361Service;
import com.bizvane.customized.company.store361.service.Cus361StoreGroupService;
import com.bizvane.customized.facade.models.bo.Cus361SapAndCorpBo;
import com.bizvane.customized.facade.models.po.Cus361ChannelDataPO;
import com.bizvane.customized.facade.models.po.Cus361DistributorDataPo;
import com.bizvane.customized.facade.models.po.Cus361PrecinctAreaPO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(value="361")
@RequestMapping(value={"/store"})
@RestController
public class Cus361RpcController {
    private static final Logger log = LoggerFactory.getLogger(Cus361RpcController.class);
    @Autowired
    Cus361Service cus361Service;
    @Autowired
    Cus361StoreGroupService cus361StoreGroupService;
    private static final Logger logger = LoggerFactory.getLogger(Cus361RpcController.class);

    @PostMapping(value={"/channel"})
    @ResponseBody
    ResponseData addAndUpdate361ChannelData(@RequestBody String jsonStr, HttpServletRequest request) {
        logger.info("Cus361RpcController addAndUpdate361ChannelData method");
        Long corpId = HeadUtil.getCorpId((HttpServletRequest)request);
        return this.cus361Service.addAndUpdate361ChannelData(jsonStr, corpId);
    }

    @PostMapping(value={"/area"})
    @ResponseBody
    ResponseData addAndUpdate361PrecinctArea(@RequestBody String jsonStr, HttpServletRequest request) {
        logger.info("Cus361RpcController addAndUpdate361PrecinctArea method");
        Long corpId = HeadUtil.getCorpId((HttpServletRequest)request);
        return this.cus361Service.addAndUpdate361PrecinctArea(jsonStr, corpId);
    }

    @PostMapping(value={"/sync"})
    @ResponseBody
    ResponseData addAndUpdateStoreFieldsInfo(@RequestBody String jsonStr) {
        logger.info("CusStoreFieldsController addAndUpdateStoreFieldsInfo method");
        return this.cus361Service.addAndUpdateStoreFieldsInfo(jsonStr);
    }

    @RequestMapping(value={"/getAreaCode"}, method={RequestMethod.POST})
    ResponseData<Cus361PrecinctAreaPO> getPrecinctArea(@RequestParam(value="areaCode") String areaCode) {
        log.info("CusStoreFieldsController getPrecinctArea param : {}", (Object)areaCode);
        return this.cus361StoreGroupService.getPrecinctArea(areaCode);
    }

    @RequestMapping(value={"/getSapCode"}, method={RequestMethod.POST})
    ResponseData<Cus361ChannelDataPO> getSapCode(@RequestParam(value="sapCode") String sapCode) {
        log.info("CusStoreFieldsController getSapCode param : {}", (Object)sapCode);
        return this.cus361StoreGroupService.getSapCode(sapCode);
    }

    @RequestMapping(value={"/getCorpCode"}, method={RequestMethod.POST})
    ResponseData<Cus361DistributorDataPo> getCorpCode(@RequestParam(value="corpCode") String corpCode) {
        log.info("CusStoreFieldsController getCorpCode param : {}", (Object)corpCode);
        return this.cus361StoreGroupService.getCorpCode(corpCode);
    }

    @RequestMapping(value={"/select361OrderIntegral"}, method={RequestMethod.POST})
    public ResponseData<Integer> select361OrderIntegral(@RequestParam(value="sysCompanyId") Long sysCompanyId, @RequestParam(value="orderNo") String orderNo) {
        ResponseData responseData = new ResponseData();
        Integer integral = this.cus361Service.select361OrderIntegral(sysCompanyId, orderNo);
        integral = integral == null ? 0 : integral;
        responseData.setData((Object)integral);
        return responseData;
    }

    @RequestMapping(value={"/get361ByStoreCode"}, method={RequestMethod.POST})
    ResponseData<Cus361SapAndCorpBo> get361ByStoreCode(@RequestParam(value="storeCode") String storeCode) {
        log.info("CusStoreFieldsController get361CodeByStoreOnlineCode param : {}", (Object)storeCode);
        return this.cus361StoreGroupService.get361CodeByStoreCode(storeCode, null);
    }
}

