/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.standard.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.core.facade.interfaces.CoreTraceFeign;
import com.bizvane.core.facade.models.po.TracePO;
import com.bizvane.customized.common.constants.MemberDistributionResponseEnum;
import com.bizvane.customized.common.system.RedisManager;
import com.bizvane.customized.common.thread.ThreadPool;
import com.bizvane.customized.common.utils.CommonExportExcelUtil;
import com.bizvane.customized.common.utils.DateUtil;
import com.bizvane.customized.common.utils.DownLoadFileUtil;
import com.bizvane.customized.common.utils.ExportExcelUtil;
import com.bizvane.customized.common.utils.FileNameUtil;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.QiNiuConfig;
import com.bizvane.customized.common.utils.QiNiuUtil;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.common.utils.ResponseUtil;
import com.bizvane.customized.common.utils.StreamingExportExcelPageInfoUtilForStorage;
import com.bizvane.customized.common.utils.StreamingExportExcelUtil;
import com.bizvane.customized.common.utils.UUIDGenerator;
import com.bizvane.customized.company.standard.service.MemberDistributionService;
import com.bizvane.customized.company.ur.members.service.StorageCardService;
import com.bizvane.customized.facade.models.po.CusDistributionExchangePO;
import com.bizvane.customized.facade.models.po.CusDistributionPO;
import com.bizvane.customized.facade.models.po.CusDistributionPOExample;
import com.bizvane.customized.facade.models.po.CusDistributionRecordPO;
import com.bizvane.customized.facade.models.po.CusDistributionRegxPO;
import com.bizvane.customized.facade.models.po.CusDistributionTaskDetailPO;
import com.bizvane.customized.facade.models.vo.CusDistributionVO;
import com.bizvane.customized.facade.models.vo.DistributionMemeberResVo;
import com.bizvane.customized.facade.models.vo.DistributionVo;
import com.bizvane.customized.facade.models.vo.MemberDistributionPageVo;
import com.bizvane.customized.facade.models.vo.MemberDistributionRegxVo;
import com.bizvane.customized.facade.models.vo.MemberDistributionShareVo;
import com.bizvane.customized.facade.models.vo.MemberDistributionVo;
import com.bizvane.customized.facade.models.vo.SubordinateMemeberResVo;
import com.bizvane.customized.mappers.CusDistributionExchangePOMapper;
import com.bizvane.customized.mappers.CusDistributionPOMapper;
import com.bizvane.customized.mappers.CusDistributionRecordPOMapper;
import com.bizvane.customized.mappers.CusDistributionRegxPOMapper;
import com.bizvane.customized.mappers.CusDistributionTaskDetailPOMapper;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.DistributionMemberApiService;
import com.bizvane.members.facade.service.api.IntegralChangeApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.members.facade.service.ur.UrMemberApiService;
import com.bizvane.members.facade.ur.vo.MemberRequestCardNoVo;
import com.bizvane.members.facade.ur.vo.MemberResponseCardNoVo;
import com.bizvane.members.facade.ur.vo.MembersEsRequestVo;
import com.bizvane.members.facade.ur.vo.MembersEsResponseVo;
import com.bizvane.members.facade.utils.DesensitizeUtil;
import com.bizvane.members.facade.vo.DistributionMemberRequestVo;
import com.bizvane.members.facade.vo.DistributionMemberResponseVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.wechatfacade.interfaces.QRCodeServiceFeign;
import com.bizvane.wechatfacade.models.vo.CreateMiniprgmQRCodeRequestVO;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Service
public class MemberDistributionServiceImpl
implements MemberDistributionService {
    private static final Logger log = LoggerFactory.getLogger(MemberDistributionServiceImpl.class);
    @Autowired
    private CusDistributionRegxPOMapper cusDistributionRegxPOMapper;
    @Autowired
    private CusDistributionPOMapper cusDistributionPOMapper;
    @Autowired
    private CusDistributionExchangePOMapper cusDistributionExchangePOMapper;
    @Autowired
    private CusDistributionRecordPOMapper cusDistributionRecordPOMapper;
    @Autowired
    private CusDistributionTaskDetailPOMapper cusDistributionTaskDetailPOMapper;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Autowired
    private QRCodeServiceFeign qrCodeServiceFeign;
    @Autowired
    private IntegralChangeApiService integralChangeApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private DistributionMemberApiService distributionMemberApiService;
    @Autowired
    private UrMemberApiService urMemberApiService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private CoreTraceFeign coreTraceFeign;
    @Autowired
    private StorageCardService storageCardService;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ResponseData addAndUpdateDistributionRegx(MemberDistributionRegxVo vo) {
        log.info("enter MemberDistributionServiceImpl addAndUpdateDistributionRegx method !");
        ResponseData responseData = new ResponseData();
        RedisClient redisClient = RedisManager.getInstince();
        Long sysCompanyId = vo.getSysCompanyId();
        Long brandId = vo.getBrandId();
        HashMap<String, Object> regxMap = new HashMap<String, Object>();
        DistributionMemberRequestVo distributionMemberRequestVo = new DistributionMemberRequestVo();
        distributionMemberRequestVo.setSysCompanyId(sysCompanyId);
        distributionMemberRequestVo.setBrandId(brandId);
        distributionMemberRequestVo.setPageNumber(Integer.valueOf(1));
        distributionMemberRequestVo.setPageSize(Integer.valueOf(10));
        distributionMemberRequestVo.setDistributionStatus(Integer.valueOf(1));
        distributionMemberRequestVo.setIsDesc(Boolean.valueOf(false));
        distributionMemberRequestVo.setOrderType("1");
        distributionMemberRequestVo.setQueryPCode(Boolean.valueOf(false));
        ResponseData pageInfoResponseData = this.distributionMemberApiService.queryDistribMemberAdvancedSearch(distributionMemberRequestVo);
        if (pageInfoResponseData.getData() != null && ((PageInfo)pageInfoResponseData.getData()).getList() != null && ((PageInfo)pageInfoResponseData.getData()).getList().size() > 0 && vo.getCommissionStatus() == 2) {
            responseData.setCode(MemberDistributionResponseEnum.OPERATE_FAILED_ACTIVE_DISTRIBUTOR_EXISTS.getCode());
            responseData.setMessage(MemberDistributionResponseEnum.OPERATE_FAILED_ACTIVE_DISTRIBUTOR_EXISTS.getMessage());
            return responseData;
        }
        List cusDistributionRegxPOS = this.cusDistributionRegxPOMapper.selectByBrandIdAndCompanyId((CusDistributionRegxPO)vo);
        if (cusDistributionRegxPOS != null && cusDistributionRegxPOS.size() > 0) {
            CusDistributionRegxPO oldPo = (CusDistributionRegxPO)cusDistributionRegxPOS.get(0);
            vo.setModifiedUserId(vo.getOperatorId());
            vo.setModifiedUserName(vo.getOperatorName());
            vo.setModifiedDate(new Date());
            int count = this.cusDistributionRegxPOMapper.updateByBrandIdAndCompanyId((CusDistributionRegxPO)vo);
            if (count != 1) {
                responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.OPERATE_FAILED_UPDATE_ERROR.getCode());
                responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.OPERATE_FAILED_UPDATE_ERROR.getMessage());
                return responseData;
            }
            regxMap.put("commissionName", oldPo.getCommissionName());
            regxMap.put("commission", oldPo.getCommission());
            regxMap.put("integral", oldPo.getIntegral());
            regxMap.put("commissionObtainType", oldPo.getCommissionObtainType());
            regxMap.put("commissionObtainDetailType", oldPo.getCommissionObtainDetailType());
            regxMap.put("commissionRation", oldPo.getCommissionRation());
            regxMap.put("commissionPeriod", oldPo.getCommissionPeriod());
            JSONObject regxJson = new JSONObject(regxMap);
            if (vo.getCommissionStatus() == 2) {
                log.info("\u4fee\u6539\u5206\u9500\u89c4\u5219\u4e3a\u7981\u7528,params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
                redisClient.set(sysCompanyId + "MEMBER_DISTRIBUTION_REGX_KEY" + brandId, (Object)regxJson, Long.valueOf(0L));
            } else if (oldPo.getCommissionStatus() == 2) {
                log.info("\u4fee\u6539\u5206\u9500\u89c4\u5219\u7531\u7981\u7528\u53d8\u542f\u7528,params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
            } else {
                boolean exists = redisClient.exists(sysCompanyId + "MEMBER_DISTRIBUTION_REGX_KEY" + brandId);
                if (!exists) {
                    Long seconds = this.getSecondsNextEarlyMorning();
                    redisClient.set(sysCompanyId + "MEMBER_DISTRIBUTION_REGX_KEY" + brandId, (Object)regxJson, seconds);
                }
            }
        } else {
            vo.setCreateUserId(vo.getOperatorId());
            vo.setCreateUserName(vo.getOperatorName());
            vo.setCreateDate(new Date());
            vo.setValid(Boolean.valueOf(true));
            int count = this.cusDistributionRegxPOMapper.insertSelective((CusDistributionRegxPO)vo);
            if (count != 1) {
                responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.OPERATE_FAILED_ADD_ERROR.getCode());
                responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.OPERATE_FAILED_ADD_ERROR.getMessage());
                return responseData;
            }
            regxMap.put("commissionName", vo.getCommissionName());
            regxMap.put("commission", vo.getCommission());
            regxMap.put("integral", vo.getIntegral());
            regxMap.put("commissionObtainType", vo.getCommissionObtainType());
            regxMap.put("commissionObtainDetailType", vo.getCommissionObtainDetailType());
            regxMap.put("commissionRation", vo.getCommissionRation());
            regxMap.put("commissionPeriod", vo.getCommissionPeriod());
            JSONObject regxJson = new JSONObject(regxMap);
            if (vo.getCommissionStatus() == 1) {
                Long seconds = this.getSecondsNextEarlyMorning();
                redisClient.set(sysCompanyId + "MEMBER_DISTRIBUTION_REGX_KEY" + brandId, (Object)regxJson, seconds);
            }
        }
        return responseData;
    }

    public PageInfo<DistributionMemeberResVo> queryDistributionMemberList(DistributionVo vo, Optional<SysAccountPO> currentUser, Pageable pageable) {
        log.info("MemberDistributionServiceImpl queryDistributionMemberList method !");
        SysAccountPO accountPO = currentUser.get();
        DistributionMemberRequestVo distributionMemberRequestVo = new DistributionMemberRequestVo();
        distributionMemberRequestVo.setSysCompanyId(accountPO.getSysCompanyId());
        distributionMemberRequestVo.setBrandId(accountPO.getBrandId());
        distributionMemberRequestVo.setPageNumber(Integer.valueOf(pageable.getPageNumber()));
        distributionMemberRequestVo.setPageSize(Integer.valueOf(pageable.getPageSize()));
        distributionMemberRequestVo.setIsDesc(vo.getIsDesc());
        distributionMemberRequestVo.setOrderType(vo.getOrderType());
        if (StringUtils.isNotBlank((CharSequence)vo.getCondition())) {
            distributionMemberRequestVo.setCondition(vo.getCondition());
        }
        if (vo.getDistributionStatus() != null) {
            distributionMemberRequestVo.setDistributionStatus(vo.getDistributionStatus());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getStartTime(), vo.getEndTime()})) {
            try {
                Date startCreateDate = this.simpleDateFormat.parse(vo.getStartTime());
                Date endCreateDate = this.simpleDateFormat.parse(vo.getEndTime());
                distributionMemberRequestVo.setBeforeDistribCreateDate(startCreateDate);
                distributionMemberRequestVo.setAfterDistribCreateDate(endCreateDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getOperateStartTime(), vo.getOperateEndTime()})) {
            try {
                Date startOperateDate = this.simpleDateFormat.parse(vo.getOperateStartTime());
                Date endOperateDate = this.simpleDateFormat.parse(vo.getOperateEndTime());
                distributionMemberRequestVo.setBeforeDistribModifyDate(startOperateDate);
                distributionMemberRequestVo.setAfterDistribModifyDate(endOperateDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (vo.getServiceStoreIds() != null && vo.getServiceStoreIds().size() > 0) {
            distributionMemberRequestVo.setServiceStoreIdList(vo.getServiceStoreIds());
        }
        ResponseData pageInfoResponseData = this.distributionMemberApiService.queryDistribMemberAdvancedSearch(distributionMemberRequestVo);
        ArrayList distributionMemeberResVoList = new ArrayList();
        List responseVoList = ((PageInfo)pageInfoResponseData.getData()).getList();
        if (responseVoList.size() > 0) {
            List serviceStoreIdList = responseVoList.stream().map(DistributionMemberResponseVo::getServiceStoreId).collect(Collectors.toList());
            ResponseData storeListResponseData = this.storeServiceRpc.getIdStoreLists(serviceStoreIdList);
            List sysStorePoList = (List)storeListResponseData.getData();
            Map<Long, String> storeMap = sysStorePoList.stream().collect(Collectors.toMap(SysStorePo::getSysStoreId, SysStorePo::getStoreName, (key1, key2) -> key2));
            List memberCodeList = responseVoList.stream().map(DistributionMemberResponseVo::getMemberCode).collect(Collectors.toList());
            List distributionStatusList = this.cusDistributionPOMapper.selectDisStatusByMemberCodes(memberCodeList);
            CusDistributionPO cusDistributionPO = new CusDistributionPO();
            cusDistributionPO.setMemberCode("memberCode");
            cusDistributionPO.setDistributionStatus(Integer.valueOf(0));
            distributionStatusList.add(cusDistributionPO);
            Map statusMap = distributionStatusList.stream().collect(Collectors.toMap(CusDistributionPO::getMemberCode, Function.identity(), (key1, key2) -> key2));
            Boolean isDesensitize = this.storageCardService.getMemberDataDesensitizeByAccountConfig(accountPO.getSysAccountId());
            responseVoList.forEach(res -> {
                DistributionMemeberResVo resvo = new DistributionMemeberResVo();
                resvo.setMemberCode(res.getMemberCode());
                resvo.setPhone(res.getPhone());
                resvo.setName(res.getName());
                resvo.setServiceStoreId(res.getServiceStoreId());
                String storeName = (String)storeMap.get(res.getServiceStoreId());
                resvo.setStoreName(storeName);
                resvo.setDistributionStatus(Integer.valueOf(statusMap.get(res.getMemberCode()) == null ? 2 : ((CusDistributionPO)statusMap.get(res.getMemberCode())).getDistributionStatus()));
                resvo.setCountDownline(res.getCountDownline());
                resvo.setSumCommission(res.getSumCommission());
                resvo.setCommissionBalance(res.getCommissionBalance());
                resvo.setOperater(statusMap.get(res.getMemberCode()) == null ? "" : ((CusDistributionPO)statusMap.get(res.getMemberCode())).getDistribModifyUserName());
                resvo.setOperateTime(statusMap.get(res.getMemberCode()) == null ? null : ((CusDistributionPO)statusMap.get(res.getMemberCode())).getDistribModifyDate());
                resvo.setSuperMemberCode(res.getSuperiorMemberCode());
                if (isDesensitize.booleanValue()) {
                    resvo.setPhone(DesensitizeUtil.encrypt((String)resvo.getPhone()));
                }
                distributionMemeberResVoList.add(resvo);
            });
        }
        PageInfo pageInfo = new PageInfo(distributionMemeberResVoList);
        pageInfo.setTotal(((PageInfo)pageInfoResponseData.getData()).getTotal());
        return pageInfo;
    }

    public ResponseData exportDistributionMemberList(DistributionVo vo, Optional<SysAccountPO> currentUser) {
        log.info("MemberDistributionServiceImpl exportDistributionMemberList param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        SysAccountPO sysAccountPO = currentUser.get();
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setBrandId(sysAccountPO.getBrandId());
        if (vo.getSysCompanyId() == null || vo.getBrandId() == null) {
            responseData.setMessage("\u4f01\u4e1aID,\u54c1\u724cID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        PageInfo pageInfo = this.queryDistributionMemberList(vo, currentUser, (Pageable)pageable);
        if (pageInfo.getList() == null) {
            responseData.setMessage("\u65e0\u53ef\u5bfc\u51fa\u8bb0\u5f55");
            return responseData;
        }
        List distributionMemberResponseVoList = pageInfo.getList();
        long sum = pageInfo.getTotal();
        if (sum > 500000L) {
            return ResponseUtil.getFailedData(null, (String)"\u6279\u91cf\u4efb\u52a1\u4e0d\u80fd\u8d85\u8fc750\u4e07");
        }
        Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        fileTaskPo.setFileId(String.valueOf(taskId));
        fileTaskPo.setTaskTypeCode(sum + "\u6761");
        fileTaskPo.setTaskName("\u5206\u9500\u5458\u5217\u8868");
        if (sysAccountPO != null) {
            fileTaskPo.setSysBrandId(sysAccountPO.getBrandId());
            fileTaskPo.setCreateUserId(sysAccountPO.getSysAccountId());
            fileTaskPo.setCreateUserName(sysAccountPO.getName());
        }
        fileTaskPo.setFileStatus(Long.valueOf(0L));
        fileTaskPo.setFileType("EXPORT");
        fileTaskPo.setValid(Boolean.valueOf(true));
        this.fileTaskServiceRpc.addFileTask(fileTaskPo);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"});
        StreamingExportExcelPageInfoUtilForStorage excelUtil = new StreamingExportExcelPageInfoUtilForStorage(Long.valueOf(sum));
        excelUtil.setExportProcessId((Object)taskId);
        Method method = ReflectionUtils.findMethod(this.getClass(), (String)"queryDistributionMemberList", (Class[])new Class[]{DistributionVo.class, Optional.class, Pageable.class});
        new Thread(() -> {
            try {
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                excelUtil.read("memberDistributionServiceImpl", method, (model, row) -> {
                    if (row.getRowNum() == 0) {
                        row.createCell(0).setCellValue("\u624b\u673a\u53f7");
                        row.createCell(1).setCellValue("\u4f1a\u5458\u59d3\u540d");
                        row.createCell(2).setCellValue("\u6240\u5c5e\u95e8\u5e97");
                        row.createCell(3).setCellValue("\u5206\u9500\u72b6\u6001");
                        row.createCell(4).setCellValue("\u4e0b\u7ebf\u4f1a\u5458");
                        row.createCell(5).setCellValue("\u7d2f\u79ef\u83b7\u5f97\u4f63\u91d1");
                        row.createCell(6).setCellValue("\u4f63\u91d1\u4f59\u989d");
                        row.createCell(7).setCellValue("\u64cd\u4f5c\u65f6\u95f4");
                        row.createCell(8).setCellValue("\u64cd\u4f5c\u4eba");
                    } else {
                        row.createCell(0).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getPhone(), (Object)""));
                        row.createCell(1).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getName(), (Object)""));
                        row.createCell(2).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getStoreName(), (Object)""));
                        row.createCell(3).setCellValue(model.getDistributionStatus() != null ? (model.getDistributionStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528") : "\u7981\u7528");
                        row.createCell(4).setCellValue((double)((Integer)ObjectUtils.defaultIfNull((Object)model.getCountDownline(), (Object)0)).intValue());
                        row.createCell(5).setCellValue((double)((Integer)ObjectUtils.defaultIfNull((Object)model.getSumCommission(), (Object)0)).intValue());
                        row.createCell(6).setCellValue((double)((Integer)ObjectUtils.defaultIfNull((Object)model.getCommissionBalance(), (Object)0)).intValue());
                        row.createCell(7).setCellValue(model.getOperateTime() != null ? sd.format(model.getOperateTime()) : "");
                        row.createCell(8).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getOperater(), (Object)""));
                    }
                }, sort, new Object[]{vo, currentUser});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        new Thread(() -> {
            OutputStream out = null;
            ByteArrayInputStream in = null;
            try {
                BigDecimal process = null;
                while (true) {
                    if ((process = StreamingExportExcelPageInfoUtilForStorage.getExportPercentageProcess((Object)taskId)).compareTo(new BigDecimal(0)) < 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(-1L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    if (process.compareTo(new BigDecimal(1)) == 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(99L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMddHHmmss");
                        Date currentDate = new Date();
                        String fileNameXls = FileNameUtil.getFileName((String)"\u5206\u9500\u5458\u5217\u8868\u5bfc\u51fa-", (String)sd.format(currentDate), (String)".xlsx");
                        String fileNameZip = FileNameUtil.getFileName((String)"\u5206\u9500\u5458\u5217\u8868\u5bfc\u51fa_", (String)sd.format(currentDate), (String)".zip");
                        out = new ByteArrayOutputStream();
                        excelUtil.exprotToZipOutputStream(out, fileNameXls, fileNameZip);
                        in = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                        String qiniuUrl = QiNiuUtil.upload((InputStream)in, (String)fileNameZip);
                        fileTaskPo.setFileStatus(Long.valueOf(100L));
                        fileTaskPo.setFileUnl(qiniuUrl);
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    fileTaskPo.setFileStatus(Long.valueOf(process.multiply(new BigDecimal(100)).longValue()));
                    this.fileTaskServiceRpc.update(fileTaskPo);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                fileTaskPo.setFileStatus(Long.valueOf(-1L));
                this.fileTaskServiceRpc.update(fileTaskPo);
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f!");
        return responseData;
    }

    @Transactional
    public ResponseData updateDistributionState(DistributionMemeberResVo vo) {
        log.info("enter MemberDistributionServiceImpl updateDistributionState method !");
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        if (vo.getMemberCode() == null || vo.getDistributionStatus() == null) {
            return responseData;
        }
        CusDistributionRegxPO cusDistributionRegxPO = new CusDistributionRegxPO();
        cusDistributionRegxPO.setBrandId(vo.getBrandId());
        cusDistributionRegxPO.setSysCompanyId(vo.getSysCompanyId());
        List cusDistributionRegxPOList = this.cusDistributionRegxPOMapper.selectByBrandIdAndCompanyId(cusDistributionRegxPO);
        if (cusDistributionRegxPOList == null || cusDistributionRegxPOList.size() == 0 || ((CusDistributionRegxPO)cusDistributionRegxPOList.get(0)).getCommissionStatus() == 2) {
            responseData.setMessage("\u65e0\u6709\u6548\u7684\u5206\u9500\u89c4\u5219\uff0c\u4e0d\u80fd\u64cd\u4f5c");
            return responseData;
        }
        Integer result = 0;
        CusDistributionPOExample example = new CusDistributionPOExample();
        example.createCriteria().andMemberCodeEqualTo(vo.getMemberCode()).andSysCompanyIdEqualTo(vo.getSysCompanyId()).andBrandIdEqualTo(vo.getBrandId());
        List cusDistributionPOList = this.cusDistributionPOMapper.selectByExample(example);
        if (cusDistributionPOList == null || cusDistributionPOList.size() == 0) {
            CusDistributionPO cusDistributionPO = new CusDistributionPO();
            cusDistributionPO.setSysCompanyId(vo.getSysCompanyId());
            cusDistributionPO.setBrandId(vo.getBrandId());
            cusDistributionPO.setDistributionStatus(vo.getDistributionStatus());
            cusDistributionPO.setMemberCode(vo.getMemberCode());
            cusDistributionPO.setCommissionBalance(Integer.valueOf(0));
            cusDistributionPO.setSumCommission(Integer.valueOf(0));
            cusDistributionPO.setCountDownline(Integer.valueOf(0));
            cusDistributionPO.setDistribCreateUserId(vo.getOperaterId());
            cusDistributionPO.setDistribCreateUserName(vo.getOperater());
            cusDistributionPO.setDistribCreateDate(vo.getOperateTime());
            cusDistributionPO.setCreateUserId(vo.getOperaterId());
            cusDistributionPO.setCreateUserName(vo.getOperater());
            cusDistributionPO.setCreateDate(vo.getOperateTime());
            cusDistributionPO.setDistribModifiyUserId(vo.getOperaterId());
            cusDistributionPO.setDistribModifyUserName(vo.getOperater());
            cusDistributionPO.setDistribModifyDate(vo.getOperateTime());
            cusDistributionPO.setModifiedUserId(vo.getOperaterId());
            cusDistributionPO.setModifiedUserName(vo.getOperater());
            cusDistributionPO.setModifiedDate(vo.getOperateTime());
            cusDistributionPO.setValid(Boolean.valueOf(true));
            result = this.cusDistributionPOMapper.insertSelective(cusDistributionPO);
        } else {
            if (vo.getDistributionStatus() == 1 && StringUtils.isNotBlank((CharSequence)((CusDistributionPO)cusDistributionPOList.get(0)).getSuperiorMemberCode())) {
                responseData.setMessage("\u542f\u7528\u5931\u8d25");
                return responseData;
            }
            CusDistributionPO po = new CusDistributionPO();
            po.setMemberCode(vo.getMemberCode());
            po.setDistributionStatus(vo.getDistributionStatus());
            po.setDistribModifiyUserId(vo.getOperaterId());
            po.setDistribModifyUserName(vo.getOperater());
            po.setDistribModifyDate(vo.getOperateTime());
            po.setModifiedUserId(vo.getOperaterId());
            po.setModifiedUserName(vo.getOperater());
            po.setModifiedDate(vo.getOperateTime());
            po.setSysCompanyId(vo.getSysCompanyId());
            po.setBrandId(vo.getBrandId());
            result = this.cusDistributionPOMapper.updateDisStatusByMemberCode(po);
        }
        if (result < 1) {
            responseData.setMessage("\u64cd\u4f5c\u5931\u8d25");
            return responseData;
        }
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData<PageInfo<CusDistributionRecordPO>> queryCommissionRecord(MemberDistributionVo memberDistributionVo) {
        log.info("MemberDistributionServiceImpl queryCommissionRecord param:{}", (Object)JacksonUtil.bean2Json((Object)memberDistributionVo));
        Page page = PageHelper.startPage((int)memberDistributionVo.getPageNumber(), (int)memberDistributionVo.getPageSize()).doSelectPage(() -> this.cusDistributionRecordPOMapper.queryCommissionRecord(memberDistributionVo));
        PageInfo pageInfo = new PageInfo((List)page);
        return ResponseDataUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData commissionRecordExport(MemberDistributionVo memberDistributionVo, Optional<SysAccountPO> currentUser) {
        ResponseData responseData = new ResponseData();
        SysAccountPO sysAccountPO = currentUser.get();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        memberDistributionVo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        memberDistributionVo.setBrandId(sysAccountPO.getBrandId());
        if (memberDistributionVo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        try {
            List cusDistributionRecordPOS = this.cusDistributionRecordPOMapper.queryCommissionRecordTask(memberDistributionVo, Long.valueOf(1L), Long.valueOf(1L));
            long sum = cusDistributionRecordPOS.size();
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = new FileTaskPo();
            fileTaskPo.setTaskId(taskId);
            fileTaskPo.setFileId(String.valueOf(taskId));
            fileTaskPo.setTaskTypeCode(sum + "\u6761");
            fileTaskPo.setTaskName("\u5bfc\u51fa\u4f63\u91d1\u6d41\u6c34\u4fe1\u606f");
            if (sysAccountPO != null) {
                fileTaskPo.setSysBrandId(sysAccountPO.getBrandId());
                fileTaskPo.setCreateUserId(sysAccountPO.getSysAccountId());
                fileTaskPo.setCreateUserName(sysAccountPO.getName());
            }
            fileTaskPo.setFileStatus(Long.valueOf(0L));
            fileTaskPo.setFileType("EXPORT");
            fileTaskPo.setValid(Boolean.valueOf(true));
            this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(sum));
            Boolean isDesensitize = this.storageCardService.getMemberDataDesensitizeByAccountConfig(sysAccountPO.getSysAccountId());
            new Thread(() -> {
                try {
                    SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    exportExcelUtil.setExportProcessId((Object)taskId);
                    Method method = this.cusDistributionRecordPOMapper.getClass().getMethod("queryCommissionRecordTask", MemberDistributionVo.class, Long.class, Long.class);
                    exportExcelUtil.read("cusDistributionRecordPOMapper", method, (model, row) -> {
                        if (isDesensitize.booleanValue() && null != model) {
                            model.setCardNo(DesensitizeUtil.encrypt((String)model.getCardNo()));
                            model.setcPhone(DesensitizeUtil.encrypt((String)model.getcPhone()));
                            model.setpPhone(DesensitizeUtil.encrypt((String)model.getpPhone()));
                        }
                        if (row.getRowNum() == 0) {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue("\u5206\u9500\u5458\u624b\u673a\u53f7");
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue("\u5206\u9500\u5458\u59d3\u540d");
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue("\u4e0b\u7ebf\u4f1a\u5458\u624b\u673a\u53f7");
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue("\u4e0b\u7ebf\u4f1a\u5458\u59d3\u540d");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue("\u8ba2\u5355\u53f7");
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue("\u8ba2\u5355\u91d1\u989d");
                            Cell cell6 = row.createCell(6);
                            cell6.setCellValue("\u5b9e\u4ed8\u91d1\u989d");
                            Cell cell7 = row.createCell(7);
                            cell7.setCellValue("\u4f63\u91d1");
                            Cell cell8 = row.createCell(8);
                            cell8.setCellValue("\u4f63\u91d1\u6bd4\u4f8b");
                            Cell cell9 = row.createCell(9);
                            cell9.setCellValue("\u72b6\u6001");
                            Cell cell10 = row.createCell(10);
                            cell10.setCellValue("\u6d88\u8d39\u65e5\u671f");
                            Cell cell11 = row.createCell(11);
                            cell11.setCellValue("\u7ed3\u7b97\u65e5\u671f");
                        } else {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getpPhone(), (Object)""));
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getpName(), (Object)""));
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getcPhone(), (Object)""));
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getcName(), (Object)""));
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getOrderNo(), (Object)""));
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getTradeAmount().toString(), (Object)""));
                            Cell cell6 = row.createCell(6);
                            cell6.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getCommodityAmount().toString(), (Object)"0"));
                            Cell cell7 = row.createCell(7);
                            cell7.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getCommission().toString(), (Object)"0"));
                            Cell cell8 = row.createCell(8);
                            cell8.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getRegx(), (Object)"0"));
                            Cell cell9 = row.createCell(9);
                            String status = "";
                            if (model.getCommissionStatus() != null) {
                                switch (model.getCommissionStatus()) {
                                    case 1: {
                                        status = "\u5f85\u7ed3\u7b97";
                                        break;
                                    }
                                    case 2: {
                                        status = "\u5df2\u7ed3\u7b97";
                                        break;
                                    }
                                    case 3: {
                                        status = "\u9000\u8d27";
                                    }
                                }
                            }
                            cell9.setCellValue(status);
                            Cell cell10 = row.createCell(10);
                            cell10.setCellValue(model.getConsumeDate() != null ? sd.format(model.getConsumeDate()) : "");
                            Cell cell11 = row.createCell(11);
                            cell11.setCellValue(model.getDealDate() != null ? sd.format(model.getDealDate()) : "");
                        }
                    }, new Object[]{memberDistributionVo});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
            new Thread(() -> {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"\u4f63\u91d1\u6d41\u6c34\u4fe1\u606f\u5bfc\u51fa_");
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f!");
        return responseData;
    }

    public ResponseData<MemberDistributionShareVo> getChooseFriends(MemberDistributionShareVo vo) {
        log.info("MemberDistributionServiceImpl getChooseFriends method !");
        ResponseData responseData = new ResponseData();
        CusDistributionRegxPO po = new CusDistributionRegxPO();
        po.setSysCompanyId(vo.getSysCompanyId());
        po.setBrandId(vo.getBrandId());
        String qiniuUrl = this.qiNiuConfig.getDomain() + "/";
        List cusDistributionRegxPOS = this.cusDistributionRegxPOMapper.selectByBrandIdAndCompanyId(po);
        if (cusDistributionRegxPOS != null && cusDistributionRegxPOS.size() > 0) {
            CusDistributionRegxPO regxPO = (CusDistributionRegxPO)cusDistributionRegxPOS.get(0);
            vo.setMiniProgramShareDescription(regxPO.getMiniProgramShareDescription());
            vo.setMiniProgramShareTitle(regxPO.getMiniProgramShareTitle());
            vo.setMiniProgramShareUrl(QiNiuUtil.httpUrlCompatible((String)qiniuUrl, (String)regxPO.getMiniProgramShareUrl()));
        }
        Long traceId = this.saveTrace(vo.getMemberCode(), "pages/entry/main", vo.getSysCompanyId());
        vo.setTraceId(traceId);
        responseData.setData((Object)vo);
        return responseData;
    }

    public ResponseData<MemberDistributionShareVo> getSharePosters(MemberDistributionShareVo vo) {
        log.info("MemberDistributionServiceImpl getSharePosters method !");
        ResponseData responseData = new ResponseData();
        CusDistributionRegxPO po = new CusDistributionRegxPO();
        po.setSysCompanyId(vo.getSysCompanyId());
        po.setBrandId(vo.getBrandId());
        String qiniuUrl = this.qiNiuConfig.getDomain() + "/";
        List cusDistributionRegxPOS = this.cusDistributionRegxPOMapper.selectByBrandIdAndCompanyId(po);
        if (cusDistributionRegxPOS != null && cusDistributionRegxPOS.size() > 0) {
            CusDistributionRegxPO regxPO = (CusDistributionRegxPO)cusDistributionRegxPOS.get(0);
            vo.setBackgroundUrl(QiNiuUtil.httpUrlCompatible((String)qiniuUrl, (String)regxPO.getBackgroundUrl()));
        }
        Long traceId = this.saveTrace(vo.getMemberCode(), "pages/entry/main", vo.getSysCompanyId());
        vo.setTraceId(traceId);
        vo.setQrCode(this.getWxUrl(vo));
        responseData.setData((Object)vo);
        return responseData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResponseData commissionExchangeIntegral(MemberDistributionPageVo vo) {
        CusDistributionExchangePO exchangePO;
        log.info("MemberDistributionServiceImpl commissionExchangeIntegral param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        MemberDistributionRegxVo memberDistributionRegxVo = new MemberDistributionRegxVo();
        memberDistributionRegxVo.setSysCompanyId(vo.getSysCompanyId());
        memberDistributionRegxVo.setBrandId(vo.getBrandId());
        List regxPOS = this.cusDistributionRegxPOMapper.selectByBrandIdAndCompanyId((CusDistributionRegxPO)memberDistributionRegxVo);
        if (regxPOS.size() <= 0 || regxPOS == null) return ResponseDataUtil.getFailedData(null, (String)"\u8be5\u54c1\u724c\u8fd8\u672a\u8bbe\u7f6e\u89c4\u5219");
        CusDistributionRegxPO regxP0 = (CusDistributionRegxPO)regxPOS.get(0);
        if (regxP0.getCommissionStatus() != 1) return ResponseDataUtil.getFailedData(null, (String)"\u5151\u6362\u6d3b\u52a8\u672a\u5f00\u542f");
        int count = vo.getCommission() / regxP0.getCommission();
        int integral = count * regxP0.getIntegral();
        int commission = count * regxP0.getCommission();
        CusDistributionPO distributionPO = new CusDistributionPO();
        distributionPO.setSysCompanyId(vo.getSysCompanyId());
        distributionPO.setBrandId(vo.getBrandId());
        distributionPO.setMemberCode(vo.getMemberCode());
        distributionPO.setCommissionBalance(Integer.valueOf(commission * -1));
        distributionPO.setModifiedDate(new Date());
        int updateCount = this.cusDistributionPOMapper.updateBalanceByMemberCode(distributionPO);
        if (updateCount == 0) {
            return ResponseDataUtil.getFailedData(null, (String)"\u6263\u51cf\u4f63\u91d1\u5931\u8d25,\u4f63\u91d1\u4f59\u989d\u4e0d\u8db3");
        }
        IntegralChangeRequestModel changeRequestModel = new IntegralChangeRequestModel();
        changeRequestModel.setChangeType("2");
        changeRequestModel.setBusinessType("39");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String changeBills = "EXCH" + sdf.format(new Date()) + (int)((Math.random() * 9.0 + 1.0) * 1000.0);
        changeRequestModel.setChangeBills(changeBills);
        changeRequestModel.setChangeIntegral(Integer.valueOf(integral));
        changeRequestModel.setSysCompanyId(vo.getSysCompanyId());
        changeRequestModel.setBrandId(vo.getBrandId());
        changeRequestModel.setMemberCode(vo.getMemberCode());
        IntegralChangeResponseModel integralChangeResponseModel = this.integralChangeApiService.integralChangeOperate(changeRequestModel);
        if (integralChangeResponseModel.getCode().intValue() == com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode()) {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(vo.getMemberCode());
            memberInfoModel.setSysCompanyId(vo.getSysCompanyId());
            memberInfoModel.setBrandId(vo.getBrandId());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            MemberInfoModel memberInfo = (MemberInfoModel)singleMemberModel.getData();
            exchangePO = new CusDistributionExchangePO();
            exchangePO.setSysCompanyId(vo.getSysCompanyId());
            exchangePO.setBrandId(vo.getBrandId());
            exchangePO.setPhone(memberInfo.getPhone());
            exchangePO.setName(memberInfo.getName());
            exchangePO.setCommission(Integer.valueOf(commission));
            exchangePO.setIntegral(Integer.valueOf(integral));
            String regx = vo.getCommission() + "\u4f63\u91d1=" + vo.getIntegral() + "\u79ef\u5206";
            exchangePO.setRegx(regx);
            if (memberInfo.getServiceStoreId() != null) {
                exchangePO.setServiceStoreId(memberInfo.getServiceStoreId());
                ResponseData sysStoreData = this.storeServiceRpc.getSysStoreById(memberInfo.getServiceStoreId());
                if (sysStoreData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
                    SysStoreVo sysStoreVo = (SysStoreVo)sysStoreData.getData();
                    exchangePO.setServiceStoreName(sysStoreVo.getStoreName());
                }
            }
        } else {
            distributionPO.setCommissionBalance(Integer.valueOf(commission));
            distributionPO.setModifiedDate(new Date());
            this.cusDistributionPOMapper.updateByMemberCode(distributionPO);
            return ResponseDataUtil.getFailedData(null, (String)"\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        exchangePO.setMemberCode(vo.getMemberCode());
        exchangePO.setCreateDate(new Date());
        exchangePO.setValid(Boolean.valueOf(true));
        this.cusDistributionExchangePOMapper.insert(exchangePO);
        return ResponseDataUtil.getSuccessData(null, (String)"\u5151\u6362\u6210\u529f");
    }

    public PageInfo<SubordinateMemeberResVo> querySubordinateMemberList(DistributionVo vo, Optional<SysAccountPO> currentUser, Pageable pageable) {
        log.info("MemberDistributionServiceImpl queryDistributionMemberList method !");
        SysAccountPO accountPO = currentUser.get();
        DistributionMemberRequestVo requestVo = new DistributionMemberRequestVo();
        requestVo.setBrandId(accountPO.getBrandId());
        requestVo.setSysCompanyId(accountPO.getSysCompanyId());
        requestVo.setPageNumber(Integer.valueOf(pageable.getPageNumber()));
        requestVo.setPageSize(Integer.valueOf(pageable.getPageSize()));
        requestVo.setOrderType(vo.getOrderType());
        requestVo.setIsDesc(vo.getIsDesc());
        PageInfo pageInfo = new PageInfo();
        if (StringUtils.isNotBlank((CharSequence)vo.getConditionApplet())) {
            requestVo.setName(vo.getName());
            requestVo.setPhone(vo.getPhone());
            requestVo.setQueryPCode(Boolean.valueOf(false));
            return this.getSubordinateMemeberResVoPageInfo(vo, requestVo);
        }
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{vo.getCPhone(), vo.getCName(), vo.getName(), vo.getPhone()})) {
            requestVo.setQueryPCode(Boolean.valueOf(true));
            pageInfo = vo.getServiceStoreIds() != null && vo.getServiceStoreIds().size() > 0 ? this.getSubordinateMemeberResVoPageInfo(vo, requestVo) : this.getSubordinateMemeberResVoPageInfo(accountPO, requestVo, vo);
        } else if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{vo.getPhone(), vo.getName()}) && !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{vo.getCPhone(), vo.getCName()})) {
            requestVo.setName(vo.getName());
            requestVo.setPhone(vo.getPhone());
            requestVo.setQueryPCode(Boolean.valueOf(false));
            pageInfo = this.getSubordinateMemeberResVoPageInfo(vo, requestVo);
        } else if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{vo.getPhone(), vo.getName()}) && !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{vo.getCPhone(), vo.getCName()})) {
            requestVo.setQueryPCode(Boolean.valueOf(true));
            if (StringUtils.isNotBlank((CharSequence)vo.getCName())) {
                requestVo.setName(vo.getCName());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getCPhone())) {
                requestVo.setPhone(vo.getCPhone());
            }
            pageInfo = vo.getServiceStoreIds() != null && vo.getServiceStoreIds().size() > 0 ? this.getSubordinateMemeberResVoPageInfo(vo, requestVo) : this.getSubordinateMemeberResVoPageInfo(accountPO, requestVo, vo);
        } else if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{vo.getPhone(), vo.getName()}) && StringUtils.isAllBlank((CharSequence[])new CharSequence[]{vo.getCPhone(), vo.getCName()})) {
            requestVo.setQueryPCode(Boolean.valueOf(false));
            if (StringUtils.isNotBlank((CharSequence)vo.getName())) {
                requestVo.setName(vo.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getPhone())) {
                requestVo.setPhone(vo.getPhone());
            }
            pageInfo = this.getSubordinateMemeberResVoPageInfo(vo, requestVo);
        }
        return pageInfo;
    }

    private PageInfo<SubordinateMemeberResVo> getSubordinateMemeberResVoPageInfo(DistributionVo vo, DistributionMemberRequestVo requestVo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList resList = new ArrayList();
        ResponseData pageInfoResponseData = this.distributionMemberApiService.queryDistribMemberAdvancedSearch(requestVo);
        List list = ((PageInfo)pageInfoResponseData.getData()).getList();
        if (list.size() > 0) {
            List memberCodeList = list.stream().map(DistributionMemberResponseVo::getMemberCode).collect(Collectors.toList());
            Map<String, DistributionMemberResponseVo> map = list.stream().collect(Collectors.toMap(DistributionMemberResponseVo::getMemberCode, member -> member));
            requestVo.setMemberCodeList(memberCodeList);
            if (StringUtils.isNotBlank((CharSequence)requestVo.getName())) {
                requestVo.setName(null);
            }
            if (StringUtils.isNotBlank((CharSequence)requestVo.getPhone())) {
                requestVo.setPhone(null);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getCName())) {
                requestVo.setName(vo.getCName());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getCPhone())) {
                requestVo.setPhone(vo.getCPhone());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getConditionApplet())) {
                requestVo.setConditionApplet(vo.getConditionApplet());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getBindStartTime(), vo.getBindEndTime()})) {
                try {
                    Date bindStartDate = this.simpleDateFormat.parse(vo.getBindStartTime());
                    Date bindEndDate = this.simpleDateFormat.parse(vo.getBindEndTime());
                    requestVo.setBeforeDistribBindCreateDate(bindStartDate);
                    requestVo.setAfterDistribBindCreateDate(bindEndDate);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            requestVo.setQueryPCode(Boolean.valueOf(true));
            ResponseData responseData = this.distributionMemberApiService.queryDistribMemberAdvancedSearch(requestVo);
            List responseVoList = ((PageInfo)responseData.getData()).getList();
            if (responseVoList.size() > 0) {
                responseVoList.forEach(res -> {
                    SubordinateMemeberResVo resVo = new SubordinateMemeberResVo();
                    resVo.setCName(res.getName() == null ? "" : res.getName());
                    resVo.setCPhone(res.getPhone());
                    resVo.setBindTime(res.getDistribBindCreateDate());
                    resVo.setOperateTime(res.getDistribBindModifyDate());
                    resVo.setOperater(res.getDistribBindModifyUserName());
                    String name = ((DistributionMemberResponseVo)map.get(res.getSuperiorMemberCode())).getName();
                    resVo.setName(name);
                    String phone = ((DistributionMemberResponseVo)map.get(res.getSuperiorMemberCode())).getPhone();
                    resVo.setPhone(phone);
                    resVo.setContributionCommission(res.getContributionCommission());
                    resVo.setMemberCode(res.getMemberCode());
                    resVo.setDistribBindStatus(res.getDistribBindStatus());
                    resVo.setCardNo(res.getCardNo());
                    if (StringUtils.isNotBlank((CharSequence)res.getHeadPortraits())) {
                        if (res.getHeadPortraits().startsWith("http")) {
                            resVo.setHeadPortraits(res.getHeadPortraits());
                        } else {
                            resVo.setHeadPortraits(QiNiuUtil.httpUrlCompatible((String)(this.qiNiuConfig.getDomain() + "/"), (String)res.getHeadPortraits()));
                        }
                    }
                    resList.add(resVo);
                });
            }
            List collect = resList.size() > 0 ? this.filterNotBindList(vo, resList) : resList;
            PageInfo pageInfo = new PageInfo(collect);
            pageInfo.setTotal(((PageInfo)responseData.getData()).getTotal());
            return pageInfo;
        }
        PageInfo pageInfo = new PageInfo(resList);
        return pageInfo;
    }

    private List<SubordinateMemeberResVo> filterNotBindList(DistributionVo vo, ArrayList<SubordinateMemeberResVo> resList) {
        List memberCode = resList.stream().map(SubordinateMemeberResVo::getMemberCode).collect(Collectors.toList());
        CusDistributionPOExample distributionPOExample = new CusDistributionPOExample();
        distributionPOExample.createCriteria().andMemberCodeIn(memberCode).andDistribBindStatusEqualTo(Integer.valueOf(1)).andValidEqualTo(Boolean.valueOf(true));
        List poList = this.cusDistributionPOMapper.selectByExample(distributionPOExample);
        ArrayList<SubordinateMemeberResVo> collect = new ArrayList();
        if (poList.size() > 0) {
            List noBindList = poList.stream().map(CusDistributionPO::getMemberCode).collect(Collectors.toList());
            collect = resList.stream().filter(res -> !noBindList.contains(res.getMemberCode())).collect(Collectors.toList());
            return collect;
        }
        return resList;
    }

    private PageInfo<SubordinateMemeberResVo> getSubordinateMemeberResVoPageInfo(SysAccountPO accountPO, DistributionMemberRequestVo requestVo, DistributionVo vo) {
        ResponseData responseData;
        List responseVoList;
        ArrayList resList = new ArrayList();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getBindStartTime(), vo.getBindEndTime()})) {
            try {
                Date bindStartDate = this.simpleDateFormat.parse(vo.getBindStartTime());
                Date bindEndDate = this.simpleDateFormat.parse(vo.getBindEndTime());
                requestVo.setBeforeDistribBindCreateDate(bindStartDate);
                requestVo.setAfterDistribBindCreateDate(bindEndDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if ((responseVoList = ((PageInfo)(responseData = this.distributionMemberApiService.queryDistribMemberAdvancedSearch(requestVo)).getData()).getList()).size() > 0) {
            List pMemberCodeList = responseVoList.stream().map(DistributionMemberResponseVo::getSuperiorMemberCode).collect(Collectors.toList());
            MembersEsRequestVo membersEsRequestVo = new MembersEsRequestVo();
            membersEsRequestVo.setBrandId(accountPO.getBrandId());
            membersEsRequestVo.setSysCompanyId(accountPO.getSysCompanyId());
            membersEsRequestVo.setMemberCodeList(pMemberCodeList);
            membersEsRequestVo.setPageNum(Integer.valueOf(1));
            membersEsRequestVo.setPageSize(Integer.valueOf(1000));
            ResponseData membersListData = this.urMemberApiService.getMembersListPageable(membersEsRequestVo);
            List membersList = ((PageInfo)membersListData.getData()).getList();
            Map<String, MembersEsResponseVo> map = membersList.stream().collect(Collectors.toMap(MembersEsResponseVo::getMemberCode, member -> member));
            responseVoList.forEach(res -> {
                SubordinateMemeberResVo resVo = new SubordinateMemeberResVo();
                resVo.setCName(res.getName());
                resVo.setCPhone(res.getPhone());
                resVo.setBindTime(res.getDistribBindCreateDate());
                resVo.setOperateTime(res.getDistribBindModifyDate());
                resVo.setOperater(res.getDistribBindModifyUserName());
                String name = map.get(res.getSuperiorMemberCode()) != null ? ((MembersEsResponseVo)map.get(res.getSuperiorMemberCode())).getName() : "";
                resVo.setName(name);
                String phone = map.get(res.getSuperiorMemberCode()) != null ? ((MembersEsResponseVo)map.get(res.getSuperiorMemberCode())).getPhone() : "";
                resVo.setPhone(phone);
                resVo.setContributionCommission(res.getContributionCommission());
                resVo.setMemberCode(res.getMemberCode());
                resVo.setDistribBindStatus(res.getDistribBindStatus());
                resVo.setCardNo(res.getCardNo());
                if (StringUtils.isNotBlank((CharSequence)res.getHeadPortraits())) {
                    if (res.getHeadPortraits().startsWith("http")) {
                        resVo.setHeadPortraits(res.getHeadPortraits());
                    } else {
                        resVo.setHeadPortraits(QiNiuUtil.httpUrlCompatible((String)(this.qiNiuConfig.getDomain() + "/"), (String)res.getHeadPortraits()));
                    }
                }
                resList.add(resVo);
            });
            List collect = resList.size() > 0 ? this.filterNotBindList(vo, resList) : resList;
            PageInfo pageInfo = new PageInfo(collect);
            pageInfo.setTotal(((PageInfo)responseData.getData()).getTotal());
            return pageInfo;
        }
        PageInfo pageInfo = new PageInfo(resList);
        return pageInfo;
    }

    public ResponseData exportSubordinateMemberList(DistributionVo vo, Optional<SysAccountPO> optional) {
        log.info("MemberDistributionServiceImpl exportSubordinateMemberList param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        PageInfo pageInfo = this.querySubordinateMemberList(vo, optional, (Pageable)pageable);
        long total = pageInfo.getTotal();
        Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        fileTaskPo.setFileId(String.valueOf(taskId));
        fileTaskPo.setTaskTypeCode(total + "\u6761");
        fileTaskPo.setTaskName("\u4e0b\u7ebf\u4f1a\u5458\u5217\u8868\u5bfc\u51fa");
        SysAccountPO currentUser = optional.get();
        fileTaskPo.setSysCompanyId(currentUser.getSysCompanyId());
        fileTaskPo.setSysBrandId(currentUser.getBrandId());
        fileTaskPo.setCreateUserId(currentUser.getSysAccountId());
        fileTaskPo.setCreateUserName(currentUser.getName());
        fileTaskPo.setFileStatus(Long.valueOf(0L));
        fileTaskPo.setFileType("EXPORT");
        fileTaskPo.setValid(Boolean.valueOf(true));
        ResponseData response = this.fileTaskServiceRpc.addFileTask(fileTaskPo);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"bindTime"});
        StreamingExportExcelPageInfoUtilForStorage excelUtil = new StreamingExportExcelPageInfoUtilForStorage(Long.valueOf(total));
        excelUtil.setExportProcessId((Object)taskId);
        Method method = ReflectionUtils.findMethod(this.getClass(), (String)"querySubordinateMemberList", (Class[])new Class[]{DistributionVo.class, Optional.class, Pageable.class});
        Boolean isDesensitize = this.storageCardService.getMemberDataDesensitizeByAccountConfig(currentUser.getSysAccountId());
        new Thread(() -> {
            try {
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                excelUtil.read("memberDistributionServiceImpl", method, (model, row) -> {
                    if (isDesensitize.booleanValue() && null != model) {
                        model.setCardNo(DesensitizeUtil.encrypt((String)model.getCardNo()));
                        model.setPhone(DesensitizeUtil.encrypt((String)model.getPhone()));
                        model.setCPhone(DesensitizeUtil.encrypt((String)model.getCPhone()));
                    }
                    if (row.getRowNum() == 0) {
                        row.createCell(0).setCellValue("\u5206\u9500\u5458\u624b\u673a\u53f7");
                        row.createCell(1).setCellValue("\u5206\u9500\u5458\u59d3\u540d");
                        row.createCell(2).setCellValue("\u4e0b\u7ebf\u4f1a\u5458\u624b\u673a\u53f7");
                        row.createCell(3).setCellValue("\u4e0b\u7ebf\u4f1a\u5458\u59d3\u540d");
                        row.createCell(4).setCellValue("\u7ed1\u5b9a\u65f6\u95f4");
                        row.createCell(5).setCellValue("\u8d21\u732e\u4f63\u91d1");
                        row.createCell(6).setCellValue("\u64cd\u4f5c\u65f6\u95f4");
                        row.createCell(7).setCellValue("\u64cd\u4f5c\u4eba");
                    } else {
                        row.createCell(0).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getPhone(), (Object)""));
                        row.createCell(1).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getName(), (Object)""));
                        row.createCell(2).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getCPhone(), (Object)""));
                        row.createCell(3).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getCName(), (Object)""));
                        row.createCell(4).setCellValue(model.getBindTime() != null ? sd.format(model.getBindTime()) : "");
                        row.createCell(5).setCellValue((double)((Integer)ObjectUtils.defaultIfNull((Object)model.getContributionCommission(), (Object)0)).intValue());
                        row.createCell(6).setCellValue(model.getOperateTime() != null ? sd.format(model.getOperateTime()) : "");
                        row.createCell(7).setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getOperater(), (Object)""));
                    }
                }, sort, new Object[]{vo, optional});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        new Thread(() -> {
            OutputStream out = null;
            ByteArrayInputStream in = null;
            try {
                BigDecimal process = null;
                while (true) {
                    if ((process = StreamingExportExcelPageInfoUtilForStorage.getExportPercentageProcess((Object)taskId)).compareTo(new BigDecimal(0)) < 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(-1L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    if (process.compareTo(new BigDecimal(1)) == 0) {
                        fileTaskPo.setFileStatus(Long.valueOf(99L));
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMddHHmmss");
                        Date currentDate = new Date();
                        String fileNameXls = FileNameUtil.getFileName((String)"\u4e0b\u7ebf\u4f1a\u5458\u5217\u8868\u5bfc\u51fa-", (String)sd.format(currentDate), (String)".xlsx");
                        String fileNameZip = FileNameUtil.getFileName((String)"\u4e0b\u7ebf\u4f1a\u5458\u5217\u8868\u5bfc\u51fa_", (String)sd.format(currentDate), (String)".zip");
                        out = new ByteArrayOutputStream();
                        excelUtil.exprotToZipOutputStream(out, fileNameXls, fileNameZip);
                        in = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                        String qiniuUrl = QiNiuUtil.upload((InputStream)in, (String)fileNameZip);
                        fileTaskPo.setFileStatus(Long.valueOf(100L));
                        fileTaskPo.setFileUnl(qiniuUrl);
                        this.fileTaskServiceRpc.update(fileTaskPo);
                        break;
                    }
                    fileTaskPo.setFileStatus(Long.valueOf(process.multiply(new BigDecimal(100)).longValue()));
                    this.fileTaskServiceRpc.update(fileTaskPo);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                fileTaskPo.setFileStatus(Long.valueOf(-1L));
                this.fileTaskServiceRpc.update(fileTaskPo);
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
        return response;
    }

    public ResponseData cancelBind(MemberDistributionVo vo, Optional<SysAccountPO> currentUser) {
        log.info("enter MemberDistributionServiceImpl cancelBind param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO accountPO = currentUser.get();
        CusDistributionPO cusDistributionPO = new CusDistributionPO();
        cusDistributionPO.setSuperiorMemberCode(null);
        cusDistributionPO.setDistributionStatus(Integer.valueOf(2));
        cusDistributionPO.setDistribBindModifyUserId(accountPO.getSysAccountId());
        cusDistributionPO.setDistribBindModifyUserName(accountPO.getName());
        cusDistributionPO.setDistribBindModifyDate(new Date());
        cusDistributionPO.setModifiedUserId(accountPO.getSysAccountId());
        cusDistributionPO.setModifiedUserName(accountPO.getName());
        cusDistributionPO.setModifiedDate(new Date());
        cusDistributionPO.setSysCompanyId(accountPO.getSysCompanyId());
        cusDistributionPO.setBrandId(accountPO.getBrandId());
        List memberCodes = vo.getMemberCodes();
        int count = this.cusDistributionPOMapper.updateDisBindStatusByMemberCode(cusDistributionPO, memberCodes);
        if (count == 0) {
            return ResponseDataUtil.getFailedData(null, (String)"\u89e3\u7ed1\u5931\u8d25");
        }
        return ResponseDataUtil.getSuccessData(null);
    }

    public ResponseData<String> importDistributionExcel(String url, Optional<SysAccountPO> optional) {
        log.info("enter MemberDistributionServiceImpl importDistributionExcel method !");
        ResponseData responseData = new ResponseData();
        SysAccountPO currentUser = optional.get();
        List cusDistributionVOList = Collections.synchronizedList(new ArrayList());
        CusDistributionTaskDetailPO po = new CusDistributionTaskDetailPO();
        po.setBrandId(currentUser.getBrandId());
        po.setSysCompanyId(currentUser.getSysCompanyId());
        po.setCreateUserId(currentUser.getSysAccountId());
        po.setCreateUserName(currentUser.getName());
        po.setCreatedDate(new Date());
        po.setValid(Boolean.valueOf(true));
        String taskCode = this.generateTaskBatchCode();
        po.setTaskBatchCode(taskCode);
        CommonExportExcelUtil re = null;
        AtomicBoolean flag = new AtomicBoolean(false);
        Integer num = 0;
        try {
            re = DownLoadFileUtil.urlToExcel((String)QiNiuUtil.httpUrlCompatible((String)(this.qiNiuConfig.getDomain() + "/"), (String)url));
            num = re.getLastRowNum();
            if (num > 50000) {
                responseData.setMessage("\u5bfc\u5165\u5931\u8d25\uff0c\u6570\u91cf\u6700\u591a\u4e3a5\u4e07\u6761");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                po.setImportStaus(Integer.valueOf(2));
                po.setRemark("\u5bfc\u5165\u6570\u91cf\u6700\u591a\u4e3a5\u4e07\u6761");
                this.cusDistributionTaskDetailPOMapper.insertSelective(po);
                return responseData;
            }
            for (int i = 0; i < 1; ++i) {
                AtomicInteger a = new AtomicInteger();
                re.read(0, 0, 1, i, row -> {
                    if (a.compareAndSet(0, 0)) {
                        String col1 = (String)row[0];
                        String col2 = (String)row[1];
                        if (!"\u4f1a\u5458\u5361\u53f7".equals(col1) || !"\u5206\u9500\u72b6\u6001\uff080\uff1a\u7981\u7528\uff0c1\u542f\u7528\uff09".equals(col2)) {
                            flag.set(true);
                            return;
                        }
                        a.incrementAndGet();
                        return;
                    }
                    String memberCardNo = (String)row[0];
                    String distributionStatus = (String)row[1];
                    if (com.github.pagehelper.util.StringUtil.isEmpty((String)memberCardNo)) {
                        return;
                    }
                    if (StringUtils.isBlank((CharSequence)distributionStatus) || !"01".contains(distributionStatus) || distributionStatus.length() > 1) {
                        po.setRemark("\u5206\u9500\u72b6\u6001\u53ea\u80fd\u586b0\u62161");
                        po.setImportStaus(Integer.valueOf(2));
                        po.setCardNo(memberCardNo);
                        this.cusDistributionTaskDetailPOMapper.insertSelective(po);
                        return;
                    }
                    CusDistributionVO cusDistributionVO = new CusDistributionVO();
                    cusDistributionVO.setCardNo(memberCardNo);
                    cusDistributionVO.setDistributionStatus(Integer.valueOf(Integer.parseInt(distributionStatus)));
                    cusDistributionVOList.add(cusDistributionVO);
                });
            }
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("excel\u6587\u4ef6url\u89e3\u6790\u51fa\u9519!");
            e.printStackTrace();
            po.setImportStaus(Integer.valueOf(2));
            po.setRemark("excel\u6587\u4ef6url\u89e3\u6790\u51fa\u9519!");
            this.cusDistributionTaskDetailPOMapper.insertSelective(po);
            return responseData;
        }
        if (flag.get()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5bfc\u5165excel\u6587\u4ef6\u548c\u6a21\u677f\u6587\u4ef6\u4e0d\u540c!");
            po.setImportStaus(Integer.valueOf(2));
            po.setRemark("\u5bfc\u5165excel\u6587\u4ef6\u548c\u6a21\u677f\u6587\u4ef6\u4e0d\u540c!");
            this.cusDistributionTaskDetailPOMapper.insertSelective(po);
            return responseData;
        }
        return this.asynchronousInsertValidte(cusDistributionVOList, po);
    }

    private ResponseData asynchronousInsertValidte(List<CusDistributionVO> cusDistributionVOList, CusDistributionTaskDetailPO taskDetailPO) {
        log.info("enter MemberDistributionServiceImpl asynchronousInsertValidte method !");
        ResponseData responseData = new ResponseData();
        if (cusDistributionVOList.size() <= 0) {
            responseData.setMessage("\u5bfc\u5165\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        cusDistributionVOList.forEach(cusDistributionVO -> {
            Runnable runnable = () -> {
                MemberRequestCardNoVo memberRequestCardNoVo = new MemberRequestCardNoVo();
                memberRequestCardNoVo.setSysCompanyId(taskDetailPO.getSysCompanyId());
                memberRequestCardNoVo.setBrandId(taskDetailPO.getBrandId());
                memberRequestCardNoVo.setCardNo(cusDistributionVO.getCardNo());
                ResponseData membersInfoByCardNoRes = this.urMemberApiService.getMembersInfoByCardNo(memberRequestCardNoVo);
                if (membersInfoByCardNoRes.getCode() == SysResponseEnum.FAILED.getCode() || membersInfoByCardNoRes.getData() == null) {
                    taskDetailPO.setImportStaus(Integer.valueOf(2));
                    taskDetailPO.setRemark("\u5361\u53f7\u65e0\u6548");
                    taskDetailPO.setCardNo(cusDistributionVO.getCardNo());
                    this.cusDistributionTaskDetailPOMapper.insertSelective(taskDetailPO);
                    return;
                }
                MemberResponseCardNoVo vo = (MemberResponseCardNoVo)membersInfoByCardNoRes.getData();
                CusDistributionPOExample example = new CusDistributionPOExample();
                example.createCriteria().andMemberCodeEqualTo(vo.getMemberCode()).andSysCompanyIdEqualTo(taskDetailPO.getSysCompanyId()).andBrandIdEqualTo(taskDetailPO.getBrandId());
                List cusDistributionPOS = this.cusDistributionPOMapper.selectByExample(example);
                if (cusDistributionPOS == null || cusDistributionPOS.size() == 0) {
                    CusDistributionPO cusDistributionPO = new CusDistributionPO();
                    cusDistributionPO.setSysCompanyId(taskDetailPO.getSysCompanyId());
                    cusDistributionPO.setBrandId(taskDetailPO.getBrandId());
                    cusDistributionPO.setDistributionStatus(Integer.valueOf(cusDistributionVO.getDistributionStatus() == 0 ? 2 : cusDistributionVO.getDistributionStatus()));
                    cusDistributionPO.setMemberCode(vo.getMemberCode());
                    cusDistributionPO.setCommissionBalance(Integer.valueOf(0));
                    cusDistributionPO.setSumCommission(Integer.valueOf(0));
                    cusDistributionPO.setCountDownline(Integer.valueOf(0));
                    cusDistributionPO.setDistribCreateUserId(taskDetailPO.getCreateUserId());
                    cusDistributionPO.setDistribCreateUserName(taskDetailPO.getCreateUserName());
                    cusDistributionPO.setDistribCreateDate(taskDetailPO.getCreatedDate());
                    cusDistributionPO.setCreateUserId(taskDetailPO.getCreateUserId());
                    cusDistributionPO.setCreateUserName(taskDetailPO.getCreateUserName());
                    cusDistributionPO.setCreateDate(taskDetailPO.getCreatedDate());
                    cusDistributionPO.setDistribModifiyUserId(taskDetailPO.getCreateUserId());
                    cusDistributionPO.setDistribModifyUserName(taskDetailPO.getCreateUserName());
                    cusDistributionPO.setDistribModifyDate(taskDetailPO.getCreatedDate());
                    cusDistributionPO.setModifiedUserId(taskDetailPO.getCreateUserId());
                    cusDistributionPO.setModifiedUserName(taskDetailPO.getCreateUserName());
                    cusDistributionPO.setModifiedDate(taskDetailPO.getCreatedDate());
                    cusDistributionPO.setValid(Boolean.valueOf(true));
                    Integer result = this.cusDistributionPOMapper.insertSelective(cusDistributionPO);
                    if (result > 0) {
                        taskDetailPO.setImportStaus(Integer.valueOf(1));
                        taskDetailPO.setCardNo(cusDistributionVO.getCardNo());
                        taskDetailPO.setMemberCode(vo.getMemberCode());
                        taskDetailPO.setDistributionStatus(cusDistributionVO.getDistributionStatus());
                        this.cusDistributionTaskDetailPOMapper.insertSelective(taskDetailPO);
                    }
                } else {
                    CusDistributionPO cusDistributionPO = (CusDistributionPO)cusDistributionPOS.get(0);
                    if (cusDistributionVO.getDistributionStatus() == 1 && StringUtils.isNotBlank((CharSequence)cusDistributionPO.getSuperiorMemberCode())) {
                        taskDetailPO.setImportStaus(Integer.valueOf(2));
                        taskDetailPO.setCardNo(cusDistributionVO.getCardNo());
                        taskDetailPO.setDistributionStatus(cusDistributionVO.getDistributionStatus());
                        taskDetailPO.setMemberCode(vo.getMemberCode());
                        taskDetailPO.setRemark("\u5b58\u5728\u4e0a\u7ea7\u5206\u9500\u5458\u4e0d\u80fd\u76f4\u63a5\u542f\u7528,\u9700\u5148\u624b\u52a8\u89e3\u7ed1\u5173\u7cfb");
                        this.cusDistributionTaskDetailPOMapper.insertSelective(taskDetailPO);
                        return;
                    }
                    cusDistributionPO.setDistributionStatus(Integer.valueOf(cusDistributionVO.getDistributionStatus() == 0 ? 2 : cusDistributionVO.getDistributionStatus()));
                    cusDistributionPO.setDistribModifiyUserId(taskDetailPO.getCreateUserId());
                    cusDistributionPO.setDistribModifyUserName(taskDetailPO.getCreateUserName());
                    cusDistributionPO.setDistribModifyDate(taskDetailPO.getCreatedDate());
                    cusDistributionPO.setModifiedUserId(taskDetailPO.getCreateUserId());
                    cusDistributionPO.setModifiedUserName(taskDetailPO.getCreateUserName());
                    cusDistributionPO.setModifiedDate(taskDetailPO.getCreatedDate());
                    Integer result = this.cusDistributionPOMapper.updateDisStatusByMemberCode(cusDistributionPO);
                    if (result > 0) {
                        taskDetailPO.setImportStaus(Integer.valueOf(1));
                        taskDetailPO.setCardNo(cusDistributionVO.getCardNo());
                        taskDetailPO.setMemberCode(vo.getMemberCode());
                        taskDetailPO.setDistributionStatus(cusDistributionVO.getDistributionStatus());
                        this.cusDistributionTaskDetailPOMapper.insertSelective(taskDetailPO);
                    }
                }
            };
            ThreadPool.run((Runnable)runnable);
        });
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData<CusDistributionRegxPO> findDistributionRegx(MemberDistributionRegxVo memberDistributionRegxVo) {
        log.info("enter MemberDistributionServiceImpl findDistributionRegx method !");
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        List cusDistributionRegxPOS = this.cusDistributionRegxPOMapper.selectByBrandIdAndCompanyId((CusDistributionRegxPO)memberDistributionRegxVo);
        if (cusDistributionRegxPOS != null && cusDistributionRegxPOS.size() > 0) {
            responseData.setData(cusDistributionRegxPOS.get(0));
        }
        return responseData;
    }

    public ResponseData<PageInfo<CusDistributionExchangePO>> findDistributionExchange(MemberDistributionVo memberDistributionVo) {
        log.info("enter MemberDistributionServiceImpl findDistributionExchange method !");
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)memberDistributionVo.getPageNumber(), (int)memberDistributionVo.getPageSize());
        List list = this.cusDistributionExchangePOMapper.selectByVo(memberDistributionVo, Long.valueOf(1L), Long.valueOf(1L));
        PageInfo pageInfo = new PageInfo(list);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData commissionExchangeExport(MemberDistributionVo memberDistributionVo, Optional<SysAccountPO> currentUser) {
        log.info("enter MemberDistributionServiceImpl commissionExchangeExport method !");
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        SysAccountPO sysAccountPO = currentUser.get();
        memberDistributionVo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        memberDistributionVo.setBrandId(sysAccountPO.getBrandId());
        if (memberDistributionVo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        try {
            List CusDistributionExchangePOS = this.cusDistributionExchangePOMapper.selectByVo(memberDistributionVo, Long.valueOf(1L), Long.valueOf(1L));
            long sum = CusDistributionExchangePOS.size();
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = new FileTaskPo();
            fileTaskPo.setTaskId(taskId);
            fileTaskPo.setFileId(String.valueOf(taskId));
            fileTaskPo.setTaskTypeCode(sum + "\u6761");
            fileTaskPo.setTaskName("\u4f63\u91d1\u5151\u6362\u8bb0\u5f55");
            if (sysAccountPO != null) {
                fileTaskPo.setSysBrandId(sysAccountPO.getBrandId());
                fileTaskPo.setCreateUserId(sysAccountPO.getSysAccountId());
                fileTaskPo.setCreateUserName(sysAccountPO.getName());
            }
            fileTaskPo.setFileStatus(Long.valueOf(0L));
            fileTaskPo.setFileType("EXPORT");
            fileTaskPo.setValid(Boolean.valueOf(true));
            this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(sum));
            Boolean isDesensitize = this.storageCardService.getMemberDataDesensitizeByAccountConfig(sysAccountPO.getSysAccountId());
            new Thread(() -> {
                try {
                    exportExcelUtil.setExportProcessId((Object)taskId);
                    Method method = this.cusDistributionExchangePOMapper.getClass().getMethod("selectByVo", MemberDistributionVo.class, Long.class, Long.class);
                    exportExcelUtil.read("cusDistributionExchangePOMapper", method, (model, row) -> {
                        if (isDesensitize.booleanValue() && null != model) {
                            model.setPhone(DesensitizeUtil.encrypt((String)model.getPhone()));
                        }
                        if (row.getRowNum() == 0) {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue("\u5206\u9500\u5458\u624b\u673a\u53f7");
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue("\u5206\u9500\u5458\u59d3\u540d");
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue("\u6240\u5c5e\u95e8\u5e97");
                            Cell cell3 = row.createCell(3);
                            cell2.setCellValue("\u5151\u6362\u4f63\u91d1");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue("\u5151\u6362\u79ef\u5206");
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue("\u5151\u6362\u65f6\u95f4");
                        } else {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getPhone(), (Object)""));
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getName(), (Object)""));
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getServiceStoreName(), (Object)""));
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue((double)model.getCommission().intValue());
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue((double)model.getIntegral().intValue());
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue(model.getCreateDate() != null ? DateUtil.format((Date)model.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss") : "");
                        }
                    }, new Object[]{memberDistributionVo});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
            new Thread(() -> ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"\u4f63\u91d1\u5151\u6362\u8bb0\u5f55\u5bfc\u51fa_")).start();
        }
        catch (Exception e) {
            log.error("method commissionExchangeExport error:" + e.getMessage());
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f!");
        return responseData;
    }

    public ResponseData<MemberDistributionPageVo> queryDistribution(MemberDistributionPageVo vo) {
        log.info("enter MemberDistributionServiceImpl queryDistribution method !");
        ResponseData responseData = new ResponseData();
        CusDistributionRegxPO cusDistributionRegxPO = new CusDistributionRegxPO();
        cusDistributionRegxPO.setSysCompanyId(vo.getSysCompanyId());
        cusDistributionRegxPO.setBrandId(vo.getBrandId());
        List cusDistributionRegxPOS = this.cusDistributionRegxPOMapper.selectByBrandIdAndCompanyId(cusDistributionRegxPO);
        CusDistributionPOExample example = new CusDistributionPOExample();
        example.createCriteria().andBrandIdEqualTo(vo.getBrandId()).andSysCompanyIdEqualTo(vo.getSysCompanyId()).andMemberCodeEqualTo(vo.getMemberCode());
        List cusDistributionPOList = this.cusDistributionPOMapper.selectByExample(example);
        if (cusDistributionRegxPOS != null && cusDistributionRegxPOS.size() > 0 && ((CusDistributionRegxPO)cusDistributionRegxPOS.get(0)).getCommissionStatus() == 1) {
            RedisClient redisClient = RedisManager.getInstince();
            boolean exists = redisClient.exists(vo.getSysCompanyId() + "MEMBER_DISTRIBUTION_REGX_KEY" + vo.getBrandId());
            if (exists) {
                JSONObject regxJson;
                JSONObject regxMap = regxJson = JSONObject.parseObject((String)redisClient.get(vo.getSysCompanyId() + "MEMBER_DISTRIBUTION_REGX_KEY" + vo.getBrandId()).toString());
                vo.setCommissionName(StringUtil.valueOf(regxMap.get("commissionName")));
            } else {
                vo.setCommissionName(((CusDistributionRegxPO)cusDistributionRegxPOS.get(0)).getCommissionName());
            }
            if (cusDistributionPOList != null && cusDistributionPOList.size() > 0) {
                vo.setCommissionBalance(((CusDistributionPO)cusDistributionPOList.get(0)).getCommissionBalance());
                if (((CusDistributionRegxPO)cusDistributionRegxPOS.get(0)).getCommissionStatus() == 1 && ((CusDistributionPO)cusDistributionPOList.get(0)).getDistributionStatus() == 1) {
                    vo.setIsDistributor(Boolean.valueOf(true));
                } else {
                    vo.setIsDistributor(Boolean.valueOf(false));
                }
            } else {
                vo.setIsDistributor(Boolean.valueOf(false));
                vo.setCommissionBalance(Integer.valueOf(0));
            }
        } else {
            if (cusDistributionPOList != null && cusDistributionPOList.size() > 0) {
                vo.setCommissionBalance(((CusDistributionPO)cusDistributionPOList.get(0)).getCommissionBalance());
            } else {
                vo.setCommissionBalance(Integer.valueOf(0));
            }
            vo.setIsDistributor(Boolean.valueOf(false));
        }
        responseData.setData((Object)vo);
        return responseData;
    }

    public ResponseData<String> queryCommissionRegular(MemberDistributionPageVo vo) {
        log.info("enter MemberDistributionServiceImpl querycommissionRegular method !");
        ResponseData responseData = new ResponseData();
        CusDistributionRegxPO cusDistributionRegxPO = new CusDistributionRegxPO();
        cusDistributionRegxPO.setSysCompanyId(vo.getSysCompanyId());
        cusDistributionRegxPO.setBrandId(vo.getBrandId());
        List cusDistributionRegxPOS = this.cusDistributionRegxPOMapper.selectByBrandIdAndCompanyId(cusDistributionRegxPO);
        if (cusDistributionRegxPOS != null && cusDistributionRegxPOS.size() > 0) {
            responseData.setData((Object)((CusDistributionRegxPO)cusDistributionRegxPOS.get(0)).getCommissionRegular());
        }
        return responseData;
    }

    public ResponseData<MemberDistributionPageVo> queryExchangeRate(MemberDistributionPageVo vo) {
        log.info("enter MemberDistributionServiceImpl queryExchangeRate method !");
        ResponseData responseData = new ResponseData();
        Long sysCompanyId = vo.getSysCompanyId();
        Long brandId = vo.getBrandId();
        CusDistributionPOExample example = new CusDistributionPOExample();
        example.createCriteria().andMemberCodeEqualTo(vo.getMemberCode()).andSysCompanyIdEqualTo(sysCompanyId).andBrandIdEqualTo(brandId).andValidEqualTo(Boolean.valueOf(true));
        List cusDistributionPOList = this.cusDistributionPOMapper.selectByExample(example);
        if (cusDistributionPOList != null && cusDistributionPOList.size() > 0) {
            vo.setCommissionBalance(((CusDistributionPO)cusDistributionPOList.get(0)).getCommissionBalance());
        } else {
            vo.setCommissionBalance(Integer.valueOf(0));
        }
        CusDistributionRegxPO cusDistributionRegxPO = new CusDistributionRegxPO();
        cusDistributionRegxPO.setSysCompanyId(sysCompanyId);
        cusDistributionRegxPO.setBrandId(brandId);
        List cusDistributionRegxPOS = this.cusDistributionRegxPOMapper.selectByBrandIdAndCompanyId(cusDistributionRegxPO);
        if (cusDistributionRegxPOS == null || cusDistributionRegxPOS.size() == 0 || ((CusDistributionRegxPO)cusDistributionRegxPOS.get(0)).getCommissionStatus() == 2) {
            log.info("\u6ca1\u6709\u5bf9\u5e94\u5206\u9500\u89c4\u5219");
            vo.setExchangeDescription("");
            vo.setCommissionName("\u4f63\u91d1");
            vo.setCommission(Integer.valueOf(0));
            vo.setIntegral(Integer.valueOf(0));
            responseData.setData((Object)vo);
            return responseData;
        }
        CusDistributionRegxPO po = (CusDistributionRegxPO)cusDistributionRegxPOS.get(0);
        vo.setExchangeDescription(po.getExchangeDescription());
        RedisClient redisClient = RedisManager.getInstince();
        boolean exists = redisClient.exists(sysCompanyId + "MEMBER_DISTRIBUTION_REGX_KEY" + brandId);
        if (exists) {
            JSONObject regxJson;
            JSONObject regxMap = regxJson = JSONObject.parseObject((String)redisClient.get(sysCompanyId + "MEMBER_DISTRIBUTION_REGX_KEY" + brandId).toString());
            vo.setCommissionName(StringUtil.valueOf(regxMap.get("commissionName")));
            vo.setCommission(Integer.valueOf(Integer.parseInt(StringUtil.valueOf(regxMap.get("commission")))));
            vo.setIntegral(Integer.valueOf(Integer.parseInt(StringUtil.valueOf(regxMap.get("integral")))));
        } else {
            vo.setCommissionName(po.getCommissionName());
            vo.setCommission(po.getCommission());
            vo.setIntegral(po.getIntegral());
        }
        responseData.setData((Object)vo);
        return responseData;
    }

    public ResponseData<MemberDistributionPageVo> queryCommissionIntegral(MemberDistributionPageVo vo) {
        log.info("enter MemberDistributionServiceImpl queryCommissionIntegral method !");
        ResponseData responseData = new ResponseData();
        Integer commissionOld = vo.getCommission();
        Integer integralOld = vo.getIntegral();
        Integer commission = vo.getCommissionBalance();
        vo.setCommission(Integer.valueOf(commission / commissionOld * integralOld * commissionOld / integralOld));
        vo.setIntegral(Integer.valueOf(commission / commissionOld * integralOld));
        responseData.setData((Object)vo);
        return responseData;
    }

    public ResponseData runCommissionTask(String param) {
        log.info("enter MemberDistributionServiceImpl runCommissionTask method !");
        ResponseData responseData = new ResponseData();
        MemberDistributionVo vo = new MemberDistributionVo();
        vo.setCommissionStatus(Integer.valueOf(1));
        JSONObject jsonObject = JSONObject.parseObject((String)param);
        if (jsonObject.get((Object)"sysCompanyId") == null || jsonObject.get((Object)"brandId") == null) {
            log.info("enter MemberDistributionServiceImpl runCommissionTask method sysCompanyId or brandId is null !");
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("sysCompanyId or brandId is null !");
            return responseData;
        }
        vo.setSysCompanyId(Long.valueOf(Long.parseLong(jsonObject.get((Object)"sysCompanyId").toString())));
        vo.setBrandId(Long.valueOf(Long.parseLong(jsonObject.get((Object)"brandId").toString())));
        List cusDistributionRecordPOList = this.cusDistributionRecordPOMapper.queryRecordDeal(vo);
        if (cusDistributionRecordPOList != null && cusDistributionRecordPOList.size() > 0) {
            int sum = cusDistributionRecordPOList.size();
            for (CusDistributionRecordPO po : cusDistributionRecordPOList) {
                Integer commission = po.getCommission();
                CusDistributionPO cusDistributionPO = new CusDistributionPO();
                cusDistributionPO.setSysCompanyId(po.getSysCompanyId());
                cusDistributionPO.setBrandId(po.getBrandId());
                cusDistributionPO.setMemberCode(po.getpMemberCode());
                cusDistributionPO.setSumCommission(commission);
                cusDistributionPO.setCommissionBalance(commission);
                cusDistributionPO.setModifiedDate(new Date());
                this.cusDistributionPOMapper.updateByMemberCode(cusDistributionPO);
                cusDistributionPO.setMemberCode(po.getcMemberCode());
                cusDistributionPO.setContributionCommission(commission);
                this.cusDistributionPOMapper.updateByCMemberCode(cusDistributionPO);
                po.setCommissionStatus(Integer.valueOf(2));
                po.setDealDate(new Date());
                po.setModifiedDate(new Date());
                this.cusDistributionRecordPOMapper.updateByPrimaryKeySelective(po);
            }
        }
        return responseData;
    }

    public Long getSecondsNextEarlyMorning() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 1);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return (cal.getTimeInMillis() - System.currentTimeMillis()) / 1000L;
    }

    public String getWxUrl(MemberDistributionShareVo vo) {
        CreateMiniprgmQRCodeRequestVO createMiniprgmQRCodeRequestVO = new CreateMiniprgmQRCodeRequestVO();
        createMiniprgmQRCodeRequestVO.setSysBrandId(vo.getBrandId());
        createMiniprgmQRCodeRequestVO.setMiniProgramType("10");
        createMiniprgmQRCodeRequestVO.setPath("pages/entry/main");
        createMiniprgmQRCodeRequestVO.setScene("distribution," + vo.getTraceId());
        ResponseData qrCodeResponseData = this.qrCodeServiceFeign.createMiniprgmQRCode(createMiniprgmQRCodeRequestVO);
        return (String)qrCodeResponseData.getData();
    }

    public Long saveTrace(String memberCode, String pageUrl, Long sysCompanyId) {
        String traceValue = "{\"source_way\":\"appletagent\",\"channel\":\"1\",\"sub_channel\":\"2\",\"member_code\":\"" + memberCode + "\",\"page\":\"" + pageUrl + "\"}";
        TracePO po = new TracePO();
        po.setTraceValue(traceValue);
        po.setCreateDate(new Date());
        po.setSysCompanyId(sysCompanyId);
        ResponseData responseData = this.coreTraceFeign.insertTrace(po);
        if (responseData.getCode() != com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode()) {
            log.error("\u751f\u6210trace\u5931\u8d25\uff1a" + responseData.getMessage());
            return null;
        }
        return (Long)responseData.getData();
    }

    private String generateTaskBatchCode() {
        return "FX" + UUIDGenerator.getLocalTrmSeqNum();
    }
}

