/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.standard.controller;

import com.bizvane.customized.common.thread.ThreadPool;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.company.standard.service.MemberDistributionService;
import com.bizvane.customized.company.ur.members.service.StorageCardService;
import com.bizvane.customized.facade.models.po.CusDistributionExchangePO;
import com.bizvane.customized.facade.models.po.CusDistributionRecordPO;
import com.bizvane.customized.facade.models.po.CusDistributionRegxPO;
import com.bizvane.customized.facade.models.vo.DistributionMemeberResVo;
import com.bizvane.customized.facade.models.vo.DistributionVo;
import com.bizvane.customized.facade.models.vo.MemberDistributionRegxVo;
import com.bizvane.customized.facade.models.vo.MemberDistributionVo;
import com.bizvane.customized.facade.models.vo.SubordinateMemeberResVo;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.utils.DesensitizeUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(description="\u4f1a\u5458\u5206\u9500")
@RestController
@RequestMapping(value={"/memberDistribution"})
public class MemberDistributionController {
    private static final Logger log = LoggerFactory.getLogger(MemberDistributionController.class);
    @Autowired
    private MemberDistributionService memberDistributionService;
    @Autowired
    private StorageCardService storageCardService;

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u5458\u5206\u9500\u89c4\u5219")
    @PostMapping(value={"/findDistributionRegx"})
    public ResponseData<CusDistributionRegxPO> findDistributionRegx(MemberDistributionRegxVo memberDistributionRegxVo, HttpServletRequest request) {
        log.info("enter addAndUpdateDistributionRegx method param: memberDistributionRegxVo:{}", (Object)JacksonUtil.bean2Json((Object)memberDistributionRegxVo));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        memberDistributionRegxVo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        memberDistributionRegxVo.setBrandId(sysAccountPO.getBrandId());
        return this.memberDistributionService.findDistributionRegx(memberDistributionRegxVo);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4f1a\u5458\u5206\u9500\u89c4\u5219")
    @PostMapping(value={"/addAndUpdateDistributionRegx"})
    public ResponseData addAndUpdateDistributionRegx(MemberDistributionRegxVo memberDistributionRegxVo, HttpServletRequest request) {
        log.info("enter addAndUpdateDistributionRegx method  param: memberDistributionRegxVo:{}", (Object)JacksonUtil.bean2Json((Object)memberDistributionRegxVo));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        memberDistributionRegxVo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        memberDistributionRegxVo.setBrandId(sysAccountPO.getBrandId());
        memberDistributionRegxVo.setOperatorId(sysAccountPO.getSysAccountId());
        memberDistributionRegxVo.setOperatorName(sysAccountPO.getName());
        return this.memberDistributionService.addAndUpdateDistributionRegx(memberDistributionRegxVo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u9500\u5458\u5217\u8868")
    @PostMapping(value={"/queryDistributionMemberList"})
    public ResponseData queryDistributionMemberList(DistributionVo distributionVo, HttpServletRequest request) {
        log.info("enter MemberDistributionController queryDistributionMemberList param:{}", (Object)JacksonUtil.bean2Json((Object)distributionVo));
        ResponseData responseData = new ResponseData();
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        Optional<SysAccountPO> currentUser = Optional.ofNullable(accountPO);
        PageRequest pageable = PageRequest.of((int)distributionVo.getPageNumber(), (int)distributionVo.getPageSize());
        PageInfo pageInfo = this.memberDistributionService.queryDistributionMemberList(distributionVo, currentUser, (Pageable)pageable);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u9500\u4e0b\u7ea7\u4f1a\u5458\u5217\u8868")
    @PostMapping(value={"/querySubordinateMemberList"})
    public ResponseData querySubordinateMemberList(DistributionVo vo, HttpServletRequest request) {
        log.info("enter MemberDistributionController querySubordinateMemberList param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        Optional<SysAccountPO> currentUser = Optional.ofNullable(accountPO);
        PageRequest pageable = PageRequest.of((int)vo.getPageNumber(), (int)vo.getPageSize());
        PageInfo pageInfo = this.memberDistributionService.querySubordinateMemberList(vo, currentUser, (Pageable)pageable);
        Boolean isDesensitize = this.storageCardService.getMemberDataDesensitizeByAccountConfig(accountPO.getSysAccountId());
        if (isDesensitize.booleanValue() && null != pageInfo && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            for (SubordinateMemeberResVo resVo : pageInfo.getList()) {
                resVo.setCardNo(DesensitizeUtil.encrypt((String)resVo.getCardNo()));
                resVo.setPhone(DesensitizeUtil.encrypt((String)resVo.getPhone()));
                resVo.setCPhone(DesensitizeUtil.encrypt((String)resVo.getCPhone()));
            }
        }
        return ResponseDataUtil.getSuccessData((Object)pageInfo);
    }

    @ApiOperation(value="\u5bfc\u51fa\u5206\u9500\u4e0b\u7ea7\u4f1a\u5458\u5217\u8868")
    @PostMapping(value={"/exportSubordinateMemberList"})
    public ResponseData exportSubordinateMemberList(DistributionVo vo, HttpServletRequest request) {
        log.info("enter MemberDistributionController exportSubordinateMemberList param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        Optional<SysAccountPO> currentUser = Optional.ofNullable(accountPO);
        return this.memberDistributionService.exportSubordinateMemberList(vo, currentUser);
    }

    @ApiOperation(value="\u5bfc\u51fa\u5206\u9500\u5458\u5217\u8868")
    @PostMapping(value={"/exportDistributionMemberList"})
    public ResponseData exportDistributionMemberList(DistributionVo memberDistributionVo, HttpServletRequest request) {
        log.info("enter MemberDistributionController exportDistributionMemberList param:{}", (Object)JacksonUtil.bean2Json((Object)memberDistributionVo));
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        Optional<SysAccountPO> currentUser = Optional.ofNullable(accountPO);
        return this.memberDistributionService.exportDistributionMemberList(memberDistributionVo, currentUser);
    }

    @ApiOperation(value="\u7981\u7528\u6216\u8005\u542f\u7528\u5206\u9500")
    @PostMapping(value={"/updateDistributionState"})
    public ResponseData updateDistributionState(DistributionMemeberResVo vo, HttpServletRequest request) {
        log.info("enter MemberDistributionController updateDistributionState param:{}", (Object)vo);
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setOperater(accountPO.getName());
        vo.setOperaterId(accountPO.getSysAccountId());
        Date date = new Date();
        vo.setOperateTime(date);
        vo.setSysCompanyId(accountPO.getSysCompanyId());
        vo.setBrandId(accountPO.getBrandId());
        try {
            return this.memberDistributionService.updateDistributionState(vo);
        }
        catch (MemberException me) {
            ResponseData responseData = new ResponseData();
            responseData.setData((Object)0);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(me.getMessage());
            return responseData;
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u4f63\u91d1\u6d41\u6c34")
    @PostMapping(value={"/queryCommissionRecord"})
    public ResponseData<PageInfo<CusDistributionRecordPO>> queryCommissionRecord(MemberDistributionVo vo, HttpServletRequest request) {
        log.info("enter MemberDistributionController queryCommissionRecord param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(accountPO.getSysCompanyId());
        vo.setBrandId(accountPO.getBrandId());
        ResponseData responseData = this.memberDistributionService.queryCommissionRecord(vo);
        Boolean isDesensitize = this.storageCardService.getMemberDataDesensitizeByAccountConfig(accountPO.getSysAccountId());
        if (isDesensitize.booleanValue() && null != responseData && CollectionUtils.isNotEmpty((Collection)((PageInfo)responseData.getData()).getList())) {
            for (CusDistributionRecordPO responsePo : ((PageInfo)responseData.getData()).getList()) {
                responsePo.setCardNo(DesensitizeUtil.encrypt((String)responsePo.getCardNo()));
                responsePo.setcPhone(DesensitizeUtil.encrypt((String)responsePo.getcPhone()));
                responsePo.setpPhone(DesensitizeUtil.encrypt((String)responsePo.getpPhone()));
            }
        }
        return responseData;
    }

    @ApiOperation(value="\u67e5\u8be2\u4f63\u91d1\u6d41\u6c34\u5bfc\u51fa")
    @PostMapping(value={"/commissionRecordExport"})
    public ResponseData commissionRecordExport(MemberDistributionVo memberDistributionVo, HttpServletRequest request) {
        log.info("enter MemberDistributionController commissionRecordExport param:{}", (Object)JacksonUtil.bean2Json((Object)memberDistributionVo));
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        Optional<SysAccountPO> currentUser = Optional.ofNullable(accountPO);
        return this.memberDistributionService.commissionRecordExport(memberDistributionVo, currentUser);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f63\u91d1\u5151\u6362\u8bb0\u5f55")
    @PostMapping(value={"/findDistributionExchange"})
    public ResponseData<PageInfo<CusDistributionExchangePO>> findDistributionExchange(MemberDistributionVo memberDistributionVo, HttpServletRequest request) {
        log.info("enter findDistributionExchange method param: memberDistributionVo:{}", (Object)JacksonUtil.bean2Json((Object)memberDistributionVo));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        memberDistributionVo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        memberDistributionVo.setBrandId(sysAccountPO.getBrandId());
        ResponseData responseData = this.memberDistributionService.findDistributionExchange(memberDistributionVo);
        Boolean isDesensitize = this.storageCardService.getMemberDataDesensitizeByAccountConfig(sysAccountPO.getSysAccountId());
        if (isDesensitize.booleanValue() && null != responseData && CollectionUtils.isNotEmpty((Collection)((PageInfo)responseData.getData()).getList())) {
            for (CusDistributionExchangePO responsePo : ((PageInfo)responseData.getData()).getList()) {
                responsePo.setPhone(DesensitizeUtil.encrypt((String)responsePo.getPhone()));
            }
        }
        return responseData;
    }

    @ApiOperation(value="\u4f63\u91d1\u5151\u6362\u8bb0\u5f55\u5bfc\u51fa")
    @PostMapping(value={"/commissionExchangeExport"})
    public ResponseData commissionExchangeExport(MemberDistributionVo memberDistributionVo, HttpServletRequest request) {
        log.info("enter MemberDistributionController commissionExchangeExport param:{}", (Object)JacksonUtil.bean2Json((Object)memberDistributionVo));
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        Optional<SysAccountPO> currentUser = Optional.ofNullable(accountPO);
        return this.memberDistributionService.commissionExchangeExport(memberDistributionVo, currentUser);
    }

    @ApiOperation(value="\u542f\u52a8\u8ba1\u7b97\u4f63\u91d1\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"/runCommissionTask"})
    public ResponseData runCommissionTask(String param) {
        log.info("enter MemberDistributionController runCommissionTask:{}", (Object)JacksonUtil.bean2Json((Object)param));
        return this.memberDistributionService.runCommissionTask(param);
    }

    @ApiOperation(value="\u89e3\u7ed1\uff0c\u6279\u91cf\u89e3\u7ed1")
    @PostMapping(value={"/cancelBind"})
    public ResponseData cancelBind(MemberDistributionVo vo, HttpServletRequest request) {
        log.info("enter MemberDistributionController cancelBind params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        Optional<SysAccountPO> currentUser = Optional.ofNullable(sysAccountPO);
        return this.memberDistributionService.cancelBind(vo, currentUser);
    }

    @PostMapping(value={"/importDistributionExcel"})
    public ResponseData<String> importDistributionExcel(String url, HttpServletRequest request) {
        log.info("enter MemberDistributionController importDistributionExcel param {}", (Object)url);
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        Runnable runnable = () -> this.memberDistributionService.importDistributionExcel(url, optional);
        ThreadPool.run((Runnable)runnable);
        ResponseData responseData = new ResponseData();
        responseData.setMessage("\u5bfc\u5165\u4e2d\uff01");
        return responseData;
    }
}

