/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.mj.controller.rpc;

import com.bizvane.baisonBase.facade.models.mj.QueryGiftRecordsResponseVo;
import com.bizvane.customized.company.mj.service.CurMjGiftCardConfigService;
import com.bizvane.customized.company.mj.service.CurMjGiftCardService;
import com.bizvane.customized.company.wm.service.WmCouponSyncService;
import com.bizvane.customized.facade.models.vo.mj.CurMjGiftCardConfigVo;
import com.bizvane.customized.facade.models.vo.mj.CurMjGiftCardRecordRequestVo;
import com.bizvane.customized.facade.models.vo.mj.CusMjGiftCardRequestVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"mjGiftCardRpc"})
public class CurMjGiftCardRpcController {
    @Autowired
    private CurMjGiftCardService curMjGiftCardService;
    @Autowired
    private CurMjGiftCardConfigService curMjGiftCardConfigService;
    @Autowired
    private WmCouponSyncService wmCouponSyncService;

    @RequestMapping(value={"bindGiftCard"}, method={RequestMethod.POST})
    public ResponseData<String> bindGiftCard(@RequestBody @Valid CusMjGiftCardRequestVo vo, BindingResult bindingResult) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        if (bindingResult.hasErrors()) {
            String defaultMessage = bindingResult.getFieldError().getDefaultMessage();
            responseData.setMessage(defaultMessage);
            return responseData;
        }
        responseData = this.curMjGiftCardService.bindGiftCard(vo);
        return responseData;
    }

    @RequestMapping(value={"getGiftCardConfig"}, method={RequestMethod.POST})
    public ResponseData<CurMjGiftCardConfigVo> getGiftCardConfig(@RequestBody CurMjGiftCardConfigVo vo) {
        ResponseData responseData = this.curMjGiftCardConfigService.getGiftCardConfig(vo);
        return responseData;
    }

    @RequestMapping(value={"selectPage"}, method={RequestMethod.POST})
    public ResponseData<PageInfo<QueryGiftRecordsResponseVo>> selectPage(@RequestBody CurMjGiftCardRecordRequestVo vo) {
        ResponseData responseData = this.curMjGiftCardService.selectPageNew(vo);
        return responseData;
    }

    @RequestMapping(value={"sendUserCouponForMjRetry"}, method={RequestMethod.POST})
    public ResponseData<Object> sendUserCouponForMjRetry(@RequestParam(value="phone", required=true) String phone) {
        this.wmCouponSyncService.sendUserCouponForMjRetry(phone);
        return new ResponseData();
    }
}

