/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.littleStar.giftCard.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.OrderItemVO;
import com.bizvane.connectorservice.entity.common.SingleRetailAddRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.OutOfConnectServiceFeign;
import com.bizvane.customized.company.littleStar.giftCard.model.CompanyBrandBO;
import com.bizvane.customized.company.littleStar.giftCard.service.CompanyBrandService;
import com.bizvane.customized.company.littleStar.giftCard.service.CusLittleStarGoodCardService;
import com.bizvane.customized.facade.models.po.CusLittleStarGoodCardEntityPO;
import com.bizvane.customized.facade.models.vo.CusLittleStarGoodsCardCreateData;
import com.bizvane.customized.facade.models.vo.CusLittleStarGoodsCardCreateDataOrderItem;
import com.bizvane.customized.mappers.CusLittleStarGoodCardEntityPOMapper;
import com.bizvane.trace.service.TraceService;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CusLittleStarGoodCardServiceImpl
implements CusLittleStarGoodCardService {
    private static final Logger log = LoggerFactory.getLogger(CusLittleStarGoodCardServiceImpl.class);
    @Autowired
    private CusLittleStarGoodCardEntityPOMapper cusLittleStarGoodCardEntityPOMapper;
    @Autowired
    private OutOfConnectServiceFeign outOfConnectServiceFeign;
    @Autowired
    private TraceService traceService;
    @Autowired
    private CompanyBrandService companyBrandService;

    public void create(CusLittleStarGoodsCardCreateData data) {
        CompanyBrandBO companyBrand = this.companyBrandService.getCompanyBrand(data.getCompanyCode(), data.getBrandCode());
        CusLittleStarGoodsCardCreateDataOrderItem order_item = data.getOrder_item();
        CusLittleStarGoodCardEntityPO entityPO = CusLittleStarGoodCardEntityPO.builder().sysCompanyId(companyBrand.getCompanyId()).sysBrandId(companyBrand.getBrandId()).cardNo(data.getCard_no()).consigneeAddress(data.getConsignee_address()).consigneeArea(data.getConsignee_area()).consigneeCity(data.getConsignee_city()).consigneeProvince(data.getConsignee_province()).consigneeName(data.getConsignee_name()).consigneePhone(data.getConsignee_phone()).corpCode(data.getCorp_code()).createDate(new Date()).eorderNo(data.getEorder_no()).expiredDate("21171231").orderId(String.valueOf(System.currentTimeMillis())).orderIdOnline(data.getTrade_no()).orderItem(JSON.toJSONString((Object)order_item)).orderTime(data.getOrder_time()).trace(this.traceService.trace()).build();
        this.cusLittleStarGoodCardEntityPOMapper.insertSelective(entityPO);
        SingleRetailAddRequestVO requestVO = new SingleRetailAddRequestVO();
        requestVO.setBrandId(companyBrand.getBrandId());
        requestVO.setOfflineBrandCode(data.getBrandCode());
        requestVO.setOrder_time(data.getOrder_time());
        requestVO.setConsignee_address(data.getConsignee_address());
        requestVO.setConsignee_area(data.getConsignee_area());
        requestVO.setConsignee_city(data.getConsignee_city());
        requestVO.setConsignee_province(data.getConsignee_province());
        requestVO.setConsignee_name(data.getConsignee_name());
        requestVO.setConsignee_phone(data.getConsignee_phone());
        requestVO.setEordercode(data.getEorder_no());
        OrderItemVO itemVO = new OrderItemVO();
        itemVO.setBarcode(order_item.getSku_code());
        itemVO.setQuantity(order_item.getQuantity() == null ? "0" : String.valueOf(order_item.getQuantity()));
        itemVO.setTotalfee(order_item.getAmount());
        requestVO.setWx_order_item(Collections.singletonList(new OrderItemVO()));
        log.info("connectorServiceFeign addSingleRetail requestvo : {}", (Object)JSON.toJSONString((Object)requestVO));
        Result result = this.outOfConnectServiceFeign.addSingleRetail(requestVO);
        log.info("CusLittleStarGoodCardServiceImpl create goodcard write to offlien result code : {}, message : {}", (Object)result.getCode(), (Object)result.getMessage());
    }
}

