/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.littleStar.giftCard.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.ValueCardAddRequestVO;
import com.bizvane.connectorservice.entity.common.ValueCardUpdateRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.OutOfConnectServiceFeign;
import com.bizvane.customized.common.utils.NumberUtil;
import com.bizvane.customized.company.littleStar.giftCard.model.CompanyBrandBO;
import com.bizvane.customized.company.littleStar.giftCard.service.CompanyBrandService;
import com.bizvane.customized.company.littleStar.giftCard.service.CusLittleStarGiftCardService;
import com.bizvane.customized.facade.models.po.CusLittleStarGiftCardChangePO;
import com.bizvane.customized.facade.models.po.CusLittleStarGiftCardEntityPO;
import com.bizvane.customized.facade.models.po.CusLittleStarGiftCardEntityPOExample;
import com.bizvane.customized.facade.models.vo.CusLittleStarGiftCardCreateCardListElement;
import com.bizvane.customized.facade.models.vo.CusLittleStarGiftCardCreateData;
import com.bizvane.customized.facade.models.vo.CusLittleStarGiftCardDisableData;
import com.bizvane.customized.facade.models.vo.CusLittleStarGiftCardMoData;
import com.bizvane.customized.mappers.CusLittleStarGiftCardChangePOMapper;
import com.bizvane.customized.mappers.CusLittleStarGiftCardEntityPOMapper;
import com.bizvane.trace.service.TraceService;
import io.jsonwebtoken.lang.Assert;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CusLittleStarGiftCardServiceImpl
implements CusLittleStarGiftCardService {
    private static final Logger log = LoggerFactory.getLogger(CusLittleStarGiftCardServiceImpl.class);
    @Autowired
    private CusLittleStarGiftCardEntityPOMapper cusLittleStarGiftCardEntityPOMapper;
    @Autowired
    private CusLittleStarGiftCardChangePOMapper cusLittleStarGiftCardChangePOMapper;
    @Autowired
    private OutOfConnectServiceFeign outOfConnectServiceFeign;
    @Autowired
    private CompanyBrandService companyBrandService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private static final String CREATE_CARD_KEY = "customized-CusLittleStarGiftCardServiceImpl-create-%s-%s";
    private static final String CREATE_CARD_VALUE = "&";
    private BigDecimal coefficient = new BigDecimal(100);
    @Autowired
    private TraceService traceService;

    public void create(CusLittleStarGiftCardCreateData data) {
        CompanyBrandBO companyBrand = this.companyBrandService.getCompanyBrand(data.getCompanyCode(), data.getBrandCode());
        for (CusLittleStarGiftCardCreateCardListElement card : data.getCard_list()) {
            if (this.isCardExist(data.getCorp_code(), card.getCode())) {
                log.info("CusLittleStarGiftCardServiceImpl create card exist !");
                continue;
            }
            BigDecimal price = new BigDecimal(card.getPrice());
            BigDecimal balance = new BigDecimal(card.getBalance());
            BigDecimal factAmount = price.divide(this.coefficient, 2, 4);
            BigDecimal amount = balance.divide(this.coefficient, 2, 4);
            CusLittleStarGiftCardEntityPO po = CusLittleStarGiftCardEntityPO.builder().sysCompanyId(companyBrand.getCompanyId()).sysBrandId(companyBrand.getBrandId()).appId(data.getApp_id()).bindPasswd(NumberUtil.random((int)6)).factAmount(factAmount.toString()).openId(data.getOpen_id()).corpCode(data.getCorp_code()).createDate(new Date()).cardNo(card.getCode()).publishDate(StringUtils.isEmpty((CharSequence)data.getPublish_date()) ? this.formatDate(LocalDate.now().toString()) : this.formatDate(data.getPublish_date())).expiredDate("21180212").cardType(data.getCard_type()).trace(this.traceService.trace()).balance(card.getBalance()).amount(amount.toString()).build();
            this.cusLittleStarGiftCardEntityPOMapper.insertSelective(po);
            ValueCardAddRequestVO requestVO = new ValueCardAddRequestVO();
            requestVO.setBrandId(companyBrand.getBrandId());
            requestVO.setOfflineBrandCode(data.getBrandCode());
            requestVO.setAmount(factAmount.toString());
            requestVO.setBalance(card.getBalance());
            requestVO.setVaulecardno(card.getCode());
            requestVO.setWechatOrderNo(data.getOrder_id());
            requestVO.setTransactionNumber(data.getTrans_id());
            log.info("connectorServiceFeign addValueCard requestvo : {}", (Object)JSON.toJSONString((Object)requestVO));
            Result result = this.outOfConnectServiceFeign.addValueCard(requestVO);
            log.info("CusLittleStarGiftCardServiceImpl create card write to offlien result code : {}, message : {}", (Object)result.getCode(), (Object)result.getMessage());
            if (0 != result.getCode()) continue;
            this.cusLittleStarGiftCardEntityPOMapper.updateOfflienStatus(po.getCorpCode(), po.getCardNo(), "Y");
        }
    }

    @Transactional
    public void mod(CusLittleStarGiftCardMoData data) {
        CompanyBrandBO companyBrand = this.companyBrandService.getCompanyBrand(data.getCompanyCode(), data.getBrandCode());
        CusLittleStarGiftCardEntityPO entityPO = CusLittleStarGiftCardEntityPO.builder().openId(data.getOpen_id()).cardNo(data.getNew_card_no()).build();
        CusLittleStarGiftCardEntityPOExample example = new CusLittleStarGiftCardEntityPOExample();
        example.createCriteria().andCorpCodeEqualTo(data.getCorp_code()).andCardNoEqualTo(data.getCard_no());
        int count = this.cusLittleStarGiftCardEntityPOMapper.updateByExampleSelective(entityPO, example);
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u82f1\u5f0f\u50a8\u503c\u5361\u51fa\u9519");
        example.clear();
        example.createCriteria().andCorpCodeEqualTo(data.getCorp_code()).andCardNoEqualTo(data.getNew_card_no());
        List list = this.cusLittleStarGiftCardEntityPOMapper.selectByExample(example);
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)list) ? 1 : 0) != 0, (String)"\u67e5\u8be2\u82f1\u5f0f\u50a8\u503c\u5361\u51fa\u9519");
        ValueCardUpdateRequestVO requestVO = new ValueCardUpdateRequestVO();
        requestVO.setBrandId(companyBrand.getBrandId());
        requestVO.setOfflineBrandCode(data.getBrandCode());
        requestVO.setNewvaulecardno(data.getNew_card_no());
        requestVO.setOldvaulecardno(data.getCard_no());
        requestVO.setAmount(((CusLittleStarGiftCardEntityPO)list.get(0)).getAmount());
        requestVO.setBalance(((CusLittleStarGiftCardEntityPO)list.get(0)).getBalance());
        requestVO.setOriginalPayAmount(((CusLittleStarGiftCardEntityPO)list.get(0)).getFactAmount());
        log.info("connectorServiceFeign updateValueCard requestvo : {}", (Object)JSON.toJSONString((Object)requestVO));
        Result result = this.outOfConnectServiceFeign.updateValueCard(requestVO);
        log.info("CusLittleStarGiftCardServiceImpl mod card write to offlien result code : {}, message : {}", (Object)result.getCode(), (Object)result.getMessage());
        CusLittleStarGiftCardChangePO changePO = CusLittleStarGiftCardChangePO.builder().sysCompanyId(companyBrand.getCompanyId()).sysBrandId(companyBrand.getBrandId()).corpCode(data.getCorp_code()).cardNo(data.getCard_no()).newCardNo(data.getNew_card_no()).cause(JSON.toJSONString((Object)result)).valid(Boolean.valueOf(result.getCode() == 0)).createDate(new Date()).trace(this.traceService.trace()).build();
        this.cusLittleStarGiftCardChangePOMapper.insertSelective(changePO);
        if (result.getCode() != 0) {
            CusLittleStarGiftCardEntityPO entityPO2 = CusLittleStarGiftCardEntityPO.builder().cardNo(data.getNew_card_no()).build();
            int count2 = this.cusLittleStarGiftCardEntityPOMapper.updateByExampleSelective(entityPO2, example);
            log.info("\u7ebf\u4e0b\u8fd4\u56de\u5931\u8d25\uff0c\u628a\u5361\u53f7\u66f4\u65b0\u56de\u53bb\uff0ccount : {}", (Object)count2);
        }
    }

    public void disable(CusLittleStarGiftCardDisableData data) {
        int count = this.cusLittleStarGiftCardEntityPOMapper.updateDisable(data.getCorp_code(), data.getCard_no(), data.getOpen_id());
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u82f1\u5f0f\u50a8\u503c\u5361\u7981\u7528\u51fa\u9519");
    }

    private boolean isCardExist(String corp_code, String card_no) {
        CusLittleStarGiftCardEntityPOExample example = new CusLittleStarGiftCardEntityPOExample();
        example.createCriteria().andCorpCodeEqualTo(corp_code).andCardNoEqualTo(card_no);
        long count = this.cusLittleStarGiftCardEntityPOMapper.countByExample(example);
        if (count > 0L) {
            return true;
        }
        String rkey = String.format(CREATE_CARD_KEY, corp_code, card_no);
        Boolean absent = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)rkey, (Object)CREATE_CARD_VALUE);
        if (absent == null || !absent.booleanValue()) {
            return true;
        }
        this.stringRedisTemplate.expire((Object)rkey, 2L, TimeUnit.MINUTES);
        return false;
    }

    private String formatDate(String data) {
        return data.replace("-", "");
    }
}

