/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.goldLion.service.biz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.interfaces.SendCouponServiceFeign;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.customized.common.utils.BeanUtils;
import com.bizvane.customized.company.goldLion.service.base.CusGoldlionMemberActivityService;
import com.bizvane.customized.company.goldLion.service.base.CusGoldlionMemberReceiveRecordService;
import com.bizvane.customized.company.goldLion.service.biz.BizCusGoldlionMemberActivityService;
import com.bizvane.customized.facade.exception.ServiceException;
import com.bizvane.customized.facade.models.vo.goldLion.base.CusGoldlionMemberReceiveRecordVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.BizGoldLionMemberActivityVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.TakeEquityReqVo;
import com.bizvane.utils.redisutils.RedissonTemplate;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizCusGoldlionMemberReceiveRecordService {
    private static final Logger logger = LoggerFactory.getLogger(BizCusGoldlionMemberActivityService.class);
    @Autowired
    private CusGoldlionMemberActivityService cusGoldlionMemberActivityService;
    @Autowired
    private CusGoldlionMemberReceiveRecordService cusGoldlionMemberReceiveRecordService;
    @Autowired
    SendCouponServiceFeign sendCouponServiceFeign;
    @Autowired
    RedissonTemplate redissonTemplate;

    @Transactional(rollbackFor={ServiceException.class})
    public void takeEquity(TakeEquityReqVo takeEquityReqVo) {
        List byActivityNo;
        logger.info("\u9886\u53d6\u6743\u76caBizCusGoldlionMemberActivityService.takeEquity\u5165\u53c2takeEquityReqVo:{}", (Object)JSONObject.toJSONString((Object)takeEquityReqVo));
        BizGoldLionMemberActivityVo bizGoldLionMemberActivityVo = this.cusGoldlionMemberActivityService.getById(takeEquityReqVo.getCusGoldlionMemberActivityId());
        logger.info("\u7ed3\u679cbizGoldLionMemberActivityVo:{}", (Object)JSON.toJSONString((Object)bizGoldLionMemberActivityVo));
        CusGoldlionMemberReceiveRecordVo cusGoldlionMemberReceiveRecordVo = new CusGoldlionMemberReceiveRecordVo();
        cusGoldlionMemberReceiveRecordVo = (CusGoldlionMemberReceiveRecordVo)BeanUtils.copyProperties((Object)takeEquityReqVo, CusGoldlionMemberReceiveRecordVo.class);
        if (bizGoldLionMemberActivityVo == null) {
            throw new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (bizGoldLionMemberActivityVo.getAlreadyReceivedAmount().equals(bizGoldLionMemberActivityVo.getTotalAcquirableEquityAmount())) {
            throw new ServiceException("\u5f53\u524d\u6743\u76ca\u5df2\u88ab\u5168\u90e8\u9886\u5b8c");
        }
        Integer memberNum = 1;
        Integer activityNum = 1;
        this.cusGoldlionMemberActivityService.updateReceivedAmountById(takeEquityReqVo.getCusGoldlionMemberActivityId());
        cusGoldlionMemberReceiveRecordVo.setMemberRencentUsableAmount(Integer.valueOf(bizGoldLionMemberActivityVo.getMaxAcquirableEquityAmount() - memberNum));
        if (bizGoldLionMemberActivityVo.getTotalAcquirableEquityAmount() < 1) {
            throw new ServiceException("\u5f53\u524d\u6d3b\u52a8\u53ef\u53c2\u4e0e\u6b21\u6570\u4e0d\u8db3");
        }
        List cusGoldlionMemberReceiveRecordVos = this.cusGoldlionMemberReceiveRecordService.getByMemberCodeAndActivityNo(takeEquityReqVo.getMemberCode(), takeEquityReqVo.getActivityNo());
        if (!CollectionUtils.isEmpty((Collection)cusGoldlionMemberReceiveRecordVos)) {
            if (bizGoldLionMemberActivityVo.getMaxAcquirableEquityAmount().equals(cusGoldlionMemberReceiveRecordVos.size())) {
                throw new ServiceException("\u60a8\u7684\u6743\u76ca\u5df2\u9886\u5b8c");
            }
            memberNum = cusGoldlionMemberReceiveRecordVos.size() + memberNum;
        }
        if (!CollectionUtils.isEmpty((Collection)(byActivityNo = this.cusGoldlionMemberReceiveRecordService.getByActivityNo(takeEquityReqVo.getActivityNo())))) {
            activityNum = byActivityNo.size() + activityNum;
        }
        SendCouponSimpleRequestVO sendCouponSimpleRequestVO = new SendCouponSimpleRequestVO();
        sendCouponSimpleRequestVO.setMemberCode(takeEquityReqVo.getMemberCode());
        sendCouponSimpleRequestVO.setSendType("126");
        sendCouponSimpleRequestVO.setCouponDefinitionId(bizGoldLionMemberActivityVo.getCouponId());
        sendCouponSimpleRequestVO.setSendBussienId(bizGoldLionMemberActivityVo.getCusGoldlionMemberActivityId());
        try {
            this.sendCouponServiceFeign.simple(sendCouponSimpleRequestVO);
        }
        catch (Exception e) {
            throw new ServiceException("\u8c03\u7528\u5361\u5238\u6a21\u5757\u53d1\u5238\u63a5\u53e3\u5f02\u5e38");
        }
        cusGoldlionMemberReceiveRecordVo.setActivityRencentUsableAmount(Integer.valueOf(bizGoldLionMemberActivityVo.getTotalAcquirableEquityAmount() - activityNum));
        cusGoldlionMemberReceiveRecordVo.setCouponId(bizGoldLionMemberActivityVo.getCouponId());
        cusGoldlionMemberReceiveRecordVo.setCouponName(bizGoldLionMemberActivityVo.getCouponName());
        this.cusGoldlionMemberReceiveRecordService.add(cusGoldlionMemberReceiveRecordVo);
    }
}

