/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.goldLion.service.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.common.utils.BeanUtils;
import com.bizvane.customized.facade.enums.goldLionEnums.ActivityStatusEnum;
import com.bizvane.customized.facade.exception.ServiceException;
import com.bizvane.customized.facade.models.po.CouponDefinitionWithBLOBs;
import com.bizvane.customized.facade.models.po.CusGoldlionMemberActivity;
import com.bizvane.customized.facade.models.po.CusGoldlionMemberActivityExample;
import com.bizvane.customized.facade.models.vo.CouponDefinitionWithBLOBsVo;
import com.bizvane.customized.facade.models.vo.goldLion.base.CusGoldlionMemberActivityVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.BizGoldLionMemberActivityVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.GoldLionMemberActivityReqVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.MemberActivityListReqVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.MemberActivityListResVo;
import com.bizvane.customized.mappers.BizMappers.BizCusGoldlionMemberActivityMapper;
import com.bizvane.customized.mappers.CouponDefinitionMapper;
import com.bizvane.utils.tokens.SysAccountPO;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CusGoldlionMemberActivityService {
    private static final Logger log = LoggerFactory.getLogger(CusGoldlionMemberActivityService.class);
    private static final Logger logger = LoggerFactory.getLogger(CusGoldlionMemberActivityService.class);
    @Autowired
    private BizCusGoldlionMemberActivityMapper bizCusGoldlionMemberActivityMapper;
    @Autowired
    private CouponDefinitionMapper couponDefinitionMapper;

    public void add(CusGoldlionMemberActivityVo cusGoldlionMemberActivityVo, SysAccountPO sysAccountPO) {
        logger.info("\u5165\u53c2cusGoldlionMemberActivityVo:{},sysAccountPO:{}", (Object)JSON.toJSONString((Object)cusGoldlionMemberActivityVo), (Object)JSON.toJSONString((Object)sysAccountPO));
        if (cusGoldlionMemberActivityVo == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        cusGoldlionMemberActivityVo.setActivityStatus(ActivityStatusEnum.OPEN.getCode());
        cusGoldlionMemberActivityVo.setAlreadyReceivedAmount(Integer.valueOf(0));
        CusGoldlionMemberActivity cusGoldlionMemberActivity = (CusGoldlionMemberActivity)BeanUtils.copyProperties((Object)cusGoldlionMemberActivityVo, CusGoldlionMemberActivity.class);
        cusGoldlionMemberActivity.setCreateUserId(sysAccountPO.getCtrlAccountId());
        cusGoldlionMemberActivity.setCreateUserName(sysAccountPO.getName());
        cusGoldlionMemberActivity.setBrandId(sysAccountPO.getBrandId());
        this.bizCusGoldlionMemberActivityMapper.insertSelective(cusGoldlionMemberActivity);
    }

    public List<CusGoldlionMemberActivityVo> getPageList(GoldLionMemberActivityReqVo goldLionMemberActivityReqVo) {
        logger.info("CusGoldlionMemberActivityService.getPageList\u5165\u53c2goldLionMemberActivityReqVo:{}", (Object)JSONObject.toJSONString((Object)goldLionMemberActivityReqVo));
        List pageList = this.bizCusGoldlionMemberActivityMapper.getPageList(goldLionMemberActivityReqVo);
        if (CollectionUtils.isEmpty((Collection)pageList)) {
            return null;
        }
        logger.info("CusGoldlionMemberActivityService.getPageList\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)pageList));
        return pageList;
    }

    public BizGoldLionMemberActivityVo getById(Long cusGoldlionMemberActivityId) {
        logger.info("CusGoldlionMemberActivityService.getById\u5165\u53c2cusGoldlionMemberActivityId:{}", (Object)cusGoldlionMemberActivityId);
        if (cusGoldlionMemberActivityId == null) {
            throw new ServiceException("\u5165\u53c2cusGoldlionMemberActivityId\u4e3a\u7a7a\uff01");
        }
        CusGoldlionMemberActivityVo cusGoldlionMemberActivityVo = this.bizCusGoldlionMemberActivityMapper.getById(cusGoldlionMemberActivityId);
        if (cusGoldlionMemberActivityVo == null) {
            return null;
        }
        BizGoldLionMemberActivityVo bizGoldLionMemberActivityVo = (BizGoldLionMemberActivityVo)BeanUtils.copyProperties((Object)cusGoldlionMemberActivityVo, BizGoldLionMemberActivityVo.class);
        CouponDefinitionWithBLOBs couponDefinitions = this.couponDefinitionMapper.selectByPrimaryKey(bizGoldLionMemberActivityVo.getCouponId());
        if (couponDefinitions == null) {
            throw new ServiceException("\u672a\u67e5\u8be2\u5230\u8be5\u6d3b\u52a8\u5bf9\u5e94\u7684\u5361\u5238\u4fe1\u606f");
        }
        CouponDefinitionWithBLOBsVo couponDefinitionVo = (CouponDefinitionWithBLOBsVo)BeanUtils.copyProperties((Object)couponDefinitions, CouponDefinitionWithBLOBsVo.class);
        bizGoldLionMemberActivityVo.setCouponDefinitionVo(couponDefinitionVo);
        logger.info("CusGoldlionMemberActivityService.getById\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)bizGoldLionMemberActivityVo));
        return bizGoldLionMemberActivityVo;
    }

    public List<BizGoldLionMemberActivityVo> getByActivityNo(String activityNo) {
        logger.info("CusGoldlionMemberActivityService.getByActivityNo\u5165\u53c2activityNo:{}", (Object)activityNo);
        if (StringUtils.isBlank((CharSequence)activityNo)) {
            throw new ServiceException("\u5165\u53c2activityNo\u4e3a\u7a7a");
        }
        CusGoldlionMemberActivityExample cusGoldlionMemberActivityExample = new CusGoldlionMemberActivityExample();
        cusGoldlionMemberActivityExample.createCriteria().andActivityNoEqualTo(activityNo).andValidEqualTo(Boolean.TRUE);
        List cusGoldlionMemberActivities = this.bizCusGoldlionMemberActivityMapper.selectByExample(cusGoldlionMemberActivityExample);
        if (CollectionUtils.isEmpty((Collection)cusGoldlionMemberActivities)) {
            return null;
        }
        logger.info("CusGoldlionMemberActivityService.getByActivityNo\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)cusGoldlionMemberActivities));
        return BeanUtils.copyProperties((List)cusGoldlionMemberActivities, BizGoldLionMemberActivityVo.class);
    }

    public void switchById(Long cusGoldlionMemberActivityId, Boolean isOpenFlag, SysAccountPO sysAccountPO) {
        if (cusGoldlionMemberActivityId == null || isOpenFlag == null) {
            throw new ServiceException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CusGoldlionMemberActivity cusGoldlionMemberActivity = new CusGoldlionMemberActivity();
        cusGoldlionMemberActivity.setCusGoldlionMemberActivityId(cusGoldlionMemberActivityId);
        if (Boolean.TRUE.equals(isOpenFlag)) {
            cusGoldlionMemberActivity.setActivityStatus(ActivityStatusEnum.OPEN.getCode());
        }
        if (Boolean.FALSE.equals(isOpenFlag)) {
            cusGoldlionMemberActivity.setActivityStatus(ActivityStatusEnum.CLOSE.getCode());
        }
        cusGoldlionMemberActivity.setModifiedUserId(sysAccountPO.getCtrlAccountId());
        cusGoldlionMemberActivity.setModifiedUserName(sysAccountPO.getName());
        this.bizCusGoldlionMemberActivityMapper.updateByPrimaryKeySelective(cusGoldlionMemberActivity);
    }

    public void updateReceivedAmountById(Long cusGoldlionMemberActivityId) {
        if (cusGoldlionMemberActivityId == null) {
            throw new ServiceException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.bizCusGoldlionMemberActivityMapper.updateReceivedAmountById(cusGoldlionMemberActivityId);
    }

    public List<MemberActivityListResVo> memberActivityList(MemberActivityListReqVo memberActivityListReqVo) {
        logger.info("CusGoldlionMemberActivityService.memberActivityList\u5165\u53c2memberActivityListReqVo:{}", (Object)JSONObject.toJSONString((Object)memberActivityListReqVo));
        List memberActivityListResVos = this.bizCusGoldlionMemberActivityMapper.memberActivityList(memberActivityListReqVo);
        if (CollectionUtils.isEmpty((Collection)memberActivityListResVos)) {
            return null;
        }
        logger.info("CusGoldlionMemberActivityService.memberActivityList\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)memberActivityListResVos));
        return memberActivityListResVos;
    }
}

