/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.goldLion.controller.feignController;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.company.goldLion.controller.CusGoldlionMemberActivityController;
import com.bizvane.customized.company.goldLion.service.biz.BizCusGoldlionMemberActivityService;
import com.bizvane.customized.company.goldLion.service.biz.BizCusGoldlionMemberReceiveRecordService;
import com.bizvane.customized.facade.exception.CustomizedException;
import com.bizvane.customized.facade.exception.ServiceException;
import com.bizvane.customized.facade.models.vo.goldLion.biz.BizGoldLionMemberActivityVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.MemberActivityListReqVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.MemberActivityListResVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.TakeEquityReqVo;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goldlionMemberActivityFeign"})
@Api(value="CusGoldlionMemberActivityController")
public class CusGoldLionMemberActivityFeignController {
    private static final Logger logger = LoggerFactory.getLogger(CusGoldlionMemberActivityController.class);
    private static final String LOCK_KEY = "takeEquity_";
    @Autowired
    private BizCusGoldlionMemberReceiveRecordService bizCusGoldlionMemberReceiveRecordService;
    @Autowired
    private BizCusGoldlionMemberActivityService bizCusGoldlionMemberActivityService;
    @Autowired
    private RedissonTemplate redissonTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u6210\u529f")})
    @ApiOperation(value="\u9886\u53d6\u4f1a\u5458\u6d3b\u52a8\u6743\u76ca", notes="\u9886\u53d6\u4f1a\u5458\u6d3b\u52a8\u6743\u76ca")
    @PostMapping(value={"takeEquity"})
    public ResponseData takeEquity(@RequestBody TakeEquityReqVo takeEquityReqVo) {
        logger.info("\u9886\u53d6\u4f1a\u5458\u6d3b\u52a8\u6743\u76caCusGoldLionMemberActivityFeignController.takeEquity-->takeEquityReqVo:{}", (Object)JSONObject.toJSONString((Object)takeEquityReqVo));
        ResponseData responseData = new ResponseData();
        String key = LOCK_KEY + takeEquityReqVo.getCusGoldlionMemberActivityId();
        this.redissonTemplate.getRLock(key, 60L, TimeUnit.SECONDS);
        logger.info("key:{}", (Object)key);
        try {
            this.bizCusGoldlionMemberReceiveRecordService.takeEquity(takeEquityReqVo);
        }
        catch (ServiceException e) {
            ResponseData responseData2 = ResponseDataUtil.getFailedData(null, (String)e.getMessage());
            return responseData2;
        }
        catch (CustomizedException e) {
            ResponseData responseData3 = ResponseDataUtil.getFailedData(null, (String)e.getMessage());
            return responseData3;
        }
        finally {
            this.redissonTemplate.getRUnLook(key);
        }
        responseData.setCode(200);
        responseData.setMessage("\u64cd\u4f5c\u6210\u529f\uff01");
        return responseData;
    }

    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u6210\u529f")})
    @ApiOperation(value="\u6743\u76ca\u6d3b\u52a8\u5217\u8868", notes="\u6743\u76ca\u6d3b\u52a8\u5217\u8868")
    @PostMapping(value={"memberActivityList"})
    public ResponseData<List<MemberActivityListResVo>> memberActivityList(@RequestBody MemberActivityListReqVo memberActivityListReqVo) {
        logger.info("\u9886\u53d6\u4f1a\u5458\u6d3b\u52a8\u6743\u76caCusGoldLionMemberActivityFeignController.memberActivityList-->memberActivityListReqVo:{}", (Object)JSONObject.toJSONString((Object)memberActivityListReqVo));
        ResponseData responseData = new ResponseData();
        List memberActivityListResVos = this.bizCusGoldlionMemberActivityService.memberActivityList(memberActivityListReqVo);
        responseData.setCode(200);
        responseData.setMessage("\u64cd\u4f5c\u6210\u529f\uff01");
        responseData.setData((Object)memberActivityListResVos);
        return responseData;
    }

    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u6210\u529f")})
    @ApiOperation(value="\u4f1a\u5458\u6743\u76ca\u6d3b\u52a8\u8be6\u7ec6", notes="\u4f1a\u5458\u6743\u76ca\u6d3b\u52a8\u8be6\u7ec6")
    @GetMapping(value={"getById"})
    public ResponseData<BizGoldLionMemberActivityVo> getById(@RequestParam Long cusGoldlionMemberActivityId) {
        logger.info("\u4f1a\u5458\u6743\u76ca\u6d3b\u52a8\u5217\u8868CusGoldlionMemberActivityController.getPageList-->cusGoldlionMemberActivityId:{}", (Object)cusGoldlionMemberActivityId);
        ResponseData responseData = new ResponseData();
        BizGoldLionMemberActivityVo bizGoldLionMemberActivityVo = this.bizCusGoldlionMemberActivityService.getById(cusGoldlionMemberActivityId);
        responseData.setCode(200);
        responseData.setData((Object)bizGoldLionMemberActivityVo);
        return responseData;
    }
}

