/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.common.utils;

import com.bizvane.customized.facade.models.po.SysQiniuConfigPO;
import com.bizvane.customized.facade.models.po.SysQiniuConfigPOExample;
import com.bizvane.customized.facade.models.vo.QiNiuVo;
import com.bizvane.customized.mappers.SysQiniuConfigPOMapper;
import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.BatchStatus;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class QiNiuUtils
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(QiNiuUtils.class);
    @Autowired
    private SysQiniuConfigPOMapper sysQiNiuConfigPoMapper;
    private static String accessKey = "Jv79lFtLNDBj1XJ6vkXkemnRN5LIOSXMeDOvW35n";
    private static String secretKey = "HIKXNXr12qRhpIAsdI8xTaX87LeTqqLGjXB_RgDf";

    public static void main(String[] args) throws Exception {
        QiNiuUtils qiNiuUtil = new QiNiuUtils();
        File file = new File("/Users/liufq/workspace/julu/customized/customized-service/src/main/resources/GIFT_CARD.xlsx");
        String bucketNm = "bizvane01";
        QiNiuVo qiNiuVo = qiNiuUtil.upload(bucketNm, file);
        System.out.println(qiNiuVo.getUrl());
    }

    public void run(ApplicationArguments args) throws Exception {
        SysQiniuConfigPOExample example = new SysQiniuConfigPOExample();
        List sysQiNiuConfigPos = this.sysQiNiuConfigPoMapper.selectByExample(example);
        if (!CollectionUtils.isEmpty((Collection)sysQiNiuConfigPos)) {
            SysQiniuConfigPO sysQiNiuConfigPo = (SysQiniuConfigPO)sysQiNiuConfigPos.get(0);
            accessKey = sysQiNiuConfigPo.getAccessKey();
            secretKey = sysQiNiuConfigPo.getSecretKey();
        }
    }

    public void getFileInfo(String bucketNm) {
        try {
            BucketManager bucketManager = this.getBucketManager();
            String prefix = "";
            int limit = 1000;
            String delimiter = "";
            BucketManager.FileListIterator fileListIterator = bucketManager.createFileListIterator(bucketNm, prefix, limit, delimiter);
            while (fileListIterator.hasNext()) {
                FileInfo[] items;
                for (FileInfo item : items = fileListIterator.next()) {
                    System.out.println(item.key);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getBucketsInfo() {
        try {
            String[] bucketNms;
            BucketManager bucketManager = this.getBucketManager();
            for (String bucket : bucketNms = bucketManager.buckets()) {
                System.out.println(bucket);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public QiNiuVo deletes(String bucketNm, String[] keys) {
        QiNiuVo qiNiuVo = null;
        try {
            if (keys.length > 1000) {
                return new QiNiuVo(false);
            }
            BucketManager.BatchOperations batchOperations = new BucketManager.BatchOperations();
            batchOperations.addDeleteOp(bucketNm, keys);
            BucketManager bucketManager = this.getBucketManager();
            Response response = bucketManager.batch(batchOperations);
            BatchStatus[] batchStatusList = (BatchStatus[])response.jsonToObject(BatchStatus[].class);
            for (int i = 0; i < keys.length; ++i) {
                BatchStatus status = batchStatusList[i];
                String key = keys[i];
                System.out.print(key + "\t");
                if (status.code != 200) {
                    System.out.println(status.data.error);
                    return new QiNiuVo(false);
                }
                System.out.println("delete success");
            }
            qiNiuVo = new QiNiuVo(true);
        }
        catch (Exception e) {
            qiNiuVo = new QiNiuVo(false);
        }
        return qiNiuVo;
    }

    public QiNiuVo delete(String bucketNm, String key) {
        QiNiuVo result = null;
        try {
            BucketManager mg = this.getBucketManager();
            mg.delete(bucketNm, key);
            result = new QiNiuVo(true);
        }
        catch (Exception e) {
            result = new QiNiuVo(false);
        }
        return result;
    }

    public QiNiuVo upload(String bucketNm, InputStream in, String key) {
        QiNiuVo result = null;
        try {
            UploadManager uploadManager = this.getUploadManager(bucketNm);
            String token = this.getToken(bucketNm);
            Response response = uploadManager.put(in, key, token, null, null);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            System.out.println(putRet.key);
            System.out.println(putRet.hash);
            result = new QiNiuVo(true, putRet.key);
        }
        catch (Exception e) {
            log.error("QiNiuUtils upload error", (Throwable)e);
            result = new QiNiuVo(false);
        }
        return result;
    }

    public QiNiuVo upload(String bucketNm, File file) {
        QiNiuVo result = null;
        try {
            UploadManager uploadManager = this.getUploadManager(bucketNm);
            String token = this.getToken(bucketNm);
            Response response = uploadManager.put(file.getAbsolutePath(), this.newName(file.getName()), token);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            System.out.println(putRet.key);
            System.out.println(putRet.hash);
            result = new QiNiuVo(true, putRet.key);
        }
        catch (QiniuException e) {
            e.printStackTrace();
            result = new QiNiuVo(false);
        }
        return result;
    }

    public String newName(String oldName) {
        String[] datas = oldName.split("\\.");
        String type = datas[datas.length - 1];
        String newName = UUID.randomUUID().toString() + "." + type;
        return newName;
    }

    public UploadManager getUploadManager(String bucketNm) {
        Configuration cfg = new Configuration(Zone.zone0());
        UploadManager uploadManager = new UploadManager(cfg);
        return uploadManager;
    }

    public BucketManager getBucketManager() {
        Configuration cfg = new Configuration(Zone.zone0());
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        BucketManager bucketManager = new BucketManager(auth, cfg);
        return bucketManager;
    }

    public String getToken(String bucketNm) {
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        String upToken = auth.uploadToken(bucketNm);
        return upToken;
    }
}

