/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.common.utils;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PackageUtil {
    private static final Logger log = LoggerFactory.getLogger(PackageUtil.class);

    public static List<Class<?>> loadClass(String ... scanLocations) {
        ArrayList classList = new ArrayList();
        for (String scanLocation : scanLocations) {
            classList.addAll(PackageUtil.loadClass((String)scanLocation));
        }
        return classList;
    }

    public static List<Class<?>> loadClass(String scanLocation) {
        List classNameList = PackageUtil.getClassName((String)scanLocation);
        if (classNameList == null) {
            return new ArrayList(0);
        }
        ArrayList classList = new ArrayList(classNameList.size());
        for (int i = 0; i < classNameList.size(); ++i) {
            try {
                classList.add(i, Class.forName((String)classNameList.get(i)));
                continue;
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return classList;
    }

    public static List<String> getClassName(String packageName) {
        return PackageUtil.getClassName((String)packageName, (boolean)true);
    }

    public static List<String> getClassName(String packageName, boolean childPackage) {
        String packagePath;
        List fileNames = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(packagePath = packageName.replace(".", "/"));
        if (url != null) {
            String type = url.getProtocol();
            if ("file".equals(type)) {
                fileNames = PackageUtil.getClassNameByFile((String)url.getPath(), null, (boolean)childPackage);
            } else if ("jar".equals(type)) {
                fileNames = PackageUtil.getClassNameByJar((String)url.getPath(), (boolean)childPackage);
            }
        } else {
            fileNames = PackageUtil.getClassNameByJars((URL[])((URLClassLoader)loader).getURLs(), (String)packagePath, (boolean)childPackage);
        }
        return fileNames;
    }

    private static List<String> getClassNameByFile(String filePath, List<String> className, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath);
        File[] childFiles = file.listFiles();
        if (childFiles == null) {
            return myClassName;
        }
        for (File childFile : childFiles) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(PackageUtil.getClassNameByFile((String)childFile.getPath(), myClassName, (boolean)childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class")) continue;
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                childFilePath = childFilePath.substring(childFilePath.indexOf("/classes") + 9, childFilePath.lastIndexOf("."));
                childFilePath = childFilePath.replace("/", ".");
            } else {
                childFilePath = childFilePath.substring(childFilePath.indexOf("\\classes") + 9, childFilePath.lastIndexOf("."));
                childFilePath = childFilePath.replace("\\", ".");
            }
            myClassName.add(childFilePath);
        }
        return myClassName;
    }

    private static List<String> getClassNameByJar(String jarPath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        String packagePath = jarInfo[1].substring(1);
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    myClassName.add(entryName);
                    continue;
                }
                int index = entryName.lastIndexOf("/");
                String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                myClassName.add(entryName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myClassName;
    }

    private static List<String> getClassNameByJars(URL[] urls, String packagePath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        if (urls != null) {
            for (URL url : urls) {
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                myClassName.addAll(PackageUtil.getClassNameByJar((String)jarPath, (boolean)childPackage));
            }
        }
        return myClassName;
    }
}

