/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JacksonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonUtil.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static <T> String bean2Json(T bean) {
        try {
            return MAPPER.writeValueAsString(bean);
        }
        catch (JsonProcessingException e) {
            LOG.error("JavaBean ===> JSON ERROR : {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> Map<String, Object> bean2Map(T bean) {
        return JacksonUtil.json2Map((String)JacksonUtil.bean2Json(bean));
    }

    public static <T> Map<String, String> bean2Map1(T bean) {
        return JacksonUtil.json2Map1((String)JacksonUtil.bean2Json(bean));
    }

    public static <T> T json2Obj(String json, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            LOG.error("JSON ==> {} ERROR : {}", (Object)clazz.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T json2Objs(String json, Class<T> clazz) {
        try {
            MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            LOG.error("JSON ==> {} ERROR : {}", (Object)clazz.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }

    public static <T> Class[] json2Array(String json, Class<T>[] classes) {
        try {
            return (Class[])MAPPER.readValue(json, classes.getClass());
        }
        catch (IOException e) {
            LOG.error("JSON ==> {} ERROR : {}", (Object)classes.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }

    public static String list2Json(List list) {
        try {
            return MAPPER.writeValueAsString((Object)list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Map<String, Object> json2Map(String json) {
        return (Map)JacksonUtil.json2Obj((String)json, HashMap.class);
    }

    public static Map<String, String> json2Map1(String json) {
        return (Map)JacksonUtil.json2Objs((String)json, HashMap.class);
    }

    public static List json2List(String json) {
        try {
            return (List)MAPPER.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            LOG.error("JSON ==> List ERROR : {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> List<T> json2List(String json, Class<T> t) {
        try {
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{t});
            return (List)MAPPER.readValue(json, javaType);
        }
        catch (IOException e) {
            LOG.error("JSON ==> List ERROR : {}", (Object)e.getMessage());
            return null;
        }
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        MAPPER.setDateFormat((DateFormat)yyyyMMddHHmmss);
        MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }
}

