/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bizvane.centerstageservice.models.po.SysStoreGroupPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.customized.common.utils.yComparator;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateConversionUtil {
    Logger logger = LoggerFactory.getLogger(DateConversionUtil.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static DecimalFormat df = new DecimalFormat("0.00");

    public String getStartAndEndDate(String yesterday, int number, String dateLatitude) {
        String dateStr = "";
        switch (dateLatitude) {
            case "1": {
                dateStr = this.getDay(yesterday, number);
                break;
            }
            case "2": {
                dateStr = this.getWeek(yesterday, number);
                break;
            }
            case "3": {
                dateStr = this.getMonth(yesterday, number);
                break;
            }
        }
        return dateStr;
    }

    private String getDay(String yesterday, int number) {
        number = -number + 1;
        Date date = this.sdf.parse(yesterday, new ParsePosition(0));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, number);
        Date newDate = calendar.getTime();
        String dayStr = this.sdf.format(newDate);
        return dayStr;
    }

    private String getWeek(String yesterday, int number) {
        Date date = null;
        try {
            date = this.sdf.parse(yesterday);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        int weekOfMonth = calendar.get(3);
        System.out.println("=======" + weekOfMonth);
        int value = weekOfMonth - number;
        int week = 0;
        SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy");
        int year = Integer.parseInt(sdfYear.format(new Date()));
        this.logger.info("\u52b5\u6d88\u8d39\u5206\u6790\u5468\u5904\u7406,value:" + value);
        week = value >= 0 ? value + 1 : this.getWeekOfYear(--year) + value;
        String weekFistDate = this.getWeekFistDate(year, week);
        return weekFistDate;
    }

    private String getMonth(String yesterday, int number) {
        --number;
        Date date = null;
        try {
            date = this.sdf.parse(yesterday);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdfMonth = new SimpleDateFormat("MM");
        int month = Integer.parseInt(sdfMonth.format(date));
        SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy");
        int year = Integer.parseInt(sdfYear.format(new Date()));
        int value = month - number;
        this.logger.info("\u52b5\u6d88\u8d39\u5206\u6790\u6708\u5904\u7406,value:" + value);
        if (value > 0) {
            month = value;
        } else {
            --year;
            month = 12 + value;
        }
        String monthFistDate = String.valueOf(year) + "-" + String.valueOf(month) + "-1";
        return monthFistDate;
    }

    public String getYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        Date d = cal.getTime();
        String yesterday = this.sdf.format(d);
        return yesterday;
    }

    private int getWeekOfYear(int year) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(year, 11, 31, 23, 59, 59);
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setFirstDayOfWeek(2);
        cal1.setMinimalDaysInFirstWeek(7);
        cal1.setTime(cal.getTime());
        return cal1.get(3);
    }

    private String getWeekFistDate(int year, int week) {
        this.logger.info("\u52b5\u6548\u679c\u5206\u6790\u5468=====year:" + year + ",week:" + week);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(3, week);
        cal.set(7, 2);
        String firstDayOfWeek = this.sdf.format(cal.getTime());
        return firstDayOfWeek;
    }

    private String getDayNum(String newDate) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        Date datet = null;
        try {
            datet = f.parse(newDate);
            cal.setTime(datet);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public JSONObject getWeekNum(String newDate) {
        SimpleDateFormat formatMon = new SimpleDateFormat("MM");
        SimpleDateFormat formatYear = new SimpleDateFormat("yyyy");
        Date date = null;
        try {
            date = this.sdf.parse(newDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int month = Integer.valueOf(formatMon.format(date));
        int year = Integer.valueOf(formatYear.format(date));
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        int week = calendar.get(3);
        JSONObject dateJson = new JSONObject();
        dateJson.put("week", (Object)week);
        if (week == 1 && month == 12) {
            dateJson.put("year", (Object)(year + 1));
        } else {
            dateJson.put("year", (Object)year);
        }
        return dateJson;
    }

    public String getMonthNum(String newDate) {
        SimpleDateFormat sdfs = new SimpleDateFormat("MM");
        Date date = null;
        try {
            date = this.sdf.parse(newDate);
            sdfs.parse(newDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String monthStr = sdfs.format(date);
        return monthStr;
    }

    public JSONArray getDataHandle(JSONObject dataJson, String dateLatitude) {
        LinkedHashMap jsonMap = (LinkedHashMap)JSON.parseObject((String)JSON.toJSONString((Object)dataJson), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        JSONArray jsonArrayback = new JSONArray();
        TreeMap treeMap = new TreeMap((Comparator<String>)new yComparator());
        for (Map.Entry entry : jsonMap.entrySet()) {
            treeMap.put(DateConversionUtil.dateToStamp((String)((String)entry.getKey())), entry.getValue());
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            String dateStr = DateConversionUtil.stampToDate((String)((String)entry.getKey()));
            String weekStr = "";
            switch (dateLatitude) {
                case "1": {
                    weekStr = dateStr.substring(0, 10) + "(" + this.getDayNum(dateStr) + ")";
                    break;
                }
                case "2": {
                    JSONObject dateJson = this.getWeekNum(dateStr);
                    weekStr = dateJson.getString("year") + "\u5e74" + dateJson.getString("week") + "\u5468";
                    break;
                }
                case "3": {
                    weekStr = dateStr.substring(0, 7).replace("-", "\u5e74") + "\u6708";
                    break;
                }
            }
            JSONObject json = new JSONObject();
            json.put("time", (Object)weekStr);
            json.put("value", entry.getValue());
            jsonArrayback.add((Object)json);
        }
        return jsonArrayback;
    }

    public JSONArray getCouponStore(JSONArray dataJson, JSONObject storeJson, String isStore) {
        JSONArray resultDataArray = new JSONArray();
        for (int i = 0; i < dataJson.size(); ++i) {
            SysStoreGroupPo sysStoreGroupPo;
            String id;
            JSONObject json = new JSONObject();
            this.logger.info("value:" + dataJson.getJSONObject(i));
            JSONObject dataValueJson = dataJson.getJSONObject(i);
            String salesVolume = dataValueJson.getString("salesVolume");
            if (salesVolume.indexOf(".") > 0) {
                salesVolume = salesVolume.replaceAll("0+?$", "");
                salesVolume = salesVolume.replaceAll("[.]$", "");
            }
            String achievements = dataValueJson.getString("achievements");
            String penNumber = dataValueJson.getString("penNumber");
            String discount = dataValueJson.getString("discount");
            String pieceNumber = dataValueJson.getString("pieceNumber");
            String unitPrice = df.format(Double.parseDouble(achievements) / Double.parseDouble(penNumber));
            String jointRate = df.format(Double.parseDouble(pieceNumber) / Double.parseDouble(penNumber));
            if (jointRate.indexOf(".") > 0) {
                jointRate = jointRate.replaceAll("0+?$", "");
                jointRate = jointRate.replaceAll("[.]$", "");
            }
            Double achievementsDouble = Double.parseDouble(achievements);
            Double disAccountDouble = Double.parseDouble(discount);
            String roi = achievementsDouble == 0.0 || disAccountDouble == 0.0 ? "0" : df.format(Double.parseDouble(achievements) / Double.parseDouble(discount) * 100.0);
            if ("store".equals(isStore)) {
                id = dataValueJson.getString("id");
                SysStorePo sysStorePo = (SysStorePo)storeJson.get((Object)id);
                if (sysStorePo == null) continue;
                json.put("storeId", (Object)sysStorePo.getStoreId());
                json.put("storeCode", (Object)sysStorePo.getSysStoreOfflineCode());
                json.put("storeName", (Object)sysStorePo.getStoreName());
                json.put("salesVolume", (Object)salesVolume);
                json.put("unitPrice", (Object)("\uffe5" + unitPrice));
                json.put("jointRate", (Object)jointRate);
                json.put("achievements", (Object)("\uffe5" + df.format(achievementsDouble)));
                json.put("roi", (Object)(roi + "%"));
                resultDataArray.add((Object)json);
                continue;
            }
            if (!"storeGroup".equals(isStore) || (sysStoreGroupPo = (SysStoreGroupPo)storeJson.get((Object)(id = dataValueJson.getString("id")))) == null) continue;
            json.put("storeGroupCode", (Object)sysStoreGroupPo.getSysStoreGroupCode());
            json.put("storeGroupName", (Object)sysStoreGroupPo.getStoreGroupName());
            json.put("salesVolume", (Object)salesVolume);
            json.put("unitPrice", (Object)("\uffe5" + unitPrice));
            json.put("jointRate", (Object)jointRate);
            json.put("achievements", (Object)("\uffe5" + df.format(achievementsDouble)));
            json.put("roi", (Object)(roi + "%"));
            resultDataArray.add((Object)json);
        }
        return resultDataArray;
    }

    public static String dateToStamp(String s) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = simpleDateFormat.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        long ts = date.getTime();
        String res = String.valueOf(ts);
        return res;
    }

    public static String stampToDate(String s) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long lt = new Long(s);
        Date date = new Date(lt);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public String eraseZero(Double number) {
        DecimalFormat df = new DecimalFormat("0.00");
        String numberString = df.format(number);
        if (numberString.indexOf(".") > 0) {
            numberString = numberString.replaceAll("0+?$", "");
            numberString = numberString.replaceAll("[.]$", "");
        }
        return numberString;
    }
}

