/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.common.utils;

import com.bizvane.customized.common.utils.CommonExportCallBack;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class CommonExportExcelUtil {
    private Workbook wb;

    public CommonExportExcelUtil(String fileName) throws InvalidFormatException, IOException {
        this.wb = WorkbookFactory.create((File)new File(fileName));
    }

    public CommonExportExcelUtil(InputStream is) throws InvalidFormatException, IOException {
        this.wb = WorkbookFactory.create((InputStream)is);
    }

    public int getNumberOfSheets() {
        return this.wb.getNumberOfSheets();
    }

    private Sheet getSheetAt(int num) {
        return this.wb.getSheetAt(num);
    }

    public int getLastRowNum() {
        Sheet sheet = this.wb.getSheetAt(0);
        return sheet.getLastRowNum();
    }

    public void read(int beginRowNum, int beginColumnNum, int endColumnNum, int sheetNum, CommonExportCallBack callback) throws Exception {
        Sheet sheet = this.getSheetAt(sheetNum);
        int endRowNum = sheet.getLastRowNum();
        if (beginRowNum > endRowNum) {
            throw new Exception("\u5f00\u59cb\u884c\u6570\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u884c\u6570");
        }
        if (beginColumnNum > endColumnNum) {
            throw new Exception("\u5f00\u59cb\u5217\u6570\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u5217\u6570");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        for (int rowNum = beginRowNum; rowNum <= endRowNum; ++rowNum) {
            Object[] array = new String[endColumnNum - beginColumnNum + 1];
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            for (int column = beginColumnNum; column <= endColumnNum; ++column) {
                Cell cell = row.getCell(column, Row.RETURN_BLANK_AS_NULL);
                if (cell == null) {
                    array[column - beginColumnNum] = null;
                    continue;
                }
                cell.setCellType(1);
                array[column - beginColumnNum] = cell.getRichStringCellValue().getString();
            }
            callback.onRowCompletion(array);
        }
    }

    public static void main(String[] args) {
        try {
            CommonExportExcelUtil re = new CommonExportExcelUtil("D:\\memberLabel_20180830105414.xls");
            int numOfSheets = re.getNumberOfSheets();
            for (int i = 0; i < numOfSheets; ++i) {
                try {
                    re.read(0, 0, 4, i, row -> {
                        System.out.println(row[0]);
                        System.out.println(row[1]);
                        System.out.println(row[2]);
                        System.out.println("---------");
                    });
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

