package com.bizvane.customized.facade.models.vo.shininghouse;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author yy
 * @create 2019-03-11 17:29
 */
@Data
public class IntegralRefundOrder implements Serializable{

    private Integer id;

    /**
     * 商户ID
     */
    private Integer merchantId;


    private String orderNo;

    private String refundNo;


    private Integer orderDetailId;


    private Integer refundIntegral;

    private Integer refundQuantity;

    private String refundStatus;

    /**
     * 退款方式 0仅退款 1退款退货
     */
    private String refundType;


    /**
     * 退货时间
     */
    private Date refundTime;

    /**
     * 退货原因
     */
    private String refundReason;

    private String refundShippingCompany;

    private String refundCompanyCode;


    private String refundShippingNo;


    /**
     * 审核人
     */
    private String auditor;

    /**
     * 审核时间
     */
    private Date auditTime;

    /**
     * 审核反馈
     */
    private String auditReback;

    /**
     * 审核状态 0 待审核 1 通过 2 驳回
     */
    private String auditStatus;

    private Date gmtCreate;

    private Date gmtModified;


    private Boolean valid;


    /**
     * 审批类型
     * true 通过
     * false 驳回
     */
    private Boolean auditType;


    /**
     * 0待审核
     * 1待退款=0退货中
     * 2已退款=1退货成功
     * 3已驳回=2驳回
     */
    private String orderType;


    private String goodsName;


    private String beginTime;


    private String endTime;


    private String buyerName;


    private String goodsSkuNo;

    private String goodsSkuSpecNames;

    private String memberCode;


    private Integer pageIndex;

    private Integer pageSize;


    private String createTime;


    private String auditTimeStr;


    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Integer merchantId) {
        this.merchantId = merchantId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRefundNo() {
        return refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public Integer getOrderDetailId() {
        return orderDetailId;
    }

    public void setOrderDetailId(Integer orderDetailId) {
        this.orderDetailId = orderDetailId;
    }

    public Integer getRefundIntegral() {
        return refundIntegral;
    }

    public void setRefundIntegral(Integer refundIntegral) {
        this.refundIntegral = refundIntegral;
    }

    public Integer getRefundQuantity() {
        return refundQuantity;
    }

    public void setRefundQuantity(Integer refundQuantity) {
        this.refundQuantity = refundQuantity;
    }

    public String getRefundStatus() {
        return refundStatus;
    }

    public void setRefundStatus(String refundStatus) {
        this.refundStatus = refundStatus;
    }

    public String getRefundType() {
        return refundType;
    }

    public void setRefundType(String refundType) {
        this.refundType = refundType;
    }

    public Date getRefundTime() {
        return refundTime;
    }

    public void setRefundTime(Date refundTime) {
        this.refundTime = refundTime;
    }

    public String getRefundReason() {
        return refundReason;
    }

    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    public String getRefundShippingCompany() {
        return refundShippingCompany;
    }

    public void setRefundShippingCompany(String refundShippingCompany) {
        this.refundShippingCompany = refundShippingCompany;
    }

    public String getRefundCompanyCode() {
        return refundCompanyCode;
    }

    public void setRefundCompanyCode(String refundCompanyCode) {
        this.refundCompanyCode = refundCompanyCode;
    }

    public String getRefundShippingNo() {
        return refundShippingNo;
    }

    public void setRefundShippingNo(String refundShippingNo) {
        this.refundShippingNo = refundShippingNo;
    }

    public String getAuditor() {
        return auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(auditTime);
        setAuditTimeStr(time);
    }

    public String getAuditReback() {
        return auditReback;
    }

    public void setAuditReback(String auditReback) {
        this.auditReback = auditReback;
    }

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate);
        setCreateTime(time);
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Boolean getValid() {
        return valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public Boolean getAuditType() {
        return auditType;
    }

    public void setAuditType(Boolean auditType) {
        this.auditType = auditType;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public String getGoodsSkuNo() {
        return goodsSkuNo;
    }

    public void setGoodsSkuNo(String goodsSkuNo) {
        this.goodsSkuNo = goodsSkuNo;
    }

    public String getGoodsSkuSpecNames() {
        return goodsSkuSpecNames;
    }

    public void setGoodsSkuSpecNames(String goodsSkuSpecNames) {
        this.goodsSkuSpecNames = goodsSkuSpecNames;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getAuditTimeStr() {
        return auditTimeStr;
    }

    public void setAuditTimeStr(String auditTimeStr) {
        this.auditTimeStr = auditTimeStr;
    }
}
