package com.bizvane.customized.facade.models.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author lijunke
 */
@Data
public class CusSyncWMOrderVo implements Serializable {

    /**
     * 单据编号
     */
    @JSONField(name = "record_code")
    private String recordCode;

    /**
     * 消费类型（0：消费；1：退货；2：额外退款）
     */
    @JSONField(name = "consume_type")
    private Integer consumeType;

    /**
     * 渠道代码（商帆取中台附加属性ICRM编码）
     */
    @JSONField(name = "org_code")
    private String orgCode;

    /**
     * 店铺代码（商帆取中台附加属性ICRM编码）
     */
    @JSONField(name = "shop_code")
    private String shopCode;

    /**
     * 导购code
     */
    @JSONField(name = "guide_code")
    private String guideCode;

    /**
     * 数量
     */
    // private String num;

    /**
     * 总额，不包含用券、用积分部分
     */
    // private BigDecimal money;

    /**
     * 积分
     */
    private String integral;

    /**
     * 业务时间（线下专用的营业日期）
     */
    @JSONField(name = "record_time")
    @JsonFormat(pattern = "yyyy-MM-dd 00:00:00", locale = "zh", timezone = "Asia/Shanghai")
    private Date recordTime;

    /**
     * 实付金额，不包含用券、用积分部分
     */
    @JSONField(name = "real_money")
    private BigDecimal realMoney;

    /**
     * 找零，线上订单不存在找零
     */
    @JSONField(name = "change_money")
    private BigDecimal changeMoney;

    /**
     * 下单时间（线上专用的订单创建时间）
     */
    @JSONField(name = "order_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "Asia/Shanghai")
    private Date orderTime;

    /**
     * 顾客代码
     */
    @JSONField(name = "customer_code")
    private String customerCode;

    /**
     * vip代码
     */
    @JSONField(name = "vip_code")
    private String vipCode;

    /**
     * 来源 1:erp 6：pos 30：微购物 31：微信
     */
    @JSONField(name = "source")
    private String source;

    /**
     * 平均折扣
     */
    @JSONField(name = "rebate")
    private String rebate;

    /**
     * 收货人 顾客名称
     */
    @JSONField(name = "customer_name")
    private String customerName;

    /**
     * 添加时间（crm统一规则策略、统计的时间。对应与线下订单是制单时间，对应于线上就是订单创建时间）
     */
    @JSONField(name = "is_add_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "Asia/Shanghai")
    private Date isAddTime;

    /**
     * 生日（年-月-日）
     */
    // @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "Asia/Shanghai")
    // private Date birthday;

    /**
     * 备注
     */
    @JSONField(name = "remark")
    private String remark;

    /**
     * 来源平台（0：无类型，1：线上，2：线下(CRM通过来源关联来源类型)）
     */
    @JSONField(name = "source_type")
    private Integer sourceType;

    /**
     * 订单明细
     */
    @JSONField(name = "ConsumeDetails")
    private List<CusSyncWMOrderDetailVo> cusSyncWMOrderDetailVoList;

    @JSONField(name = "is_pushed")
    private String isPushed = "1";
}