package com.bizvane.couponfacade.models.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

@ToString
@Builder
@Data
public class SendCouponWebhookRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "brandCode不能为空")
    @ApiModelProperty(value = "品牌code", name = "brandCode")
    private String brandCode;

    @NotNull(message = "请求id不能为空")
    @ApiModelProperty(value = "请求id", name = "requestUniqueId")
    private String requestUniqueId;

    @NotNull(message = "券定义ID列表不能为空")
    @ApiModelProperty(value = "券定义ID列表", name = "couponDefinitionIdList")
    private List<Long> couponDefinitionIdList;

    @NotNull(message = "发放计划ID不能为空")
    @ApiModelProperty(value = "发放计划ID", name = "sendCouponPlanCode")
    private String sendCouponPlanCode;

    @NotNull(message = "发放计划名称不能为空")
    @ApiModelProperty(value = "发放计划名称", name = "sendCouponPlanName")
    private String sendCouponPlanName;

    @NotNull(message = "发放用户列表不能为空")
    @Size(max = 50)
    @ApiModelProperty(value = "发放用户列表", name = "sendUserList")
    private List<String> sendUserList;
}
