package com.bizvane.couponfacade.models.vo;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.bizvane.centerstageservice.models.po.SysProductCategoryPo;
import com.bizvane.couponfacade.models.po.*;
import com.bizvane.customized.facade.models.vo.CouponDefinitionVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.mktcenterservice.models.bo.ActivityGiftbagBO;
import lombok.ToString;

/**
 * @author bizvane
 */
@ToString
public class CouponDetailResponseVO implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @io.swagger.annotations.ApiModelProperty(value = "券定义对象", name = "couponDefinitionPOWithBLOBs", required = false,example = "")
  private CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs;
  @io.swagger.annotations.ApiModelProperty(value = "券定义对象", name = "couponDefinitionPO", required = false,example = "")
  private CouponDefinitionPO couponDefinitionPO;
  @io.swagger.annotations.ApiModelProperty(value = "券实例对象", name = "couponEntityPO", required = false,example = "")
  private CouponEntityPO couponEntityPO;
  @io.swagger.annotations.ApiModelProperty(value = "券状态集合", name = "couponStatusLogList", required = false,example = "")
  private List<CouponStatusLogPO> couponStatusLogList;
  @io.swagger.annotations.ApiModelProperty(value = "渠道对象集合", name = "wxChannelInfoVo", required = false,example = "")
  private WxChannelInfoVo wxChannelInfoVo;
  @io.swagger.annotations.ApiModelProperty(value = "手动发券对象", name = "wxChannelInfoVo", required = false,example = "")
  private CouponManualVO couponManualPO;
  @io.swagger.annotations.ApiModelProperty(value = "券定义对象列表", name = "couponDefinitionPOList", required = false,example = "")
  private List<CouponDefinitionVO> couponDefinitionPOList;

  @io.swagger.annotations.ApiModelProperty(value = "礼包信息", name = "activityGiftbagBO", required = false,example = "")
  private ActivityGiftbagBO activityGiftbagBO;

  private Map<String, List<SysProductCategoryPo>> map;
  //是否为异业券
  private Byte isDifindustryCoupon = 0;

  @io.swagger.annotations.ApiModelProperty(value = "券定义扩展对象", name = "couponDefinitionPO", required = false,example = "")
  private CouponDefinitionVO couponDefinitionVO;

  public CouponDefinitionPOWithBLOBs getCouponDefinitionPOWithBLOBs() {
    return couponDefinitionPOWithBLOBs;
  }

  public void setCouponDefinitionPOWithBLOBs(CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs) {
    this.couponDefinitionPOWithBLOBs = couponDefinitionPOWithBLOBs;
  }

  public CouponDefinitionPO getCouponDefinitionPO() {
    return couponDefinitionPO;
  }

  public void setCouponDefinitionPO(CouponDefinitionPO couponDefinitionPO) {
    this.couponDefinitionPO = couponDefinitionPO;
  }

  public CouponEntityPO getCouponEntityPO() {
    return couponEntityPO;
  }

  public void setCouponEntityPO(CouponEntityPO couponEntityPO) {
    this.couponEntityPO = couponEntityPO;
  }

  public List<CouponStatusLogPO> getCouponStatusLogList() {
    return couponStatusLogList;
  }

  public void setCouponStatusLogList(List<CouponStatusLogPO> couponStatusLogList) {
        this.couponStatusLogList = couponStatusLogList;
    }

  public WxChannelInfoVo getWxChannelInfoVo() {
    return wxChannelInfoVo;
  }

  public void setWxChannelInfoVo(WxChannelInfoVo wxChannelInfoVo) {
    this.wxChannelInfoVo = wxChannelInfoVo;
  }

  public CouponManualVO getCouponManualPO() {
    return couponManualPO;
  }

  public void setCouponManualPO(CouponManualVO couponManualPO) {
    this.couponManualPO = couponManualPO;
  }

  public List<CouponDefinitionVO> getCouponDefinitionPOList() {
    return couponDefinitionPOList;
  }

  public void setCouponDefinitionPOList(List<CouponDefinitionVO> couponDefinitionPOList) {
    this.couponDefinitionPOList = couponDefinitionPOList;
  }

  public ActivityGiftbagBO getActivityGiftbagBO() {
    return activityGiftbagBO;
  }

  public void setActivityGiftbagBO(ActivityGiftbagBO activityGiftbagBO) {
    this.activityGiftbagBO = activityGiftbagBO;
  }

  public Map<String, List<SysProductCategoryPo>> getMap() {
    return map;
  }

  public void setMap(Map<String, List<SysProductCategoryPo>> map) {
    this.map = map;
  }

  public Byte getIsDifindustryCoupon() {
    return isDifindustryCoupon;
  }

  public void setIsDifindustryCoupon(Byte isDifindustryCoupon) {
    this.isDifindustryCoupon = isDifindustryCoupon;
  }

  public CouponDefinitionVO getCouponDefinitionVO() {
    return couponDefinitionVO;
  }

  public void setCouponDefinitionVO(CouponDefinitionVO couponDefinitionVO) {
    this.couponDefinitionVO = couponDefinitionVO;
  }
}
