package com.bizvane.couponfacade.enums;

import com.bizvane.utils.enumutils.SysResponseEnum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 对应券发放查询页面的发券总类型
 * 每个总类型又包含具体的类型
 *
 * @author Bizvane
 */
public enum CouponSendTypeEnum {


    /**
     * 手动发券任务
     */
    MANUAL_SEND_TASK(1, "手动发券任务", Arrays.asList("85", "110")),
    /**
     * 会员活动
     */
    MEMBER_ACTIVITIES(2, "会员活动", Arrays.asList("10", "15", "30", "35", "45", "50", "55", "56", "90", "100", "103", "104", "105", "106", "107", "108", "109", "045", "055")),
    /**
     * 会员任务
     */
    MEMBER_TASK(3, "会员任务", Arrays.asList("60", "65", "70", "75", "80", "79", "78","81")),
    /**
     * 智能营销
     */
    MKT_SMART(4, "智能营销", Arrays.asList("95")),
    /**
     * 会员分组运营
     */
    MKT_MEMBER_GROUP(5, "会员分组运营", Arrays.asList("94")),
    /**
     * 积分商城
     */
    POINTS_MALL(7, "积分商城", Arrays.asList("101","127")),
    /**
     * 导购发券
     */
    GUIDE_COUPON(8, "导购发券", Arrays.asList("102")),
    /**
     * 员工券
     */
    STAFF_COUPON(10, "员工券", Arrays.asList("111")),
    /**
     * 线下券
     */
    OFFLINE_COUPON(11, "线下券", Arrays.asList("115")),
    /**
     * 天猫券
     */
    TMALL_COUPON(12, "天猫券", Arrays.asList("120")),
    /**
     * 渠道领券
     */
    CHANNEL_COUPON(13, "渠道领券", Arrays.asList("125")),
    /**
     * 自动营销任务
     */
    AUTO_MARK_TASK(16, "自动营销任务", Arrays.asList("130")),
    /**
     * 异业卷
     */
    DIF_FINDUSTRY_COUPON(17, "异业卷", Arrays.asList(SendTypeEnum.SEND_COUPON_DIF.getCode())),
    /**
     * 支付宝商家券
     */
    ALIPAY_VOUCHER_COUPON(18,"支付宝商家券",Arrays.asList(SendTypeEnum.SEND_ALIPAY_VOUCHER.getCode()));

    /**
     * 总类型
     */
    private Integer code;
    /**
     * 类型名称
     */
    private String message;
    /**
     * 包含的具体类型
     */
    private List<String> detailTypes;

    CouponSendTypeEnum(Integer code, String message, List<String> detailTypes) {
        this.code = code;
        this.message = message;
        this.detailTypes = detailTypes;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<String> getDetailTypes() {
        return detailTypes;
    }

    public void setDetailTypes(List<String> detailTypes) {
        this.detailTypes = detailTypes;
    }

    /**
     * 获取营销发券类型
     * 排除 员工券和天猫券
     */
    public static List<Integer> getMktTypeList() {
        List<CouponSendTypeEnum> collect = Arrays.stream(CouponSendTypeEnum.values()).filter(
                f -> !f.code.equals(TMALL_COUPON.code)
                        && !f.code.equals(STAFF_COUPON.code))
                .collect(Collectors.toList());
        return collect.stream().map(CouponSendTypeEnum::getCode).collect(Collectors.toList());
    }

    /**
     * 获取营销券类型
     * 排除 员工券和天猫券
     */
    public static List<String> getMktDetailTypeList() {
        List<CouponSendTypeEnum> collect = Arrays.stream(CouponSendTypeEnum.values()).filter(
                f -> !f.code.equals(TMALL_COUPON.code)
                        && !f.code.equals(STAFF_COUPON.code))
                .collect(Collectors.toList());
        List<String> result = new ArrayList<>();
        for (CouponSendTypeEnum couponSendTypeEnum : collect) {
            result.addAll(couponSendTypeEnum.getDetailTypes());
        }
        return result;
    }

    /**
     * 根据主类型获取明细类型
     */
    public static List<String> getDetailTypeList(Integer code) {
        for (CouponSendTypeEnum value : CouponSendTypeEnum.values()) {
            if (value.code.equals(code)) {
                return value.getDetailTypes();
            }
        }
        return new ArrayList<>();
    }

    /**
     * 根据主类型集合获取明细类型
     */
    public static List<String> getDetailTypeList(List<Integer> codes) {
        List<String> result = new ArrayList<>();
        for (Integer code : codes) {
            result.addAll(getDetailTypeList(code));
        }
        return result;
    }

    /**
     * 根据明细类型获取主类型名称
     */
    public static String getMessage(String detailType) {
        for (CouponSendTypeEnum value : CouponSendTypeEnum.values()) {
            for (String type : value.getDetailTypes()) {
                if (type.equals(detailType)) {
                    return value.getMessage();
                }
            }
        }
        return "";
    }


    /**
     * 根据明细类型获取主类型code
     */
    public static Integer getCode(String detailType) {
        for (CouponSendTypeEnum value : CouponSendTypeEnum.values()) {
            for (String type : value.getDetailTypes()) {
                if (type.equals(detailType)) {
                    return value.getCode();
                }
            }
        }
        return 666;
    }
}
