package com.bizvane.couponfacade.models.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author baofeng@bizvane.cn
 * @createTime 2021-10-18 10:32:38
 * @description: 查询优惠券列表请求对象
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponQueryDTO {
    @ApiModelProperty(name = "cardCode", value = "会员卡号", required = true, example = "")
    private String cardCode;

    @ApiModelProperty(name = "phone", value = "手机号")
    private String phone;
    
    @ApiModelProperty(name = "couponCodeList", value = "券号集合")
    private List<String> couponCodeList;

    @NotNull(message = "品牌ID不能为空")
    @ApiModelProperty(name = "brandId", value = "品牌ID", required = false, example = "")
    private Long brandId;

    @ApiModelProperty(name = "sysCompanyId", value = "企业ID", required = false, example = "")
    private Long sysCompanyId;

    @Deprecated
    @ApiModelProperty(name = "couponStatus", value = "5-线上绑定，10-同步中，11-同步失败，12-同步成功，20-未使用，25-已过期，30-已核销", required = false, example = "")
    private Integer couponStatus;

    @ApiModelProperty(name = "couponStatusList", value = "5-线上绑定，10-同步中，11-同步失败，12-同步成功，20-未使用，25-已过期，30-已核销")
    private List<Integer> couponStatusList;

    @ApiModelProperty(name = "couponDefinitionIdList", value = "券定义id集合")
    private List<Long> couponDefinitionIdList;

    @ApiModelProperty(name = "preferentialType", value = "优惠类型：现金=1,折扣=2,兑换=3", required = false, example = "")
    private Byte preferentialType;

    @ApiModelProperty(name = "queryBrandIds", value = "查询品牌ID集合")
    private List<Long> queryBrandIds;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize = 20;

}
